/************************/
/*     PICNIC TABLE     */
/************************/

#declare FrontLeg_Cross = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-5.000205, -5.000027>,
  <-3.300013, -5.000027>,
  <0.000006, -1.199947>,
  <3.299998, -5.000014>,
  <4.999859, -4.999948>,
  <1.199875, 0.000114>,
  <4.999992, 4.999992>,
  <3.2998, 4.999838>,
  <-0.000022, 1.200018>,
  <-3.299993, 5.00002>,
  <-5.000017, 4.999993>,
  <-1.200086, 0.000264>,
  <-5.000205, -5.000027>
  rotate -x*90
  rotate 90.0*x
  translate  <0.000128, 0.4, -5.285146>
}
#declare BackLeg_Cross = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-5.000205, -5.000027>,
  <-3.300013, -5.000027>,
  <0.000006, -1.199947>,
  <3.299998, -5.000014>,
  <4.999859, -4.999948>,
  <1.199875, 0.000114>,
  <4.999992, 4.999992>,
  <3.2998, 4.999838>,
  <-0.000022, 1.200018>,
  <-3.299993, 5.00002>,
  <-5.000017, 4.999993>,
  <-1.200086, 0.000264>,
  <-5.000205, -5.000027>
  rotate -x*90
  rotate 90.0*x
  translate  <0.000128, 14.6, -5.285146>
}

union { // Picnic_Table
  box { // Wood2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  2.0*y
  }
  box { // Wood1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
  }
  box { // Wood3
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  4.0*y
  }
  box { // Wood4
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  6.0*y
  }
  box { // Wood5
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  8.0*y
  }
  box { // Wood6
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  10.0*y
  }
  box { // Wood7
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  12.0*y
  }
  box { // Wood8
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.701269, 0.285177>
    translate  14.0*y
  }
  box { // LeftWood
    <-1, -1, -1>, <1, 1, 1>
    scale <6.6, 0.701269, 0.285177>
    rotate -90.0*z
    translate  <-4.0, 7.0, -0.6>
  }
  box { // Right_Wood
    <-1, -1, -1>, <1, 1, 1>
    scale <6.6, 0.701269, 0.285177>
    rotate -90.0*z
    translate  <4.0, 7.0, -0.6>
  }
  object { FrontLeg_Cross }
  object { BackLeg_Cross }
  material {
    T_Wood17_1
  }
  scale <.15, .18, .15>
  rotate <0,0,-10>
  translate  <-5.5,-18,5.65>
}


/************************/
/*      LILY PADS       */
/************************/


#declare Layer1_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate 23.88201*z
  translate  <-3.759097, 9.368118, 0.0>
  material {
    White_Leaf
  }
  rotate <10.0, 0.0, -22.989002>
  translate  <0.0, 2.880574, 0.242251>
}
#declare Layer1_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  material {
    White_Leaf
  }
  rotate <7.0, 0.0, -75.233147>
  translate  <14.520067, 0.618388, 1.581531>
}
#declare Layer1_3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  material {
    White_Leaf
  }
  rotate <10.0, 0.0, -171.56662>
  translate  <2.430321, -16.813789, 1.8985>
}
#declare Layer1_4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  material {
    White_Leaf
  }
  rotate <15.0, 0.0, 125.276016>
  translate  <-12.366777, -10.690271, 2.998605>
}
#declare Layer2_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <20.0, -7.206578, -46.008465>
  translate  <10.01797, 9.196666, 3.977854>
}
#declare Layer2_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <17.0, -7.206578, -96.940399>
  translate  <13.695214, -4.634616, 3.556447>
}
#declare Layer2_3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <25.0, -7.206578, 24.682032>
  translate  <-5.790898, 10.144562, 5.163792>
}
#declare Layer2_4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <30.0, -7.206578, 149.445709>
  translate  <-5.505156, -12.492553, 5.689551>
}
#declare Layer2_5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <35.0, -7.206578, 103.119583>
  translate  <-11.304355, -5.109567, 6.606181>
}
#declare Layer2_6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <35.0, -7.206578, -135.448242>
  translate  <10.267841, -10.86377, 6.943595>
}
#declare Layer3_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  material {
    White_Leaf
  }
  rotate <45.0, -7.206578, -117.627098>
  translate  <9.978226, -6.858584, 8.762837>
}
#declare Layer3_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, -58.641132>
  translate  <9.391042, 4.35707, 8.762837>
}
#declare Layer3_3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, -85.225945>
  translate  <12.148977, 0.306353, 8.762837>
}
#declare Layer3_4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, -13.660853>
  translate  <1.609114, 8.229422, 8.762837>
}
#declare Layer3_5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, 62.619797>
  translate  <-9.940218, 1.316683, 8.762837>
}
#declare Layer3_6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, 113.537262>
  translate  <-8.675262, -7.674584, 8.762837>
}
#declare Layer3_7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, 150.507767>
  translate  <-3.248285, -12.563418, 8.762837>
}
#declare Layer3_8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <45.0, -7.206578, -179.701141>
  translate  <2.222003, -13.269262, 8.803203>
}
#declare Layer4_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <48.0, -7.206578, -179.701141>
  translate  <1.059004, -11.454502, 9.179036>
}
#declare Layer4_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <52.0, -7.206578, -147.429459>
  translate  <5.891578, -8.521948, 9.57196>
}
#declare Layer4_3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <57.0, -7.206578, -110.187469>
  translate  <8.710808, -2.964963, 10.181043>
}
#declare Layer4_4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <58.0, -7.206578, -78.541763>
  translate  <8.783038, 2.528892, 10.517485>
}
#declare Layer4_5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <60.0, -7.206578, -30.076269>
  translate  <3.19658, 6.837188, 10.649415>
}
#declare Layer4_6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <50.0, -7.206578, 10.259514>
  translate  <-3.877329, 8.589248, 9.501856>
}
#declare Layer4_7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <63.0, -7.206578, 61.783821>
  translate  <-6.71123, 0.565892, 10.912335>
}
#declare Layer4_8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <65.0, -5.815492, 88.607468>
  translate  <-6.169618, -3.916105, 11.134134>
}
#declare Layer4_9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <53.0, -7.206578, 126.831085>
  translate  <-8.478834, -8.735099, 9.70195>
}
#declare Layer4_10 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.477685, -12.049822, 0.000000>, <-0.979996, -12.278780, 0.000000>, <-0.647096, -12.339638, 0.000000>, <-0.376625, -12.343982, 0.000000>, 
      <-2.225231, -10.978754, 0.000000>, <-1.995541, -10.903008, -0.408163>, <-1.379262, -10.795749, -0.858239>, <-0.830861, -10.747404, -1.011920>, 
      <-2.733218, -9.300466, 0.000000>, <-2.393167, -9.299116, -1.107397>, <-1.631556, -9.913657, -1.281586>, <-1.001162, -9.913657, -1.281586>, 
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.867152, -7.842089, 0.000000>, <-2.491327, -8.310107, -1.149585>, <-1.665238, -8.707920, -1.311651>, <-1.065848, -8.699980, -1.376296>, 
      <-3.001087, -6.383712, 0.000000>, <-2.589486, -7.321099, -1.191772>, <-1.698920, -7.502183, -1.341716>, <-1.130534, -7.486303, -1.471005>, 
      <-3.185942, -4.032426, 0.000000>, <-2.700869, -4.047508, -1.239183>, <-1.599718, -4.058200, -1.451344>, <-1.038877, -3.902986, -1.525819>, 
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.164154, -2.123287, 0.000000>, <-2.723604, -2.263040, -1.033706>, <-1.635688, -2.152993, -1.462684>, <-1.068783, -2.058652, -1.552153>, 
      <-3.142367, -0.214148, 0.000000>, <-2.746339, -0.478571, -0.828230>, <-1.671658, -0.247787, -1.474023>, <-1.098690, -0.214319, -1.578487>, 
      <-2.608198, 4.729959, 0.000000>, <-2.251612, 5.869716, -0.904556>, <-1.552534, 6.313366, -1.544264>, <-0.990137, 6.419420, -1.635389>, 
      <-2.161806, 6.556583, -0.019396>, <-1.928376, 7.197202, 0.000000>, <-1.425962, 8.743524, 0.000000>, <-0.931839, 9.358108, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.376625, -12.343982, 0.000000>, <-0.106153, -12.348326, 0.000000>, <0.138691, -12.351105, 0.000000>, <0.420887, -12.345372, 0.000000>, 
      <-0.830861, -10.747404, -1.011920>, <-0.282460, -10.699059, -1.165600>, <0.403517, -10.698418, -1.165600>, <0.935928, -10.737892, -0.996156>, 
      <-1.001162, -9.913657, -1.281586>, <-0.370768, -9.913657, -1.281586>, <0.419211, -9.943585, -1.281586>, <1.054014, -9.928621, -1.258007>, 
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.065848, -8.699980, -1.376296>, <-0.466458, -8.692040, -1.440941>, <0.497695, -8.695409, -1.446512>, <1.104127, -8.669691, -1.364723>, 
      <-1.130534, -7.486303, -1.471005>, <-0.562148, -7.470423, -1.600295>, <0.576179, -7.447233, -1.611438>, <1.154240, -7.410761, -1.471439>, 
      <-1.038877, -3.902986, -1.525819>, <-0.478035, -3.747772, -1.600295>, <0.474272, -3.720840, -1.611438>, <1.135922, -3.700838, -1.467463>, 
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.068783, -2.058652, -1.552153>, <-0.501878, -1.964311, -1.641623>, <0.492072, -1.950681, -1.644907>, <1.133696, -1.941173, -1.484197>, 
      <-1.098690, -0.214319, -1.578487>, <-0.525721, -0.180851, -1.682950>, <0.509872, -0.180522, -1.678375>, <1.131470, -0.181508, -1.500931>, 
      <-0.990137, 6.419420, -1.635389>, <-0.427741, 6.525474, -1.726515>, <0.445273, 6.541853, -1.784817>, <0.973739, 6.425641, -1.673287>, 
      <-0.931839, 9.358108, 0.000000>, <-0.437717, 9.972693, 0.000000>, <0.456329, 9.972693, 0.000000>, <0.902475, 9.340515, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.420887, -12.345372, 0.000000>, <0.703083, -12.339638, 0.000000>, <1.008896, -12.304844, 0.000000>, <1.519320, -12.043686, 0.000000>, 
      <0.935928, -10.737892, -0.996156>, <1.468339, -10.777367, -0.826712>, <1.977385, -10.891246, -0.403963>, <2.222950, -10.989748, 0.000000>, 
      <1.054014, -9.928621, -1.258007>, <1.688818, -9.913657, -1.234428>, <2.281781, -9.313795, -0.987424>, <2.721161, -9.326713, 0.000000>, 
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.104127, -8.669691, -1.364723>, <1.710559, -8.643973, -1.282934>, <2.405502, -8.266874, -0.977831>, <2.910095, -7.872638, 0.000000>, 
      <1.154240, -7.410761, -1.471439>, <1.732300, -7.374289, -1.331439>, <2.529222, -7.219954, -0.968239>, <3.099029, -6.418563, 0.000000>, 
      <1.135922, -3.700838, -1.467463>, <1.797572, -3.680836, -1.323487>, <2.780206, -3.780199, -0.612607>, <3.196822, -4.034967, 0.000000>, 
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.133696, -1.941173, -1.484197>, <1.775320, -1.931665, -1.323487>, <2.761529, -2.040533, -0.684997>, <3.154535, -2.102261, 0.000000>, 
      <1.131470, -0.181508, -1.500931>, <1.753068, -0.182495, -1.323487>, <2.742853, -0.300867, -0.757388>, <3.112247, -0.169555, 0.000000>, 
      <0.973739, 6.425641, -1.673287>, <1.502204, 6.309429, -1.561757>, <2.187527, 5.897682, -1.088737>, <2.642870, 4.834787, -0.015719>, 
      <0.902475, 9.340515, 0.000000>, <1.348622, 8.708337, 0.000000>, <1.827782, 7.314892, 0.000000>, <2.096608, 6.557515, 0.000000>
    }
  }
  rotate <63.0, -7.206578, 173.85878>
  translate  <0.376216, -10.280956, 10.730225>
}
#declare Petals = union {
  object { Layer1_1 }
  object { Layer1_2 }
  object { Layer1_3 }
  object { Layer1_4 }
  object { Layer2_1 }
  object { Layer2_2 }
  object { Layer2_3 }
  object { Layer2_4 }
  object { Layer2_5 }
  object { Layer2_6 }
  object { Layer3_1 }
  object { Layer3_2 }
  object { Layer3_3 }
  object { Layer3_4 }
  object { Layer3_5 }
  object { Layer3_6 }
  object { Layer3_7 }
  object { Layer3_8 }
  object { Layer4_1 }
  object { Layer4_2 }
  object { Layer4_3 }
  object { Layer4_4 }
  object { Layer4_5 }
  object { Layer4_6 }
  object { Layer4_7 }
  object { Layer4_8 }
  object { Layer4_9 }
  object { Layer4_10 }
}
#declare Seeds = union {
  cylinder { // Seed1
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <-12.78006, -7.508835, -11.72374>
    translate  <0.031551, 0.0, 0.665899>
  }
  cylinder { // Seed2
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate 18.253023*y
    translate  <1.820904, -1.193322, 0.737293>
  }
  cylinder { // Seed3
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <2.980182, 9.841668, -0.732944>
    translate  <1.820904, -3.132471, 0.811876>
  }
  cylinder { // Seed4
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <2.65238, 7.959325, 0.429651>
    translate  <0.981245, -1.713737, 0.811876>
  }
  cylinder { // Seed5
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <-6.080434, -9.151676, -6.108412>
    translate  <-0.757091, -0.758264, 0.811876>
  }
  cylinder { // Seed6
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <7.782257, -17.939301, -2.260559>
    translate  <-0.757091, -1.750308, 0.811876>
  }
  cylinder { // Seed7
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <18.128494, -7.598053, 3.191422>
    translate  <-0.146602, -2.208174, 0.811876>
  }
  cylinder { // Seed8
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <24.071213, 4.144485, 9.236801>
    translate  <1.096243, -2.61327, 0.811876>
  }
  cylinder { // Seed9
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <13.917618, 0.005539, 7.542252>
    translate  <0.234953, -1.330597, 0.811876>
  }
  cylinder { // Seed10
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <-15.431656, 2.81517, -1.885376>
    translate  <0.961379, 0.201539, 0.71359>
  }
  cylinder { // Seed11
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <-11.061462, 9.757065, -5.054626>
    translate  <2.044241, -0.057406, 0.71359>
  }
  cylinder { // Seed12
    <0,0,1>, <0,0,0>, 1 
    material {
      Seed_Texture
    }
    scale <0.467939, 0.445959, 11.615773>
    rotate <-10.471367, 4.31699, -4.051924>
    translate  <1.032001, -0.645918, 0.71359>
  }
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate -90.0*z
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate -45.0*z
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate 90.0*z
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate 135.0*z
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate -180.0*z
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate -180.0*z
}
#declare TransSweep011 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate -135.0*z
}
#declare TransSweep012 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-0.00001, -0.000009>,
  <1.0, 0.0>,
  <0.99375, 0.111603>,
  <0.975, 0.2222>,
  <0.95, 0.31225>,
  <0.925, 0.379967>,
  <0.900001, 0.437497>,
  <0.85, 0.5267>,
  <0.8, 0.6>,
  <0.75, 0.6614>,
  <0.7071, 0.7071>,
  <-0.00001, -0.000009>
  rotate -x*90
  scale <15.0, 15.0, 0.00001>
  rotate 45.0*z
}
#declare Pad1 = union {
  object { TransSweep005 }
  object { TransSweep006 }
  object { TransSweep007 }
  object { TransSweep008 }
  object { TransSweep009 }
  object { TransSweep010 }
  object { TransSweep011 }
//object { TransSweep012 }
  material {
    Green_Pad
  }
  translate  -1.0*z
}

union { // Lily_Pad1
  object { Petals }
  object { Seeds }
  object { Pad1 }
  material {
    White_Leaf
  }
  rotate <0,0,35>
  scale <.03,.03,.03>
  translate <10.5,.5,3.53>
//  translate <11,0,3.28>
}

union { // Lily_Pad2
  object { Petals }
  object { Seeds }
  object { Pad1 }
  material {
    White_Leaf
  }
  rotate <0,0,45>
  scale <.03,.03,.03>
  translate <10,3.5,3.53>
//  translate <10.5,3,3.28>
}


union { // Lily_Pad3
  object { Petals }
  object { Seeds }
  object { Pad1 }
  material {
    White_Leaf
  }
  rotate <0,0,25>
  scale <.03,.03,.03>
  translate <9,2.5,3.53>
//  translate <9.5,2,3.28>
}

union { 
  object { Pad1 }
  rotate <0,0,0>
  scale <.03,.03,.03>
  translate <10.25,2.0,3.53>
//  translate <10.75,1.5,3.28>
}

union { 
  object { Pad1 }
  scale <.04,.04,.05>
  rotate <0,0,-60>
  translate <10.25,5,3.53>
//  translate <10.75,4.5,3.3>
}