// File: DNA.inc
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: DNA Strand From PDB file.
                
// ATOM to place an atom object at an atom location.                
#macro ATOM(_X,_Y,_Z,_OBJECT) 
object {
   _OBJECT
   translate <_X,_Y,_Z>
}
#end

// DNA to place the atoms at the dna locations based on
// the DNA PDB file.
#macro DNA(_HO,_CO,_NO,_OO,_PO)
ATOM(-8.767, 1.872, 20.672, _PO) /*ATOM      1  P     G A   1      -8.767   1.872  20.672  1.00  0.00              */
ATOM(-9.837, 2.863, 20.452, _OO) /*ATOM      2  O1P   G A   1      -9.837   2.863  20.452  1.00  0.00              */
ATOM(-8.868, 0.621, 19.882, _OO) /*ATOM      3  O2P   G A   1      -8.868   0.621  19.882  1.00  0.00              */
ATOM(-7.342, 2.542, 20.422, _OO) /*ATOM      4  O5'   G A   1      -7.342   2.542  20.422  1.00  0.00              */
ATOM(-6.864, 3.537, 21.362, _CO) /*ATOM      5  C5'   G A   1      -6.864   3.537  21.362  1.00  0.00              */
ATOM(-6.051, 4.581, 20.632, _CO) /*ATOM      6  C4'   G A   1      -6.051   4.581  20.632  1.00  0.00              */
ATOM(-4.700, 4.060, 20.422, _OO) /*ATOM      7  O4'   G A   1      -4.700   4.060  20.422  1.00  0.00              */
ATOM(-6.531, 4.958, 19.232, _CO) /*ATOM      8  C3'   G A   1      -6.531   4.958  19.232  1.00  0.00              */
ATOM(-6.090, 6.256, 18.842, _OO) /*ATOM      9  O3'   G A   1      -6.090   6.256  18.842  1.00  0.00              */
ATOM(-5.859, 3.916, 18.352, _CO) /*ATOM     10  C2'   G A   1      -5.859   3.916  18.352  1.00  0.00              */
ATOM(-4.527, 3.712, 19.062, _CO) /*ATOM     11  C1'   G A   1      -4.527   3.712  19.062  1.00  0.00              */
ATOM(-4.030, 2.310, 19.012, _NO) /*ATOM     12  N9    G A   1      -4.030   2.310  19.012  1.00  0.00              */
ATOM(-4.738, 1.129, 19.092, _CO) /*ATOM     13  C8    G A   1      -4.738   1.129  19.092  1.00  0.00              */
ATOM(-3.995, 0.055, 19.012, _NO) /*ATOM     14  N7    G A   1      -3.995   0.055  19.012  1.00  0.00              */
ATOM(-2.698, 0.551, 18.872, _CO) /*ATOM     15  C5    G A   1      -2.698   0.551  18.872  1.00  0.00              */
ATOM(-1.468,-0.134, 18.742, _CO) /*ATOM     16  C6    G A   1      -1.468  -0.134  18.742  1.00  0.00              */
ATOM(-1.253,-1.344, 18.722, _OO) /*ATOM     17  O6    G A   1      -1.253  -1.344  18.722  1.00  0.00              */
ATOM(-0.391, 0.763, 18.622, _NO) /*ATOM     18  N1    G A   1      -0.391   0.763  18.622  1.00  0.00              */
ATOM(-0.501, 2.138, 18.622, _CO) /*ATOM     19  C2    G A   1      -0.501   2.138  18.622  1.00  0.00              */
ATOM( 0.640, 2.821, 18.492, _NO) /*ATOM     20  N2    G A   1       0.640   2.821  18.492  1.00  0.00              */
ATOM(-1.658, 2.784, 18.752, _NO) /*ATOM     21  N3    G A   1      -1.658   2.784  18.752  1.00  0.00              */
ATOM(-2.713, 1.934, 18.872, _CO) /*ATOM     22  C4    G A   1      -2.713   1.934  18.872  1.00  0.00              */
ATOM(-7.723, 4.019, 21.851, _HO) /*ATOM     23  H5'1  G A   1      -7.723   4.019  21.851  1.00  0.00              */
ATOM(-6.235, 3.050, 22.121, _HO) /*ATOM     24  H5'2  G A   1      -6.235   3.050  22.121  1.00  0.00              */
ATOM(-6.022, 5.487, 21.254, _HO) /*ATOM     25  H4'   G A   1      -6.022   5.487  21.254  1.00  0.00              */
ATOM(-3.776, 4.370, 18.599, _HO) /*ATOM     26  H1'   G A   1      -3.776   4.370  18.599  1.00  0.00              */
ATOM(-6.442, 2.984, 18.320, _HO) /*ATOM     27  H2'1  G A   1      -6.442   2.984  18.320  1.00  0.00              */
ATOM(-5.713, 4.292, 17.328, _HO) /*ATOM     28  H2'2  G A   1      -5.713   4.292  17.328  1.00  0.00              */
ATOM(-7.627, 4.901, 19.162, _HO) /*ATOM     29  H3'   G A   1      -7.627   4.901  19.162  1.00  0.00              */
ATOM(-5.820, 1.094, 19.211, _HO) /*ATOM     30  H8    G A   1      -5.820   1.094  19.211  1.00  0.00              */
ATOM( 0.526, 0.374, 18.529, _HO) /*ATOM     31  H1    G A   1       0.526   0.374  18.529  1.00  0.00              */
ATOM( 0.627, 3.851, 18.492, _HO) /*ATOM     32  H21   G A   1       0.627   3.851  18.492  1.00  0.00              */
ATOM(-8.842, 1.477, 22.112, _OO) /*ATOM     33  OXT   G A   1      -8.842   1.477  22.112  1.00  0.00              */
ATOM( 1.533, 2.318, 18.391, _HO) /*ATOM     34  H22   G A   1       1.533   2.318  18.391  1.00  0.00              */
ATOM(-9.492, 0.793, 22.219, _HO) /*ATOM     35  HTER  G A   1      -9.492   0.793  22.219  1.00  0.00              */
ATOM(-5.947, 6.602, 17.292, _PO) /*ATOM     36  P     C A   2      -5.947   6.602  17.292  1.00  0.00              */
ATOM(-6.231, 8.033, 17.072, _OO) /*ATOM     37  O1P   C A   2      -6.231   8.033  17.072  1.00  0.00              */
ATOM(-6.765, 5.650, 16.502, _OO) /*ATOM     38  O2P   C A   2      -6.765   5.650  16.502  1.00  0.00              */
ATOM(-4.401, 6.306, 17.042, _OO) /*ATOM     39  O5'   C A   2      -4.401   6.306  17.042  1.00  0.00              */
ATOM(-3.429, 6.830, 17.982, _CO) /*ATOM     40  C5'   C A   2      -3.429   6.830  17.982  1.00  0.00              */
ATOM(-2.157, 7.198, 17.252, _CO) /*ATOM     41  C4'   C A   2      -2.157   7.198  17.252  1.00  0.00              */
ATOM(-1.371, 5.982, 17.042, _OO) /*ATOM     42  O4'   C A   2      -1.371   5.982  17.042  1.00  0.00              */
ATOM(-2.324, 7.784, 15.852, _CO) /*ATOM     43  C3'   C A   2      -2.324   7.784  15.852  1.00  0.00              */
ATOM(-1.205, 8.575, 15.462, _OO) /*ATOM     44  O3'   C A   2      -1.205   8.575  15.462  1.00  0.00              */
ATOM(-2.393, 6.546, 14.972, _CO) /*ATOM     45  C2'   C A   2      -2.393   6.546  14.972  1.00  0.00              */
ATOM(-1.436, 5.598, 15.682, _CO) /*ATOM     46  C1'   C A   2      -1.436   5.598  15.682  1.00  0.00              */
ATOM(-1.857, 4.172, 15.632, _NO) /*ATOM     47  N1    C A   2      -1.857   4.172  15.632  1.00  0.00              */
ATOM(-0.866, 3.205, 15.482, _CO) /*ATOM     48  C2    C A   2      -0.866   3.205  15.482  1.00  0.00              */
ATOM( 0.314, 3.567, 15.392, _OO) /*ATOM     49  O2    C A   2       0.314   3.567  15.392  1.00  0.00              */
ATOM(-1.400, 1.793, 15.432, _NO) /*ATOM     50  N3    C A   2      -1.400   1.793  15.432  1.00  0.00              */
ATOM(-2.515, 1.542, 15.532, _CO) /*ATOM     51  C4    C A   2      -2.515   1.542  15.532  1.00  0.00              */
ATOM(-2.815, 0.253, 15.482, _NO) /*ATOM     52  N4    C A   2      -2.815   0.253  15.482  1.00  0.00              */
ATOM(-3.552, 2.516, 15.682, _CO) /*ATOM     53  C5    C A   2      -3.552   2.516  15.682  1.00  0.00              */
ATOM(-3.164, 3.819, 15.732, _CO) /*ATOM     54  C6    C A   2      -3.164   3.819  15.732  1.00  0.00              */
ATOM(-3.840, 7.725, 18.472, _HO) /*ATOM     55  H5'1  C A   2      -3.840   7.725  18.472  1.00  0.00              */
ATOM(-3.206, 6.066, 18.741, _HO) /*ATOM     56  H5'2  C A   2      -3.206   6.066  18.741  1.00  0.00              */
ATOM(-1.601, 7.914, 17.874, _HO) /*ATOM     57  H4'   C A   2      -1.601   7.914  17.874  1.00  0.00              */
ATOM(-0.442, 5.689, 15.219, _HO) /*ATOM     58  H1'   C A   2      -0.442   5.689  15.219  1.00  0.00              */
ATOM(-3.413, 6.135, 14.940, _HO) /*ATOM     59  H2'1  C A   2      -3.413   6.135  14.940  1.00  0.00              */
ATOM(-2.054, 6.764, 13.948, _HO) /*ATOM     60  H2'2  C A   2      -2.054   6.764  13.948  1.00  0.00              */
ATOM(-3.244, 8.382, 15.782, _HO) /*ATOM     61  H3'   C A   2      -3.244   8.382  15.782  1.00  0.00              */
ATOM(-3.918, 4.595, 15.854, _HO) /*ATOM     62  H6    C A   2      -3.918   4.595  15.854  1.00  0.00              */
ATOM(-4.600, 2.229, 15.752, _HO) /*ATOM     63  H5    C A   2      -4.600   2.229  15.752  1.00  0.00              */
ATOM(-2.067,-0.446, 15.364, _HO) /*ATOM     64  H41   C A   2      -2.067  -0.446  15.364  1.00  0.00              */
ATOM(-3.796,-0.051, 15.561, _HO) /*ATOM     65  H42   C A   2      -3.796  -0.051  15.561  1.00  0.00              */
ATOM(-0.886, 8.771, 13.912, _PO) /*ATOM     66  P     G A   3      -0.886   8.771  13.912  1.00  0.00              */
ATOM(-0.274,10.096, 13.692, _OO) /*ATOM     67  O1P   G A   3      -0.274  10.096  13.692  1.00  0.00              */
ATOM(-2.107, 8.481, 13.122, _OO) /*ATOM     68  O2P   G A   3      -2.107   8.481  13.122  1.00  0.00              */
ATOM( 0.192, 7.623, 13.662, _OO) /*ATOM     69  O5'   G A   3       0.192   7.623  13.662  1.00  0.00              */
ATOM( 1.286, 7.476, 14.602, _CO) /*ATOM     70  C5'   G A   3       1.286   7.476  14.602  1.00  0.00              */
ATOM( 2.530, 7.026, 13.872, _CO) /*ATOM     71  C4'   G A   3       2.530   7.026  13.872  1.00  0.00              */
ATOM( 2.452, 5.580, 13.662, _OO) /*ATOM     72  O4'   G A   3       2.452   5.580  13.662  1.00  0.00              */
ATOM( 2.740, 7.599, 12.472, _CO) /*ATOM     73  C3'   G A   3       2.740   7.599  12.472  1.00  0.00              */
ATOM( 4.111, 7.580, 12.082, _OO) /*ATOM     74  O3'   G A   3       4.111   7.580  12.082  1.00  0.00              */
ATOM( 1.957, 6.638, 11.592, _CO) /*ATOM     75  C2'   G A   3       1.957   6.638  11.592  1.00  0.00              */
ATOM( 2.174, 5.308, 12.302, _CO) /*ATOM     76  C1'   G A   3       2.174   5.308  12.302  1.00  0.00              */
ATOM( 0.995, 4.402, 12.252, _NO) /*ATOM     77  N9    G A   3       0.995   4.402  12.252  1.00  0.00              */
ATOM(-0.347, 4.710, 12.332, _CO) /*ATOM     78  C8    G A   3      -0.347   4.710  12.332  1.00  0.00              */
ATOM(-1.139, 3.672, 12.252, _NO) /*ATOM     79  N7    G A   3      -1.139   3.672  12.252  1.00  0.00              */
ATOM(-0.266, 2.591, 12.112, _CO) /*ATOM     80  C5    G A   3      -0.266   2.591  12.112  1.00  0.00              */
ATOM(-0.537, 1.210, 11.982, _CO) /*ATOM     81  C6    G A   3      -0.537   1.210  11.982  1.00  0.00              */
ATOM(-1.623, 0.631, 11.962, _OO) /*ATOM     82  O6    G A   3      -1.623   0.631  11.962  1.00  0.00              */
ATOM( 0.648, 0.463, 11.862, _NO) /*ATOM     83  N1    G A   3       0.648   0.463  11.862  1.00  0.00              */
ATOM( 1.922, 0.993, 11.862, _CO) /*ATOM     84  C2    G A   3       1.922   0.993  11.862  1.00  0.00              */
ATOM( 2.924, 0.118, 11.732, _NO) /*ATOM     85  N2    G A   3       2.924   0.118  11.732  1.00  0.00              */
ATOM( 2.178, 2.292, 11.992, _NO) /*ATOM     86  N3    G A   3       2.178   2.292  11.992  1.00  0.00              */
ATOM( 1.045, 3.033, 12.112, _CO) /*ATOM     87  C4    G A   3       1.045   3.033  12.112  1.00  0.00              */
ATOM( 1.479, 8.442, 15.091, _HO) /*ATOM     88  H5'1  G A   3       1.479   8.442  15.091  1.00  0.00              */
ATOM( 1.017, 6.727, 15.361, _HO) /*ATOM     89  H5'2  G A   3       1.017   6.727  15.361  1.00  0.00              */
ATOM( 3.401, 7.278, 14.494, _HO) /*ATOM     90  H4'   G A   3       3.401   7.278  14.494  1.00  0.00              */
ATOM( 3.032, 4.797, 11.839, _HO) /*ATOM     91  H1'   G A   3       3.032   4.797  11.839  1.00  0.00              */
ATOM( 0.890, 6.904, 11.560, _HO) /*ATOM     92  H2'1  G A   3       0.890   6.904  11.560  1.00  0.00              */
ATOM( 2.360, 6.615, 10.568, _HO) /*ATOM     93  H2'2  G A   3       2.360   6.615  10.568  1.00  0.00              */
ATOM( 2.348, 8.624, 12.402, _HO) /*ATOM     94  H3'   G A   3       2.348   8.624  12.402  1.00  0.00              */
ATOM(-0.715, 5.728, 12.451, _HO) /*ATOM     95  H8    G A   3      -0.715   5.728  12.451  1.00  0.00              */
ATOM( 0.561,-0.529, 11.769, _HO) /*ATOM     96  H1    G A   3       0.561  -0.529  11.769  1.00  0.00              */
ATOM( 3.900, 0.448, 11.732, _HO) /*ATOM     97  H21   G A   3       3.900   0.448  11.732  1.00  0.00              */
ATOM( 2.721,-0.887, 11.631, _HO) /*ATOM     98  H22   G A   3       2.721  -0.887  11.631  1.00  0.00              */
ATOM( 4.484, 7.551, 10.532, _PO) /*ATOM     99  P     A A   4       4.484   7.551  10.532  1.00  0.00              */
ATOM( 5.758, 8.264, 10.312, _OO) /*ATOM    100  O1P   A A   4       5.758   8.264  10.312  1.00  0.00              */
ATOM( 3.326, 8.035,  9.742, _OO) /*ATOM    101  O2P   A A   4       3.326   8.035   9.742  1.00  0.00              */
ATOM( 4.681, 5.989, 10.282, _OO) /*ATOM    102  O5'   A A   4       4.681   5.989  10.282  1.00  0.00              */
ATOM( 5.480, 5.228, 11.222, _CO) /*ATOM    103  C5'   A A   4       5.480   5.228  11.222  1.00  0.00              */
ATOM( 6.222, 4.131, 10.492, _CO) /*ATOM    104  C4'   A A   4       6.222   4.131  10.492  1.00  0.00              */
ATOM( 5.309, 3.008, 10.282, _OO) /*ATOM    105  O4'   A A   4       5.309   3.008  10.282  1.00  0.00              */
ATOM( 6.728, 4.472,  9.092, _CO) /*ATOM    106  C3'   A A   4       6.728   4.472   9.092  1.00  0.00              */
ATOM( 7.826, 3.651,  8.702, _OO) /*ATOM    107  O3'   A A   4       7.826   3.651   8.702  1.00  0.00              */
ATOM( 5.530, 4.154,  8.212, _CO) /*ATOM    108  C2'   A A   4       5.530   4.154   8.212  1.00  0.00              */
ATOM( 4.924, 2.951,  8.922, _CO) /*ATOM    109  C1'   A A   4       4.924   2.951   8.922  1.00  0.00              */
ATOM( 3.437, 2.911,  8.872, _NO) /*ATOM    110  N9    A A   4       3.437   2.911   8.872  1.00  0.00              */
ATOM( 2.558, 3.957,  8.952, _CO) /*ATOM    111  C8    A A   4       2.558   3.957   8.952  1.00  0.00              */
ATOM( 1.312, 3.595,  8.882, _NO) /*ATOM    112  N7    A A   4       1.312   3.595   8.882  1.00  0.00              */
ATOM( 1.374, 2.222,  8.732, _CO) /*ATOM    113  C5    A A   4       1.374   2.222   8.732  1.00  0.00              */
ATOM( 0.376, 1.233,  8.602, _CO) /*ATOM    114  C6    A A   4       0.376   1.233   8.602  1.00  0.00              */
ATOM(-0.928, 1.496,  8.592, _NO) /*ATOM    115  N6    A A   4      -0.928   1.496   8.592  1.00  0.00              */
ATOM( 0.780,-0.041,  8.482, _NO) /*ATOM    116  N1    A A   4       0.780  -0.041   8.482  1.00  0.00              */
ATOM( 2.082,-0.306,  8.492, _CO) /*ATOM    117  C2    A A   4       2.082  -0.306   8.492  1.00  0.00              */
ATOM( 3.102, 0.516,  8.612, _NO) /*ATOM    118  N3    A A   4       3.102   0.516   8.612  1.00  0.00              */
ATOM( 2.666, 1.784,  8.732, _CO) /*ATOM    119  C4    A A   4       2.666   1.784   8.732  1.00  0.00              */
ATOM( 6.204, 5.896, 11.710, _HO) /*ATOM    120  H5'1  A A   4       6.204   5.896  11.710  1.00  0.00              */
ATOM( 4.823, 4.781, 11.982, _HO) /*ATOM    121  H5'2  A A   4       4.823   4.781  11.982  1.00  0.00              */
ATOM( 7.075, 3.823, 11.114, _HO) /*ATOM    122  H4'   A A   4       7.075   3.823  11.114  1.00  0.00              */
ATOM( 5.318, 2.034,  8.459, _HO) /*ATOM    123  H1'   A A   4       5.318   2.034   8.459  1.00  0.00              */
ATOM( 4.824, 4.996,  8.179, _HO) /*ATOM    124  H2'1  A A   4       4.824   4.996   8.179  1.00  0.00              */
ATOM( 5.843, 3.898,  7.188, _HO) /*ATOM    125  H2'2  A A   4       5.843   3.898   7.188  1.00  0.00              */
ATOM( 7.013, 5.532,  9.022, _HO) /*ATOM    126  H3'   A A   4       7.013   5.532   9.022  1.00  0.00              */
ATOM( 2.873, 4.994,  9.063, _HO) /*ATOM    127  H8    A A   4       2.873   4.994   9.063  1.00  0.00              */
ATOM(-1.258, 2.467,  8.682, _HO) /*ATOM    128  H61   A A   4      -1.258   2.467   8.682  1.00  0.00              */
ATOM(-1.607, 0.728,  8.493, _HO) /*ATOM    129  H62   A A   4      -1.607   0.728   8.493  1.00  0.00              */
ATOM( 2.342,-1.353,  8.385, _HO) /*ATOM    130  H2    A A   4       2.342  -1.353   8.385  1.00  0.00              */
ATOM( 8.111, 3.408,  7.152, _PO) /*ATOM    131  P     A A   5       8.111   3.408   7.152  1.00  0.00              */
ATOM( 9.560, 3.236,  6.932, _OO) /*ATOM    132  O1P   A A   5       9.560   3.236   6.932  1.00  0.00              */
ATOM( 7.458, 4.480,  6.362, _OO) /*ATOM    133  O2P   A A   5       7.458   4.480   6.362  1.00  0.00              */
ATOM( 7.353, 2.029,  6.902, _OO) /*ATOM    134  O5'   A A   5       7.353   2.029   6.902  1.00  0.00              */
ATOM( 7.551, 0.943,  7.842, _CO) /*ATOM    135  C5'   A A   5       7.551   0.943   7.842  1.00  0.00              */
ATOM( 7.507,-0.380,  7.112, _CO) /*ATOM    136  C4'   A A   5       7.507  -0.380   7.112  1.00  0.00              */
ATOM( 6.108,-0.752,  6.902, _OO) /*ATOM    137  O4'   A A   5       6.108  -0.752   6.902  1.00  0.00              */
ATOM( 8.116,-0.402,  5.712, _CO) /*ATOM    138  C3'   A A   5       8.116  -0.402   5.712  1.00  0.00              */
ATOM( 8.523,-1.712,  5.322, _OO) /*ATOM    139  O3'   A A   5       8.523  -1.712   5.322  1.00  0.00              */
ATOM( 6.960, 0.045,  4.832, _CO) /*ATOM    140  C2'   A A   5       6.960   0.045   4.832  1.00  0.00              */
ATOM( 5.763,-0.572,  5.542, _CO) /*ATOM    141  C1'   A A   5       5.763  -0.572   5.542  1.00  0.00              */
ATOM( 4.537, 0.269,  5.492, _NO) /*ATOM    142  N9    A A   5       4.537   0.269   5.492  1.00  0.00              */
ATOM( 4.441, 1.633,  5.572, _CO) /*ATOM    143  C8    A A   5       4.441   1.633   5.572  1.00  0.00              */
ATOM( 3.220, 2.072,  5.502, _NO) /*ATOM    144  N7    A A   5       3.220   2.072   5.502  1.00  0.00              */
ATOM( 2.462, 0.924,  5.352, _CO) /*ATOM    145  C5    A A   5       2.462   0.924   5.352  1.00  0.00              */
ATOM( 1.074, 0.711,  5.222, _CO) /*ATOM    146  C6    A A   5       1.074   0.711   5.222  1.00  0.00              */
ATOM( 0.174, 1.690,  5.212, _NO) /*ATOM    147  N6    A A   5       0.174   1.690   5.212  1.00  0.00              */
ATOM( 0.652,-0.556,  5.102, _NO) /*ATOM    148  N1    A A   5       0.652  -0.556   5.102  1.00  0.00              */
ATOM( 1.550,-1.537,  5.112, _CO) /*ATOM    149  C2    A A   5       1.550  -1.537   5.112  1.00  0.00              */
ATOM( 2.858,-1.471,  5.232, _NO) /*ATOM    150  N3    A A   5       2.858  -1.471   5.232  1.00  0.00              */
ATOM( 3.251,-0.189,  5.352, _CO) /*ATOM    151  C4    A A   5       3.251  -0.189   5.352  1.00  0.00              */
ATOM( 8.529, 1.058,  8.331, _HO) /*ATOM    152  H5'1  A A   5       8.529   1.058   8.331  1.00  0.00              */
ATOM( 6.756, 0.968,  8.601, _HO) /*ATOM    153  H5'2  A A   5       6.756   0.968   8.601  1.00  0.00              */
ATOM( 8.016,-1.131,  7.734, _HO) /*ATOM    154  H4'   A A   5       8.016  -1.131   7.734  1.00  0.00              */
ATOM( 5.543,-1.545,  5.079, _HO) /*ATOM    155  H1'   A A   5       5.543  -1.545   5.079  1.00  0.00              */
ATOM( 6.884, 1.142,  4.799, _HO) /*ATOM    156  H2'1  A A   5       6.884   1.142   4.799  1.00  0.00              */
ATOM( 7.063,-0.346,  3.808, _HO) /*ATOM    157  H2'2  A A   5       7.063  -0.346   3.808  1.00  0.00              */
ATOM( 8.969, 0.289,  5.642, _HO) /*ATOM    158  H3'   A A   5       8.969   0.289   5.642  1.00  0.00              */
ATOM( 5.305, 2.287,  5.683, _HO) /*ATOM    159  H8    A A   5       5.305   2.287   5.683  1.00  0.00              */
ATOM( 0.478, 2.670,  5.302, _HO) /*ATOM    160  H61   A A   5       0.478   2.670   5.302  1.00  0.00              */
ATOM(-0.827, 1.468,  5.113, _HO) /*ATOM    161  H62   A A   5      -0.827   1.468   5.113  1.00  0.00              */
ATOM( 1.145,-2.537,  5.005, _HO) /*ATOM    162  H2    A A   5       1.145  -2.537   5.005  1.00  0.00              */
ATOM( 8.611,-2.076,  3.772, _PO) /*ATOM    163  P     A A   6       8.611  -2.076   3.772  1.00  0.00              */
ATOM( 9.681,-3.067,  3.552, _OO) /*ATOM    164  O1P   A A   6       9.681  -3.067   3.552  1.00  0.00              */
ATOM( 8.712,-0.825,  2.982, _OO) /*ATOM    165  O2P   A A   6       8.712  -0.825   2.982  1.00  0.00              */
ATOM( 7.186,-2.746,  3.522, _OO) /*ATOM    166  O5'   A A   6       7.186  -2.746   3.522  1.00  0.00              */
ATOM( 6.708,-3.741,  4.462, _CO) /*ATOM    167  C5'   A A   6       6.708  -3.741   4.462  1.00  0.00              */
ATOM( 5.895,-4.785,  3.732, _CO) /*ATOM    168  C4'   A A   6       5.895  -4.785   3.732  1.00  0.00              */
ATOM( 4.544,-4.264,  3.522, _OO) /*ATOM    169  O4'   A A   6       4.544  -4.264   3.522  1.00  0.00              */
ATOM( 6.375,-5.162,  2.332, _CO) /*ATOM    170  C3'   A A   6       6.375  -5.162   2.332  1.00  0.00              */
ATOM( 5.934,-6.460,  1.942, _OO) /*ATOM    171  O3'   A A   6       5.934  -6.460   1.942  1.00  0.00              */
ATOM( 5.703,-4.120,  1.452, _CO) /*ATOM    172  C2'   A A   6       5.703  -4.120   1.452  1.00  0.00              */
ATOM( 4.371,-3.916,  2.162, _CO) /*ATOM    173  C1'   A A   6       4.371  -3.916   2.162  1.00  0.00              */
ATOM( 3.874,-2.514,  2.112, _NO) /*ATOM    174  N9    A A   6       3.874  -2.514   2.112  1.00  0.00              */
ATOM( 4.597,-1.355,  2.192, _CO) /*ATOM    175  C8    A A   6       4.597  -1.355   2.192  1.00  0.00              */
ATOM( 3.868,-0.281,  2.122, _NO) /*ATOM    176  N7    A A   6       3.868  -0.281   2.122  1.00  0.00              */
ATOM( 2.581,-0.765,  1.972, _CO) /*ATOM    177  C5    A A   6       2.581  -0.765   1.972  1.00  0.00              */
ATOM( 1.332,-0.122,  1.842, _CO) /*ATOM    178  C6    A A   6       1.332  -0.122   1.842  1.00  0.00              */
ATOM( 1.179, 1.200,  1.832, _NO) /*ATOM    179  N6    A A   6       1.179   1.200   1.832  1.00  0.00              */
ATOM( 0.246,-0.899,  1.722, _NO) /*ATOM    180  N1    A A   6       0.246  -0.899   1.722  1.00  0.00              */
ATOM( 0.395,-2.220,  1.732, _CO) /*ATOM    181  C2    A A   6       0.395  -2.220   1.732  1.00  0.00              */
ATOM( 1.493,-2.936,  1.852, _NO) /*ATOM    182  N3    A A   6       1.493  -2.936   1.852  1.00  0.00              */
ATOM( 2.564,-2.129,  1.972, _CO) /*ATOM    183  C4    A A   6       2.564  -2.129   1.972  1.00  0.00              */
ATOM( 7.567,-4.223,  4.951, _HO) /*ATOM    184  H5'1  A A   6       7.567  -4.223   4.951  1.00  0.00              */
ATOM( 6.079,-3.254,  5.221, _HO) /*ATOM    185  H5'2  A A   6       6.079  -3.254   5.221  1.00  0.00              */
ATOM( 5.866,-5.691,  4.354, _HO) /*ATOM    186  H4'   A A   6       5.866  -5.691   4.354  1.00  0.00              */
ATOM( 3.621,-4.574,  1.699, _HO) /*ATOM    187  H1'   A A   6       3.621  -4.574   1.699  1.00  0.00              */
ATOM( 6.286,-3.188,  1.420, _HO) /*ATOM    188  H2'1  A A   6       6.286  -3.188   1.420  1.00  0.00              */
ATOM( 5.557,-4.496,  0.428, _HO) /*ATOM    189  H2'2  A A   6       5.557  -4.496   0.428  1.00  0.00              */
ATOM( 7.472,-5.105,  2.262, _HO) /*ATOM    190  H3'   A A   6       7.472  -5.105   2.262  1.00  0.00              */
ATOM( 5.680,-1.334,  2.303, _HO) /*ATOM    191  H8    A A   6       5.680  -1.334   2.303  1.00  0.00              */
ATOM( 2.001, 1.814,  1.922, _HO) /*ATOM    192  H61   A A   6       2.001   1.814   1.922  1.00  0.00              */
ATOM( 0.239, 1.609,  1.733, _HO) /*ATOM    193  H62   A A   6       0.239   1.609   1.733  1.00  0.00              */
ATOM(-0.521,-2.790,  1.625, _HO) /*ATOM    194  H2    A A   6      -0.521  -2.790   1.625  1.00  0.00              */
ATOM( 5.791,-6.806,  0.392, _PO) /*ATOM    195  P     T A   7       5.791  -6.806   0.392  1.00  0.00              */
ATOM( 6.075,-8.237,  0.172, _OO) /*ATOM    196  O1P   T A   7       6.075  -8.237   0.172  1.00  0.00              */
ATOM( 6.609,-5.854, -0.398, _OO) /*ATOM    197  O2P   T A   7       6.609  -5.854  -0.398  1.00  0.00              */
ATOM( 4.245,-6.510,  0.142, _OO) /*ATOM    198  O5'   T A   7       4.245  -6.510   0.142  1.00  0.00              */
ATOM( 3.273,-7.034,  1.082, _CO) /*ATOM    199  C5'   T A   7       3.273  -7.034   1.082  1.00  0.00              */
ATOM( 2.001,-7.402,  0.352, _CO) /*ATOM    200  C4'   T A   7       2.001  -7.402   0.352  1.00  0.00              */
ATOM( 1.215,-6.186,  0.142, _OO) /*ATOM    201  O4'   T A   7       1.215  -6.186   0.142  1.00  0.00              */
ATOM( 2.168,-7.988, -1.048, _CO) /*ATOM    202  C3'   T A   7       2.168  -7.988  -1.048  1.00  0.00              */
ATOM( 1.049,-8.779, -1.438, _OO) /*ATOM    203  O3'   T A   7       1.049  -8.779  -1.438  1.00  0.00              */
ATOM( 2.237,-6.750, -1.928, _CO) /*ATOM    204  C2'   T A   7       2.237  -6.750  -1.928  1.00  0.00              */
ATOM( 1.280,-5.802, -1.218, _CO) /*ATOM    205  C1'   T A   7       1.280  -5.802  -1.218  1.00  0.00              */
ATOM( 1.701,-4.376, -1.268, _NO) /*ATOM    206  N1    T A   7       1.701  -4.376  -1.268  1.00  0.00              */
ATOM( 0.709,-3.430, -1.418, _CO) /*ATOM    207  C2    T A   7       0.709  -3.430  -1.418  1.00  0.00              */
ATOM(-0.471,-3.721, -1.508, _OO) /*ATOM    208  O2    T A   7      -0.471  -3.721  -1.508  1.00  0.00              */
ATOM( 1.145,-2.121, -1.458, _NO) /*ATOM    209  N3    T A   7       1.145  -2.121  -1.458  1.00  0.00              */
ATOM( 2.446,-1.686, -1.368, _CO) /*ATOM    210  C4    T A   7       2.446  -1.686  -1.368  1.00  0.00              */
ATOM( 2.717,-0.480, -1.418, _OO) /*ATOM    211  O4    T A   7       2.717  -0.480  -1.418  1.00  0.00              */
ATOM( 3.415,-2.744, -1.218, _CO) /*ATOM    212  C5    T A   7       3.415  -2.744  -1.218  1.00  0.00              */
ATOM( 4.847,-2.316, -1.108, _CO) /*ATOM    213  C5M   T A   7       4.847  -2.316  -1.108  1.00  0.00              */
ATOM( 3.027,-4.034, -1.168, _CO) /*ATOM    214  C6    T A   7       3.027  -4.034  -1.168  1.00  0.00              */
ATOM( 3.685,-7.929,  1.572, _HO) /*ATOM    215  H5'1  T A   7       3.685  -7.929   1.572  1.00  0.00              */
ATOM( 3.050,-6.270,  1.841, _HO) /*ATOM    216  H5'2  T A   7       3.050  -6.270   1.841  1.00  0.00              */
ATOM( 1.445,-8.118,  0.974, _HO) /*ATOM    217  H4'   T A   7       1.445  -8.118   0.974  1.00  0.00              */
ATOM( 0.286,-5.893, -1.681, _HO) /*ATOM    218  H1'   T A   7       0.286  -5.893  -1.681  1.00  0.00              */
ATOM( 3.257,-6.339, -1.960, _HO) /*ATOM    219  H2'1  T A   7       3.257  -6.339  -1.960  1.00  0.00              */
ATOM( 1.898,-6.968, -2.952, _HO) /*ATOM    220  H2'2  T A   7       1.898  -6.968  -2.952  1.00  0.00              */
ATOM( 3.089,-8.586, -1.118, _HO) /*ATOM    221  H3'   T A   7       3.089  -8.586  -1.118  1.00  0.00              */
ATOM( 3.776,-4.816, -1.047, _HO) /*ATOM    222  H6    T A   7       3.776  -4.816  -1.047  1.00  0.00              */
ATOM( 5.349,-2.461, -2.077, _HO) /*ATOM    223  H51   T A   7       5.349  -2.461  -2.077  1.00  0.00              */
ATOM( 5.352,-2.919, -0.340, _HO) /*ATOM    224  H52   T A   7       5.352  -2.919  -0.340  1.00  0.00              */
ATOM( 4.892,-1.253, -0.828, _HO) /*ATOM    225  H53   T A   7       4.892  -1.253  -0.828  1.00  0.00              */
ATOM( 0.443,-1.417, -1.564, _HO) /*ATOM    226  H3    T A   7       0.443  -1.417  -1.564  1.00  0.00              */
ATOM( 0.730,-8.975, -2.988, _PO) /*ATOM    227  P     T A   8       0.730  -8.975  -2.988  1.00  0.00              */
ATOM( 0.118,10.300, -3.208, _OO) /*ATOM    228  O1P   T A   8       0.118 -10.300  -3.208  1.00  0.00              */
ATOM( 1.951,-8.685, -3.778, _OO) /*ATOM    229  O2P   T A   8       1.951  -8.685  -3.778  1.00  0.00              */
ATOM(-0.348,-7.827, -3.238, _OO) /*ATOM    230  O5'   T A   8      -0.348  -7.827  -3.238  1.00  0.00              */
ATOM(-1.442,-7.680, -2.298, _CO) /*ATOM    231  C5'   T A   8      -1.442  -7.680  -2.298  1.00  0.00              */
ATOM(-2.686,-7.230, -3.028, _CO) /*ATOM    232  C4'   T A   8      -2.686  -7.230  -3.028  1.00  0.00              */
ATOM(-2.608,-5.784, -3.238, _OO) /*ATOM    233  O4'   T A   8      -2.608  -5.784  -3.238  1.00  0.00              */
ATOM(-2.896,-7.803, -4.428, _CO) /*ATOM    234  C3'   T A   8      -2.896  -7.803  -4.428  1.00  0.00              */
ATOM(-4.267,-7.784, -4.818, _OO) /*ATOM    235  O3'   T A   8      -4.267  -7.784  -4.818  1.00  0.00              */
ATOM(-2.113,-6.842, -5.308, _CO) /*ATOM    236  C2'   T A   8      -2.113  -6.842  -5.308  1.00  0.00              */
ATOM(-2.330,-5.512, -4.598, _CO) /*ATOM    237  C1'   T A   8      -2.330  -5.512  -4.598  1.00  0.00              */
ATOM(-1.151,-4.606, -4.648, _NO) /*ATOM    238  N1    T A   8      -1.151  -4.606  -4.648  1.00  0.00              */
ATOM(-1.398,-3.257, -4.798, _CO) /*ATOM    239  C2    T A   8      -1.398  -3.257  -4.798  1.00  0.00              */
ATOM(-2.523,-2.799, -4.888, _OO) /*ATOM    240  O2    T A   8      -2.523  -2.799  -4.888  1.00  0.00              */
ATOM(-0.275,-2.454, -4.838, _NO) /*ATOM    241  N3    T A   8      -0.275  -2.454  -4.838  1.00  0.00              */
ATOM( 1.034,-2.867, -4.748, _CO) /*ATOM    242  C4    T A   8       1.034  -2.867  -4.748  1.00  0.00              */
ATOM( 1.961,-2.050, -4.798, _OO) /*ATOM    243  O4    T A   8       1.961  -2.050  -4.798  1.00  0.00              */
ATOM( 1.195,-4.293, -4.598, _CO) /*ATOM    244  C5    T A   8       1.195  -4.293  -4.598  1.00  0.00              */
ATOM( 2.606,-4.788, -4.488, _CO) /*ATOM    245  C5M   T A   8       2.606  -4.788  -4.488  1.00  0.00              */
ATOM( 0.123,-5.108, -4.548, _CO) /*ATOM    246  C6    T A   8       0.123  -5.108  -4.548  1.00  0.00              */
ATOM(-1.635,-8.646, -1.809, _HO) /*ATOM    247  H5'1  T A   8      -1.635  -8.646  -1.809  1.00  0.00              */
ATOM(-1.173,-6.931, -1.539, _HO) /*ATOM    248  H5'2  T A   8      -1.173  -6.931  -1.539  1.00  0.00              */
ATOM(-3.557,-7.483, -2.406, _HO) /*ATOM    249  H4'   T A   8      -3.557  -7.483  -2.406  1.00  0.00              */
ATOM(-3.187,-5.001, -5.061, _HO) /*ATOM    250  H1'   T A   8      -3.187  -5.001  -5.061  1.00  0.00              */
ATOM(-1.046,-7.108, -5.340, _HO) /*ATOM    251  H2'1  T A   8      -1.046  -7.108  -5.340  1.00  0.00              */
ATOM(-2.516,-6.819, -6.332, _HO) /*ATOM    252  H2'2  T A   8      -2.516  -6.819  -6.332  1.00  0.00              */
ATOM(-2.503,-8.828, -4.498, _HO) /*ATOM    253  H3'   T A   8      -2.503  -8.828  -4.498  1.00  0.00              */
ATOM( 0.269,-6.180, -4.427, _HO) /*ATOM    254  H6    T A   8       0.269  -6.180  -4.427  1.00  0.00              */
ATOM( 2.927,-5.200, -5.457, _HO) /*ATOM    255  H51   T A   8       2.927  -5.200  -5.457  1.00  0.00              */
ATOM( 2.661,-5.573, -3.720, _HO) /*ATOM    256  H52   T A   8       2.661  -5.573  -3.720  1.00  0.00              */
ATOM( 3.267,-3.954, -4.208, _HO) /*ATOM    257  H53   T A   8       3.267  -3.954  -4.208  1.00  0.00              */
ATOM(-0.429,-1.472, -4.944, _HO) /*ATOM    258  H3    T A   8      -0.429  -1.472  -4.944  1.00  0.00              */
ATOM(-4.640,-7.755, -6.368, _PO) /*ATOM    259  P     T A   9      -4.640  -7.755  -6.368  1.00  0.00              */
ATOM(-5.914,-8.468, -6.588, _OO) /*ATOM    260  O1P   T A   9      -5.914  -8.468  -6.588  1.00  0.00              */
ATOM(-3.482,-8.239, -7.158, _OO) /*ATOM    261  O2P   T A   9      -3.482  -8.239  -7.158  1.00  0.00              */
ATOM(-4.837,-6.193, -6.618, _OO) /*ATOM    262  O5'   T A   9      -4.837  -6.193  -6.618  1.00  0.00              */
ATOM(-5.636,-5.432, -5.678, _CO) /*ATOM    263  C5'   T A   9      -5.636  -5.432  -5.678  1.00  0.00              */
ATOM(-6.378,-4.335, -6.408, _CO) /*ATOM    264  C4'   T A   9      -6.378  -4.335  -6.408  1.00  0.00              */
ATOM(-5.465,-3.212, -6.618, _OO) /*ATOM    265  O4'   T A   9      -5.465  -3.212  -6.618  1.00  0.00              */
ATOM(-6.884,-4.676, -7.808, _CO) /*ATOM    266  C3'   T A   9      -6.884  -4.676  -7.808  1.00  0.00              */
ATOM(-7.982,-3.855, -8.198, _OO) /*ATOM    267  O3'   T A   9      -7.982  -3.855  -8.198  1.00  0.00              */
ATOM(-5.686,-4.358, -8.688, _CO) /*ATOM    268  C2'   T A   9      -5.686  -4.358  -8.688  1.00  0.00              */
ATOM(-5.080,-3.155, -7.978, _CO) /*ATOM    269  C1'   T A   9      -5.080  -3.155  -7.978  1.00  0.00              */
ATOM(-3.593,-3.115, -8.028, _NO) /*ATOM    270  N1    T A   9      -3.593  -3.115  -8.028  1.00  0.00              */
ATOM(-3.000,-1.879, -8.178, _CO) /*ATOM    271  C2    T A   9      -3.000  -1.879  -8.178  1.00  0.00              */
ATOM(-3.641,-0.846, -8.268, _OO) /*ATOM    272  O2    T A   9      -3.641  -0.846  -8.268  1.00  0.00              */
ATOM(-1.620,-1.889, -8.218, _NO) /*ATOM    273  N3    T A   9      -1.620  -1.889  -8.218  1.00  0.00              */
ATOM(-0.804,-2.992, -8.128, _CO) /*ATOM    274  C4    T A   9      -0.804  -2.992  -8.128  1.00  0.00              */
ATOM( 0.426,-2.877, -8.178, _OO) /*ATOM    275  O4    T A   9       0.426  -2.877  -8.178  1.00  0.00              */
ATOM(-1.511,-4.241, -7.978, _CO) /*ATOM    276  C5    T A   9      -1.511  -4.241  -7.978  1.00  0.00              */
ATOM(-0.661,-5.470, -7.868, _CO) /*ATOM    277  C5M   T A   9      -0.661  -5.470  -7.868  1.00  0.00              */
ATOM(-2.858,-4.270, -7.928, _CO) /*ATOM    278  C6    T A   9      -2.858  -4.270  -7.928  1.00  0.00              */
ATOM(-6.360,-6.100, -5.190, _HO) /*ATOM    279  H5'1  T A   9      -6.360  -6.100  -5.190  1.00  0.00              */
ATOM(-4.978,-4.985, -4.918, _HO) /*ATOM    280  H5'2  T A   9      -4.978  -4.985  -4.918  1.00  0.00              */
ATOM(-7.231,-4.027, -5.786, _HO) /*ATOM    281  H4'   T A   9      -7.231  -4.027  -5.786  1.00  0.00              */
ATOM(-5.473,-2.238, -8.441, _HO) /*ATOM    282  H1'   T A   9      -5.473  -2.238  -8.441  1.00  0.00              */
ATOM(-4.979,-5.200, -8.721, _HO) /*ATOM    283  H2'1  T A   9      -4.979  -5.200  -8.721  1.00  0.00              */
ATOM(-5.998,-4.102, -9.712, _HO) /*ATOM    284  H2'2  T A   9      -5.998  -4.102  -9.712  1.00  0.00              */
ATOM(-7.168,-5.736, -7.878, _HO) /*ATOM    285  H3'   T A   9      -7.168  -5.736  -7.878  1.00  0.00              */
ATOM(-3.370,-5.223, -7.807, _HO) /*ATOM    286  H6    T A   9      -3.370  -5.223  -7.807  1.00  0.00              */
ATOM(-0.644,-5.992, -8.837, _HO) /*ATOM    287  H51   T A   9      -0.644  -5.992  -8.837  1.00  0.00              */
ATOM(-1.078,-6.137, -7.100, _HO) /*ATOM    288  H52   T A   9      -1.078  -6.137  -7.100  1.00  0.00              */
ATOM( 0.364,-5.184, -7.588, _HO) /*ATOM    289  H53   T A   9       0.364  -5.184  -7.588  1.00  0.00              */
ATOM(-1.167,-1.003, -8.324, _HO) /*ATOM    290  H3    T A   9      -1.167  -1.003  -8.324  1.00  0.00              */
ATOM(-8.267,-3.612, -9.748, _PO) /*ATOM    291  P     G A  10      -8.267  -3.612  -9.748  1.00  0.00              */
ATOM(-9.716,-3.440, -9.968, _OO) /*ATOM    292  O1P   G A  10      -9.716  -3.440  -9.968  1.00  0.00              */
ATOM(-7.614,-4.684,-10.538, _OO) /*ATOM    293  O2P   G A  10      -7.614  -4.684 -10.538  1.00  0.00              */
ATOM(-7.509,-2.233, -9.998, _OO) /*ATOM    294  O5'   G A  10      -7.509  -2.233  -9.998  1.00  0.00              */
ATOM(-7.707,-1.147, -9.058, _CO) /*ATOM    295  C5'   G A  10      -7.707  -1.147  -9.058  1.00  0.00              */
ATOM(-7.663, 0.176, -9.788, _CO) /*ATOM    296  C4'   G A  10      -7.663   0.176  -9.788  1.00  0.00              */
ATOM(-6.264, 0.548, -9.998, _OO) /*ATOM    297  O4'   G A  10      -6.264   0.548  -9.998  1.00  0.00              */
ATOM(-8.272, 0.198,-11.188, _CO) /*ATOM    298  C3'   G A  10      -8.272   0.198 -11.188  1.00  0.00              */
ATOM(-8.679, 1.508,-11.578, _OO) /*ATOM    299  O3'   G A  10      -8.679   1.508 -11.578  1.00  0.00              */
ATOM(-7.116,-0.249,-12.068, _CO) /*ATOM    300  C2'   G A  10      -7.116  -0.249 -12.068  1.00  0.00              */
ATOM(-5.919, 0.368,-11.358, _CO) /*ATOM    301  C1'   G A  10      -5.919   0.368 -11.358  1.00  0.00              */
ATOM(-4.693,-0.473,-11.408, _NO) /*ATOM    302  N9    G A  10      -4.693  -0.473 -11.408  1.00  0.00              */
ATOM(-4.572,-1.845,-11.328, _CO) /*ATOM    303  C8    G A  10      -4.572  -1.845 -11.328  1.00  0.00              */
ATOM(-3.339,-2.277,-11.408, _NO) /*ATOM    304  N7    G A  10      -3.339  -2.277 -11.408  1.00  0.00              */
ATOM(-2.581,-1.113,-11.548, _CO) /*ATOM    305  C5    G A  10      -2.581  -1.113 -11.548  1.00  0.00              */
ATOM(-1.184,-0.944,-11.678, _CO) /*ATOM    306  C6    G A  10      -1.184  -0.944 -11.678  1.00  0.00              */
ATOM(-0.298,-1.798,-11.698, _OO) /*ATOM    307  O6    G A  10      -0.298  -1.798 -11.698  1.00  0.00              */
ATOM(-0.840, 0.414,-11.798, _NO) /*ATOM    308  N1    G A  10      -0.840   0.414 -11.798  1.00  0.00              */
ATOM(-1.737, 1.462,-11.798, _CO) /*ATOM    309  C2    G A  10      -1.737   1.462 -11.798  1.00  0.00              */
ATOM(-1.215, 2.685,-11.928, _NO) /*ATOM    310  N2    G A  10      -1.215   2.685 -11.928  1.00  0.00              */
ATOM(-3.052, 1.304,-11.668, _NO) /*ATOM    311  N3    G A  10      -3.052   1.304 -11.668  1.00  0.00              */
ATOM(-3.407,-0.003,-11.548, _CO) /*ATOM    312  C4    G A  10      -3.407  -0.003 -11.548  1.00  0.00              */
ATOM(-8.685,-1.262, -8.569, _HO) /*ATOM    313  H5'1  G A  10      -8.685  -1.262  -8.569  1.00  0.00              */
ATOM(-6.912,-1.172, -8.299, _HO) /*ATOM    314  H5'2  G A  10      -6.912  -1.172  -8.299  1.00  0.00              */
ATOM(-8.172, 0.927, -9.166, _HO) /*ATOM    315  H4'   G A  10      -8.172   0.927  -9.166  1.00  0.00              */
ATOM(-5.698, 1.341,-11.821, _HO) /*ATOM    316  H1'   G A  10      -5.698   1.341 -11.821  1.00  0.00              */
ATOM(-7.039,-1.346,-12.101, _HO) /*ATOM    317  H2'1  G A  10      -7.039  -1.346 -12.101  1.00  0.00              */
ATOM(-7.218, 0.142,-13.092, _HO) /*ATOM    318  H2'2  G A  10      -7.218   0.142 -13.092  1.00  0.00              */
ATOM(-9.125,-0.493,-11.258, _HO) /*ATOM    319  H3'   G A  10      -9.125  -0.493 -11.258  1.00  0.00              */
ATOM(-5.426,-2.510,-11.209, _HO) /*ATOM    320  H8    G A  10      -5.426  -2.510 -11.209  1.00  0.00              */
ATOM( 0.130, 0.637,-11.891, _HO) /*ATOM    321  H1    G A  10       0.130   0.637 -11.891  1.00  0.00              */
ATOM(-1.831, 3.511,-11.928, _HO) /*ATOM    322  H21   G A  10      -1.831   3.511 -11.928  1.00  0.00              */
ATOM(-0.196, 2.802,-12.029, _HO) /*ATOM    323  H22   G A  10      -0.196   2.802 -12.029  1.00  0.00              */
ATOM(-8.767, 1.872,-13.128, _PO) /*ATOM    324  P     C A  11      -8.767   1.872 -13.128  1.00  0.00              */
ATOM(-9.837, 2.863,-13.348, _OO) /*ATOM    325  O1P   C A  11      -9.837   2.863 -13.348  1.00  0.00              */
ATOM(-8.868, 0.621,-13.918, _OO) /*ATOM    326  O2P   C A  11      -8.868   0.621 -13.918  1.00  0.00              */
ATOM(-7.342, 2.542,-13.378, _OO) /*ATOM    327  O5'   C A  11      -7.342   2.542 -13.378  1.00  0.00              */
ATOM(-6.864, 3.537,-12.438, _CO) /*ATOM    328  C5'   C A  11      -6.864   3.537 -12.438  1.00  0.00              */
ATOM(-6.051, 4.581,-13.168, _CO) /*ATOM    329  C4'   C A  11      -6.051   4.581 -13.168  1.00  0.00              */
ATOM(-4.700, 4.060,-13.378, _OO) /*ATOM    330  O4'   C A  11      -4.700   4.060 -13.378  1.00  0.00              */
ATOM(-6.531, 4.958,-14.568, _CO) /*ATOM    331  C3'   C A  11      -6.531   4.958 -14.568  1.00  0.00              */
ATOM(-6.090, 6.256,-14.958, _OO) /*ATOM    332  O3'   C A  11      -6.090   6.256 -14.958  1.00  0.00              */
ATOM(-5.859, 3.916,-15.448, _CO) /*ATOM    333  C2'   C A  11      -5.859   3.916 -15.448  1.00  0.00              */
ATOM(-4.527, 3.712,-14.738, _CO) /*ATOM    334  C1'   C A  11      -4.527   3.712 -14.738  1.00  0.00              */
ATOM(-4.030, 2.310,-14.788, _NO) /*ATOM    335  N1    C A  11      -4.030   2.310 -14.788  1.00  0.00              */
ATOM(-2.660, 2.111,-14.938, _CO) /*ATOM    336  C2    C A  11      -2.660   2.111 -14.938  1.00  0.00              */
ATOM(-1.917, 3.097,-15.028, _OO) /*ATOM    337  O2    C A  11      -1.917   3.097 -15.028  1.00  0.00              */
ATOM(-2.261, 0.654,-14.988, _NO) /*ATOM    338  N3    C A  11      -2.261   0.654 -14.988  1.00  0.00              */
ATOM(-3.016,-0.205,-14.888, _CO) /*ATOM    339  C4    C A  11      -3.016  -0.205 -14.888  1.00  0.00              */
ATOM(-2.501,-1.423,-14.938, _NO) /*ATOM    340  N4    C A  11      -2.501  -1.423 -14.938  1.00  0.00              */
ATOM(-4.427,-0.026,-14.738, _CO) /*ATOM    341  C5    C A  11      -4.427  -0.026 -14.738  1.00  0.00              */
ATOM(-4.879, 1.257,-14.688, _CO) /*ATOM    342  C6    C A  11      -4.879   1.257 -14.688  1.00  0.00              */
ATOM(-7.723, 4.019,-11.949, _HO) /*ATOM    343  H5'1  C A  11      -7.723   4.019 -11.949  1.00  0.00              */
ATOM(-6.235, 3.050,-11.679, _HO) /*ATOM    344  H5'2  C A  11      -6.235   3.050 -11.679  1.00  0.00              */
ATOM(-6.022, 5.487,-12.546, _HO) /*ATOM    345  H4'   C A  11      -6.022   5.487 -12.546  1.00  0.00              */
ATOM(-3.776, 4.370,-15.201, _HO) /*ATOM    346  H1'   C A  11      -3.776   4.370 -15.201  1.00  0.00              */
ATOM(-6.442, 2.984,-15.480, _HO) /*ATOM    347  H2'1  C A  11      -6.442   2.984 -15.480  1.00  0.00              */
ATOM(-5.713, 4.292,-16.472, _HO) /*ATOM    348  H2'2  C A  11      -5.713   4.292 -16.472  1.00  0.00              */
ATOM(-7.627, 4.901,-14.638, _HO) /*ATOM    349  H3'   C A  11      -7.627   4.901 -14.638  1.00  0.00              */
ATOM(-5.945, 1.442,-14.566, _HO) /*ATOM    350  H6    C A  11      -5.945   1.442 -14.566  1.00  0.00              */
ATOM(-5.106,-0.874,-14.668, _HO) /*ATOM    351  H5    C A  11      -5.106  -0.874 -14.668  1.00  0.00              */
ATOM(-1.485,-1.548,-15.056, _HO) /*ATOM    352  H41   C A  11      -1.485  -1.548 -15.056  1.00  0.00              */
ATOM(-3.116,-2.246,-14.859, _HO) /*ATOM    353  H42   C A  11      -3.116  -2.246 -14.859  1.00  0.00              */
ATOM(-5.947, 6.602,-16.508, _PO) /*ATOM    354  P     G A  12      -5.947   6.602 -16.508  1.00  0.00              */
ATOM(-6.231, 8.033,-16.728, _OO) /*ATOM    355  O1P   G A  12      -6.231   8.033 -16.728  1.00  0.00              */
ATOM(-6.765, 5.650,-17.298, _OO) /*ATOM    356  O2P   G A  12      -6.765   5.650 -17.298  1.00  0.00              */
ATOM(-4.401, 6.306,-16.758, _OO) /*ATOM    357  O5'   G A  12      -4.401   6.306 -16.758  1.00  0.00              */
ATOM(-3.429, 6.830,-15.818, _CO) /*ATOM    358  C5'   G A  12      -3.429   6.830 -15.818  1.00  0.00              */
ATOM(-2.157, 7.198,-16.548, _CO) /*ATOM    359  C4'   G A  12      -2.157   7.198 -16.548  1.00  0.00              */
ATOM(-1.371, 5.982,-16.758, _OO) /*ATOM    360  O4'   G A  12      -1.371   5.982 -16.758  1.00  0.00              */
ATOM(-2.324, 7.784,-17.948, _CO) /*ATOM    361  C3'   G A  12      -2.324   7.784 -17.948  1.00  0.00              */
ATOM(-1.205, 8.575,-18.338, _OO) /*ATOM    362  O3'   G A  12      -1.205   8.575 -18.338  1.00  0.00              */
ATOM(-2.393, 6.546,-18.828, _CO) /*ATOM    363  C2'   G A  12      -2.393   6.546 -18.828  1.00  0.00              */
ATOM(-1.436, 5.598,-18.118, _CO) /*ATOM    364  C1'   G A  12      -1.436   5.598 -18.118  1.00  0.00              */
ATOM(-1.857, 4.172,-18.168, _NO) /*ATOM    365  N9    G A  12      -1.857   4.172 -18.168  1.00  0.00              */
ATOM(-3.124, 3.633,-18.088, _CO) /*ATOM    366  C8    G A  12      -3.124   3.633 -18.088  1.00  0.00              */
ATOM(-3.154, 2.328,-18.168, _NO) /*ATOM    367  N7    G A  12      -3.154   2.328 -18.168  1.00  0.00              */
ATOM(-1.814, 1.966,-18.308, _CO) /*ATOM    368  C5    G A  12      -1.814   1.966 -18.308  1.00  0.00              */
ATOM(-1.221, 0.689,-18.438, _CO) /*ATOM    369  C6    G A  12      -1.221   0.689 -18.438  1.00  0.00              */
ATOM(-1.759,-0.417,-18.458, _OO) /*ATOM    370  O6    G A  12      -1.759  -0.417 -18.458  1.00  0.00              */
ATOM( 0.177, 0.782,-18.558, _NO) /*ATOM    371  N1    G A  12       0.177   0.782 -18.558  1.00  0.00              */
ATOM( 0.896, 1.959,-18.558, _CO) /*ATOM    372  C2    G A  12       0.896   1.959 -18.558  1.00  0.00              */
ATOM( 2.221, 1.841,-18.688, _NO) /*ATOM    373  N2    G A  12       2.221   1.841 -18.688  1.00  0.00              */
ATOM( 0.340, 3.161,-18.428, _NO) /*ATOM    374  N3    G A  12       0.340   3.161 -18.428  1.00  0.00              */
ATOM(-1.013, 3.094,-18.308, _CO) /*ATOM    375  C4    G A  12      -1.013   3.094 -18.308  1.00  0.00              */
ATOM(-0.397, 8.073,-18.207, _HO) /*ATOM    376  HCAP  G A  12      -0.397   8.073 -18.207  1.00  0.00              */
ATOM(-3.840, 7.725,-15.328, _HO) /*ATOM    377  H5'1  G A  12      -3.840   7.725 -15.328  1.00  0.00              */
ATOM(-3.206, 6.066,-15.059, _HO) /*ATOM    378  H5'2  G A  12      -3.206   6.066 -15.059  1.00  0.00              */
ATOM(-1.601, 7.914,-15.926, _HO) /*ATOM    379  H4'   G A  12      -1.601   7.914 -15.926  1.00  0.00              */
ATOM(-0.442, 5.689,-18.581, _HO) /*ATOM    380  H1'   G A  12      -0.442   5.689 -18.581  1.00  0.00              */
ATOM(-3.413, 6.135,-18.860, _HO) /*ATOM    381  H2'1  G A  12      -3.413   6.135 -18.860  1.00  0.00              */
ATOM(-2.054, 6.764,-19.852, _HO) /*ATOM    382  H2'2  G A  12      -2.054   6.764 -19.852  1.00  0.00              */
ATOM(-3.244, 8.382,-18.018, _HO) /*ATOM    383  H3'   G A  12      -3.244   8.382 -18.018  1.00  0.00              */
ATOM(-4.020, 4.240,-17.969, _HO) /*ATOM    384  H8    G A  12      -4.020   4.240 -17.969  1.00  0.00              */
ATOM( 0.690,-0.072,-18.651, _HO) /*ATOM    385  H1    G A  12       0.690  -0.072 -18.651  1.00  0.00              */
ATOM( 2.816, 2.682,-18.688, _HO) /*ATOM    386  H21   G A  12       2.816   2.682 -18.688  1.00  0.00              */
ATOM( 2.648, 0.909,-18.789, _HO) /*ATOM    387  H22   G A  12       2.648   0.909 -18.789  1.00  0.00              */
ATOM( 4.484,-7.755,-20.668, _PO) /*ATOM    389  P     C B   1       4.484  -7.755 -20.668  1.00  0.00              */
ATOM( 5.758,-8.468,-20.448, _OO) /*ATOM    390  O1P   C B   1       5.758  -8.468 -20.448  1.00  0.00              */
ATOM( 3.326,-8.239,-19.878, _OO) /*ATOM    391  O2P   C B   1       3.326  -8.239 -19.878  1.00  0.00              */
ATOM( 4.681,-6.193,-20.418, _OO) /*ATOM    392  O5'   C B   1       4.681  -6.193 -20.418  1.00  0.00              */
ATOM( 5.480,-5.432,-21.358, _CO) /*ATOM    393  C5'   C B   1       5.480  -5.432 -21.358  1.00  0.00              */
ATOM( 6.222,-4.335,-20.628, _CO) /*ATOM    394  C4'   C B   1       6.222  -4.335 -20.628  1.00  0.00              */
ATOM( 5.309,-3.212,-20.418, _OO) /*ATOM    395  O4'   C B   1       5.309  -3.212 -20.418  1.00  0.00              */
ATOM( 6.728,-4.676,-19.228, _CO) /*ATOM    396  C3'   C B   1       6.728  -4.676 -19.228  1.00  0.00              */
ATOM( 7.826,-3.855,-18.838, _OO) /*ATOM    397  O3'   C B   1       7.826  -3.855 -18.838  1.00  0.00              */
ATOM( 5.530,-4.358,-18.348, _CO) /*ATOM    398  C2'   C B   1       5.530  -4.358 -18.348  1.00  0.00              */
ATOM( 4.924,-3.155,-19.058, _CO) /*ATOM    399  C1'   C B   1       4.924  -3.155 -19.058  1.00  0.00              */
ATOM( 3.437,-3.115,-19.008, _NO) /*ATOM    400  N1    C B   1       3.437  -3.115 -19.008  1.00  0.00              */
ATOM( 2.824,-1.873,-18.858, _CO) /*ATOM    401  C2    C B   1       2.824  -1.873 -18.858  1.00  0.00              */
ATOM( 3.533,-0.863,-18.768, _OO) /*ATOM    402  O2    C B   1       3.533  -0.863 -18.768  1.00  0.00              */
ATOM( 1.315,-1.944,-18.808, _NO) /*ATOM    403  N3    C B   1       1.315  -1.944 -18.808  1.00  0.00              */
ATOM( 0.732,-2.928,-18.908, _CO) /*ATOM    404  C4    C B   1       0.732  -2.928 -18.908  1.00  0.00              */
ATOM(-0.586,-2.815,-18.858, _NO) /*ATOM    405  N4    C B   1      -0.586  -2.815 -18.858  1.00  0.00              */
ATOM( 1.338,-4.215,-19.058, _CO) /*ATOM    406  C5    C B   1       1.338  -4.215 -19.058  1.00  0.00              */
ATOM( 2.698,-4.249,-19.108, _CO) /*ATOM    407  C6    C B   1       2.698  -4.249 -19.108  1.00  0.00              */
ATOM( 4.131,-7.948,-22.109, _OO) /*ATOM    408  OXT   C B   1       4.131  -7.948 -22.109  1.00  0.00              */
ATOM( 6.204,-6.100,-21.847, _HO) /*ATOM    409  H5'1  C B   1       6.204  -6.100 -21.847  1.00  0.00              */
ATOM( 4.823,-4.985,-22.119, _HO) /*ATOM    410  H5'2  C B   1       4.823  -4.985 -22.119  1.00  0.00              */
ATOM( 7.075,-4.027,-21.251, _HO) /*ATOM    411  H4'   C B   1       7.075  -4.027 -21.251  1.00  0.00              */
ATOM( 5.318,-2.238,-18.596, _HO) /*ATOM    412  H1'   C B   1       5.318  -2.238 -18.596  1.00  0.00              */
ATOM( 4.824,-5.200,-18.316, _HO) /*ATOM    413  H2'1  C B   1       4.824  -5.200 -18.316  1.00  0.00              */
ATOM( 5.843,-4.102,-17.325, _HO) /*ATOM    414  H2'2  C B   1       5.843  -4.102 -17.325  1.00  0.00              */
ATOM( 7.013,-5.736,-19.159, _HO) /*ATOM    415  H3'   C B   1       7.013  -5.736 -19.159  1.00  0.00              */
ATOM( 3.204,-5.206,-19.231, _HO) /*ATOM    416  H6    C B   1       3.204  -5.206 -19.231  1.00  0.00              */
ATOM( 0.741,-5.123,-19.129, _HO) /*ATOM    417  H5    C B   1       0.741  -5.123 -19.129  1.00  0.00              */
ATOM(-1.019,-1.888,-18.741, _HO) /*ATOM    418  H41   C B   1      -1.019  -1.888 -18.741  1.00  0.00              */
ATOM(-1.178,-3.654,-18.937, _HO) /*ATOM    419  H42   C B   1      -1.178  -3.654 -18.937  1.00  0.00              */
ATOM( 3.749,-8.809,-22.229, _HO) /*ATOM    420  HTER  C B   1       3.749  -8.809 -22.229  1.00  0.00              */
ATOM( 8.111,-3.612,-17.288, _PO) /*ATOM    421  P     G B   2       8.111  -3.612 -17.288  1.00  0.00              */
ATOM( 9.560,-3.440,-17.068, _OO) /*ATOM    422  O1P   G B   2       9.560  -3.440 -17.068  1.00  0.00              */
ATOM( 7.458,-4.684,-16.498, _OO) /*ATOM    423  O2P   G B   2       7.458  -4.684 -16.498  1.00  0.00              */
ATOM( 7.353,-2.233,-17.038, _OO) /*ATOM    424  O5'   G B   2       7.353  -2.233 -17.038  1.00  0.00              */
ATOM( 7.551,-1.147,-17.978, _CO) /*ATOM    425  C5'   G B   2       7.551  -1.147 -17.978  1.00  0.00              */
ATOM( 7.507, 0.176,-17.248, _CO) /*ATOM    426  C4'   G B   2       7.507   0.176 -17.248  1.00  0.00              */
ATOM( 6.108, 0.548,-17.038, _OO) /*ATOM    427  O4'   G B   2       6.108   0.548 -17.038  1.00  0.00              */
ATOM( 8.116, 0.198,-15.848, _CO) /*ATOM    428  C3'   G B   2       8.116   0.198 -15.848  1.00  0.00              */
ATOM( 8.523, 1.508,-15.458, _OO) /*ATOM    429  O3'   G B   2       8.523   1.508 -15.458  1.00  0.00              */
ATOM( 6.960,-0.249,-14.968, _CO) /*ATOM    430  C2'   G B   2       6.960  -0.249 -14.968  1.00  0.00              */
ATOM( 5.763, 0.368,-15.678, _CO) /*ATOM    431  C1'   G B   2       5.763   0.368 -15.678  1.00  0.00              */
ATOM( 4.537,-0.473,-15.628, _NO) /*ATOM    432  N9    G B   2       4.537  -0.473 -15.628  1.00  0.00              */
ATOM( 4.416,-1.845,-15.708, _CO) /*ATOM    433  C8    G B   2       4.416  -1.845 -15.708  1.00  0.00              */
ATOM( 3.183,-2.277,-15.628, _NO) /*ATOM    434  N7    G B   2       3.183  -2.277 -15.628  1.00  0.00              */
ATOM( 2.425,-1.113,-15.488, _CO) /*ATOM    435  C5    G B   2       2.425  -1.113 -15.488  1.00  0.00              */
ATOM( 1.028,-0.944,-15.358, _CO) /*ATOM    436  C6    G B   2       1.028  -0.944 -15.358  1.00  0.00              */
ATOM( 0.142,-1.798,-15.338, _OO) /*ATOM    437  O6    G B   2       0.142  -1.798 -15.338  1.00  0.00              */
ATOM( 0.684, 0.414,-15.238, _NO) /*ATOM    438  N1    G B   2       0.684   0.414 -15.238  1.00  0.00              */
ATOM( 1.581, 1.462,-15.238, _CO) /*ATOM    439  C2    G B   2       1.581   1.462 -15.238  1.00  0.00              */
ATOM( 1.059, 2.685,-15.108, _NO) /*ATOM    440  N2    G B   2       1.059   2.685 -15.108  1.00  0.00              */
ATOM( 2.896, 1.304,-15.368, _NO) /*ATOM    441  N3    G B   2       2.896   1.304 -15.368  1.00  0.00              */
ATOM( 3.251,-0.003,-15.488, _CO) /*ATOM    442  C4    G B   2       3.251  -0.003 -15.488  1.00  0.00              */
ATOM( 8.529,-1.262,-18.468, _HO) /*ATOM    443  H5'1  G B   2       8.529  -1.262 -18.468  1.00  0.00              */
ATOM( 6.756,-1.172,-18.738, _HO) /*ATOM    444  H5'2  G B   2       6.756  -1.172 -18.738  1.00  0.00              */
ATOM( 8.017, 0.927,-17.871, _HO) /*ATOM    445  H4'   G B   2       8.017   0.927 -17.871  1.00  0.00              */
ATOM( 5.543, 1.341,-15.216, _HO) /*ATOM    446  H1'   G B   2       5.543   1.341 -15.216  1.00  0.00              */
ATOM( 6.884,-1.346,-14.936, _HO) /*ATOM    447  H2'1  G B   2       6.884  -1.346 -14.936  1.00  0.00              */
ATOM( 7.063, 0.142,-13.945, _HO) /*ATOM    448  H2'2  G B   2       7.063   0.142 -13.945  1.00  0.00              */
ATOM( 8.969,-0.493,-15.779, _HO) /*ATOM    449  H3'   G B   2       8.969  -0.493 -15.779  1.00  0.00              */
ATOM( 5.271,-2.510,-15.828, _HO) /*ATOM    450  H8    G B   2       5.271  -2.510 -15.828  1.00  0.00              */
ATOM(-0.286, 0.637,-15.146, _HO) /*ATOM    451  H1    G B   2      -0.286   0.637 -15.146  1.00  0.00              */
ATOM( 1.675, 3.511,-15.109, _HO) /*ATOM    452  H21   G B   2       1.675   3.511 -15.109  1.00  0.00              */
ATOM( 0.041, 2.802,-15.008, _HO) /*ATOM    453  H22   G B   2       0.041   2.802 -15.008  1.00  0.00              */
ATOM( 8.611, 1.872,-13.908, _PO) /*ATOM    454  P     C B   3       8.611   1.872 -13.908  1.00  0.00              */
ATOM( 9.681, 2.863,-13.688, _OO) /*ATOM    455  O1P   C B   3       9.681   2.863 -13.688  1.00  0.00              */
ATOM( 8.712, 0.621,-13.118, _OO) /*ATOM    456  O2P   C B   3       8.712   0.621 -13.118  1.00  0.00              */
ATOM( 7.186, 2.542,-13.658, _OO) /*ATOM    457  O5'   C B   3       7.186   2.542 -13.658  1.00  0.00              */
ATOM( 6.708, 3.537,-14.598, _CO) /*ATOM    458  C5'   C B   3       6.708   3.537 -14.598  1.00  0.00              */
ATOM( 5.895, 4.581,-13.868, _CO) /*ATOM    459  C4'   C B   3       5.895   4.581 -13.868  1.00  0.00              */
ATOM( 4.544, 4.060,-13.658, _OO) /*ATOM    460  O4'   C B   3       4.544   4.060 -13.658  1.00  0.00              */
ATOM( 6.375, 4.958,-12.468, _CO) /*ATOM    461  C3'   C B   3       6.375   4.958 -12.468  1.00  0.00              */
ATOM( 5.934, 6.256,-12.078, _OO) /*ATOM    462  O3'   C B   3       5.934   6.256 -12.078  1.00  0.00              */
ATOM( 5.703, 3.916,-11.588, _CO) /*ATOM    463  C2'   C B   3       5.703   3.916 -11.588  1.00  0.00              */
ATOM( 4.371, 3.712,-12.298, _CO) /*ATOM    464  C1'   C B   3       4.371   3.712 -12.298  1.00  0.00              */
ATOM( 3.874, 2.310,-12.248, _NO) /*ATOM    465  N1    C B   3       3.874   2.310 -12.248  1.00  0.00              */
ATOM( 2.504, 2.111,-12.098, _CO) /*ATOM    466  C2    C B   3       2.504   2.111 -12.098  1.00  0.00              */
ATOM( 1.761, 3.097,-12.008, _OO) /*ATOM    467  O2    C B   3       1.761   3.097 -12.008  1.00  0.00              */
ATOM( 2.105, 0.654,-12.048, _NO) /*ATOM    468  N3    C B   3       2.105   0.654 -12.048  1.00  0.00              */
ATOM( 2.860,-0.205,-12.148, _CO) /*ATOM    469  C4    C B   3       2.860  -0.205 -12.148  1.00  0.00              */
ATOM( 2.345,-1.423,-12.098, _NO) /*ATOM    470  N4    C B   3       2.345  -1.423 -12.098  1.00  0.00              */
ATOM( 4.271,-0.026,-12.298, _CO) /*ATOM    471  C5    C B   3       4.271  -0.026 -12.298  1.00  0.00              */
ATOM( 4.723, 1.257,-12.348, _CO) /*ATOM    472  C6    C B   3       4.723   1.257 -12.348  1.00  0.00              */
ATOM( 7.567, 4.019,-15.088, _HO) /*ATOM    473  H5'1  C B   3       7.567   4.019 -15.088  1.00  0.00              */
ATOM( 6.079, 3.050,-15.358, _HO) /*ATOM    474  H5'2  C B   3       6.079   3.050 -15.358  1.00  0.00              */
ATOM( 5.866, 5.487,-14.491, _HO) /*ATOM    475  H4'   C B   3       5.866   5.487 -14.491  1.00  0.00              */
ATOM( 3.621, 4.370,-11.836, _HO) /*ATOM    476  H1'   C B   3       3.621   4.370 -11.836  1.00  0.00              */
ATOM( 6.286, 2.984,-11.557, _HO) /*ATOM    477  H2'1  C B   3       6.286   2.984 -11.557  1.00  0.00              */
ATOM( 5.557, 4.292,-10.565, _HO) /*ATOM    478  H2'2  C B   3       5.557   4.292 -10.565  1.00  0.00              */
ATOM( 7.472, 4.901,-12.399, _HO) /*ATOM    479  H3'   C B   3       7.472   4.901 -12.399  1.00  0.00              */
ATOM( 5.789, 1.442,-12.471, _HO) /*ATOM    480  H6    C B   3       5.789   1.442 -12.471  1.00  0.00              */
ATOM( 4.950,-0.874,-12.369, _HO) /*ATOM    481  H5    C B   3       4.950  -0.874 -12.369  1.00  0.00              */
ATOM( 1.330,-1.548,-11.981, _HO) /*ATOM    482  H41   C B   3       1.330  -1.548 -11.981  1.00  0.00              */
ATOM( 2.960,-2.246,-12.178, _HO) /*ATOM    483  H42   C B   3       2.960  -2.246 -12.178  1.00  0.00              */
ATOM( 5.791, 6.602,-10.528, _PO) /*ATOM    484  P     A B   4       5.791   6.602 -10.528  1.00  0.00              */
ATOM( 6.075, 8.033,-10.308, _OO) /*ATOM    485  O1P   A B   4       6.075   8.033 -10.308  1.00  0.00              */
ATOM( 6.609, 5.650, -9.738, _OO) /*ATOM    486  O2P   A B   4       6.609   5.650  -9.738  1.00  0.00              */
ATOM( 4.245, 6.306,-10.278, _OO) /*ATOM    487  O5'   A B   4       4.245   6.306 -10.278  1.00  0.00              */
ATOM( 3.273, 6.830,-11.218, _CO) /*ATOM    488  C5'   A B   4       3.273   6.830 -11.218  1.00  0.00              */
ATOM( 2.001, 7.198,-10.488, _CO) /*ATOM    489  C4'   A B   4       2.001   7.198 -10.488  1.00  0.00              */
ATOM( 1.215, 5.982,-10.278, _OO) /*ATOM    490  O4'   A B   4       1.215   5.982 -10.278  1.00  0.00              */
ATOM( 2.168, 7.784, -9.088, _CO) /*ATOM    491  C3'   A B   4       2.168   7.784  -9.088  1.00  0.00              */
ATOM( 1.049, 8.575, -8.698, _OO) /*ATOM    492  O3'   A B   4       1.049   8.575  -8.698  1.00  0.00              */
ATOM( 2.237, 6.546, -8.208, _CO) /*ATOM    493  C2'   A B   4       2.237   6.546  -8.208  1.00  0.00              */
ATOM( 1.280, 5.598, -8.918, _CO) /*ATOM    494  C1'   A B   4       1.280   5.598  -8.918  1.00  0.00              */
ATOM( 1.701, 4.172, -8.868, _NO) /*ATOM    495  N9    A B   4       1.701   4.172  -8.868  1.00  0.00              */
ATOM( 2.968, 3.659, -8.948, _CO) /*ATOM    496  C8    A B   4       2.968   3.659  -8.948  1.00  0.00              */
ATOM( 3.009, 2.362, -8.878, _NO) /*ATOM    497  N7    A B   4       3.009   2.362  -8.878  1.00  0.00              */
ATOM( 1.683, 1.997, -8.728, _CO) /*ATOM    498  C5    A B   4       1.683   1.997  -8.728  1.00  0.00              */
ATOM( 1.051, 0.743, -8.598, _CO) /*ATOM    499  C6    A B   4       1.051   0.743  -8.598  1.00  0.00              */
ATOM( 1.705,-0.416, -8.588, _NO) /*ATOM    500  N6    A B   4       1.705  -0.416  -8.588  1.00  0.00              */
ATOM(-0.285, 0.733, -8.478, _NO) /*ATOM    501  N1    A B   4      -0.285   0.733  -8.478  1.00  0.00              */
ATOM(-0.940, 1.890, -8.488, _CO) /*ATOM    502  C2    A B   4      -0.940   1.890  -8.488  1.00  0.00              */
ATOM(-0.473, 3.114, -8.608, _NO) /*ATOM    503  N3    A B   4      -0.473   3.114  -8.608  1.00  0.00              */
ATOM( 0.868, 3.091, -8.728, _CO) /*ATOM    504  C4    A B   4       0.868   3.091  -8.728  1.00  0.00              */
ATOM( 3.685, 7.725,-11.709, _HO) /*ATOM    505  H5'1  A B   4       3.685   7.725 -11.709  1.00  0.00              */
ATOM( 3.050, 6.066,-11.978, _HO) /*ATOM    506  H5'2  A B   4       3.050   6.066 -11.978  1.00  0.00              */
ATOM( 1.445, 7.914,-11.111, _HO) /*ATOM    507  H4'   A B   4       1.445   7.914 -11.111  1.00  0.00              */
ATOM( 0.286, 5.689, -8.456, _HO) /*ATOM    508  H1'   A B   4       0.286   5.689  -8.456  1.00  0.00              */
ATOM( 3.257, 6.135, -8.177, _HO) /*ATOM    509  H2'1  A B   4       3.257   6.135  -8.177  1.00  0.00              */
ATOM( 1.898, 6.764, -7.185, _HO) /*ATOM    510  H2'2  A B   4       1.898   6.764  -7.185  1.00  0.00              */
ATOM( 3.089, 8.382, -9.019, _HO) /*ATOM    511  H3'   A B   4       3.089   8.382  -9.019  1.00  0.00              */
ATOM( 3.857, 4.279, -9.060, _HO) /*ATOM    512  H8    A B   4       3.857   4.279  -9.060  1.00  0.00              */
ATOM( 2.731,-0.429, -8.679, _HO) /*ATOM    513  H61   A B   4       2.731  -0.429  -8.679  1.00  0.00              */
ATOM( 1.185,-1.300, -8.490, _HO) /*ATOM    514  H62   A B   4       1.185  -1.300  -8.490  1.00  0.00              */
ATOM(-2.016, 1.814, -8.382, _HO) /*ATOM    515  H2    A B   4      -2.016   1.814  -8.382  1.00  0.00              */
ATOM( 0.730, 8.771, -7.148, _PO) /*ATOM    516  P     A B   5       0.730   8.771  -7.148  1.00  0.00              */
ATOM( 0.118,10.096, -6.928, _OO) /*ATOM    517  O1P   A B   5       0.118  10.096  -6.928  1.00  0.00              */
ATOM( 1.951, 8.481, -6.358, _OO) /*ATOM    518  O2P   A B   5       1.951   8.481  -6.358  1.00  0.00              */
ATOM(-0.348, 7.623, -6.898, _OO) /*ATOM    519  O5'   A B   5      -0.348   7.623  -6.898  1.00  0.00              */
ATOM(-1.442, 7.476, -7.838, _CO) /*ATOM    520  C5'   A B   5      -1.442   7.476  -7.838  1.00  0.00              */
ATOM(-2.686, 7.026, -7.108, _CO) /*ATOM    521  C4'   A B   5      -2.686   7.026  -7.108  1.00  0.00              */
ATOM(-2.608, 5.580, -6.898, _OO) /*ATOM    522  O4'   A B   5      -2.608   5.580  -6.898  1.00  0.00              */
ATOM(-2.896, 7.599, -5.708, _CO) /*ATOM    523  C3'   A B   5      -2.896   7.599  -5.708  1.00  0.00              */
ATOM(-4.267, 7.580, -5.318, _OO) /*ATOM    524  O3'   A B   5      -4.267   7.580  -5.318  1.00  0.00              */
ATOM(-2.113, 6.638, -4.828, _CO) /*ATOM    525  C2'   A B   5      -2.113   6.638  -4.828  1.00  0.00              */
ATOM(-2.330, 5.308, -5.538, _CO) /*ATOM    526  C1'   A B   5      -2.330   5.308  -5.538  1.00  0.00              */
ATOM(-1.151, 4.402, -5.488, _NO) /*ATOM    527  N9    A B   5      -1.151   4.402  -5.488  1.00  0.00              */
ATOM( 0.175, 4.731, -5.568, _CO) /*ATOM    528  C8    A B   5       0.175   4.731  -5.568  1.00  0.00              */
ATOM( 0.971, 3.706, -5.498, _NO) /*ATOM    529  N7    A B   5       0.971   3.706  -5.498  1.00  0.00              */
ATOM( 0.113, 2.631, -5.348, _CO) /*ATOM    530  C5    A B   5       0.113   2.631  -5.348  1.00  0.00              */
ATOM( 0.339, 1.245, -5.218, _CO) /*ATOM    531  C6    A B   5       0.339   1.245  -5.218  1.00  0.00              */
ATOM( 1.549, 0.691, -5.208, _NO) /*ATOM    532  N6    A B   5       1.549   0.691  -5.208  1.00  0.00              */
ATOM(-0.736, 0.452, -5.098, _NO) /*ATOM    533  N1    A B   5      -0.736   0.452  -5.098  1.00  0.00              */
ATOM(-1.946, 1.003, -5.108, _CO) /*ATOM    534  C2    A B   5      -1.946   1.003  -5.108  1.00  0.00              */
ATOM(-2.288, 2.268, -5.228, _NO) /*ATOM    535  N3    A B   5      -2.288   2.268  -5.228  1.00  0.00              */
ATOM(-1.190, 3.037, -5.348, _CO) /*ATOM    536  C4    A B   5      -1.190   3.037  -5.348  1.00  0.00              */
ATOM(-1.635, 8.442, -8.328, _HO) /*ATOM    537  H5'1  A B   5      -1.635   8.442  -8.328  1.00  0.00              */
ATOM(-1.173, 6.727, -8.598, _HO) /*ATOM    538  H5'2  A B   5      -1.173   6.727  -8.598  1.00  0.00              */
ATOM(-3.557, 7.278, -7.731, _HO) /*ATOM    539  H4'   A B   5      -3.557   7.278  -7.731  1.00  0.00              */
ATOM(-3.187, 4.797, -5.076, _HO) /*ATOM    540  H1'   A B   5      -3.187   4.797  -5.076  1.00  0.00              */
ATOM(-1.046, 6.904, -4.797, _HO) /*ATOM    541  H2'1  A B   5      -1.046   6.904  -4.797  1.00  0.00              */
ATOM(-2.516, 6.615, -3.805, _HO) /*ATOM    542  H2'2  A B   5      -2.516   6.615  -3.805  1.00  0.00              */
ATOM(-2.503, 8.624, -5.639, _HO) /*ATOM    543  H3'   A B   5      -2.503   8.624  -5.639  1.00  0.00              */
ATOM( 0.530, 5.755, -5.680, _HO) /*ATOM    544  H8    A B   5       0.530   5.755  -5.680  1.00  0.00              */
ATOM( 2.387, 1.283, -5.299, _HO) /*ATOM    545  H61   A B   5       2.387   1.283  -5.299  1.00  0.00              */
ATOM( 1.648,-0.330, -5.110, _HO) /*ATOM    546  H62   A B   5       1.648  -0.330  -5.110  1.00  0.00              */
ATOM(-2.771, 0.309, -5.002, _HO) /*ATOM    547  H2    A B   5      -2.771   0.309  -5.002  1.00  0.00              */
ATOM(-4.640, 7.551, -3.768, _PO) /*ATOM    548  P     A B   6      -4.640   7.551  -3.768  1.00  0.00              */
ATOM(-5.914, 8.264, -3.548, _OO) /*ATOM    549  O1P   A B   6      -5.914   8.264  -3.548  1.00  0.00              */
ATOM(-3.482, 8.035, -2.978, _OO) /*ATOM    550  O2P   A B   6      -3.482   8.035  -2.978  1.00  0.00              */
ATOM(-4.837, 5.989, -3.518, _OO) /*ATOM    551  O5'   A B   6      -4.837   5.989  -3.518  1.00  0.00              */
ATOM(-5.636, 5.228, -4.458, _CO) /*ATOM    552  C5'   A B   6      -5.636   5.228  -4.458  1.00  0.00              */
ATOM(-6.378, 4.131, -3.728, _CO) /*ATOM    553  C4'   A B   6      -6.378   4.131  -3.728  1.00  0.00              */
ATOM(-5.465, 3.008, -3.518, _OO) /*ATOM    554  O4'   A B   6      -5.465   3.008  -3.518  1.00  0.00              */
ATOM(-6.884, 4.472, -2.328, _CO) /*ATOM    555  C3'   A B   6      -6.884   4.472  -2.328  1.00  0.00              */
ATOM(-7.982, 3.651, -1.938, _OO) /*ATOM    556  O3'   A B   6      -7.982   3.651  -1.938  1.00  0.00              */
ATOM(-5.686, 4.154, -1.448, _CO) /*ATOM    557  C2'   A B   6      -5.686   4.154  -1.448  1.00  0.00              */
ATOM(-5.080, 2.951, -2.158, _CO) /*ATOM    558  C1'   A B   6      -5.080   2.951  -2.158  1.00  0.00              */
ATOM(-3.593, 2.911, -2.108, _NO) /*ATOM    559  N9    A B   6      -3.593   2.911  -2.108  1.00  0.00              */
ATOM(-2.714, 3.957, -2.188, _CO) /*ATOM    560  C8    A B   6      -2.714   3.957  -2.188  1.00  0.00              */
ATOM(-1.468, 3.595, -2.118, _NO) /*ATOM    561  N7    A B   6      -1.468   3.595  -2.118  1.00  0.00              */
ATOM(-1.530, 2.222, -1.968, _CO) /*ATOM    562  C5    A B   6      -1.530   2.222  -1.968  1.00  0.00              */
ATOM(-0.532, 1.233, -1.838, _CO) /*ATOM    563  C6    A B   6      -0.532   1.233  -1.838  1.00  0.00              */
ATOM( 0.772, 1.496, -1.828, _NO) /*ATOM    564  N6    A B   6       0.772   1.496  -1.828  1.00  0.00              */
ATOM(-0.936,-0.041, -1.718, _NO) /*ATOM    565  N1    A B   6      -0.936  -0.041  -1.718  1.00  0.00              */
ATOM(-2.238,-0.306, -1.728, _CO) /*ATOM    566  C2    A B   6      -2.238  -0.306  -1.728  1.00  0.00              */
ATOM(-3.258, 0.516, -1.848, _NO) /*ATOM    567  N3    A B   6      -3.258   0.516  -1.848  1.00  0.00              */
ATOM(-2.822, 1.784, -1.968, _CO) /*ATOM    568  C4    A B   6      -2.822   1.784  -1.968  1.00  0.00              */
ATOM(-6.360, 5.896, -4.947, _HO) /*ATOM    569  H5'1  A B   6      -6.360   5.896  -4.947  1.00  0.00              */
ATOM(-4.978, 4.781, -5.219, _HO) /*ATOM    570  H5'2  A B   6      -4.978   4.781  -5.219  1.00  0.00              */
ATOM(-7.231, 3.823, -4.351, _HO) /*ATOM    571  H4'   A B   6      -7.231   3.823  -4.351  1.00  0.00              */
ATOM(-5.473, 2.034, -1.696, _HO) /*ATOM    572  H1'   A B   6      -5.473   2.034  -1.696  1.00  0.00              */
ATOM(-4.979, 4.996, -1.416, _HO) /*ATOM    573  H2'1  A B   6      -4.979   4.996  -1.416  1.00  0.00              */
ATOM(-5.998, 3.898, -0.425, _HO) /*ATOM    574  H2'2  A B   6      -5.998   3.898  -0.425  1.00  0.00              */
ATOM(-7.168, 5.532, -2.259, _HO) /*ATOM    575  H3'   A B   6      -7.168   5.532  -2.259  1.00  0.00              */
ATOM(-3.029, 4.994, -2.300, _HO) /*ATOM    576  H8    A B   6      -3.029   4.994  -2.300  1.00  0.00              */
ATOM( 1.102, 2.467, -1.919, _HO) /*ATOM    577  H61   A B   6       1.102   2.467  -1.919  1.00  0.00              */
ATOM( 1.452, 0.728, -1.730, _HO) /*ATOM    578  H62   A B   6       1.452   0.728  -1.730  1.00  0.00              */
ATOM(-2.498,-1.353, -1.622, _HO) /*ATOM    579  H2    A B   6      -2.498  -1.353  -1.622  1.00  0.00              */
ATOM(-8.267, 3.408, -0.388, _PO) /*ATOM    580  P     T B   7      -8.267   3.408  -0.388  1.00  0.00              */
ATOM(-9.716, 3.236, -0.168, _OO) /*ATOM    581  O1P   T B   7      -9.716   3.236  -0.168  1.00  0.00              */
ATOM(-7.614, 4.480,  0.402, _OO) /*ATOM    582  O2P   T B   7      -7.614   4.480   0.402  1.00  0.00              */
ATOM(-7.509, 2.029, -0.138, _OO) /*ATOM    583  O5'   T B   7      -7.509   2.029  -0.138  1.00  0.00              */
ATOM(-7.707, 0.943, -1.078, _CO) /*ATOM    584  C5'   T B   7      -7.707   0.943  -1.078  1.00  0.00              */
ATOM(-7.663,-0.380, -0.348, _CO) /*ATOM    585  C4'   T B   7      -7.663  -0.380  -0.348  1.00  0.00              */
ATOM(-6.264,-0.752, -0.138, _OO) /*ATOM    586  O4'   T B   7      -6.264  -0.752  -0.138  1.00  0.00              */
ATOM(-8.272,-0.402,  1.052, _CO) /*ATOM    587  C3'   T B   7      -8.272  -0.402   1.052  1.00  0.00              */
ATOM(-8.679,-1.712,  1.442, _OO) /*ATOM    588  O3'   T B   7      -8.679  -1.712   1.442  1.00  0.00              */
ATOM(-7.116, 0.045,  1.932, _CO) /*ATOM    589  C2'   T B   7      -7.116   0.045   1.932  1.00  0.00              */
ATOM(-5.919,-0.572,  1.222, _CO) /*ATOM    590  C1'   T B   7      -5.919  -0.572   1.222  1.00  0.00              */
ATOM(-4.693, 0.269,  1.272, _NO) /*ATOM    591  N1    T B   7      -4.693   0.269   1.272  1.00  0.00              */
ATOM(-3.486,-0.382,  1.422, _CO) /*ATOM    592  C2    T B   7      -3.486  -0.382   1.422  1.00  0.00              */
ATOM(-3.398,-1.594,  1.512, _OO) /*ATOM    593  O2    T B   7      -3.398  -1.594   1.512  1.00  0.00              */
ATOM(-2.376, 0.437,  1.462, _NO) /*ATOM    594  N3    T B   7      -2.376   0.437   1.462  1.00  0.00              */
ATOM(-2.364, 1.810,  1.372, _CO) /*ATOM    595  C4    T B   7      -2.364   1.810   1.372  1.00  0.00              */
ATOM(-1.301, 2.439,  1.422, _OO) /*ATOM    596  O4    T B   7      -1.301   2.439   1.422  1.00  0.00              */
ATOM(-3.670, 2.404,  1.222, _CO) /*ATOM    597  C5    T B   7      -3.670   2.404   1.222  1.00  0.00              */
ATOM(-3.705, 3.898,  1.112, _CO) /*ATOM    598  C5M   T B   7      -3.705   3.898   1.112  1.00  0.00              */
ATOM(-4.777, 1.636,  1.172, _CO) /*ATOM    599  C6    T B   7      -4.777   1.636   1.172  1.00  0.00              */
ATOM(-8.685, 1.058, -1.568, _HO) /*ATOM    600  H5'1  T B   7      -8.685   1.058  -1.568  1.00  0.00              */
ATOM(-6.912, 0.968, -1.838, _HO) /*ATOM    601  H5'2  T B   7      -6.912   0.968  -1.838  1.00  0.00              */
ATOM(-8.172,-1.131, -0.971, _HO) /*ATOM    602  H4'   T B   7      -8.172  -1.131  -0.971  1.00  0.00              */
ATOM(-5.698,-1.545,  1.684, _HO) /*ATOM    603  H1'   T B   7      -5.698  -1.545   1.684  1.00  0.00              */
ATOM(-7.039, 1.142,  1.964, _HO) /*ATOM    604  H2'1  T B   7      -7.039   1.142   1.964  1.00  0.00              */
ATOM(-7.218,-0.346,  2.955, _HO) /*ATOM    605  H2'2  T B   7      -7.218  -0.346   2.955  1.00  0.00              */
ATOM(-9.125, 0.289,  1.121, _HO) /*ATOM    606  H3'   T B   7      -9.125   0.289   1.121  1.00  0.00              */
ATOM(-5.751, 2.106,  1.050, _HO) /*ATOM    607  H6    T B   7      -5.751   2.106   1.050  1.00  0.00              */
ATOM(-3.998, 4.330,  2.080, _HO) /*ATOM    608  H51   T B   7      -3.998   4.330   2.080  1.00  0.00              */
ATOM(-4.435, 4.192,  0.343, _HO) /*ATOM    609  H52   T B   7      -4.435   4.192   0.343  1.00  0.00              */
ATOM(-2.708, 4.269,  0.831, _HO) /*ATOM    610  H53   T B   7      -2.708   4.269   0.831  1.00  0.00              */
ATOM(-1.489,-0.014,  1.567, _HO) /*ATOM    611  H3    T B   7      -1.489  -0.014   1.567  1.00  0.00              */
ATOM(-8.767,-2.076,  2.992, _PO) /*ATOM    612  P     T B   8      -8.767  -2.076   2.992  1.00  0.00              */
ATOM(-9.837,-3.067,  3.212, _OO) /*ATOM    613  O1P   T B   8      -9.837  -3.067   3.212  1.00  0.00              */
ATOM(-8.868,-0.825,  3.782, _OO) /*ATOM    614  O2P   T B   8      -8.868  -0.825   3.782  1.00  0.00              */
ATOM(-7.342,-2.746,  3.242, _OO) /*ATOM    615  O5'   T B   8      -7.342  -2.746   3.242  1.00  0.00              */
ATOM(-6.864,-3.741,  2.302, _CO) /*ATOM    616  C5'   T B   8      -6.864  -3.741   2.302  1.00  0.00              */
ATOM(-6.051,-4.785,  3.032, _CO) /*ATOM    617  C4'   T B   8      -6.051  -4.785   3.032  1.00  0.00              */
ATOM(-4.700,-4.264,  3.242, _OO) /*ATOM    618  O4'   T B   8      -4.700  -4.264   3.242  1.00  0.00              */
ATOM(-6.531,-5.162,  4.432, _CO) /*ATOM    619  C3'   T B   8      -6.531  -5.162   4.432  1.00  0.00              */
ATOM(-6.090,-6.460,  4.822, _OO) /*ATOM    620  O3'   T B   8      -6.090  -6.460   4.822  1.00  0.00              */
ATOM(-5.859,-4.120,  5.312, _CO) /*ATOM    621  C2'   T B   8      -5.859  -4.120   5.312  1.00  0.00              */
ATOM(-4.527,-3.916,  4.602, _CO) /*ATOM    622  C1'   T B   8      -4.527  -3.916   4.602  1.00  0.00              */
ATOM(-4.030,-2.514,  4.652, _NO) /*ATOM    623  N1    T B   8      -4.030  -2.514   4.652  1.00  0.00              */
ATOM(-2.671,-2.332,  4.802, _CO) /*ATOM    624  C2    T B   8      -2.671  -2.332   4.802  1.00  0.00              */
ATOM(-1.887,-3.261,  4.892, _OO) /*ATOM    625  O2    T B   8      -1.887  -3.261   4.892  1.00  0.00              */
ATOM(-2.254,-1.017,  4.842, _NO) /*ATOM    626  N3    T B   8      -2.254  -1.017   4.842  1.00  0.00              */
ATOM(-3.051, 0.101,  4.752, _CO) /*ATOM    627  C4    T B   8      -3.051   0.101   4.752  1.00  0.00              */
ATOM(-2.561, 1.235,  4.802, _OO) /*ATOM    628  O4    T B   8      -2.561   1.235   4.802  1.00  0.00              */
ATOM(-4.457,-0.186,  4.602, _CO) /*ATOM    629  C5    T B   8      -4.457  -0.186   4.602  1.00  0.00              */
ATOM(-5.364, 1.002,  4.492, _CO) /*ATOM    630  C5M   T B   8      -5.364   1.002   4.492  1.00  0.00              */
ATOM(-4.901,-1.458,  4.552, _CO) /*ATOM    631  C6    T B   8      -4.901  -1.458   4.552  1.00  0.00              */
ATOM(-7.723,-4.223,  1.812, _HO) /*ATOM    632  H5'1  T B   8      -7.723  -4.223   1.812  1.00  0.00              */
ATOM(-6.235,-3.254,  1.542, _HO) /*ATOM    633  H5'2  T B   8      -6.235  -3.254   1.542  1.00  0.00              */
ATOM(-6.022,-5.691,  2.409, _HO) /*ATOM    634  H4'   T B   8      -6.022  -5.691   2.409  1.00  0.00              */
ATOM(-3.776,-4.574,  5.064, _HO) /*ATOM    635  H1'   T B   8      -3.776  -4.574   5.064  1.00  0.00              */
ATOM(-6.442,-3.188,  5.343, _HO) /*ATOM    636  H2'1  T B   8      -6.442  -3.188   5.343  1.00  0.00              */
ATOM(-5.713,-4.496,  6.335, _HO) /*ATOM    637  H2'2  T B   8      -5.713  -4.496   6.335  1.00  0.00              */
ATOM(-7.627,-5.105,  4.501, _HO) /*ATOM    638  H3'   T B   8      -7.627  -5.105   4.501  1.00  0.00              */
ATOM(-5.966,-1.650,  4.430, _HO) /*ATOM    639  H6    T B   8      -5.966  -1.650   4.430  1.00  0.00              */
ATOM(-5.855, 1.179,  5.460, _HO) /*ATOM    640  H51   T B   8      -5.855   1.179   5.460  1.00  0.00              */
ATOM(-6.127, 0.811,  3.723, _HO) /*ATOM    641  H52   T B   8      -6.127   0.811   3.723  1.00  0.00              */
ATOM(-4.775, 1.888,  4.211, _HO) /*ATOM    642  H53   T B   8      -4.775   1.888   4.211  1.00  0.00              */
ATOM(-1.272,-0.861,  4.947, _HO) /*ATOM    643  H3    T B   8      -1.272  -0.861   4.947  1.00  0.00              */
ATOM(-5.947,-6.806,  6.372, _PO) /*ATOM    644  P     T B   9      -5.947  -6.806   6.372  1.00  0.00              */
ATOM(-6.231,-8.237,  6.592, _OO) /*ATOM    645  O1P   T B   9      -6.231  -8.237   6.592  1.00  0.00              */
ATOM(-6.765,-5.854,  7.162, _OO) /*ATOM    646  O2P   T B   9      -6.765  -5.854   7.162  1.00  0.00              */
ATOM(-4.401,-6.510,  6.622, _OO) /*ATOM    647  O5'   T B   9      -4.401  -6.510   6.622  1.00  0.00              */
ATOM(-3.429,-7.034,  5.682, _CO) /*ATOM    648  C5'   T B   9      -3.429  -7.034   5.682  1.00  0.00              */
ATOM(-2.157,-7.402,  6.412, _CO) /*ATOM    649  C4'   T B   9      -2.157  -7.402   6.412  1.00  0.00              */
ATOM(-1.371,-6.186,  6.622, _OO) /*ATOM    650  O4'   T B   9      -1.371  -6.186   6.622  1.00  0.00              */
ATOM(-2.324,-7.988,  7.812, _CO) /*ATOM    651  C3'   T B   9      -2.324  -7.988   7.812  1.00  0.00              */
ATOM(-1.205,-8.779,  8.202, _OO) /*ATOM    652  O3'   T B   9      -1.205  -8.779   8.202  1.00  0.00              */
ATOM(-2.393,-6.750,  8.692, _CO) /*ATOM    653  C2'   T B   9      -2.393  -6.750   8.692  1.00  0.00              */
ATOM(-1.436,-5.802,  7.982, _CO) /*ATOM    654  C1'   T B   9      -1.436  -5.802   7.982  1.00  0.00              */
ATOM(-1.857,-4.376,  8.032, _NO) /*ATOM    655  N1    T B   9      -1.857  -4.376   8.032  1.00  0.00              */
ATOM(-0.865,-3.430,  8.182, _CO) /*ATOM    656  C2    T B   9      -0.865  -3.430   8.182  1.00  0.00              */
ATOM( 0.315,-3.721,  8.272, _OO) /*ATOM    657  O2    T B   9       0.315  -3.721   8.272  1.00  0.00              */
ATOM(-1.301,-2.121,  8.222, _NO) /*ATOM    658  N3    T B   9      -1.301  -2.121   8.222  1.00  0.00              */
ATOM(-2.602,-1.686,  8.132, _CO) /*ATOM    659  C4    T B   9      -2.602  -1.686   8.132  1.00  0.00              */
ATOM(-2.873,-0.480,  8.182, _OO) /*ATOM    660  O4    T B   9      -2.873  -0.480   8.182  1.00  0.00              */
ATOM(-3.571,-2.744,  7.982, _CO) /*ATOM    661  C5    T B   9      -3.571  -2.744   7.982  1.00  0.00              */
ATOM(-5.003,-2.316,  7.872, _CO) /*ATOM    662  C5M   T B   9      -5.003  -2.316   7.872  1.00  0.00              */
ATOM(-3.183,-4.034,  7.932, _CO) /*ATOM    663  C6    T B   9      -3.183  -4.034   7.932  1.00  0.00              */
ATOM(-3.840,-7.929,  5.191, _HO) /*ATOM    664  H5'1  T B   9      -3.840  -7.929   5.191  1.00  0.00              */
ATOM(-3.206,-6.270,  4.922, _HO) /*ATOM    665  H5'2  T B   9      -3.206  -6.270   4.922  1.00  0.00              */
ATOM(-1.601,-8.118,  5.789, _HO) /*ATOM    666  H4'   T B   9      -1.601  -8.118   5.789  1.00  0.00              */
ATOM(-0.442,-5.893,  8.444, _HO) /*ATOM    667  H1'   T B   9      -0.442  -5.893   8.444  1.00  0.00              */
ATOM(-3.413,-6.339,  8.723, _HO) /*ATOM    668  H2'1  T B   9      -3.413  -6.339   8.723  1.00  0.00              */
ATOM(-2.054,-6.968,  9.715, _HO) /*ATOM    669  H2'2  T B   9      -2.054  -6.968   9.715  1.00  0.00              */
ATOM(-3.244,-8.586,  7.881, _HO) /*ATOM    670  H3'   T B   9      -3.244  -8.586   7.881  1.00  0.00              */
ATOM(-3.931,-4.816,  7.810, _HO) /*ATOM    671  H6    T B   9      -3.931  -4.816   7.810  1.00  0.00              */
ATOM(-5.504,-2.461,  8.840, _HO) /*ATOM    672  H51   T B   9      -5.504  -2.461   8.840  1.00  0.00              */
ATOM(-5.508,-2.919,  7.103, _HO) /*ATOM    673  H52   T B   9      -5.508  -2.919   7.103  1.00  0.00              */
ATOM(-5.047,-1.253,  7.591, _HO) /*ATOM    674  H53   T B   9      -5.047  -1.253   7.591  1.00  0.00              */
ATOM(-0.598,-1.417,  8.327, _HO) /*ATOM    675  H3    T B   9      -0.598  -1.417   8.327  1.00  0.00              */
ATOM(-0.886,-8.975,  9.752, _PO) /*ATOM    676  P     C B  10      -0.886  -8.975   9.752  1.00  0.00              */
ATOM(-0.274,10.300,  9.972, _OO) /*ATOM    677  O1P   C B  10      -0.274 -10.300   9.972  1.00  0.00              */
ATOM(-2.107,-8.685, 10.542, _OO) /*ATOM    678  O2P   C B  10      -2.107  -8.685  10.542  1.00  0.00              */
ATOM( 0.192,-7.827, 10.002, _OO) /*ATOM    679  O5'   C B  10       0.192  -7.827  10.002  1.00  0.00              */
ATOM( 1.286,-7.680,  9.062, _CO) /*ATOM    680  C5'   C B  10       1.286  -7.680   9.062  1.00  0.00              */
ATOM( 2.530,-7.230,  9.792, _CO) /*ATOM    681  C4'   C B  10       2.530  -7.230   9.792  1.00  0.00              */
ATOM( 2.452,-5.784, 10.002, _OO) /*ATOM    682  O4'   C B  10       2.452  -5.784  10.002  1.00  0.00              */
ATOM( 2.740,-7.803, 11.192, _CO) /*ATOM    683  C3'   C B  10       2.740  -7.803  11.192  1.00  0.00              */
ATOM( 4.111,-7.784, 11.582, _OO) /*ATOM    684  O3'   C B  10       4.111  -7.784  11.582  1.00  0.00              */
ATOM( 1.957,-6.842, 12.072, _CO) /*ATOM    685  C2'   C B  10       1.957  -6.842  12.072  1.00  0.00              */
ATOM( 2.174,-5.512, 11.362, _CO) /*ATOM    686  C1'   C B  10       2.174  -5.512  11.362  1.00  0.00              */
ATOM( 0.995,-4.606, 11.412, _NO) /*ATOM    687  N1    C B  10       0.995  -4.606  11.412  1.00  0.00              */
ATOM( 1.229,-3.241, 11.562, _CO) /*ATOM    688  C2    C B  10       1.229  -3.241  11.562  1.00  0.00              */
ATOM( 2.396,-2.840, 11.652, _OO) /*ATOM    689  O2    C B  10       2.396  -2.840  11.652  1.00  0.00              */
ATOM(-0.034,-2.412, 11.612, _NO) /*ATOM    690  N3    C B  10      -0.034  -2.412  11.612  1.00  0.00              */
ATOM(-1.084,-2.865, 11.512, _CO) /*ATOM    691  C4    C B  10      -1.084  -2.865  11.512  1.00  0.00              */
ATOM(-2.083,-1.998, 11.562, _NO) /*ATOM    692  N4    C B  10      -2.083  -1.998  11.562  1.00  0.00              */
ATOM(-1.350,-4.262, 11.362, _CO) /*ATOM    693  C5    C B  10      -1.350  -4.262  11.362  1.00  0.00              */
ATOM(-0.270,-5.088, 11.312, _CO) /*ATOM    694  C6    C B  10      -0.270  -5.088  11.312  1.00  0.00              */
ATOM( 1.479,-8.646,  8.572, _HO) /*ATOM    695  H5'1  C B  10       1.479  -8.646   8.572  1.00  0.00              */
ATOM( 1.017,-6.931,  8.302, _HO) /*ATOM    696  H5'2  C B  10       1.017  -6.931   8.302  1.00  0.00              */
ATOM( 3.401,-7.482,  9.169, _HO) /*ATOM    697  H4'   C B  10       3.401  -7.482   9.169  1.00  0.00              */
ATOM( 3.032,-5.001, 11.824, _HO) /*ATOM    698  H1'   C B  10       3.032  -5.001  11.824  1.00  0.00              */
ATOM( 0.890,-7.108, 12.103, _HO) /*ATOM    699  H2'1  C B  10       0.890  -7.108  12.103  1.00  0.00              */
ATOM( 2.360,-6.819, 13.095, _HO) /*ATOM    700  H2'2  C B  10       2.360  -6.819  13.095  1.00  0.00              */
ATOM( 2.348,-8.828, 11.261, _HO) /*ATOM    701  H3'   C B  10       2.348  -8.828  11.261  1.00  0.00              */
ATOM(-0.424,-6.159, 11.189, _HO) /*ATOM    702  H6    C B  10      -0.424  -6.159  11.189  1.00  0.00              */
ATOM(-2.367,-4.646, 11.291, _HO) /*ATOM    703  H5    C B  10      -2.367  -4.646  11.291  1.00  0.00              */
ATOM(-1.888,-0.994, 11.679, _HO) /*ATOM    704  H41   C B  10      -1.888  -0.994  11.679  1.00  0.00              */
ATOM(-3.055,-2.328, 11.483, _HO) /*ATOM    705  H42   C B  10      -3.055  -2.328  11.483  1.00  0.00              */
ATOM( 4.484,-7.755, 13.132, _PO) /*ATOM    706  P     G B  11       4.484  -7.755  13.132  1.00  0.00              */
ATOM( 5.758,-8.468, 13.352, _OO) /*ATOM    707  O1P   G B  11       5.758  -8.468  13.352  1.00  0.00              */
ATOM( 3.326,-8.239, 13.922, _OO) /*ATOM    708  O2P   G B  11       3.326  -8.239  13.922  1.00  0.00              */
ATOM( 4.681,-6.193, 13.382, _OO) /*ATOM    709  O5'   G B  11       4.681  -6.193  13.382  1.00  0.00              */
ATOM( 5.480,-5.432, 12.442, _CO) /*ATOM    710  C5'   G B  11       5.480  -5.432  12.442  1.00  0.00              */
ATOM( 6.222,-4.335, 13.172, _CO) /*ATOM    711  C4'   G B  11       6.222  -4.335  13.172  1.00  0.00              */
ATOM( 5.309,-3.212, 13.382, _OO) /*ATOM    712  O4'   G B  11       5.309  -3.212  13.382  1.00  0.00              */
ATOM( 6.728,-4.676, 14.572, _CO) /*ATOM    713  C3'   G B  11       6.728  -4.676  14.572  1.00  0.00              */
ATOM( 7.826,-3.855, 14.962, _OO) /*ATOM    714  O3'   G B  11       7.826  -3.855  14.962  1.00  0.00              */
ATOM( 5.530,-4.358, 15.452, _CO) /*ATOM    715  C2'   G B  11       5.530  -4.358  15.452  1.00  0.00              */
ATOM( 4.924,-3.155, 14.742, _CO) /*ATOM    716  C1'   G B  11       4.924  -3.155  14.742  1.00  0.00              */
ATOM( 3.437,-3.115, 14.792, _NO) /*ATOM    717  N9    G B  11       3.437  -3.115  14.792  1.00  0.00              */
ATOM( 2.533,-4.154, 14.712, _CO) /*ATOM    718  C8    G B  11       2.533  -4.154  14.712  1.00  0.00              */
ATOM( 1.282,-3.779, 14.792, _NO) /*ATOM    719  N7    G B  11       1.282  -3.779  14.792  1.00  0.00              */
ATOM( 1.353,-2.392, 14.932, _CO) /*ATOM    720  C5    G B  11       1.353  -2.392  14.932  1.00  0.00              */
ATOM( 0.321,-1.433, 15.062, _CO) /*ATOM    721  C6    G B  11       0.321  -1.433  15.062  1.00  0.00              */
ATOM(-0.897,-1.603, 15.082, _OO) /*ATOM    722  O6    G B  11      -0.897  -1.603  15.082  1.00  0.00              */
ATOM( 0.841,-0.133, 15.182, _NO) /*ATOM    723  N1    G B  11       0.841  -0.133  15.182  1.00  0.00              */
ATOM( 2.184, 0.188, 15.182, _CO) /*ATOM    724  C2    G B  11       2.184   0.188  15.182  1.00  0.00              */
ATOM( 2.480, 1.484, 15.312, _NO) /*ATOM    725  N2    G B  11       2.480   1.484  15.312  1.00  0.00              */
ATOM( 3.155,-0.713, 15.052, _NO) /*ATOM    726  N3    G B  11       3.155  -0.713  15.052  1.00  0.00              */
ATOM( 2.673,-1.979, 14.932, _CO) /*ATOM    727  C4    G B  11       2.673  -1.979  14.932  1.00  0.00              */
ATOM( 6.204,-6.100, 11.953, _HO) /*ATOM    728  H5'1  G B  11       6.204  -6.100  11.953  1.00  0.00              */
ATOM( 4.823,-4.985, 11.681, _HO) /*ATOM    729  H5'2  G B  11       4.823  -4.985  11.681  1.00  0.00              */
ATOM( 7.075,-4.027, 12.549, _HO) /*ATOM    730  H4'   G B  11       7.075  -4.027  12.549  1.00  0.00              */
ATOM( 5.318,-2.238, 15.204, _HO) /*ATOM    731  H1'   G B  11       5.318  -2.238  15.204  1.00  0.00              */
ATOM( 4.824,-5.200, 15.484, _HO) /*ATOM    732  H2'1  G B  11       4.824  -5.200  15.484  1.00  0.00              */
ATOM( 5.843,-4.102, 16.475, _HO) /*ATOM    733  H2'2  G B  11       5.843  -4.102  16.475  1.00  0.00              */
ATOM( 7.013,-5.736, 14.641, _HO) /*ATOM    734  H3'   G B  11       7.013  -5.736  14.641  1.00  0.00              */
ATOM( 2.834,-5.194, 14.592, _HO) /*ATOM    735  H8    G B  11       2.834  -5.194  14.592  1.00  0.00              */
ATOM( 0.188, 0.618, 15.274, _HO) /*ATOM    736  H1    G B  11       0.188   0.618  15.274  1.00  0.00              */
ATOM( 3.464, 1.790, 15.311, _HO) /*ATOM    737  H21   G B  11       3.464   1.790  15.311  1.00  0.00              */
ATOM( 1.725, 2.177, 15.412, _HO) /*ATOM    738  H22   G B  11       1.725   2.177  15.412  1.00  0.00              */
ATOM( 8.111,-3.612, 16.512, _PO) /*ATOM    739  P     C B  12       8.111  -3.612  16.512  1.00  0.00              */
ATOM( 9.560,-3.440, 16.732, _OO) /*ATOM    740  O1P   C B  12       9.560  -3.440  16.732  1.00  0.00              */
ATOM( 7.458,-4.684, 17.302, _OO) /*ATOM    741  O2P   C B  12       7.458  -4.684  17.302  1.00  0.00              */
ATOM( 7.353,-2.233, 16.762, _OO) /*ATOM    742  O5'   C B  12       7.353  -2.233  16.762  1.00  0.00              */
ATOM( 7.551,-1.147, 15.822, _CO) /*ATOM    743  C5'   C B  12       7.551  -1.147  15.822  1.00  0.00              */
ATOM( 7.507, 0.176, 16.552, _CO) /*ATOM    744  C4'   C B  12       7.507   0.176  16.552  1.00  0.00              */
ATOM( 6.108, 0.548, 16.762, _OO) /*ATOM    745  O4'   C B  12       6.108   0.548  16.762  1.00  0.00              */
ATOM( 8.116, 0.198, 17.952, _CO) /*ATOM    746  C3'   C B  12       8.116   0.198  17.952  1.00  0.00              */
ATOM( 8.523, 1.508, 18.342, _OO) /*ATOM    747  O3'   C B  12       8.523   1.508  18.342  1.00  0.00              */
ATOM( 6.960,-0.249, 18.832, _CO) /*ATOM    748  C2'   C B  12       6.960  -0.249  18.832  1.00  0.00              */
ATOM( 5.763, 0.368, 18.122, _CO) /*ATOM    749  C1'   C B  12       5.763   0.368  18.122  1.00  0.00              */
ATOM( 4.537,-0.473, 18.172, _NO) /*ATOM    750  N1    C B  12       4.537  -0.473  18.172  1.00  0.00              */
ATOM( 3.311, 0.171, 18.322, _CO) /*ATOM    751  C2    C B  12       3.311   0.171  18.322  1.00  0.00              */
ATOM( 3.290, 1.405, 18.412, _OO) /*ATOM    752  O2    C B  12       3.290   1.405  18.412  1.00  0.00              */
ATOM( 2.132,-0.774, 18.372, _NO) /*ATOM    753  N3    C B  12       2.132  -0.774  18.372  1.00  0.00              */
ATOM( 2.239,-1.912, 18.272, _CO) /*ATOM    754  C4    C B  12       2.239  -1.912  18.272  1.00  0.00              */
ATOM( 1.106,-2.595, 18.322, _NO) /*ATOM    755  N4    C B  12       1.106  -2.595  18.322  1.00  0.00              */
ATOM( 3.485,-2.597, 18.122, _CO) /*ATOM    756  C5    C B  12       3.485  -2.597  18.122  1.00  0.00              */
ATOM( 4.605,-1.825, 18.072, _CO) /*ATOM    757  C6    C B  12       4.605  -1.825  18.072  1.00  0.00              */
ATOM( 9.158, 1.446, 19.059, _HO) /*ATOM    758  HCAP  C B  12       9.158   1.446  19.059  1.00  0.00              */
ATOM( 8.529,-1.262, 15.332, _HO) /*ATOM    759  H5'1  C B  12       8.529  -1.262  15.332  1.00  0.00              */
ATOM( 6.756,-1.172, 15.062, _HO) /*ATOM    760  H5'2  C B  12       6.756  -1.172  15.062  1.00  0.00              */
ATOM( 8.016, 0.927, 15.929, _HO) /*ATOM    761  H4'   C B  12       8.016   0.927  15.929  1.00  0.00              */
ATOM( 5.543, 1.341, 18.584, _HO) /*ATOM    762  H1'   C B  12       5.543   1.341  18.584  1.00  0.00              */
ATOM( 6.884,-1.346, 18.864, _HO) /*ATOM    763  H2'1  C B  12       6.884  -1.346  18.864  1.00  0.00              */
ATOM( 7.063, 0.142, 19.855, _HO) /*ATOM    764  H2'2  C B  12       7.063   0.142  19.855  1.00  0.00              */
ATOM( 8.969,-0.493, 18.021, _HO) /*ATOM    765  H3'   C B  12       8.969  -0.493  18.021  1.00  0.00              */
ATOM( 5.576,-2.302, 17.949, _HO) /*ATOM    766  H6    C B  12       5.576  -2.302  17.949  1.00  0.00              */
ATOM( 3.536,-3.683, 18.051, _HO) /*ATOM    767  H5    C B  12       3.536  -3.683  18.051  1.00  0.00              */
ATOM( 0.211,-2.100, 18.439, _HO) /*ATOM    768  H41   C B  12       0.211  -2.100  18.439  1.00  0.00              */
ATOM( 1.120,-3.622, 18.243, _HO) /*ATOM    769  H42   C B  12       1.120  -3.622  18.243  1.00  0.00              */
#end
