// File: dither.pov
// Vers: POVRAY 3.1
//
// Titl: Li'l Dreamer
// Auth: Robbert de Groot
//       Copyright 2002 Robbert de Groot
// Date: 2002/06/17 
// 
// Desc: Dither pixel data from image.

// The data file.
#include "dither.inc"

// Speed rendering if not set already (not included if not set.)
#ifndef (_SPEED_RENDER)
#declare _SPEED_RENDER = 1;
#end

// If not included then set the camera.
// Settings are close to those of rjg-dream.pov
#ifndef (_INCLUDED)
camera {
   location    <0, 10, 55>
   up          y
   right       x / (3/2)
   look_at     <0, 5, 0>
   angle       40
   perspective
}
                          
#declare _LIGHT_INT  = 1.5;    
#declare _NUM_LIGHTS = 16;
#declare _COUNT      = 0;
#while (_COUNT < _NUM_LIGHTS)

   light_source {
      <100, 70, 0>
      colour rgb < _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS, _LIGHT_INT/_NUM_LIGHTS>
      #if (_SPEED_RENDER = 1) 
      shadowless
      #end
      rotate <0, _COUNT * 360 / _NUM_LIGHTS, 0>
   }                            
   
   #declare _COUNT = _COUNT + 1;

#end

// background
background { 
   color rgb < 0, 0, 0 > 
}                
#end

#macro PIXEL_STUFF(_SIZE,_R,_G,_B)  
union {
   cylinder {
      <0, 0, 0>, <0, 0, -2>, (_SIZE - 1)        
   }      
   cylinder {
      <0, 0, -1>, <0, 0, -20>, _SIZE
   }      
   torus {
      (_SIZE - 1), 1
      rotate <90, 0, 0>  
      translate <0, 0, -1>
   }  
   texture {      
      pigment
      {
         color rgb <0.9, 0.91, 0.98>
      }      
      finish
      {
         ambient 0.0
         diffuse 1
         brilliance 6.0
         phong 0.75
         phong_size 80.0
         reflection 0.4
      }
   }      
   translate <0, 0, .1>
}   
#end                          


/* The Image background*/
#declare _DITHER = union {
   #declare _COUNT = 0;
   
   #while (_COUNT < 150)                                 
   
      #debug concat("Row:",str(_COUNT,5,0),"\n")                
      #declare _SIZE = -1.5 + _COUNT/17;
                          
      #if (_SIZE > 0) 
      #declare PIXEL_OBJECT = object { PIXEL_STUFF(_SIZE, 1, 1, 0) }
   
      difference {
         union {      
            BWIMAGE(_COUNT, 1, 1, PIXEL_OBJECT)
           
            translate <-50, -75, 0>
         }
         box {
            <-60, -80, 0>, <60, 80, 1>
            pigment {
               image_map {
                  png "Galaxy.png"
                  interpolate 2
               }      
               scale 100
               translate <50, -50, 0>
            }
            finish {
               ambient     1
               diffuse     0
            }     
         }
      }
      #end
      
      #declare _COUNT = _COUNT + 1;
      
   #end
}

#ifndef (_INCLUDED)
object {
   _DITHER
   translate   <0, 5, -10>
}

plane {
   y, -20
   texture {
      pigment {
         color rgb <0.9, 0.91, 0.98>
      }
      normal {
         average
         normal_map {
            [bumps , 1.0 
             scale  2.0]
            [bumps , 2.0
             scale  4.0]
            [bumps , 3.0
             scale  16.0]
         }
         scale  0.5
         rotate -45.0 * z
      }      
      finish {
         ambient     0.0
         diffuse     1
         brilliance  6.0
         phong       0.75
         phong_size  80.0
         reflection  0.25
      }
   }   
}
#end
