// Persistence Of Vision raytracer version 3.5 beta
// Treasure Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"

global_settings { assumed_gamma 2.2 max_trace_level 5 }

camera { location < 0, 6, -200 > look_at < -30, 46, 0 > angle 38 }

light_source { < 0,54,200 >*2 color rgb 2 fade_distance 400 fade_power 1 media_interaction off }
light_source { < 0,54,-200 >*2 color rgb 0.5 fade_distance 400 fade_power 1 shadowless media_interaction off }


//**********************************************************************************
// spotlight
#local Ei=18; #local Si=0; #while(Si<Ei)
 #local Slx=200*cos(radians(360*Si/Ei+90)); #local Sly=200*sin(radians(360*Si/Ei+90));
 light_source { < 0,58,200 > color rgb 2.5 spotlight point_at <Slx,Sly,-50> radius 0.1 falloff 2 }
 #if(Si<9|10<Si)
 #local Slx=200*cos(radians(360*Si/Ei+90+7)); #local Sly=200*sin(radians(360*Si/Ei+90+7));
 light_source { < 0,54,200 > color rgb 2 spotlight point_at <Slx,Sly,-25> radius 0.1 falloff 4 }
 #end
 #if(Si<11|16<Si)
 #local Slx=200*cos(radians(360*Si/Ei+90+14)); #local Sly=200*sin(radians(360*Si/Ei+90+14));
 light_source { < 0,50,200 > color rgb 1.5 spotlight point_at <Slx,Sly,-10> radius 0.1 falloff 6 }
 #end
#local Si=Si+1; #end
//----------------------------------------------------------------------------------
fog { fog_type 1 distance 300 color rgbt< 2,1.8,2,0.8> }
media { confidence 0.999 variance 0.001 scattering { 2, rgb <1,1,0>*0.003 } }
//----------------------------------------------------------------------------------
// glow
coordinate_color(360,0,1.00,1,1)
coordinate_color(360,0,0.99,1,2)
coordinate_color(360,0,0.93,1,3)
#local F_stg = 2.3;
#local T_glow =
texture {
  pigment { wood
            scallop_wave
            color_map { [ 0.0 rgbt < R1, G1, B1, 0.98 > ]
                        [ 0.1 rgbt < R2, G2, B2, 0.95 >*F_stg ]
                        [ 0.2 rgbt < R3, G3, B3, 0.90 >*F_stg ]
                        [ 0.5 rgbt < R3, G3, B3, 0.90 >*F_stg ]
                        [ 0.6 rgbt < R2, G2, B2, 0.95 >*F_stg ]
                        [ 1.0 rgbt < R1, G1, B1, 1.0 > ] } scale 62 }
  finish { ambient 0 diffuse 0 reflection 0 }
}
#local Glow_org = disc { 0, z, 30 hollow on texture { T_glow } }
//
object { Glow_org scale 14 translate <0,58,200>*1.5 no_shadow }
object { Glow_org scale 13 translate <0,54,200>*1.9 no_shadow }
#local Glow_seg =
difference {
 object { Glow_org }
 #local Ei=18; #local Si=0; #while(Si<Ei)
  cone { 0 0, 30*x 6 pigment { color rgbt 1 } translate 3*x rotate 360*Si/Ei*z }
 #local Si=Si+1; #end
}
object { Glow_seg scale 16 rotate 360/Ei*1/3*z translate <0,44,200>*3 no_shadow }
object { Glow_seg scale 18 rotate 360/Ei*2/3*z translate <0,44,200>*3 no_shadow }
//**********************************************************************************
// eye
#local P_clear = pigment { color rgb 1 }
#local T_skin = texture { pigment { color rgbt 1 } }
//
#local Eye_base =
merge {
 sphere { 0, 30.5 texture { T_skin } }
 sphere { 0, 30.501
  clipped_by { plane { z, -8 } rotate -50*x }
  clipped_by { plane { z, -8 } rotate  55*x }
  pigment { color rgb 1 }
 } //eyemask
 sphere { < -26+1, 8+1, -14 >, 14 pigment { P_clear } }
 torus { 13, 3 rotate -90*x
  clipped_by { plane { x, 0 } rotate -115*z }
  clipped_by { plane { x, 0 } rotate 0*z }
  pigment { P_clear }
  translate < -8, 0, -24 >
 }
 sphere { < -16, -8, -15 >, 10 pigment { P_clear } } 
 torus { 12.5, 3 rotate -90*x
  clipped_by { plane { x, 0 } rotate 90*z }
  clipped_by { plane { x, 0 } }
  pigment { P_clear }
  translate < -8, 0, -27 >
 } //L
 sphere { < 25, 9, -14 >, 14 pigment { P_clear } }
 torus { 13, 3 rotate -90*x
  clipped_by { plane { x, 0 } rotate -115*z }
  clipped_by { plane { x, 0 } rotate 0*z }
  pigment { P_clear }
  rotate 180*y translate < 8, 0, -24 >
 }
 sphere { < 16, -8, -15 >, 10 pigment { P_clear } } 
 torus { 12.5, 3 rotate -90*x
  clipped_by { plane { x, 0 } rotate 90*z }
  clipped_by { plane { x, 0 } }
  pigment { P_clear }
  rotate 180*y translate < 8, 0, -27 >
 } //R
}
//----------------------------------------------------------------------------------
coordinate_color(  30, 0.70, 0.70, 1, 1 )
coordinate_color(  30, 0.14, 0.55, 1, 3 )
coordinate_color(  30, 0.00, 0.50, 1, 4 )
coordinate_color( 210, 0.08, 0.45, 1, 5 )
#local T_pupil =
texture {
  pigment { marble
            color_map { [ 0.0 rgbf < R1, G1, B1, 0.4 > ]
                        [ 0.4 rgbf < R1, G1, B1, 0.4 > ]
                        [ 0.6 rgbf < R3, G3, B3, 0.4 > ]
                        [ 0.8 rgbf < R4, G4, B4, 0.4 > ]
                        [ 1.0 rgbf < R5, G5, B5, 0.4 > ] } translate x/2 }
  finish { diffuse 0.15 reflection 0.3 specular 0.6 roughness 0.002 phong 1 phong_size 200 }
}
//
#local Pupil_org =
union {
 sphere { 0, 12 }
 #local Ei=24; #local Si=0; #while(Si<Ei)
  cone { <2,0,-11> 0.1, <4,0,-9> 0 pigment { color rgb 0 } rotate 360*Si/Ei*z }
  cone { <3,0,-11> 0.1, <5,0,-9> 0 pigment { color rgb 0 } rotate 360*Si/Ei*z }
 #local Si=Si+1; #end 
  texture { T_pupil rotate 90*y }
  interior { ior 2.25 }
  scale < 1.1, 1.1, 0.6 > translate -24*z rotate 2*x
}
//----------------------------------------------------------------------------------
#local Eye_org =
intersection {
 object { Eye_base }
 sphere { 0, 30.502 texture { T_skin } }
}
//
#local Eye_seg =
intersection {
 merge { object { Eye_org scale 0.99 } object { Pupil_org } }
 sphere { 0, 30.502 texture { T_skin } scale <0.933,0.60,1> translate <0,0,-6> }
}
//
#local Cat_eye =
union {
 object { Eye_seg rotate 5*z translate 30*x }
 object { Eye_seg rotate -5*z translate -30*x }
}
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
#macro Line_function(Tp,Px,Py,Pz,Func_type)
 #switch(Func_type)
  #case(1) #local Px=40*sqrt(abs(Tp))*cos(Tp); #local Py=-6*Tp; #local Pz=40*sqrt(abs(Tp))*sin(Tp); #break //sword
  #case(2) #local Px=15*cos(Tp); #local Py=15*sin(Tp); #local Pz=0; #break //jewel
 #end
#end
//----------------------------------------------------------------------------------
// sword
coordinate_color( 90, 0.1, 0.9, 1, 3 )
#local T_edge =
 texture {
  pigment { color rgbt < R3, G3, B3, 0.3 > }
  finish { metallic ambient 0.2 reflection 0.7 phong 0.75 phong_size 80 }
}
#local T_guard =
 texture {
  pigment { color rgbt < R3, G3, B3, 0.1 > }
  finish { metallic reflection 0.4 phong 0.75 phong_size 80 }
}
#local T_hilt =
 texture {
  pigment { color rgbt < R3, G3, B3, 0.1 > }
  finish { metallic reflection 0.4 phong 0.75 phong_size 80 }
}
coordinate_color( -30, 1, 0.5, 1, 4 )
#local T_tassel =
 texture {
  pigment { color rgbt < R4, G4, B4, 0.1 > }
  finish { metallic reflection 0.4 phong 0.75 phong_size 80 }
}
//
#local Sword_edge =
merge {
sphere { 0,10
 clipped_by { plane { y,0 } rotate (180+30)*z }
 clipped_by { plane { y,0 } rotate (180-30)*z }
 }
cylinder { -30*y,10*y 10*cos(radians(30))
 clipped_by { plane { x,0 } }
 clipped_by { plane { y,0 } rotate -30*z }
 scale <1,1,1/cos(radians(30))>
 }
cylinder { -30*y,10*y 10*cos(radians(30))
 clipped_by { plane { x,0 } rotate 180*y }
 clipped_by { plane { y,0 } rotate 30*z }
 scale <1,1,1/cos(radians(30))>
 }
 translate 30*y scale <0.4,2,0.1>
}
#local Sword_guard =
union {
 torus { 80,1
  clipped_by { plane { z,0 } rotate -(80)*y }
  clipped_by { plane { z,0 } rotate -(280)*y }
  rotate -90*x }
 sphere { 0 1 translate <-80*sin(radians(10)),-80*cos(radians(10)),0> }
 sphere { 0 1 translate < 80*sin(radians(10)),-80*cos(radians(10)),0> }
 translate 80*y
}
#local Sword_hilt =
union {
#local Ei=23; #local Si=0; #while(Si<Ei)
 torus{ 2,1 translate (3+Si)*y }
#local Si=Si+1; #end
 sphere { 0 3 translate 3*y scale <1,1/2,1> }
 torus { 4,1 rotate -90*x scale <0.5,1,0.5> rotate -60*z }
 torus { 4,1 rotate -90*x scale <0.5,1,0.5> }
 torus { 4,1 rotate -90*x scale <0.5,1,0.5> rotate 60*z }
 scale <1,1,0.8>
}
//
#local Tassel_base =
union {
 torus { 2, 0.3 
  clipped_by { plane { z,0 } rotate -(180)*y }
  clipped_by { plane { z,0 } rotate -(90)*y }
 }
 cylinder { 0,-20*x 0.3 translate 2*z }
 translate <-2,0,0.4> rotate 180*z
}
#local Tassel_org =
union {
 sphere { 0 2 }
 #local Ei=12; #local Si=0; #while(Si<Ei)
  object { Tassel_base rotate 360*Si/Ei*x }
 #local Si=Si+1; #end
}
#local Tx=0; #local Ty=0; #local Tz=0;
#local Sword_tassel =
union {
 torus { 1,1 rotate 90*z translate y }
 Space_line(0.5,pi*< 0,1.6,1/28>,1)
 Line_function((1.6+1/24)*pi,Tx,Ty,Tz,1)
 object { Tassel_org rotate -20*y translate <Tx,Ty,Tz> }
}
//
#local Sword_seg =
union {
 object { Sword_edge texture { T_edge } translate (26+5)*y  }
 object { Sword_guard texture { T_guard } translate (26+5)*y }
 object { Sword_hilt texture { T_hilt } translate 5*y }
 object { Sword_tassel texture { T_tassel } rotate 10*y }
 object { Sword_tassel texture { T_tassel } rotate -10*y }
}
//**********************************************************************************
// mirror
#local T_mirror =
texture {
 pigment { color rgb 1 }
 finish { ambient 0 diffuse 0 reflection 1 }
}
//
#local Mirror_seg =
union {
 difference {
 cylinder { 0, 0.5*y 6 texture { T_hilt } }
 cylinder { 0.4*y, 0.6*y 5.4 texture { T_mirror } }
 }
 sphere { 0 2 clipped_by { plane { y,0 } } texture { T_hilt } }
}
//**********************************************************************************
#include "Motion_capture.mcr.inc"
//----------------------------------------------------------------------------------
#macro Motion_function(Tp,Mv,Mh,Func_type)
 #switch (Func_type)
  #case(1) #local Mv= sin(Tp); #local Mh=pi/4; #break    // cos
  #case(2) #local Mv=-Tp+pi; #local Mh=0; #break         // circle
  #case(3) #local Mv= sin(Tp)+pi; #local Mh=pi/4; #break // cos
  #case(4) #local Mv=-Tp; #local Mh=0; #break            // circle
  #case(5) #local Mv= pi/2; #local Mh=-sin(Tp)+pi; #break // cos
 #end
#end
//----------------------------------------------------------------------------------
#macro Motion_obj(Obj_type,Tcnt)
 #switch(Obj_type)
 #case(0) object { Jewel_seg rotate 360*Tcnt*x } #break
 #case(1) object { Coral_seg } #break
 #case(2) object { Metal_seg scale 0.48 rotate <360*Tcnt,0,-360*Tcnt> } #break
 #end
#end
//----------------------------------------------------------------------------------
// crescent jewel
coordinate_color(250,1,0.4,1,1)
#local T_jewel = texture { pigment { color rgbt < R1, G1, B1, 0.2 > } finish { ambient 0.3 reflection 0.2 } }
//
#local Jewel_org =
difference {
 merge {
  sphere { 0, 12 scale <1,1,0.9> }
  merge { Bio_line(11.8,pi*< 0.5, 1.2, 1/12 >,pi*< 0, 1/3, 0 >,2) translate <1,-13.6,0> }
  scale <1,1,0.5> }
 sphere { 0, 3 scale <1,1,4> }
 rotate 90*x translate 4*y
}
//
#local Jewel_seg = object { Jewel_org texture { T_jewel } scale 0.2 }
#local Pv=<0,0,0>; //locus of motion : 1
#local Crescent_jewel =
union {
 Locus_motion(0,Pv,20,pi*<-1.5,1,1/8>,1)
 Locus_motion(0,Pv,20,pi*<-1,0,1/8>,2)
 Locus_motion(0,Pv,20,pi*<-1,1,1/8>,3)
 Locus_motion(0,Pv,20,pi*<-1,0,1/8>,4)
}
//**********************************************************************************
coordinate_color(330,1,0.4,1,2)
#local T_coral = texture { pigment { color rgbt < R2, G2, B2, 0.2 > } finish { ambient 0.3 reflection 0.2 } }
#local Coral_seg = sphere { 0, 5 }
#local Pv=<0,0,0>; //locus of motion : 1
#local Coral_obj =
union {
 Locus_motion(1,Pv,10*8/pi,pi*<-0.5,0.5,1/8>,3)
 Locus_motion(1,Pv,10*8/pi,pi*<-0.5,1.5,1/8>,5)
}
//**********************************************************************************
// treasure boxes
coordinate_color(355,0.66,0.64,1,1)
coordinate_color(349,0.31,0.45,1,2)
#local T_wood_a =
texture {
 pigment { wood
           turbulence 0.04
           octaves 3
           scale <0.05,0.05,1>
           color_map { [0.1 rgb <R1,G1,B1>]
                       [0.9 rgb <R2,G2,B2>] } }
 finish { ambient 0.45 diffuse 0.33 reflection 0.15 specular 0.25 roughness 0.05 }
}
coordinate_color(11,0.35,0.55,1,3)
coordinate_color( 7,0.57,0.55,1,4)
coordinate_color( 0,0.50,0.40,1,5)
#local T_wood_b =
texture {
 pigment { wood
           turbulence <0.1,0.5,1>
           octaves 5
           lambda 3.25
           scale <0.15,0.5,1>
           color_map { [0.0 rgbf <R3,G3,B3,0.100>]
                       [0.1 rgbf <R4,G4,B4,0.500>]
                       [0.1 rgbf <R4,G4,B4,0.650>]
                       [0.9 rgbf <R5,G5,B5,0.975>]
                       [1.0 rgbf <R5,G5,B5,1.000>] } rotate <5,10,5> translate -2*x }
 finish { ambient 0.1 diffuse 0.33 specular 0.25 roughness 0.0005 }
}
#local T_wood = texture { T_wood_a } texture { T_wood_b }
//
coordinate_color(10,1,0.6,1,6)
#local T_treabox = texture { T_wood scale 10 } texture { pigment { color rgbf <R6,G6,B6,0.3> } }
//
coordinate_color( 30, 0.43, 0.63, 1, 1 )
#local T_gold =
  texture {
   pigment { color < R1, G1, B1 > }
   finish { metallic ambient 0.1 diffuse 0.4 reflection 0.25 specular 1 }
}
//----------------------------------------------------------------------------------
#local Bw=20; #local Bd=Bw*(-1+sqrt(5))/2; #local Bh=15; #local Bt=1; #local Ba=20;
#local Tw=Bw+Bh*tan(radians(Ba))+Bt; #local Td=Bd+Bh*tan(radians(Ba))+Bt;
//
#local Box_Sorg =
box { < -Bt,-Bt,-Td >, <  Bt, Bh, Td >
 clipped_by { plane { z,0 } rotate Ba*x translate (Bd+Bt)*z }
 clipped_by { plane { z,0 } rotate (180-Ba)*x translate -(Bd+Bt)*z }
}
#local Box_Forg =
box { < -Tw,-Bt,-Bt >, <  Tw, Bh, Bt >
 clipped_by { plane { x,0 } rotate (180+Ba)*z translate -Bw*x }
 clipped_by { plane { x,0 } rotate -Ba*z translate Bw*x }
}
#local Lock_org = sphere { 0,5 scale <1,1,0.1> clipped_by { plane { y,0 } } }
//
#local Treabox_Uorg =
union {
 box { < -Bw,-Bt,-Bd >, <  Bw, Bt, Bd > } //base
 object { Box_Sorg rotate Ba*z translate -Bw*x } //R
 object { Box_Sorg rotate -Ba*z translate Bw*x } //L
 object { Box_Forg rotate Ba*x translate Bd*z }   //back
 object { Box_Forg rotate -Ba*x translate -Bd*z } //front
 box { < -Tw+Bt/2, Bh*cos(radians(Ba))-Bt/2,-Td >, <  Tw-Bt/2, Bh*cos(radians(Ba)),-Td+Bt*2 > } //front
 object { Lock_org texture { T_gold } rotate -Ba*x translate < 0, Bh-Bt, -Td-0.5-0.2 > }
}
#local Treabox_Torg =
union {
 difference {
 cylinder { -Tw*x, Tw*x Td }
 cylinder { -(Tw-Bt*2)*x, (Tw-Bt*2)*x Td-Bt*2 }
 box { < -Tw-Bt,-Td-Bt,-Td-Bt >, < Tw+Bt, 0, Td+Bt > }
 }
 object { Lock_org texture { T_gold } rotate 180*z rotate Ba*x translate (-Td-0.5-0.2)*z }
 translate -Td*z
}
//
#local Treasure_boxes =
union {
 object { Treabox_Torg rotate 10*x translate < 0,Bh*cos(radians(Ba)),Td > }
 difference {
 object { Treabox_Uorg }
 box { < -Bt,-Bt*2,-Bt*5 >,< Bt, 0, Bt > pigment { color rgb 0 } scale <0.4,1,1> translate < 0, Bh-Bt*1.6,-Td > }
 }
 translate Bt*y
}
//**********************************************************************************
// coin
#local Coin_base =
difference {
 cylinder { -y, y 20 }
 cylinder { 0.8*y,1.1*y 18 }
 cylinder { -0.8*y,-1.1*y 18 }
 #local Ei=60; #local Si=0; #while(Si<Ei)
  cylinder { -1.1*y, 1.1*y 0.1 translate 20*x rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
}
#local Coin_back =
union {
#local Ei=12; #local Si=0; #while(Si<Ei)
 sphere { 0 8 clipped_by { plane { y,0 } } scale <1,0.2,0.3> translate 8*x rotate 360*Si/Ei*y }
#local Si=Si+1; #end
}
#local Coin_org =
union {
 object { Coin_base }
 object { Coin_back rotate 180*z translate 8*0.2*y }
 translate y 
}
//**********************************************************************************
// topaz
coordinate_color( 30, 1.0, 0.6, 1, 1 )
#local T_topaz =
texture {
 pigment { color rgbt < R1, G1, B1, 0.6 > }
 finish { ambient 0.4 reflection 0.6 phong 0.75 phong_size 80 }
}
#local I_topaz = interior { ior 1.8 fade_distance 40 fade_power 1 }
//**********************************************************************************
// emerald
coordinate_color( 130, 1.0, 0.5, 1, 1 )
#local T_emerald =
texture {
 pigment { color rgbt < R1, G1, B1, 0.6 > }
 finish { ambient 0.4 reflection 0.6 phong 0.75 phong_size 80 }
}
//----------------------------------------------------------------------------------
#local Emerald_base =
difference {
 sphere { 0 28 }
 box { <-28,-28,-28>,<28,0,28> scale 1.1 }
 box { <-20,-1,-20>, <20,20,20> translate -40*x }
 box { <-20,-1,-20>, <20,20,20> translate 40*x }
 box { <-20,-1,-20>, <20,20,20> translate 40*z }
 box { <-20,-1,-20>, <20,20,20> translate -40*z }
 scale <5/4,5/28,1>
}
#local Ca=33;
#local Emerald_org =
difference {
 object { Emerald_base } //box { <-25,0,-20>, <25,5,20> }
 box { <-26,-5,-6>, <26,10,6> rotate -Ca*x translate 20*z }
 box { <-26,-5,-6>, <26,10,6> rotate Ca*x translate -20*z }
 box { <-6,-5,-21>, <6,10,21> rotate Ca*z translate 25*x }
 box { <-6,-5,-21>, <6,10,21> rotate -Ca*z translate -25*x }
 box { <-26,-5,-6>, <26,10,6> rotate <-Ca,45,0> translate <20,0,15> }
 box { <-26,-5,-6>, <26,10,6> rotate <-Ca,-45,0> translate <-20,0,15> }
 box { <-26,-5,-6>, <26,10,6> rotate <Ca,45,0> translate <-20,0,-15> }
 box { <-26,-5,-6>, <26,10,6> rotate <Ca,-45,0> translate <20,0,-15> }
}
#local Emerald_seg =
merge {
 object { Emerald_org }
 object { Emerald_org rotate 180*x }
 translate 5*y
}
//**********************************************************************************
// sapphire
coordinate_color( 250, 1.0, 0.5, 1, 1 )
#local T_sapphire =
texture {
 pigment { color rgbt < R1, G1, B1, 0.6 > }
 finish { ambient 0.4 reflection 0.6 phong 0.75 phong_size 80 }
}
//
#local Rr=30; #local Ry=Rr*0.3;
#local Sapphire_org =
mesh{
 #local Ei=8; #local Si=0; #while(Si<Ei)
  #local Py1=Ry*cos(radians(50)); #local R1=Rr*sin(radians(50)); #local Ac=2*pi/Ei;
  triangle { <0,Ry,0>,<R1*cos(Ac*Si),Py1,R1*sin(Ac*Si)>,<R1*cos(Ac*(Si+1)),Py1,R1*sin(Ac*(Si+1))> }
  #local Py0=Ry*cos(radians(90)); #local R0=Rr*sin(radians(90)); 
  triangle { <R1*cos(Ac*Si),Py1,R1*sin(Ac*Si)>,<R1*cos(Ac*(Si+1)),Py1,R1*sin(Ac*(Si+1))>,<R0*cos(Ac*(Si+0.5)),Py0,R0*sin(Ac*(Si+0.5))> }
  triangle { <R1*cos(Ac*Si),Py1,R1*sin(Ac*Si)>,<R0*cos(Ac*(Si-0.5)),Py0,R0*sin(Ac*(Si-0.5))>,<R0*cos(Ac*(Si+0.5)),Py0,R0*sin(Ac*(Si+0.5))> }
 #local Si=Si+1; #end
}
#local Sapphire_seg =
merge {
 object { Sapphire_org }
 object { Sapphire_org rotate 180*z }
 translate Ry*y
}
//**********************************************************************************
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Px=0.8*Ss; #local Py=5*exp(-pow(Ss,2)-pow(Se,2))*(pow(Ss,2)+pow(Se,2)); #local Pz=0.8*Se; #break //rock
 #case(2) #local Px=Pr*cos(Se)*cos(Ss); #local Py=Pr*sin(Se); #local Pz=0.6*Pr*cos(Se)*sin(Ss); #break //Treasure
 #end
#end
//----------------------------------------------------------------------------------
coordinate_color( 30, 0.43, 0.63, 1, 1 )
#local T_coin =
  texture {
   pigment { color rgb < R1, G1, B1 > }
   finish { metallic ambient 0.6 diffuse 0.4 reflection 0.25 specular 1 }
}
#local Obj_seg = object { Coin_org texture { T_coin } scale 0.1 rotate -90*z }
#local Coins_obj =
union { 
 #local Pr=24; union { Normal_rect(pi*<-1,1,1/6>,pi*<0.2,0.4,1/12>,2) }
 #local Pr=23; union { Normal_rect(pi*<-1,1,1/6>,pi*<0.2,0.4,1/12>,2) rotate 10*y }
 #local Pr=22; union { Normal_rect(pi*<-1,1,1/6>,pi*<0.2,0.4,1/12>,2) rotate 20*y }
}
#local Obj_seg = object { Emerald_seg texture { T_emerald } scale 0.1 rotate -90*z }
#local Pr=20; #local Emerald_obj = union { Normal_rect(pi*<-1,1,1/6>,pi*<0.2,0.4,1/12>,2) }
#local Obj_seg = object { Emerald_seg texture { T_topaz } scale 0.1 rotate -90*z }
#local Pr=26; #local Topaz_obj = union { Normal_rect(pi*<-0.8,-0.4,1/6>,pi*<0.2,0.21,1/12>,2) }
#local Treasure_obj =
union {
 object { Coins_obj }
 object { Emerald_obj }
 object { Topaz_obj translate -2*y }
}
//**********************************************************************************
// bell
#local Bell_base =
union {
 sphere { 0 10 scale <0.5,1,1> }
 cone { 0 10, 20*x 13 }
 sphere { 0 13 scale <0.5,1,1> translate 20*x }
 torus { 10,0.5 rotate -90*z }
 torus { 13,0.5 rotate -90*z translate 20*x }
 torus { 11.5,0.5 rotate -90*z translate 10*x }
 cylinder { 0,20*x 1 rotate degrees(atan2(3,20))*z translate 10*y }
 cylinder { 0,20*x 1 rotate -degrees(atan2(3,20))*z translate -10*y }
}
#local Bell_org =
union {
 torus { 5,1 translate -3*x }
 difference {
 object { Bell_base }
 box { <0,-1,0>,<7,1,10> translate 20*x }
 cylinder { 0, 7*x 3 translate 20*x }
 scale <1,0.3,1> rotate degrees(atan2(3*0.3,20))*z translate 10*0.3*y }
}
//**********************************************************************************
coordinate_color( 270, 1.0, 0.5, 1, 1 )
#local T_ground = texture { pigment { color rgb < R1, G1, B1 > } }
#local Rock_org = object { Surface_tri2m(pi*<-1,1,1/6>,pi*<-1,1,1/8>,0) scale 8 }
#local Rock_seg =
union {
 object { Rock_org }
 object { Rock_org scale <0.8,1.3,0.8> translate 2*x }
}
//
#local Ground_seg =
union {
 sphere { 0 2000 clipped_by { plane { y,0 } rotate 180*z } scale <1,200/2000,0.5> translate <0,-186,600> }
 object { Rock_seg rotate 90*y translate <-100,0,100> }
 object { Rock_seg rotate -45*y translate <-160,0,200> }
 object { Rock_seg rotate -55*y translate <50,0,200> }
 plane { y,0 hollow }
 texture { T_ground }
}
//**********************************************************************************
// metal
#local Br=42.6;
#local Metal_base =
difference {
 sphere { 0 Br }
 box { <-Br,-Br,-Br>,<Br,0,Br> scale 1.1 }
 box { <-20,-1,-20>, <20,20,20> translate -40*x }
 box { <-20,-1,-20>, <20,20,20> translate 40*x }
 box { <-20,-1,-20>, <20,20,20> translate 40*z }
 box { <-20,-1,-20>, <20,20,20> translate -40*z }
 scale <5/4,5/28*0.5,1>
}
#local Ca=33;
#local Metal_org =
difference {
 object { Metal_base }
 box { <-26,-5,-6>, <26,10,6> rotate -Ca*x translate 20*z }
 box { <-26,-5,-6>, <26,10,6> rotate Ca*x translate -20*z }
 box { <-6,-5,-21>, <6,10,21> rotate Ca*z translate 25*x }
 box { <-6,-5,-21>, <6,10,21> rotate -Ca*z translate -25*x }
 box { <-26,-5,-6>, <26,10,6> rotate <-Ca,45,0> translate <20,0,15> }
 box { <-26,-5,-6>, <26,10,6> rotate <-Ca,-45,0> translate <-20,0,15> }
 box { <-26,-5,-6>, <26,10,6> rotate <Ca,45,0> translate <-20,0,-15> }
 box { <-26,-5,-6>, <26,10,6> rotate <Ca,-45,0> translate <20,0,-15> }
}
#local Metal_seg =
merge {
 object { Metal_org texture { T_edge } }
 object { Metal_org texture { T_edge } rotate 180*x }
 object { Sapphire_seg texture { T_sapphire } interior { I_topaz } scale 0.28 translate Br*0.59*x rotate 36*y }
 object { Sapphire_seg texture { T_sapphire } interior { I_topaz } scale 0.28 translate -Br*0.59*x rotate 36*y }
 object { Sapphire_seg texture { T_sapphire } interior { I_topaz } scale 0.28 translate Br*0.59*z rotate 54*y }
 object { Sapphire_seg texture { T_sapphire } interior { I_topaz } scale 0.28 translate -Br*0.59*z rotate 54*y }
 sphere { 0, Br scale <5/4,5/28*0.3,1> texture { T_coin } }
 translate 5*0.5*y
}
object { Metal_seg scale 0.98 rotate < -90,0,0 > translate <-100,200,300> }
// parabolic motion : 0
union { Parabolic_motion(2,<135,78>,9.8,<0,10,1>) translate <-100,200,800> }
union { Parabolic_motion(2,<150,78>,9.8,<0,10,1>) translate <-100,180,800> }
union { Parabolic_motion(2,<165,78>,9.8,<0,10,1>) translate <-100,160,800> }
union { Parabolic_motion(2,<180,78>,9.8,<0, 4,1>) translate <-100,140,800> }
//**********************************************************************************
object { Cat_eye rotate -30*y translate <-400,50,700> }
//----------------------------------------------------------------------------------
object { Sword_seg scale 0.5 rotate 180*z translate (80+26+5)/2*y }
object { Mirror_seg rotate <-degrees(atan2(2,6)),20,0> translate <15,2*0.9,0> }
object { Crescent_jewel rotate <180+8,-12,0> scale 0.24 translate <0,42,4> }
//----------------------------------------------------------------------------------
union {
 object { Treasure_boxes texture { T_treabox } scale 0.8 }
 object { Treasure_obj }
 object { Coral_obj texture { T_coral } scale 0.2 rotate 30*y translate < -Tw+5,Bh+1,-Td-1 >*0.8 }
 rotate 30*y translate -30*x
}
//----------------------------------------------------------------------------------
object { Coin_org texture { T_gold } scale 0.1 translate <-5,0,-10> }
object { Emerald_seg texture { T_topaz } interior { I_topaz } scale 0.1 translate -64*x }
object { Emerald_seg texture { T_emerald } interior { I_topaz } scale 0.1 rotate 30*y translate -70*x }
object { Sapphire_seg texture { T_sapphire } interior { I_topaz } scale 0.1 translate -80*x }
object { Bell_org texture { T_gold } scale 0.2 rotate 30*y translate <-40,0,-30> }
//----------------------------------------------------------------------------------
object { Ground_seg }
//**********************************************************************************