
#macro orientAndPos(V1,V2,MV)
  #local VX1=vnormalize(V1);
  #local VX2=vnormalize(V2);
  #local VY=vcross(VX2,VX1);
  #if (vlength(VY)>0)
  #local VY=vnormalize(VY);
  #local VZ1=vcross(VY,VX1);
  #local VZ2=vcross(VY,VX2);

  matrix < VX1.x, VY.x, VZ1.x,
           VX1.y, VY.y, VZ1.y,
           VX1.z, VY.z, VZ1.z,
               0     0      0 >

  matrix < VX2.x, VX2.y, VX2.z,
            VY.x,  VY.y,  VY.z,
           VZ2.x, VZ2.y, VZ2.z,
               0,     0,     0 >

  matrix <     1,     0,     0,
               0,     1,     0,
               0,     0,     1,
            MV.x,  MV.y,  MV.z >
  #end
#end

#macro textures_signs_material_map_d16()
  texture { pigment { color k_Lightning_Yellow } finish { Glossy } }
  texture { pigment { color k_Acadia }           finish { Glossy } }
  texture { pigment { color rgb  <0.340, 0.170, 0.085> } finish { F_MetalC } } // Rest not used presently.
  texture { pigment { color rgb  <0.360, 0.180, 0.090> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.380, 0.190, 0.095> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.400, 0.200, 0.100> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.420, 0.210, 0.105> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.440, 0.220, 0.110> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.460, 0.230, 0.115> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.480, 0.240, 0.120> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.500, 0.250, 0.125> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.520, 0.260, 0.130> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.540, 0.270, 0.135> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.560, 0.280, 0.140> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.580, 0.290, 0.145> } finish { F_MetalC } }
  texture { pigment { color rgb  <0.600, 0.300, 0.150> } finish { F_MetalC } }
#end

#declare CM_SNOW = color_map {
    [0.0000000 rgb <0.62745,0.62745,0.73725>*1.198]
    [0.0025541 rgb <0.63137,0.63137,0.74118>*1.197]
    [0.0050263 rgb <0.63922,0.63922,0.74902>*1.195]
    [0.0083989 rgb <0.64314,0.64314,0.75294>*1.194]
    [0.0111167 rgb <0.65098,0.65098,0.76078>*1.192]
    [0.0145712 rgb <0.65490,0.65490,0.76471>*1.190]
    [0.0189260 rgb <0.65882,0.65882,0.76863>*1.189]
    [0.0213164 rgb <0.66275,0.66275,0.77255>*1.187]
    [0.0251801 rgb <0.66667,0.66667,0.77647>*1.186]
    [0.0296168 rgb <0.67059,0.67059,0.78039>*1.184]
    [0.0333168 rgb <0.67451,0.67451,0.78431>*1.182]
    [0.0370987 rgb <0.67843,0.67843,0.78824>*1.181]
    [0.0407987 rgb <0.68235,0.68235,0.78431>*1.179]
    [0.0434347 rgb <0.68235,0.68235,0.79216>*1.178]
    [0.0478714 rgb <0.68627,0.67451,0.78039>*1.176]
    [0.0504255 rgb <0.68627,0.68627,0.79608>*1.175]
    [0.0533069 rgb <0.69020,0.69020,0.79216>*1.173]
    [0.0557792 rgb <0.69020,0.69020,0.80000>*1.171]
    [0.0589881 rgb <0.69412,0.68235,0.78824>*1.170]
    [0.0621151 rgb <0.69412,0.69412,0.80392>*1.168]
    [0.0646692 rgb <0.69804,0.69804,0.80000>*1.167]
    [0.0672233 rgb <0.69804,0.69804,0.80784>*1.165]
    [0.0701866 rgb <0.70196,0.69020,0.79608>*1.163]
    [0.0733955 rgb <0.70196,0.70196,0.81176>*1.162]
    [0.0770137 rgb <0.70588,0.69412,0.80000>*1.160]
    [0.0793222 rgb <0.70588,0.70588,0.81569>*1.159]
    [0.0817945 rgb <0.70980,0.69804,0.80392>*1.157]
    [0.0850034 rgb <0.70980,0.70980,0.81961>*1.155]
    [0.0877211 rgb <0.71373,0.70196,0.80784>*1.154]
    [0.0905208 rgb <0.71373,0.71373,0.82353>*1.152]
    [0.0934841 rgb <0.71765,0.70588,0.81176>*1.151]
    [0.0963656 rgb <0.72157,0.70980,0.81569>*1.149]
    [0.1000656 rgb <0.72157,0.72157,0.83137>*1.147]
    [0.1030290 rgb <0.72549,0.71765,0.81176>*1.146]
    [0.1055012 rgb <0.72549,0.72549,0.83529>*1.144]
    [0.1087920 rgb <0.72941,0.71765,0.82353>*1.143]
    [0.1125738 rgb <0.72941,0.72941,0.83922>*1.141]
    [0.1150461 rgb <0.73333,0.72157,0.82745>*1.139]
    [0.1176002 rgb <0.73333,0.73333,0.84314>*1.138]
    [0.1206454 rgb <0.73725,0.72549,0.83137>*1.136]
    [0.1231176 rgb <0.74118,0.72941,0.80392>*1.135]
    [0.1256717 rgb <0.74118,0.72941,0.83529>*1.133]
    [0.1281439 rgb <0.74118,0.74118,0.84314>*1.131]
    [0.1304524 rgb <0.74118,0.74118,0.85098>*1.130]
    [0.1329246 rgb <0.74510,0.73333,0.83922>*1.128]
    [0.1353969 rgb <0.74510,0.74510,0.85490>*1.127]
    [0.1377054 rgb <0.74902,0.73725,0.80392>*1.125]
    [0.1400139 rgb <0.74902,0.73725,0.84314>*1.124]
    [0.1436321 rgb <0.75294,0.74118,0.84706>*1.122]
    [0.1459406 rgb <0.75686,0.74510,0.81961>*1.120]
    [0.1502136 rgb <0.75686,0.74510,0.85098>*1.119]
    [0.1527677 rgb <0.75686,0.74902,0.83529>*1.117]
    [0.1553217 rgb <0.76078,0.74902,0.82353>*1.116]
    [0.1582851 rgb <0.76078,0.74902,0.85490>*1.114]
    [0.1605936 rgb <0.76471,0.75294,0.82745>*1.112]
    [0.1637207 rgb <0.76471,0.75686,0.84314>*1.111]
    [0.1663566 rgb <0.76863,0.75686,0.83137>*1.109]
    [0.1698111 rgb <0.77255,0.76078,0.83529>*1.108]
    [0.1729381 rgb <0.77255,0.76078,0.86667>*1.106]
    [0.1752466 rgb <0.77255,0.76471,0.84706>*1.104]
    [0.1775551 rgb <0.77647,0.76471,0.83137>*1.103]
    [0.1801911 rgb <0.77647,0.76471,0.83922>*1.101]
    [0.1849552 rgb <0.78039,0.76863,0.84314>*1.100]
    [0.1883278 rgb <0.78431,0.77255,0.83922>*1.098]
    [0.1915367 rgb <0.78431,0.77255,0.84706>*1.096]
    [0.1955641 rgb <0.78431,0.77647,0.85882>*1.095]
    [0.1979545 rgb <0.78824,0.77647,0.84314>*1.093]
    [0.2008360 rgb <0.78824,0.77647,0.85098>*1.092]
    [0.2062549 rgb <0.78824,0.77647,0.88235>*1.090]
    [0.2085635 rgb <0.79216,0.78039,0.84706>*1.088]
    [0.2113631 rgb <0.79216,0.78039,0.85490>*1.087]
    [0.2153087 rgb <0.79608,0.78431,0.85098>*1.085]
    [0.2176991 rgb <0.79608,0.78431,0.85882>*1.084]
    [0.2215628 rgb <0.79608,0.78431,0.86667>*1.082]
    [0.2239532 rgb <0.80000,0.78824,0.86275>*1.080]
    [0.2288810 rgb <0.80000,0.79216,0.84706>*1.079]
    [0.2317625 rgb <0.80392,0.79216,0.85882>*1.077]
    [0.2353806 rgb <0.80392,0.79216,0.86667>*1.076]
    [0.2396536 rgb <0.80784,0.79608,0.87059>*1.074]
    [0.2438448 rgb <0.81176,0.80000,0.86667>*1.073]
    [0.2473811 rgb <0.81176,0.80000,0.87451>*1.071]
    [0.2514904 rgb <0.81569,0.80392,0.87059>*1.069]
    [0.2542900 rgb <0.81569,0.80392,0.87843>*1.068]
    [0.2599545 rgb <0.81961,0.80392,0.85882>*1.066]
    [0.2623449 rgb <0.81961,0.80784,0.87451>*1.065]
    [0.2653901 rgb <0.81961,0.80784,0.88235>*1.063]
    [0.2690901 rgb <0.82353,0.81176,0.87843>*1.061]
    [0.2721353 rgb <0.82353,0.81176,0.88627>*1.060]
    [0.2763265 rgb <0.82353,0.81569,0.86667>*1.058]
    [0.2788805 rgb <0.82353,0.81569,0.87059>*1.057]
    [0.2811891 rgb <0.82745,0.81176,0.86667>*1.055]
    [0.2836613 rgb <0.82745,0.81569,0.88235>*1.053]
    [0.2864609 rgb <0.82745,0.81569,0.89020>*1.052]
    [0.2907339 rgb <0.82745,0.81961,0.87059>*1.050]
    [0.2934517 rgb <0.83137,0.81961,0.88627>*1.049]
    [0.2960876 rgb <0.83137,0.81961,0.89412>*1.047]
    [0.2993784 rgb <0.83137,0.82353,0.87451>*1.045]
    [0.3023417 rgb <0.83137,0.82353,0.87843>*1.044]
    [0.3052232 rgb <0.83529,0.81961,0.87451>*1.042]
    [0.3077773 rgb <0.83529,0.82353,0.86667>*1.041]
    [0.3100858 rgb <0.83529,0.82353,0.89804>*1.039]
    [0.3134584 rgb <0.83529,0.82745,0.87843>*1.037]
    [0.3164218 rgb <0.83922,0.82745,0.87059>*1.036]
    [0.3187303 rgb <0.83922,0.82745,0.89412>*1.034]
    [0.3214481 rgb <0.83922,0.82745,0.90196>*1.033]
    [0.3255574 rgb <0.84314,0.83137,0.89804>*1.031]
    [0.3290937 rgb <0.84314,0.83137,0.90588>*1.029]
    [0.3336123 rgb <0.84314,0.83529,0.88627>*1.028]
    [0.3362482 rgb <0.84706,0.83137,0.88627>*1.026]
    [0.3388841 rgb <0.84706,0.83529,0.87843>*1.025]
    [0.3423386 rgb <0.84706,0.83529,0.90196>*1.023]
    [0.3453838 rgb <0.84706,0.83529,0.90980>*1.022]
    [0.3478560 rgb <0.84706,0.83922,0.89020>*1.020]
    [0.3509831 rgb <0.85098,0.83529,0.89020>*1.018]
    [0.3543557 rgb <0.85098,0.83922,0.88235>*1.017]
    [0.3577283 rgb <0.85098,0.83922,0.90588>*1.015]
    [0.3604461 rgb <0.85098,0.83922,0.91373>*1.014]
    [0.3644735 rgb <0.85098,0.84314,0.89412>*1.012]
    [0.3672731 rgb <0.85490,0.83922,0.89412>*1.010]
    [0.3699909 rgb <0.85490,0.84314,0.88627>*1.009]
    [0.3746732 rgb <0.85490,0.84314,0.90980>*1.007]
    [0.3782095 rgb <0.85490,0.84314,0.91765>*1.006]
    [0.3817458 rgb <0.85490,0.84706,0.89804>*1.004]
    [0.3844636 rgb <0.85882,0.84314,0.89804>*1.002]
    [0.3874270 rgb <0.85882,0.84706,0.89020>*1.001]
    [0.3912088 rgb <0.85882,0.84706,0.91373>*0.999]
    [0.3938448 rgb <0.85882,0.84706,0.92157>*0.998]
    [0.3966444 rgb <0.85882,0.85098,0.90196>*0.996]
    [0.3999352 rgb <0.85882,0.85098,0.90588>*0.994]
    [0.4033896 rgb <0.86275,0.84706,0.90196>*0.993]
    [0.4077445 rgb <0.86275,0.85098,0.88627>*0.991]
    [0.4103804 rgb <0.86275,0.85098,0.89412>*0.990]
    [0.4157993 rgb <0.86275,0.85098,0.91765>*0.988]
    [0.4187627 rgb <0.86275,0.85098,0.92549>*0.986]
    [0.4219716 rgb <0.86275,0.85490,0.90588>*0.985]
    [0.4246894 rgb <0.86275,0.85490,0.90980>*0.983]
    [0.4269979 rgb <0.86667,0.85098,0.90588>*0.982]
    [0.4300431 rgb <0.86667,0.85490,0.89020>*0.980]
    [0.4326790 rgb <0.86667,0.85490,0.89804>*0.978]
    [0.4377706 rgb <0.86667,0.85490,0.92157>*0.977]
    [0.4405702 rgb <0.86667,0.85490,0.92941>*0.975]
    [0.4430424 rgb <0.86667,0.85882,0.90980>*0.974]
    [0.4464150 rgb <0.87059,0.85490,0.90980>*0.972]
    [0.4503606 rgb <0.87059,0.85882,0.89412>*0.971]
    [0.4528328 rgb <0.87059,0.85882,0.90196>*0.969]
    [0.4588248 rgb <0.87059,0.85882,0.92549>*0.967]
    [0.4617062 rgb <0.87059,0.85882,0.93333>*0.966]
    [0.4649152 rgb <0.87059,0.86275,0.91373>*0.964]
    [0.4681241 rgb <0.87451,0.85882,0.91373>*0.963]
    [0.4712511 rgb <0.87451,0.86275,0.89804>*0.961]
    [0.4747874 rgb <0.87451,0.86275,0.90588>*0.959]
    [0.4797971 rgb <0.87451,0.86275,0.93725>*0.958]
    [0.4821056 rgb <0.87451,0.86667,0.91765>*0.956]
    [0.4853964 rgb <0.87451,0.86667,0.92157>*0.955]
    [0.4877868 rgb <0.87843,0.86275,0.91765>*0.953]
    [0.4917323 rgb <0.87843,0.86667,0.90196>*0.951]
    [0.4949412 rgb <0.87843,0.86667,0.90980>*0.950]
    [0.5024884 rgb <0.87843,0.86667,0.93333>*0.948]
    [0.5048787 rgb <0.87843,0.87059,0.92157>*0.947]
    [0.5084969 rgb <0.87843,0.87059,0.92549>*0.945]
    [0.5109691 rgb <0.88235,0.86667,0.92157>*0.943]
    [0.5140143 rgb <0.88235,0.87059,0.89804>*0.942]
    [0.5163228 rgb <0.88235,0.87059,0.90588>*0.940]
    [0.5210051 rgb <0.88235,0.87059,0.91373>*0.939]
    [0.5266696 rgb <0.88235,0.87451,0.92549>*0.937]
    [0.5300422 rgb <0.88627,0.87059,0.92549>*0.935]
    [0.5336604 rgb <0.88627,0.87451,0.90980>*0.934]
    [0.5401434 rgb <0.88627,0.87451,0.91765>*0.932]
    [0.5464627 rgb <0.88627,0.87843,0.92941>*0.931]
    [0.5497535 rgb <0.89020,0.87451,0.92941>*0.929]
    [0.5539446 rgb <0.89020,0.87843,0.91373>*0.927]
    [0.5596091 rgb <0.89020,0.87843,0.92157>*0.926]
    [0.5672381 rgb <0.89020,0.88235,0.93333>*0.924]
    [0.5700378 rgb <0.89412,0.87843,0.93333>*0.923]
    [0.5740652 rgb <0.89412,0.88235,0.90980>*0.921]
    [0.5767830 rgb <0.89412,0.88235,0.91765>*0.920]
    [0.5817927 rgb <0.89412,0.88235,0.92549>*0.918]
    [0.5891761 rgb <0.89804,0.88235,0.93725>*0.916]
    [0.5921394 rgb <0.89804,0.88627,0.91373>*0.915]
    [0.5951028 rgb <0.89804,0.88627,0.92157>*0.913]
    [0.6011765 rgb <0.89804,0.88627,0.92941>*0.912]
    [0.6082325 rgb <0.90196,0.88627,0.94118>*0.910]
    [0.6114414 rgb <0.90196,0.89020,0.91765>*0.908]
    [0.6153870 rgb <0.90196,0.89020,0.92549>*0.907]
    [0.6227704 rgb <0.90196,0.89020,0.93333>*0.905]
    [0.6305631 rgb <0.90588,0.89412,0.92157>*0.904]
    [0.6352454 rgb <0.90588,0.89412,0.92941>*0.902]
    [0.6412373 rgb <0.90588,0.89412,0.93725>*0.900]
    [0.6487844 rgb <0.90588,0.89804,0.94902>*0.899]
    [0.6514203 rgb <0.90980,0.89412,0.94902>*0.897]
    [0.6544655 rgb <0.90980,0.89804,0.92549>*0.896]
    [0.6590659 rgb <0.90980,0.89804,0.93333>*0.894]
    [0.6661219 rgb <0.90980,0.89804,0.94118>*0.892]
    [0.6721139 rgb <0.90980,0.90196,0.95294>*0.891]
    [0.6747498 rgb <0.91373,0.89804,0.95294>*0.889]
    [0.6777950 rgb <0.91373,0.90196,0.92941>*0.888]
    [0.6819861 rgb <0.91373,0.90196,0.93725>*0.886]
    [0.6908429 rgb <0.91373,0.90196,0.94510>*0.884]
    [0.6988811 rgb <0.91765,0.90588,0.93333>*0.883]
    [0.7035634 rgb <0.91765,0.90588,0.94118>*0.881]
    [0.7123383 rgb <0.91765,0.90588,0.94902>*0.880]
    [0.7191488 rgb <0.91765,0.90980,0.96078>*0.878]
    [0.7217028 rgb <0.92157,0.90588,0.96078>*0.876]
    [0.7248299 rgb <0.92157,0.90980,0.93725>*0.875]
    [0.7309037 rgb <0.92157,0.90980,0.94510>*0.873]
    [0.7388601 rgb <0.92157,0.90980,0.95294>*0.872]
    [0.7455886 rgb <0.92549,0.91373,0.94118>*0.870]
    [0.7516624 rgb <0.92549,0.91373,0.94902>*0.869]
    [0.7609284 rgb <0.92549,0.91373,0.95686>*0.867]
    [0.7662655 rgb <0.92941,0.91765,0.94510>*0.865]
    [0.7714389 rgb <0.92941,0.91765,0.95294>*0.864]
    [0.7807868 rgb <0.92941,0.91765,0.96078>*0.862]
    [0.7866150 rgb <0.93333,0.92157,0.94902>*0.861]
    [0.7930980 rgb <0.93333,0.92157,0.95686>*0.859]
    [0.8016274 rgb <0.93333,0.92157,0.96471>*0.857]
    [0.8076193 rgb <0.93725,0.92549,0.95294>*0.856]
    [0.8138568 rgb <0.93725,0.92549,0.96078>*0.854]
    [0.8222224 rgb <0.93725,0.92549,0.96863>*0.853]
    [0.8281325 rgb <0.94118,0.92941,0.95686>*0.851]
    [0.8364163 rgb <0.94118,0.92941,0.96471>*0.849]
    [0.8439634 rgb <0.94118,0.92941,0.97255>*0.848]
    [0.8488094 rgb <0.94510,0.93333,0.96078>*0.846]
    [0.8568476 rgb <0.94510,0.93333,0.96863>*0.845]
    [0.8639036 rgb <0.94510,0.93333,0.97647>*0.843]
    [0.8687496 rgb <0.94902,0.93725,0.96471>*0.841]
    [0.8762149 rgb <0.94902,0.93725,0.97255>*0.840]
    [0.8839257 rgb <0.94902,0.93725,0.98039>*0.838]
    [0.8876257 rgb <0.95294,0.94118,0.96863>*0.837]
    [0.8934539 rgb <0.95294,0.94118,0.97647>*0.835]
    [0.9005918 rgb <0.95294,0.94118,0.98431>*0.833]
    [0.9037188 rgb <0.95686,0.94510,0.97255>*0.832]
    [0.9103656 rgb <0.95686,0.94510,0.98039>*0.830]
    [0.9164393 rgb <0.96078,0.94902,0.97647>*0.829]
    [0.9214490 rgb <0.96078,0.94902,0.98431>*0.827]
    [0.9271954 rgb <0.96471,0.95294,0.98039>*0.825]
    [0.9317139 rgb <0.96471,0.95294,0.98824>*0.824]
    [0.9369691 rgb <0.96863,0.95686,0.98431>*0.822]
    [0.9420607 rgb <0.96863,0.95686,0.99216>*0.821]
    [0.9455970 rgb <0.96863,0.95686,1.00000>*0.819]
    [0.9481511 rgb <0.97255,0.96078,0.98824>*0.818]
    [0.9521785 rgb <0.97255,0.96078,0.99608>*0.816]
    [0.9558785 rgb <0.97647,0.96471,0.99216>*0.814]
    [0.9603971 rgb <0.97647,0.96471,1.00000>*0.813]
    [0.9652431 rgb <0.98039,0.96863,0.99608>*0.811]
    [0.9688612 rgb <0.98039,0.96863,1.00000>*0.810]
    [0.9732161 rgb <0.98431,0.97255,1.00000>*0.808]
    [0.9804358 rgb <0.98824,0.97647,1.00000>*0.806]
    [0.9877373 rgb <0.99216,0.98039,1.00000>*0.805]
    [0.9925015 rgb <0.99608,0.98431,1.00000>*0.803]
    [0.9964470 rgb <1.00000,0.98824,1.00000>*0.802]
    [1.0000000 rgb <1.00000,0.99216,1.00000>*0.800]
}


#declare T_SNOW = texture {       // Use for thin snow which will be brite
   pigment {
     bozo
     scale      0.005
//   lambda     2.5
//   omega      0.75
//   octaves    5.0
     frequency  1.0
     turbulence 0.6
     color_map { CM_SNOW }
   }
   finish { ambient 0.85 diffuse 0.15 reflection 0.0 }  // crand 0.2
}

#declare T_SNOW1 = texture {       // Use for thicker snow
   pigment {
     agate
     scale      0.005
//   lambda     2.5
//   omega      0.75
//   octaves    5.0
     frequency  1.0
     turbulence 0.1
     color_map { CM_SNOW }
   }
   finish { ambient 0.85 diffuse 0.15 reflection 0.0 } // crand 0.2
}

#declare T_ICE = texture {
   pigment { color rgbf <0.80, 0.90, 0.85, 0.70> }
   finish {
      ambient     0.15   // 0.10 ->
      diffuse     0.05   // 0.10 -> 0.20 ->
      reflection  0.10   // 0.25 -> 0.20 -> 0.15 ->
      specular    0.60   // 1.00 ->
      roughness   0.07   // 0.01 -> 0.05 -> 0.10 -> 0.15 ->
   }
}

#declare T_ICE1 = texture {
   pigment { color rgbf <0.80, 0.90, 0.85, 0.70> }
   finish {
      ambient     0.15
      diffuse     0.10
      reflection  0.05
      specular    0.50
      roughness   0.10
   }
}

