
// All sorts of parts and pieces....

    #include "ARM.inc"
    #include "ARMHALF.inc"
    #include "ARM_SMALL.inc"
    #include "ARM_SMLH.inc"
    #include "BALL.inc"
    #include "BALL_CTB.inc"
    #include "BALL_CTT.inc"
    #include "BALL_W.inc"
    #include "BARREL.inc"
    #include "FUZZBALL.inc"
    #include "HAT.inc"
    #include "HATBLUE.inc"
    #include "HATCUTB.inc"
    #include "HATCUTT.inc"
    #include "SPEAR.inc"
    #include "SWRDHNDL.inc"


//---------------------------------------- The arm --------------------------------------------------------------------
#declare zARM = object {
  ARM
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The arm half ---------------------------------------------------------------
#declare zARMHALF = object {
  ARMHALF
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The small arm --------------------------------------------------------------
#declare zARM_SMALL = object {
  ARM_SMALL
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The small arm half ---------------------------------------------------------
#declare zARM_SMLH = object {
  ARM_SMLH
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The large snow person body -------------------------------------------------
#declare LARGE_SP_BODY = object {
  BALL
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The small snow person body -------------------------------------------------
#declare SMALL_SP_BODY = object {
  BALL_W
  texture { T_SNOW }
  scale 0.01
}

//---------------------------------------- The large cut snow person body bottom -------------------------------------
#declare LARGE_SP_BODY_BOTTOM = object {
  union { object { BALL_CTB texture { T_SNOW } scale 0.01 }
          object { disc { <0.0000, 0.5303, 0.0000> < 0, 1, 0> 0.02 } texture { T_SNOW } }  // Patch the hole....
  }
}

//---------------------------------------- The large cut snow person body top ----------------------------------------
#declare LARGE_SP_BODY_TOP = object {
  union { object { BALL_CTT texture { T_SNOW } scale 0.01 }
          object { disc { <0.0000, 0.0000, 0.0000> < 0,-1, 0> 0.02 } texture { T_SNOW } }  // Patch the hole....
  }
}

//---------------------------------------- The fuzz -------------------------------------------------------------------
#declare zFUZZBALL = object {
  FUZZBALL
  texture { T_Copper_3C }
  scale 0.01
}

//---------------------------------------- The spear ------------------------------------------------------------------
#declare zSPEAR = object {
  SPEAR
  texture { T_Copper_2A }
  scale 0.01
}

//---------------------------------------- The sword handle -----------------------------------------------------------
#declare zSWRDHNDL = object {
  SWRDHNDL
  texture { pigment { color rgb <0.7412, 0.1216, 0.1686> } }
  scale 0.01
}

//---------------------------------------- The complete black hat------------------------------------------------------
#declare zHATBLUE = object {
  HATBLUE
  texture { pigment { color rgb <0.1686, 0.1216, 0.7412> } }
  scale 0.01
}

//---------------------------------------- The cut black hat top -----------------------------------------------------
#declare zHATCUTT = object {
  union { object { HATCUTT texture { pigment { Gray05 } finish { Glossy } } scale 0.01 }
          object { disc { <0.000, 0.097, 0.000> <0, 1,0> 0.02 } texture { pigment { Gray05 } finish { Glossy } } }  // Patch the hole....
  }
}

//---------------------------------------- The cut black hat bottom --------------------------------------------------
#declare zHATCUTB = object {
  HATCUTB
  texture { pigment { Gray05 } finish { Glossy } }
  scale 0.01
}

//---------------------------------------- The complete cut black hat with top part on side ----------------
#declare zHATCUT = object {
  union { object { zHATCUTT translate < 0.000,-0.0389,-0.060> rotate 90*x translate < 0.00, 0.00, 0.180> }
          object { zHATCUTB }
  }
}

//---------------------------------------- The complete black hat------------------------------------------------------
#declare zHAT = object {
  union { object { HAT texture { pigment { Gray05 } finish { Glossy } } scale 0.01 }
          object { disc { <0.000, 0.097, 0.000> <0, 1,0> 0.02 } texture { pigment { Gray05 } finish { Glossy } } }  // Patch the hole....
  }
}

//---------------------------------------- The complete black hat but upside down -------------------------------------
#declare zHAT_UP_DOWN = object {
  zHAT
  rotate 180*x
  translate < 0, 0.105, 0>
}

//---------------------------------------- The complete black hat but laying sideways ---------------------------------
#declare zHAT_SIDEWAYS = object {
  zHAT
  translate <-0.0890,-0.0100, 0.000>
  rotate    -107.7*z
}

//---------------------------------------- The howitzer barrel --------------------------------------------------------
#declare F_Gun = finish {
    ambient     0.40
    diffuse     0.30
    metallic
    brilliance  0.80
    specular    0.80
    roughness   0.10
    reflection  0.03
}

#declare T_Gun = texture {
    agate
    scale 0.8
    turbulence 0.5
    frequency 4
    texture_map {
      [0.0  pigment { color rgb 0.20 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [0.1  pigment { color rgb 0.22 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [0.3  pigment { color rgb 0.30 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [0.5  pigment { color rgb 0.26 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [0.7  pigment { color rgb 0.24 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [0.9  pigment { color rgb 0.21 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
      [1.0  pigment { color rgb 0.28 * <0.94, 0.73, 0.60> } finish { F_Gun } ]
    }
 }

#declare zBARREL = object {
  union {
   object { BARREL scale 0.01 }
   blob  {
         threshold 0.45      // 0.6
         cylinder { <-0.060,-0.050, 0.000>, < 0.060,-0.050, 0.000>, 0.100, 1.0 }  // Mush for the end of the barrel.
         cylinder { < 0.000,-0.200, 0.000>, < 0.000, 0.100, 0.000>, 0.035,-1.0 }  // Center bore
         cylinder { <-0.200,-0.070, 0.000>, < 0.000,-0.050, 0.000>, 0.050,-1.0 }  // flash bore left
         cylinder { <-0.000,-0.050, 0.000>, < 0.200,-0.070, 0.000>, 0.050,-1.0 }  // flash bore right
         sturm on
       }
  }
  texture { T_Gun scale 1.0 }
}


// zARM                  zARMHALF          zARM_SMALL zARM_SMLH
// LARGE_SP_BODY         SMALL_SP_BODY
// LARGE_SP_BODY_BOTTOM  LARGE_SP_BODY_TOP
// zFUZZBALL             zSPEAR            zSWRDHNDL  zHATBLUE   zHATCUTT   zHATCUTB   zHAT

//---------------------------------------- The sword ------------------------------------------------------------------
#declare SWORD = object {
  union {
     object { zSWRDHNDL }
     object { cone   { < 0.000, 0.075, 0.000>, 0.008 < 0.000, 0.550, 0.000>, 0.001 scale < 1, 1, 0.1>} texture { T_Chrome_5C } }     // blade
  }
}

#declare NOSE = object {
     object { cone   { < 0.000, 0.000, 0.000>, 0.008 < 0.000, 0.060, 0.000>, 0.0005 } texture { pigment { k_Red_Stage } } }
}

#declare NOSE_SIDEWAYS = object {
     object { cone   { < 0.000, 0.000, 0.000>, 0.009 < 0.000, 0.000, 0.060>, 0.0005 } texture { pigment { k_Red_Stage } } }
}


//---------------------------------------- SNOW_WOMAN1 ----------------------------------------------------------------
#declare SNOW_WOMAN1 = object {
  union {
     object { SMALL_SP_BODY }
     object { zHATBLUE     rotate    2*x translate < 0.0000, 0.5570, 0.0000> }
     object { zARM_SMLH    rotate -100*z translate < 0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  125*z translate <-0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate -100*z translate < 0.1627, 0.4052, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate <-0.1599, 0.3504, 0.0000> }
     object { sphere { < 0.0000, 0.5174,-0.0486> 0.006 scale < 1.0, 1.0, 1.0> } texture { pigment { k_Red_Stage } }                                                                       rotate -45*y }  // nose
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.5174, 0.000> rotate -45*y }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.5174, 0.000> rotate -45*y }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.006 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } }                 rotate -25.25*x translate < 0.000, 0.5174, 0.000> rotate -45*y }  // mouth
     object { SWORD        rotate -100*z translate < 0.2596, 0.3873,-0.0100> }
  }
}

//---------------------------------------- SNOW_WOMAN2 ----------------------------------------------------------------
#declare SNOW_WOMAN2 = object {
  union {
     object { SMALL_SP_BODY }
     object { zHATBLUE     rotate    2*x translate < 0.0000, 0.5570, 0.0000> }
     object { zARM_SMLH    rotate -125*z translate < 0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  125*z translate <-0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate < 0.1599, 0.3504, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate <-0.1599, 0.3504, 0.0000> }
     object { sphere { < 0.0000, 0.5174,-0.0486> 0.006 scale < 1.0, 1.0, 1.0> } texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.006 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } }                 rotate -25.25*x translate < 0.000, 0.5174, 0.000> }  // mouth
  }
}

//---------------------------------------- SNOW_WOMAN3 ----------------------------------------------------------------
#declare SNOW_WOMAN3 = object {
  union {
     object { SMALL_SP_BODY }
     object { zHATBLUE     rotate    2*x translate < 0.0000, 0.5570, 0.0000> }
     object { zARM_SMLH    rotate -145*z translate < 0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  125*z translate <-0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate -145*z translate < 0.1241, 0.3317, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate <-0.1599, 0.3504, 0.0000> }
     object { sphere { < 0.0000, 0.5174,-0.0486> 0.006 scale < 1.0, 1.0, 1.0> } texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.006 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } }                 rotate -25.25*x translate < 0.000, 0.5174, 0.000> }  // mouth

     object { zSPEAR translate <-0.160, 0.000,-0.140> }
  }
}

//---------------------------------------- SNOW_WOMAN4 ----------------------------------------------------------------
#declare SNOW_WOMAN4 = object {
  union {
     object { SMALL_SP_BODY }
     object { zHATBLUE     rotate    2*x translate < 0.0000, 0.5570, 0.0000> }
     object { zARM_SMLH    rotate -125*z translate < 0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate   25*z translate <-0.0768, 0.4119, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate < 0.1599, 0.3504, 0.0000> }
     object { zARM_SMLH    rotate  -35*z translate <-0.1318, 0.5161, 0.0000> }
     object { sphere { < 0.0000, 0.5174,-0.0486> 0.006 scale < 1.0, 1.0, 1.0> } texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.006 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } }                 rotate -25.25*x translate < 0.000, 0.5174, 0.000> }  // mouth

     object { zSPEAR translate < 0.160, 0.000,-0.140> }
  }
}

//---------------------------------------- SNOW_WOMAN5 ----------------------------------------------------------------
#declare SNOW_WOMAN5 = object {
  union {
     object { SMALL_SP_BODY }
     object { zHATBLUE     rotate    2*x translate < 0.0000, 0.5570, 0.0000> }
     object { zARM_SMLH    rotate -125*z translate < 0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  125*z translate <-0.0586, 0.4235, 0.0000> }
     object { zARM_SMLH    rotate  -90*x translate < 0.1599, 0.3504, 0.0000> }
     object { zARM_SMLH    rotate  -10*x translate <-0.1599, 0.3504, 0.0000> }
     object { sphere { < 0.0000, 0.5174,-0.0486> 0.006 scale < 1.0, 1.0, 1.0> } texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.008 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.5174, 0.000> }  // eye
     object { sphere { < 0.0000, 0.0000,-0.0486> 0.006 scale < 0.7, 0.7, 1.0> } texture { pigment { k_Blue_Charcoal } }                 rotate -25.25*x translate < 0.000, 0.5174, 0.000> }  // mouth

     object { SWORD        rotate -180*x translate < 0.160, 0.350,-0.140> }
  }
}

//---------------------------------------- SNOW_MAN1 ------------------------------------------------------------------
#declare SNOW_MAN1 = object {
  union {
     object { LARGE_SP_BODY }
     object { zHAT         rotate   5*x translate < 0.0000, 0.6500, 0.0000> }
     object { zARMHALF     rotate -60*z translate < 0.0972, 0.4458, 0.0000> }
     object { zARMHALF     rotate  60*z translate <-0.0972, 0.4458, 0.0000> }
     object { zARM         rotate -45*z translate < 0.1823, 0.4910, 0.0000> }
     object { zARM         rotate  45*z translate <-0.1823, 0.4910, 0.0000> }
     object { cone   { < 0.000, 0.600,-0.080>, 0.008 < 0.000, 0.600,-0.130>, 0.000 } texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <2,2,1> }                  texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.600, 0.000> }  // eye
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <2,2,1> }                  texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.600, 0.000> }  // eye
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <3,2,1> }                  texture { pigment { k_Blue_Charcoal } }                 rotate -27.25*x translate < 0.000, 0.600, 0.000> }  // mouth
  }
}

//---------------------------------------- SNOW_MAN2 ------------------------------------------------------------------
#declare SNOW_MAN2 = object {
  union {
     object { LARGE_SP_BODY }
     object { zHAT         rotate    15*z                translate <-0.0120, 0.6500, 0.0000> }
     object { zARMHALF     rotate  -105*z                translate < 0.0972, 0.4458,-0.0500> }
     object { zARMHALF     rotate   105*z                translate <-0.0972, 0.4458,-0.0500> }
     object { zARM         rotate   -90*z rotate   130*y translate < 0.1975, 0.4144,-0.0500> }
     object { zARM         rotate    90*z rotate  -120*y translate <-0.1975, 0.4144,-0.0500> }
     object { cone   { < 0.000, 0.600,-0.080>, 0.010 < 0.000, 0.600,-0.130>, 0.000 }  texture { pigment { k_Red_Stage } } }     // nose
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <2,0.6,1> rotate  39.79*z } texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -39.79*z translate < 0.000, 0.600, 0.000> }  // eye
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <2,0.6,1> rotate -39.79*z } texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate  39.79*z translate < 0.000, 0.600, 0.000> }  // eye
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <3,0.5,1> }                 texture { pigment { k_Blue_Charcoal } }                 rotate -27.25*x translate < 0.000, 0.600, 0.000> }  // mouth
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <1,0.8,1> }                 texture { pigment { k_Blue_Charcoal } } rotate  19.74*y rotate -27.25*x translate < 0.000, 0.600, 0.000> }  // mouth
     object { sphere { < 0.000, 0.000,-0.080> 0.008 scale <1,0.8,1> }                 texture { pigment { k_Blue_Charcoal } } rotate -19.74*y rotate -27.25*x translate < 0.000, 0.600, 0.000> }  // mouth

     object { zSPEAR translate < 0.00,-0.40, 0.00> rotate -90*x rotate  15*y translate <-0.0025, 0.4109,-0.1425> }

     object { SNOW_WOMAN2 rotate 40*y rotate -10*x translate < 0.3, 0.0, 0.4> }
  }
}

//---------------------------------------- SNOW_MAN3 ------------------------------------------------------------------
#declare SNOW_MAN3 = object {
  union {
     object { LARGE_SP_BODY_BOTTOM rotate -25*x rotate -20*z }
     object { LARGE_SP_BODY_TOP    rotate 132*z translate < 0.4000, 0.6000, 0.0000> }
     object { zHAT                 rotate  55*x translate < 0.1000, 0.6500, 0.0000> }

     object { zARMHALF     rotate -140*z                  translate < 0.1064, 0.4824, 0.0000> rotate -25*x rotate -20*z }
     object { zARMHALF     rotate  140*z                  translate <-0.1064, 0.4824, 0.0000> rotate -25*x rotate -20*z }
     object { zARM         rotate -140*z  rotate    20*y  translate < 0.1733, 0.3983, 0.0000> rotate -25*x rotate -20*z }
     object { zARM         rotate  140*z  rotate   -80*y  translate <-0.1733, 0.3983, 0.0000> rotate -25*x rotate -20*z }
     object { cone   { < 0.360, 0.300, 0.080>, 0.014 < 0.420, 0.400, 0.070>, 0.001 } texture { pigment { k_Red_Stage } } }     // nose

     object { SNOW_WOMAN1                          translate <-0.4, 0.0,-0.4> }
  }
}


