//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 3 materials and 33 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 08/31/2002    (31.08.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       1.8
    count            50
    distance_maximum 0.0
    error_bound      1.0
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    7
    recursion_limit  3   
    normal on
  }
}

background { color <0.545,0.612,0.886> }

camera {  //  Camera Camera01
  location  <      6.820,       2.940,       8.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     -3.613,       3.470,       6.080>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-6.583886, 0.137579, 105.925868>
}


//
// ********  MATERIALS  *******
//

#include "vor.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

prism { // TransSweep001
  linear_sweep
  cubic_spline
  -1.0,0.0
  21  // control points
  <-1.535527, -1.837552>,
  <-2.151787, -0.865113>,
  <-1.586854, 0.27543>,
  <-0.629108, 0.461268>,
  <0.842879, 0.50313>,
  <2.14241, 0.165884>,
  <3.106612, -0.241581>,
  <3.820814, 0.058529>,
  <4.002739, 0.712645>,
  <2.948357, 1.6641>,
  <-1.425665, 1.367762>,
  <-2.68675, -2.312927>,
  <1.420915, -3.438495>,
  <1.685, -2.631146>,
  <1.333729, -3.009899>,
  <0.61806, -2.849426>,
  <0.621071, -2.371678>,
  <-0.105117, -2.208369>,
  <-1.535527, -1.837552>,
  <-2.151787, -0.865113>,
  <-1.586854, 0.27543>
  rotate -x*90
  scale <15.0, 15.0, 60.0>
  rotate 99.649284*z
  translate  <-32.901537, -15.898088, -17.368096>
  material {
    Material2
    // Transform to world space
  }
}


sphere { // Sphere004
  <0,0,0>,1
  material {
    Brass_Metal
  }
  translate  <-5.205439, 1.098413, 4.993709>
}


union { // CSG001
  sphere { // Sphere001
    <0,0,0>,1
    scale <12.63015, 14.379131, 4.127659>
    rotate <-3.426197, -0.005041, 6.104891>
    translate  <-43.469446, -8.24741, 9.913561>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <13.707519, 9.867628, 3.998008>
    rotate <-1.272735, -0.829769, 67.401108>
    translate  <-43.286171, 10.913121, 7.299567>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <8.967565, 11.27729, 2.020056>
    rotate <7.610194, -0.928059, 5.754068>
    translate  <-38.154449, 25.475332, 9.913561>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale <6.415775, 14.444906, 11.152422>
    rotate <-3.41985, -0.108125, -1.489757>
    translate  <-43.835998, 2.675795, 3.350766>
  }
  material {
    Material2
  }
}


plane { // Plane002
  z,0
  material {
    Material2
  }
  translate  -19.131925*z
}


#declare Step8 = intersection {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
}
#declare Step9 = intersection {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
  translate  10.0*z
}
union { // Unit4
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    translate  <6.0, 6.0, 0.5>
  }
  object { Step8 }
  object { Step9 }
  material {
    Stucco
  }
  rotate 180.0*z
  translate  4.0*z
}


#declare Step6 = intersection {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
}
#declare Step7 = intersection {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
  translate  10.0*z
}
union { // Unit3
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    translate  <6.0, 6.0, 0.5>
  }
  object { Step6 }
  object { Step7 }
  material {
    Stucco
  }
  rotate 135.0*z
  translate  3.0*z
}


#declare Step4 = intersection {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
}
#declare Step5 = intersection {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
  translate  10.0*z
}
union { // Unit2
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    translate  <6.0, 6.0, 0.5>
  }
  object { Step4 }
  object { Step5 }
  material {
    Stucco
  }
  rotate 90.0*z
  translate  2.0*z
}


#declare Step2 = intersection {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
}
#declare Step3 = intersection {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
  translate  10.0*z
}
union { // Unit1
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    translate  <6.0, 6.0, 0.5>
  }
  object { Step2 }
  object { Step3 }
  material {
    Stucco
  }
  rotate 45.0*z
  translate  1.0*z
}


#declare Step = intersection {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
}
#declare Step1 = intersection {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 1.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 0.5>
    scale <5.0, 5.0, 1.0>
  }
  translate  10.0*z
}
union { // Unit
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    translate  <6.0, 6.0, 0.5>
  }
  object { Step }
  object { Step1 }
  material {
    Stucco
  }
}




