
// Glenn's POV-Ray Scene File - An Orange Among the Apples
// created 2-Aug-02
// last update 30-Aug-02
// copyright 2002 Glenn McCarter (glenn@mccarters.net)
//
// This scene uses RH coordinate system, but the camera coordinates
// are inverted, so +Y is into the scene, +X to the left, Z = up.


//===============================================
//             Scene Switches
//===============================================

#declare RenderAllFiles = 1; // this supresses local rendering of each inc file, leave at 1
#declare Radios = 2; // 0=off, 1=quick, 2=best radiosity
#declare FocalBlur = 0; // 0=off, 1=focal blur
#declare AreaSun = 1; // 0=normal light, 1=area light for the sun
                  
#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.1,0.1,0.1>
//	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
	noise_generator 2

#switch (Radios)
#case (1)

   // Radiosity section: uncomment this to enable radiosity calculations
// TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}



//===============================================
//             Variables
//===============================================

#declare TTH = 32; // Table Top Height


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "Apples.inc"
#include "Orange2.inc"
#include "Shack.inc"
#include "Workbench.inc"
#include "BushelBasket.inc"
#include "Peeler.inc"
#include "KitchenKnife.inc"

//#include "GRuler.inc" // for testing only

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <-4/3, 0.0,  0.0>  // aspect ratio, swapped L-R
//		right     <1.8, 0.0,  0.0>  // aspect ratio
		angle 40
//	location <-30,6*Feet-44,5+TTH> // tabletop level test
//	look_at <0,6*Feet,7+TTH>
	location <-30,6*Feet-44,9+TTH> // Render
	look_at <0,6*Feet,TTH+7.5>
#if (FocalBlur = 1)
	 // Focal Blur section: uncomment to enable focal blur
		blur_samples 100 // 100 is ok
		confidence 0.9   // this is a probability
		variance 1/1000  // 1/10000 is pretty good
		aperture 0.6    //lower value = wider range in focus, 10 is very blurry
		focal_point <0,0,1.3+TTH>
	 // end focal blur
#end
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <4/3,     0.0,  0.0>
		angle 40
	location <-30,6*Feet-44,12+TTH> // RENDER
	look_at <0,6*Feet,TTH+4>
		angle 40
	location <-30,6*Feet-44,5+TTH> // tabletop level
	look_at <0,6*Feet,7+TTH>
//		angle 60
//	location <-8*Feet,-12*Feet,12+TTH+4*Feet> // back up
//	look_at <0,0,TTH+1*Feet>
//		angle 80
//	location <-30,6*Feet-44,12+TTH> // back wall view
//	look_at <-8*Feet,6*Feet-44,TTH+2>
//		angle 50
//	location <-30,-66*Feet,5*Feet> // overall view
//	look_at <-8*Feet,6*Feet-44,TTH+2>
		angle 40
	location <50*Feet,-46*Feet,25*Feet> // outside sunlit wall
	look_at <-0*Feet,6*Feet-44,TTH+2>
	}


camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================


//===============================================
//             Lighting
//===============================================

#declare OverheadSpotLight =
	light_source { 
		<0*Feet,0*Feet,6.7*Feet> // test
		color rgb <0.820,0.863,0.761>*1.2
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <0,0,0>
		radius 15
		falloff 40
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<1,1,.1> } finish {ambient 20} } } }
	}
object { OverheadSpotLight translate <-1,9*Feet,0> } // render
//object { TestSphere scale 20 translate <-1, 5*Feet,TTH> }

//light_source{<-4*Feet,0*Feet,4.7*Feet> color rgb<1,1,1> } // for testing only

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.531>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*55 // towards right
  rotate z*-43 // towards rear
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.046, 0.045, 0.053> } // deep blue grey

sky_sphere { // sunny day
	pigment {
		gradient z
		color_map {
			[ 0.000 color rgb <0.900,0.908,0.936>*.99 ] // below ground level
			[ 0.070 color rgb <0.970,0.967,0.954>*.92 ] // horizon
			[ 0.170 color rgb <0.430,0.639,0.744>*.92 ] // cloud line
			[ 0.300 color rgb <0.106,0.308,0.612>*.92 ] // towards vertical
			[ 0.995 color rgb <0.006,0.208,0.512>*.92 ] // to vertical
			[ 1.000 color rgb <0.070,0.168,0.436>*.92 ] // at vertical
		}
		scale 2
		translate <0,0,-.5>
		turbulence 0.083
		omega 0.5		
		rotate y*-2
	}
}

#declare GroundPlane =
	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 12 }
object { GroundPlane }


#declare BackWall =
	box {
		<-30,0,0>,<0,40*Feet,20*Feet>
		texture {
			pigment { color rgb<.95,.95,1> }
			finish { ambient .006 diffuse 0.9 }
		}
	}
//object { BackWall translate <-30*Feet,0,0> }

#declare ImagePlane =
	box {
		<0,0,0>,<1,1,.001>
		texture {
			pigment {
//			color rgb<.2,1,.2>
				image_map { // projected from -Z, with top left at <0,1,0>
					jpeg "Backdrop3.jpg"
					once
				}
			}
			finish { ambient 0.8 }
		}
		scale <3*5*Feet,2*5*Feet,1>
		rotate x*90
	}
object { ImagePlane scale 1 rotate z*-20 translate <3*Feet,15*Feet,-1*Feet> }

//===============================================
//             Objects
//===============================================

#declare ShadeTree =
	box {
		<0,0,0>,<1,1,.001>
			pigment {
//			color rgb<.2,1,.2>
				image_map { // projected from -Z, with top left at <0,1,0>
					png "TreeMaple4S.png"
					once
				}
			}
		scale <4*2.4*Feet,4*6*Feet,1>
		rotate x*90
	}

//===============================================
//             Object Placement
//===============================================

#declare WorkbenchGroup =
	union {
object { Workbench rotate z*-90 translate <-8,48,TTH> }
object { BestOrange rotate x*16 translate <-1,1,0.0+TTH> }

// far group
object { GoodApple scale 1.06 rotate z*0 rotate <0,0,0> translate <11.0,21,TTH> }
object { BestAppleWithLeaf scale 0.98 rotate z*148 rotate <0,80,-68> translate <7.2,20.4,1.2+TTH> }
object { BestAppleStemless scale 0.95 rotate z*101 rotate <2.7,2.4,0> translate <13.2,17.6,0+TTH> }
object { BestAppleStemless scale 1.07 rotate z*62 rotate <-66,0,-10> translate <4.5,21.3,1.0+TTH> }
// middle group
object { GoodAppleWithLeaf scale 1.01 rotate z*0 rotate <0,0,27> translate <7.2,2,TTH> }
object { GoodApple scale 0.92 rotate z*80 rotate <0,0,217> translate <10.5,-0.3,TTH> }
// close group
object { BestApple scale 1.00 rotate z*-70 rotate <0,-70,0> translate <-2.5,-10.8,1.0+TTH> }
object { BestAppleStemless scale 0.96 rotate z*-160 rotate <-80,0,15> translate <4.3,-9.5,1.0+TTH> }

object { BushelBasket rotate z*0 translate <5.1,33,TTH+0.089> }

object { SphereApple scale 1.00 rotate z*0 rotate <0,0,0> translate <5.1,33,TTH+0.089> translate <0,0,0> }
object { SphereApple scale 1.06 rotate z*330 rotate <0,9,14> translate <5.1,33,TTH+0.089> translate <-1.6,-2.2,1.2> }
object { SphereApple scale 1.06 rotate z*120 rotate <0,90,50> translate <5.1,33,TTH+0.089> translate <-2,-1.7,0> }
object { SphereApple scale 1.16 rotate z*11 rotate <0,120,50> translate <5.1,33,TTH+0.089> translate <-3.4,2.2,0> }
object { SphereApple scale 0.96 rotate z*100 rotate <121,74,18> translate <5.1,33,TTH+0.089> translate <2.3,-1.3,1.6> }
object { SphereApple scale 0.92 rotate z*170 rotate <342,84,108> translate <5.1,33,TTH+0.089> translate <0.3,-2.3,3.2> }
object { SphereApple scale 1.11 rotate z*220 rotate <0,90,50> translate <5.1,33,TTH+0.089> translate <2.8,1.7,4.0> }
object { SphereApple scale 1.02 rotate z*20 rotate <0,90,30> translate <5.1,33,TTH+0.089> translate <-2.8,2.7,4.3> }

object { Peeler scale <1,-1,1> rotate z*0 translate <-9,23,TTH> }
object { KitchenKnife scale <1,1,1> rotate <180,-100,0> rotate <-2,0,-7> translate <-3,8.0,-0.5+TTH> } // stuck in table
	} // end union

object { Shack translate <30,-8*Feet,0> }
object { ShadeTree rotate z*-120 translate <16*Feet,4*Feet,0> }
object { WorkbenchGroup translate <0,5.3*Feet,0> }

