
// POV-Ray Object File - A BushelBasket
// created 15-Aug-02
// last update 30-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "BushelBasket.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// BushelBasketS // simple version
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Basket origin is at the center of the the base
// Height extends into +Z

#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare StaveTex =
	texture {
		pigment {
			wood // rings around Z-axis
			color_map {
				[ 0.0 color rgb <0.537,0.435,0.353>*0.8 ]
				[ 0.4 color rgb <0.537,0.435,0.353>*0.4 ]
				[ 0.5 color rgb <0.537,0.435,0.353>*0.6 ]
				[ 1.0 color rgb <0.537,0.435,0.353>*0.3 ]
			}
			turbulence 0.02
			scale 0.26

		}
		normal { bumps 0.031 scale <.35,.31,4> }
		finish { ambient 0.1 diffuse 0.996 specular 0.2 roughness 0.24 }
	}
#declare RingWireTex =
	texture {
		pigment { color rgb<.24,.21,.28>*.34 }
		finish { specular 0.6 roughness .08 }
	}
#declare RivetTex =
	texture {
		pigment { color rgb<.24,.21,.18>*.14 }
		finish { specular 0.2 roughness .018 }
	}

#declare DirtSpot =
	cylinder {
		<0,0,0>,<0.001,0,0>,1
		texture {
			pigment {
			spherical
				color_map {
					[ 0.0 color rgbt<0.314,0.208,0.137,1> ]
					[ 1.0 color rgbt<0.314,0.208,0.137,0.3> ]
				}
			}
		}
	}

//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare BushelBasketS =
	#local Staves = 0;
	#local MaxStaves = 20;
	union {
		cylinder { // base
			<0,0,0>,<0,0,0.15>,4
		}
		torus {
			5.30,.1
			rotate x*90
			translate <0,0,6>
		}
		torus {
			6.58,.1
			rotate x*90
			translate <0,0,12>
		}
	#while ( Staves < MaxStaves )
		box {
			<0,-0.5,0>,<.1,0.5,16>
			rotate y*12
			translate <4,0,0>
			rotate z*(360/MaxStaves)*Staves
		}
		#local Staves = Staves + 1;
	#end
	texture {
		pigment { color rgb <0.537,0.435,0.353> }
	}
	} // end union


#declare WireHandle =
	#local WR = 0.08; // wire radius
	sphere_sweep {
		b_spline
		8,
		<0,0,-0.5>,WR,
		<0,0,0>,WR,
		<0,0,1>,WR,
		<.3,0,1.3>,WR,
		<3-.3,0,1.3>,WR,
		<3,0,1>,WR,
		<3,0,0>,WR,
		<3,0,-0.5>,WR
		texture {
			pigment { color rgb<.24,.21,.28> }
			finish { specular 0.8 roughness .02 }
		}
		translate <-3/2,0,0>
	}

#declare Staple =
	union {
		torus { .2,.05 rotate z*90 }
		cylinder { <0,0,0>,<0,0.15,0>,0.05 }
		cylinder { <0,0,0>,<0,0.15,0>,0.05 }
		object { DirtSpot rotate z*90 scale <.31,.31,.81> rotate x*15 translate <0,-0.05,-0.1> }
		texture { RingWireTex }
	}
#declare BushelBasket =
	union {
		cylinder { // base
			<0,0,0>,<0,0,0.15>,4
		}
		torus { // wire band
			5.45,0.1
			rotate x*90
			translate <0,0,6>
			texture { RingWireTex }
		}
		torus { // wire band
			6.73,0.1
			rotate x*90
			translate <0,0,12>
			texture { RingWireTex }
		}
	#local Staves = 0;
	#local MaxStaves = 20;
	#local RS = seed(30598); // random seed
	#while ( Staves < MaxStaves )
		box {
			<0,-0.5,0>,<.1,0.5,16>
			texture { StaveTex translate <0,0.1,-0.8> }
			rotate <rand(RS)*1,12,0>
			translate <4,0,rand(RS)*.2>
			rotate z*(360/MaxStaves)*Staves
		}
		object { Staple translate <0,-5.45,6> rotate z*(360/MaxStaves)*Staves }
		object { Staple translate <0,-6.73,12> rotate z*(360/MaxStaves)*Staves }
		object { DirtSpot scale <.42,.52,.72> rotate <0,-12,90> translate <0,-7.2,14.5> rotate z*(360/MaxStaves)*Staves }
		sphere { <0,0,0>,0.1 scale <1,.27,1> translate <0,-4.55,0.6> rotate z*(360/MaxStaves)*Staves texture { RivetTex } }
		object { DirtSpot scale <.2,.2,.4> rotate <0,-12,90> translate <0,-4.56,0.5> rotate z*(360/MaxStaves)*Staves }
		sphere { <0,0,0>,0.1 scale <1,.27,1> translate <0,-7.61,15.2> rotate z*(360/MaxStaves)*Staves texture { RivetTex } }
		object { DirtSpot scale <.2,.2,.4> rotate <0,-12,90> translate <0,-7.61,15.1> rotate z*(360/MaxStaves)*Staves }
		#local Staves = Staves + 1;
	#end
	difference {
		cone { // outside
			<0,0,0>,4.42
			<0,0,1>,4.57
		}
		cone { // inside
			<0,0,-0.01>,4.42-0.15
			<0,0,1.01>,4.57-0.15
		}
		rotate x*0.27 // tilt it a bit
		texture { StaveTex rotate <0,90,0> }
	} // end difference
	difference {
		cone { // outside
			<0,0,14.7>,7.50
			<0,0,15.7>,7.68
		}
		cone { // inside
			<0,0,14.7-0.01>,7.50-0.15
			<0,0,15.7+0.01>,7.68-0.15
		}
		texture { StaveTex rotate <0,90,-20> }
	} // end difference
	object { WireHandle rotate x*5 translate <0,-7.5,15.7> rotate z*30 }
	object { WireHandle rotate x*-5 translate <0, 7.5,15.7> rotate z*30 }
	texture {
		pigment { color rgb <0.537,0.435,0.353> }

	}
	} // end union


//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 25
		location  <1, -4*Feet, 2.5*Feet> // overall
		look_at <0*Feet,0,8>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { BushelBasket scale 1 rotate x*0 translate <0,0,9> }


#end
