
// POV-Ray Object File - A Shack
// created 10-Aug-02
// last update 30-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Shack.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// ShackS // simple version
// Shack  // detailed version
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Shack origin is at the southeast corner floor


#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================


#declare ConcreteTex =
	texture {
//		pigment { color rgb <0.729,0.675,0.663> } // concrete grey
		pigment { color rgb <0.271,0.224,0.149> } // test dark brown
		normal { bumps .08 scale .10}
//		finish { specular .38 roughness .05 reflection 0.02 }
		finish { specular .08 roughness .15 }
	}

#declare CeilingTex =
	texture {
		pigment { color rgb <0.537,0.314,0.129> } // brown
		normal { bumps .08 scale .10}
//		finish { specular .38 roughness .05 reflection 0.02 }
		finish { specular .08 roughness .15 }
	}

#declare StudTex =
	texture {
		pigment {
			wood // rings centered around z-axis
			color_map {
				[ 0.0 color rgb <0.439,0.294,0.176>*0.8 ]
				[ 0.4 color rgb <0.439,0.294,0.176>*0.5 ]
				[ 0.5 color rgb <0.439,0.294,0.176>*0.4 ]
				[ 1.0 color rgb <0.439,0.294,0.176>*0.7 ]
			}
			turbulence 0.024
		}
//		normal { bumps 0.1 scale <1,12,1> }
		finish { specular 0.2 roughness 0.24 }
	}
#declare SlatTex =
	texture {
		pigment {
			wood // rings centered around z-axis
			color_map {
				[ 0.0 color rgb <0.439,0.294,0.176>*0.8 ]
				[ 0.4 color rgb <0.439,0.294,0.176>*0.5 ]
				[ 0.5 color rgb <0.439,0.294,0.176>*0.4 ]
				[ 1.0 color rgb <0.439,0.294,0.176>*0.7 ]
			}
			turbulence 0.024
			warp {
				black_hole <0,0,-15*Feet>,2 strength 1 falloff 1.3
//				repeat <17.2,12,12>
			}
			rotate x*90
		}
//		normal { bumps 0.1 scale <1,12,1> }
		finish { specular 0.2 roughness 0.24 }

	}

#declare BrickWallTex =
	texture {
		pigment {
			brick
				color rgb <0.812,0.776,0.718> // morter
				color rgb <0.553,0.204,0.180> // brick
				brick_size <8,3,4.5>
				mortar 0.4
				rotate x*90
		}
//		normal { bumps 0.1 scale 3}
		normal {
			brick .05
			brick_size <8,3,4.5>
			mortar 0.4
			rotate x*90
		}

		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}


#declare WindowFrameTex =
	texture {
		pigment {
			color rgb <0.963,0.988,0.959>*1.0
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.6 roughness 0.05 }
	}

#declare WindowGlassInt =
	interior { ior 1.45 }
#declare WindowGlassSTex = // simple version, no reflection
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 }
	}
#declare WindowGlassSMat =
	material {
		texture { WindowGlassSTex }
		interior { WindowGlassInt }
	}
#declare WindowGlassTex = // better version
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 reflection 0.17 }
	}
#declare WindowGlassMat =
	material {
		texture { WindowGlassTex }
		interior { WindowGlassInt }
	}
#declare ClearGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbt <0.90,0.96,0.92,0.96>
		}
		normal { bumps 0.015 scale 16 }
		finish { ambient 0.1 diffuse 0.1 specular 0.999 roughness 0.00001 reflection 0.03 }
	}
#declare ClearGlassMat =
	material {
		texture { ClearGlassTex }
		interior { WindowGlassInt }
	}


//===============================================
//             Macros
//===============================================

#macro TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)
// Window is in XZ plane, with glass centered on Y=0
	#local BT = BarThickness;
#switch ( Quality )
#case ( false ) // use low quality: single pane of glass
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference

		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end

		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
/*
		box { // glass
			<0,-0.065,0>,<Xlength,0.065,Zheight>
			material { WindowGlassSMat }
		}
*/
		texture { WindowFrameTex }
	} // end union
#break
#else // use individual panes of glass, good quality
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference

		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end
		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
		#local Hglass = 0;
		#while ( Hglass < Xpanes )
			#local Vglass = 0;
			#while ( Vglass < Zpanes )
				box {
					<0,-0.065,0>,<Xlength/Xpanes,0.065,Zheight/Zpanes>
					material { WindowGlassMat translate <rand(RS)*30*Feet,0,rand(RS)*30*Feet> }
					translate <Hglass*Xlength/Xpanes,0,Vglass*Zheight/Zpanes>
				}
				#local Vglass = Vglass + 1;
			#end
			#local Hglass = Hglass + 1;
		#end
/*
		box { // glass
			<0,-0.065,0>,<Xlength,0.065,Zheight>
			material { WindowGlassMat }
		}
*/
		texture { WindowFrameTex }
	} // end union
#end
#end
//object { TiledWindow(58,36,6,3,0.55) translate <12*Feet,20*Feet,42> } // test

#macro WindowFrame(Xlength,Zheight,SillThickness)
// Note: the frame is OUTSIDE the given dimensions!
	union {
		#local ST = SillThickness;
		box { <-0.75,-ST/2,0>,<0,ST/2,Zheight> } // left
		box { <Xlength,-ST/2,0>,<Xlength+0.75,ST/2,Zheight> } // right
		box { <-0.75,-ST/2-1.5,-0.75>,<Xlength+0.75,ST/2,0> } // sill
		box { <-0.75,-ST/2,Zheight>,<Xlength+0.75,ST/2,Zheight+0.75> } // top
		texture { WindowFrameTex }
	} // end union
#end
//===============================================
//             Objects
//===============================================

// Shack origin is inside South end of East wall, on top of concrete floor
// East is +X, North is +Y, sky is +Z

#declare EastWallS =
	difference {
		box { // main wall
			<0,0,0>,<8,20*Feet,10*Feet>
		}
		box { // window cutout
			<-1,0,0>,<10,48,48>
			translate <0,10*Feet,40>
		}
		texture { ConcreteTex }
	} // end difference

#declare SlatShape =
	union {
		box { <0,0,0.25>,<0.5,20*Feet,6-0.25> }
		cylinder { <0.25,0,0.25>,<0.25,20*Feet,0.25>,0.25 }
		cylinder { <0.25,0,6-0.25>,<0.25,20*Feet,6-0.25>,0.25 }
	} // end union
#local RS = seed(23079);
#declare SlatGroup =
	difference {
		union {
			#local SlatC = 0;
			#while ( SlatC < 20 )
				object {
					SlatShape
					translate <4,0,6.5*SlatC>
					texture { SlatTex rotate <0,0,-2+rand(RS)*2> translate <4,0,3+6.5*SlatC> }
				}
				#local SlatC = SlatC + 1;
			#end
		} // end union
		cylinder { <0,0,0>,<6,0,0>,0.66 scale <1,1,.81> rotate <0,-2,18> translate <0,15*Feet,42> texture { StudTex } } // knothole
		cylinder { <0,0,0>,<6,0,0>,0.38 rotate <0,6,14> translate <0,17.6*Feet,62> texture { StudTex } } // knothole
		height_field { // extruded into +Y
			png "CrackHF.png"
			scale <55,-8,-5>
			rotate z*-90
			texture { pigment { rgb<1,1,1>} finish {ambient 1}}
			translate <11,17.0*Feet,38>
		}
	} // end difference

#declare WBH = 36; // Window Bottom Height
#declare EastWall =
	#local RS = seed(17459);
	difference {
		union {
			object { SlatGroup }
			#local StudC = 0;
			#while ( StudC < 17 )
//				object { RoundedHalfBox2(4,2,10*Feet,.13)
// RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0>
				box	{
					<0,0,0>,<4,2,10*Feet>
					texture { StudTex rotate <-1+rand(RS)*2,-1*rand(RS)*2,0> translate <4,3,4*Feet> }
					translate <0,-8+16*StudC,0>
				}
				#local StudC = StudC + 1;
			#end
			box { // window sill cross stud
				<0,0,-2>,<4,48,0>
				texture { StudTex rotate x*90 }
				translate <0,10*Feet,WBH>
			}
		} // end union
		box { // window cutout
			<-1,0,0>,<10,48,48>
			translate <0,10*Feet,WBH>
		}

		texture { ConcreteTex }
	} // end difference



#declare NorthWall =
	union {
		box {
			<0,0,0>,<20*Feet+8,8,10*Feet>
		}
		box { // support
			<0,0,0>,<18,8,10*Feet>
			translate <10*Feet,-8,0>
		}
	texture { ConcreteTex }
	} // end union

#declare NorthBrickWall =
	union {
//		difference {
			height_field { // starts extruded into +Y
				png "BrickHF2.png"
				water_level .01
				scale <1,-1,1> // extrude into -Y
				scale <40*Feet,1.6,40*Feet/1.3333> // scale it up
				translate <-9*Feet+1.2,1,-0.5> // set in shop, includes east outside wall
			}
//			plane { // cut off back side of height_field
//				-y,-6
//			}
//		} // end difference
//		texture { BrickWallTex }
				texture {
					pigment {
						image_map { // projected from -Z
							png "BrickColorMap2.png"
							once
						}
						rotate <90,0,0> // orient to wall
						scale <40*Feet,1,40*Feet/1.3333> // scale to wall
					}
					normal { granite 1 scale 1.1 }
					finish { ambient 0.1 crand 0.08 specular 0.08 roughness 0.012 }
					translate <-9*Feet+1.2,4,-0.5> // set in shop
				}

	} // end union


#declare SouthWall =
	object { NorthWall scale <1,-1,1> }

#declare WestWall =
	difference {
		box { // main wall
			<-8,0,0>,<0,20*Feet,10*Feet>
		}
		box { // window cutout
			<-10,0,0>,<1,48,48>
			translate <0,8*Feet,40>
		}
		box { // window cutout
			<-10,0,0>,<1,48,48>
			translate <0,14*Feet,40>
		}
		texture { ConcreteTex }
	} // end difference


#declare Floor =
	box {
		<-12,-12,-6>,<20*Feet+12,20*Feet+12,0>
		texture { ConcreteTex }
	}

#declare Pillar =
	box {
		<-4,-4,0>,<4,4,10*Feet>
		texture { ConcreteTex }
	}

#declare Ceiling =
	box {
		<0,0,0>,<20*Feet,20*Feet,8>
		translate <0,0,10*Feet-1>
		texture { CeilingTex }
	}

#declare ShackS =
	union {
		object { EastWallS }
		object { WestWall translate <-20*Feet,0,0> }
//		object { SouthWall translate <-20*Feet,0,0> }
		object { NorthWall translate <-20*Feet,20*Feet,0> }
		object { Floor translate <-20*Feet,0,0> }
		object { Ceiling translate <-20*Feet,0,10*Feet> }
		object { Pillar translate <-8*Feet,5*Feet,0> }
		object { Pillar translate <-8*Feet,10*Feet,0> }
		object { Pillar translate <-8*Feet,15*Feet,0> }
	} // end union



#declare Shack =
	union {
		object { EastWall }
		object { WestWall translate <-20*Feet,0,0> }
		object { SouthWall translate <-20*Feet,0,0> }
//		object { NorthWall translate <-20*Feet,20*Feet,0> }
		object { NorthBrickWall translate <-30*Feet,20*Feet,0> }
		object { Floor translate <-20*Feet,0,0> }
		object { Ceiling translate <-20*Feet,0,0> }
		object { Pillar translate <-8*Feet,5*Feet,0> }
		object { Pillar translate <-8*Feet,10*Feet,0> }
		object { Pillar translate <-8*Feet,15*Feet,0> }
		object { TiledWindow(48,48,4,4,0.4,0) rotate z*-90 translate <4,14*Feet,WBH> }
//#macro TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)
// Window is in XZ plane, with glass centered on Y=0
		object { WindowFrame(48,48,4) rotate z*-90 translate <4,14*Feet,WBH> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 35
		location  <1, -64*Feet, 41*Feet>
		look_at <-10*Feet,10*Feet,5*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

//object { SApple1 rotate x*90 translate <0,0,0> }
object { Shack scale 1 rotate x*0 translate <0,0,0> }


#end
