
// POV-Ray Object File - A Workbench
// created 11-Aug-02
// last update 17-Aug-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Workbench.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// WorkbenchS // simple version
// Workbench  // detailed version
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// See below for object orientation

#ifndef (RenderAllFiles)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WTopTex =
	texture {
		pigment {
			wood
			color_map {
/*
				[ 0.0 color rgb <0.637,0.382,0.241>*0.70 ] // deeper brownish-grey color
				[ 0.4 color rgb <0.637,0.382,0.241>*0.48 ]
				[ 0.5 color rgb <0.637,0.382,0.241>*0.56 ]
				[ 1.0 color rgb <0.637,0.382,0.241>*0.33 ]
*/
				[  0*0.07 color rgb <0.637,0.382,0.241>*0.70*1.00 ] // deeper brownish-grey color
				[  1*0.07 color rgb <0.637,0.382,0.241>*0.48*1.00 ]
				[  2*0.07 color rgb <0.637,0.382,0.241>*0.56*1.00 ]
				[  3*0.07 color rgb <0.637,0.382,0.241>*0.33*1.05 ]
				[  4*0.07 color rgb <0.637,0.382,0.241>*0.70*1.10 ] // deeper brownish-grey color
				[  5*0.07 color rgb <0.637,0.382,0.241>*0.48*1.15 ]
				[  6*0.07 color rgb <0.637,0.382,0.241>*0.56*1.20 ]
				[  7*0.07 color rgb <0.637,0.382,0.241>*0.33*1.25 ]
				[  8*0.07 color rgb <0.637,0.382,0.241>*0.70*1.20 ] // deeper brownish-grey color
				[  9*0.07 color rgb <0.637,0.382,0.241>*0.48*1.15 ]
				[ 10*0.07 color rgb <0.637,0.382,0.241>*0.56*1.10 ]
				[ 11*0.07 color rgb <0.637,0.382,0.241>*0.33*1.05 ]
				[ 12*0.07 color rgb <0.637,0.382,0.241>*0.70*1.00 ] // deeper brownish-grey color
				[ 13*0.07 color rgb <0.637,0.382,0.241>*0.48*1.00 ]
				[ 14*0.07 color rgb <0.637,0.382,0.241>*0.56*1.00 ]
				[ 15*0.07 color rgb <0.637,0.382,0.241>*0.33*1.00 ]
			}
			rotate y*90 // follow main table axis
			turbulence 0.008 octaves 3 lambda 0.1 omega 0.02 // good gentle movement

			warp {
				turbulence 0.03 octaves 6 lambda 2.8 omega 0.75
			}

			warp {
				black_hole <6/3,2/3,2/3>,2/3 strength -1 falloff 1.3
				repeat <17.2/3,12/3,12/3> // turbulence <6,1,.1>
			}

		scale 3
		}
//		normal { bumps 0.91 scale <.1,12,.1> } // test
/*
		normal {
			wood 0.9
			rotate y*90 // follow main table axis
			turbulence 0.02
		}
*/
		finish { ambient 0.1 diffuse 0.996 specular 0.2 roughness 0.24 }
	}

#declare WDrawerTex =
	texture {
		pigment {
			wood
			color_map {
				[ 0.0 color rgb <0.637,0.382,0.241>*0.60 ] // deeper brownish-grey color
				[ 0.4 color rgb <0.637,0.382,0.241>*0.48 ]
				[ 0.5 color rgb <0.637,0.382,0.241>*0.56 ]
				[ 1.0 color rgb <0.637,0.382,0.241>*0.40 ]
			}
			rotate y*90 // follow main table axis
			turbulence 0.008 octaves 3 lambda 0.1 omega 0.02 // good gentle movement
		}
		finish { ambient 0.1 diffuse 0.996 specular 0.2 roughness 0.24 }
	}

/*
#declare WTopDirtTex = // this is a test
	texture {
		image_pattern{png "WD.png"} // black and white map (white = opaque)
		texture_map{
			[0 pigment{color rgbt<1,1,1,1>}finish{ambient 0 diffuse 0}]
			[1 pigment{ image_map{png "WDcolor.png" interpolate 2}} // color map
        finish{ambient 0 diffuse 0.5 specular 1 roughness 0.001}
			]
		}
	}
*/
#declare WTopDirtTex = // this is a test
texture {
//   image_pattern { png "WD.png" use_alpha }
   image_pattern { png "WD.png" }
   texture_map {
     [0 pigment { color rgb<.8,.5,.2> } ]
     [1 pigment { transmit 1 } ]
   }
 }


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

// WorkbenchS origin is at corner of tabletop closest to camera,
// which is the right front corner if you are standing in front of it.
// Short dimension extends into +X, long into +Y, sky is +Z

#declare WorkbenchS =
	box { // top
		<0,0,-1.5>,<28,72,0>
		texture {
			pigment {
				wood
				color_map {
					[ 0.0 color rgb <0.671,0.365,0.176> ]
					[ 0.4 color rgb <0.345,0.133,0.090> ]
					[ 0.5 color rgb <0.608,0.537,0.482> ]
					[ 1.0 color rgb <0.608,0.376,0.188> ]
				}
				rotate x*90 // follow main table axis
				turbulence 0.08
			}
			normal { bumps 0.1 scale <1,12,1> }
			finish { specular 0.2 roughness 0.24 }
		}
	}

// Workbench origin is at left front corner of tabletop
// Long dimension extends into +X, short into +Y, top at Z=0

#declare Workbench =
	union {
		object { RoundedHalfBox2(72,6.5,1.75,.15)
			texture { WTopTex rotate <0,1.7,-1.1> translate <0,3,6.7> }
//			texture { WTopDirtTex scale <72,25.2,1> translate <0,0,0> }
			translate <0,0,-1.75> }
		object { RoundedHalfBox2(72,6.5,1.75,.15)
			texture { WTopTex rotate y*-0.3 translate <404,0,0.3> }
//			texture { WTopDirtTex scale <72,25.2,1> translate <0,-6.5,0> }
			translate <0,6.5,-1.75> }
		object { RoundedHalfBox2(72,6.5,1.75,.15)
			texture { WTopTex rotate y*-2.2 translate <224,0,0.7> }
//			texture { WTopDirtTex scale <72,25.2,1> translate <0,-13,0> }
			translate <0,13,-1.75> }
		object { RoundedHalfBox2(72,6.5,1.75,.15)
			texture { WTopTex rotate y*0.9 translate <88,0,1.0> }
//			texture { WTopDirtTex scale <72,25.2,1> translate <0,-19.5,0> }
			translate <0,19.5,-1.75> }
		object { // front panel
			RoundedBox2(72-2,1,6,.15)
			texture { WTopTex rotate <0,0.6,7.0> scale <1,1,.3> translate <143,9,1.8> }
			translate <1,1.5,-1.75-5.75> }
		object { // drawer
			RoundedBox2(16,.375,4,.12)
			texture { WDrawerTex scale 0.7 translate <12,6,8> }
			translate <72/2-16/2,1.1,-1.75-4.5> }
		cylinder { // knob
			<0,0,0>,<0,1,0>,0.2
			texture { WTopTex scale 0.1 }
			translate <72/2,1.1-0.5,-1.75-4.5/2> }
		sphere { // knob
			<0,0,0>,0.6
			scale <1,.25,1>
			texture { WTopTex scale 0.1 }
			translate <72/2,1.1-0.5,-1.75-4.5/2> }
		object { // left front leg
			RoundedHalfBox2(3.6,3.6,32,.25)
			texture { WTopTex rotate y*90 }
			translate <-3.6/2+2.8,-3.6/2+2.8,-1.75-32>
		}
		object { // right front leg
			RoundedHalfBox2(3.6,3.6,32,.25)
			texture { WTopTex rotate y*90 rotate <1,0.5,0> translate <2.0,1.7,0> }
			translate <-3.6/2+72-2.8,-3.6/2+2.8,-1.75-32>
		}
	} // end union

//===============================================
//             For Testing Only
//===============================================

#ifndef (RenderAllFiles)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 25
		location  <1, -6*Feet, 7.5*Feet> // overall
		look_at <0*Feet,1*Feet,32>
//		location  <1, -3*Feet, 5.5*Feet> // drawer area
//		look_at <0*Feet,0*Feet,32>
		angle 45 // render view
		location  <-45, -1*Feet, 38> // drawer area
		look_at <0*Feet,8,32>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { Workbench scale 1 rotate x*0 translate <-72/2,0,32> }


#end
