//1:30



#include "colors.inc"

camera {
  location -69*y
  look_at <-10,-70,10>
}

sky_sphere { // les etoiles
  pigment {
    bumps
    turbulence 5
    scale .002 
    color_map {
      [ .0 .01 color White color White ]
      [ .015  1 color Black color Black ]
    } 
  }
}


fog { //de la brume au dessus du lac
  distance 10
  fog_type 2
  fog_offset -70
  fog_alt 1 
  color rgbt <.9, .9, 1, 0>
  turbulence .5
}


height_field {
  tga "height_field.tga"
  smooth
  water_level .15
  translate -0.5
  scale <640,200,480>
  pigment {
    color rgb <.9,.7,1>
  }
  normal {
    bumps .2
    scale .5
  }    
  finish {
    ambient .1
    diffuse .1
  }

}



plane { // le lac
  y, -70
  pigment {
    color Black
  }
  normal {
    ripples .1
    frequency 10
    scale <20,10,20>
    translate <-10,-70,10>
  }
  finish {
    ambient .2
    reflection .5
  }
} 

#declare Tex_Tuyau = 
  texture {
    pigment {
      color rgb <.5,.5,1> 
    }
  } // texture
  texture {
    pigment {
      gradient y //le dessus est gele
      turbulence .1
      color_map {
        [ 0 color White  ]
        [ .4 color White ]
        [ .6 color transmit 1 ]
        [  1 color transmit 1 ]
      }
      scale 4.1
      translate 4*y
    } //pigment
    normal {
      bumps .5
      scale .1 //un aspect granuleux
    } //normal
    finish {
      ambient .7
      reflection .1
    }
  }

#declare Tuyau  = // un gros tuyau surtant du methane
  merge {
    difference { // 1/4 de tore
      torus {
        2, .5
        rotate 90*z // on le met a la verticale
      }
      box {
        <-5,-5,0>,<5,5,10>
      }
      box {
        <-5,0,-5>,<5,-10,5>
      }
    } // difference
    cylinder { // a l'air libre 
      <0,2,0>,<0,2,50>, .5
    }
    cylinder { //plonge dans le sol
      <0,0,-2>,<0,-10,-2>, .5
    }
  } // merge
  
#declare Support =
union { 
  prism {
    linear_sweep
    linear_spline
    0, .5, 13, 
    <-4,0>, <4,0>, <0,4>, <-4,0>, // triangle de base
    <-1,1.5>, <1,1.5>, <0,3>, <-1,1.5>,  // un trou
    <-3,0>, <3,0>, <1.5,1>, <-1.5,1>, <-3,0> // un autre trou
    scale 0.5
  }
  difference { // le joint entre deux tuyaux
    cylinder {
      <0,0.15,2>, <0,0.35,2>, .7
    }
    cylinder {
      <0,0.23,2>, <0,0.27,2>, .8
    }
  } //difference
  rotate -90*x
} //union
  
merge {
  object { 
    Tuyau
  }
  union {
    #declare I = 0 ;
      #while ( I < 10 )
        object { 
          Support 
          translate (I*5+2)*z
        } 
      #declare I = I + 1 ;
    #end
    #undef I
  } // union
  texture {
    Tex_Tuyau
  }
  translate <-10,-70,10>
} // merge
