// irtc 08/2002

#declare Xmin=-600;
#declare Xmax= 600;
#declare Ymax=400;
#declare Ys=100;
#declare Zmin=-1500;
#declare Zmax=200;

#declare Nb1a=5;
#declare Nb2a=4;

#declare Mike=on;

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 300;
#declare Rad_error = .1;
#declare Rad_rec = 1;
#declare Rad_bright = 1.6;
#declare Rad_bo = 1/128;

#if (Use_rad)
#default { texture { finish { ambient 0.0 diffuse 1.0 } } }
#else
//#default { texture { finish { ambient 0.3 diffuse 0.8 } } }
#end

global_settings {
	max_trace_level 20
	adc_bailout 1/128
#if (Use_rad)
//	ini_option "+QR"
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .01

		always_sample off
//		samples{quality 6 area_light off normal off}

		low_error_factor .5
		gray_threshold 0.1
		minimum_reuse 0.015
		normal on
		media on

		max_sample 2
		adc_bailout Rad_bo
	}
#end
}




// camera
camera {
  ultra_wide_angle
  location <Xmax-1, 150, -400>
  look_at  <Xmin, 150, 100>
  right x*image_width/image_height
  angle 80
}


// spots


light_source {
  < 300, Ymax-20,-350>
  color rgb <1,.9,.4>*1.4
  spotlight
  point_at <0, Ys+100, Zmax-100>
  radius 10
  tightness 50
  falloff 15
}
light_source {
  <-300, Ymax-50,-350>
  color rgb <.6,.7,1>*1.4
  spotlight
  point_at <0, Ys+100, Zmax-100>
  radius 10
  tightness 50
  falloff 15
}

light_source{
	<Xmin/2, Ymax/2, Zmin+1>, rgb <1,.6.3>*.12
	area_light 50*x, 20*y, Nb1a,Nb2a
	jitter adaptive 1
}
light_source{
	<0, Ymax/2, Zmin+1>, rgb <1,.6.3>*.12
	area_light 50*x, 20*y, Nb1a,Nb2a
	jitter adaptive 1
}
light_source{
	<Xmax/2, Ymax/2, Zmin+1>, rgb <1,.6.3>*.12
	area_light 50*x, 20*y, Nb1a,Nb2a
	jitter adaptive 1
}


// sol
box{<Xmin, -1, Zmin>,<Xmax, 0, Zmax>
	pigment{rgb .4}
}
// plafond
/*
box{<Xmin, Ymax, Zmin>,<Xmax, Ymax+1, Zmax>
	pigment{rgb .4}
}
*/

#local Nbpx=3;
#local Lp=(0-Xmin)/Nbpx;
#local Ep=5;
#local Nbpz1=int(-Zmin*.7/Lp)+1;
#local Nbpz2=int( Zmax/Lp)+1;


#local Hfp1=height_field{
	png "plafond"
	smooth
	scale <.5,1,.5>
}


#local Hfp=union{
	object{Hfp1}
	object{Hfp1 scale <-1,1, 1> translate x}
	object{Hfp1 scale < 1,1,-1> translate z}
	object{Hfp1 scale <-1,1,-1> translate x+z}
	box{0,<1,.05,1>}
	scale <Lp,-Ep,Lp>
}

union{
#local i=0;
#while(i<Nbpz1)
	#local j=0;
	#while(j<Nbpx)
		object{Hfp translate <Xmin+j*Lp, Ymax, -Lp*(i+1)>}
		#local j=j+1;
	#end
	#local i=i+1;
#end
#local i=0;
#while(i<Nbpz2)
	#local j=0;
	#while(j<Nbpx)
		object{Hfp translate <Xmin+j*Lp, Ymax, Lp*i>}
		#local j=j+1;
	#end
	#local i=i+1;
#end
	box{<Xmin, Ymax, Zmin>,<Xmax, Ymax+1, Zmax>}
	texture{
		pigment{granite scale Lp*.1 color_map{[0 rgb .7][1 rgb 1]}}
		finish{brilliance .9 diffuse 1.2}
	}
}



//mur gauche
box{<Xmin-1, 0, Zmin>,<Xmin, Ymax, Zmax>
	texture{
		pigment{color rgb <0.573,0.169,0.125>}
		normal{wrinkles 0.9 sine_wave scale 1.5 turbulence .5}
		finish{brilliance 1.5}
	}
}
#include "divers.inc"
object{
	Frisouille((10+Zmax-Zmin),60)
	rotate -90*y
	translate <Xmin, Ymax, Zmin>
}

box{<Xmin-1,0, Zmin*.25-20>, <Xmin+10,Ymax, Zmin*.25+20>
	texture{
		pigment{color rgb .2}
		normal{wrinkles .2 scale 2}
		finish{brilliance 1.2 specular .3 roughness .1}
	}
}
box{<Xmin-1,0, Zmin*.50-20>, <Xmin+10,Ymax, Zmin*.50+20>
	texture{
		pigment{color rgb .2}
		normal{wrinkles .2 scale 2}
		finish{brilliance 1.2 specular .3 roughness .1}
	}
}
box{<Xmin-1,0, Zmin*.75-20>, <Xmin+10,Ymax, Zmin*.75+20>
	texture{
		pigment{color rgb .2}
		normal{wrinkles .2 scale 2}
		finish{brilliance 1.2 specular .3 roughness .1}
	}
}


//mur droite
box{<Xmax+1, 0, Zmin>,<Xmax, Ymax, Zmax>
	texture{
		pigment{color rgb <0.573,0.169,0.125>}
		normal{wrinkles .2 scale .1}
		finish{brilliance 1.2 specular .1 roughness .5}
	}
}

//scene
/*
box{<Xmin,0,0>,<Xmax,Ys,Zmax>
	pigment{rgb .4}
}
*/
#include "scene.inc"



// rideaux
#declare Haut=Ymax-Ys;
#declare Nbx=300;
#declare Larg=Zmax;

#declare Rideau = mesh {
	#include "rideau_s.msh"
	uv_mapping
	texture {
		pigment {color rgb <0.698,0.102,0.071>}
		normal{wrinkles .1 scale .001}
		finish{brilliance 1.1 phong .1 phong_size 2 metallic}
	}
	translate -350*y
	scale <1,Haut/(30*Larg/(Nbx-1)),1>
	translate 350*y
}

object{Rideau translate <4, Ys, Zmax>}
object{Rideau scale <-1,1,-1> translate <-6, Ys, Zmax>}

union{
	box{<Xmin,Ys,Zmax-10>,<Xmin+30,Ymax,Zmax-8>}
	box{<Xmax,Ys,Zmax-10>,<Xmax+30,Ymax,Zmax-8>}
	box{<Xmin,Ymax-30,Zmax-10>,<Xmax,Ymax,Zmax-8>}
	texture{
		pigment{color rgb <0.573,0.169,0.125>*.5}
		normal{wrinkles .2 scale .1}
		finish{brilliance 1.2 specular .1 roughness .5}
	}
}

/*
box{<Xmin, Ys, Zmax-10>, <Xmax, Ymax, Zmax>
	 pigment{color rgb <0.675,0.129,0.090>}
}
*/

// fauteuils
#include "fauteuil.inc"

#local StF=seed(1342*12);
#local i=-90;
#local dec=0;
#while(i>Zmin*.7)
	#local j=Xmin+120;
	#while(j<Xmax-120)
		object{Fauteuil rotate -y*90 translate <j+2*rand(StF)-1+dec*Flarg/2,2*rand(StF)-1,i+2*rand(StF)-1>}
		#local j=j+Flarg;
	#end
	#local dec=1-dec;
	#local i=i-90;
#end

// micro
#include "pied_de_micro.inc"

object{PiedMicro
	rotate -y*86
	translate <-20, Ys, Zmax*.3>
}
#undef PiedMicro 

// hp
#include "hp.inc"
object{HP
	rotate -20*y
	translate <Xmin+60, Ys, Zmax-70>
}
#undef HP


// mike
#if (Mike)
#include "artiste2.inc"
object{
	Artiste
	scale 165/OBJuvPOVmaxY
	translate <10, Ys, Zmax*.6>
}
#undef Artiste
#end
