
#version unofficial MegaPov 0.72;


#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht, loose)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = i*nlng/loose;
			#local tempy = haut - j*nlng;
			#local tempz = (-1+2*rand(st))*nlng*0.01;
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#fclose file
#end



/* write initial file */
#macro WriteInitialRideau(nbx, larg, haut, loose)

WriteClothFile("rideau.cth", nbx, 30, loose*larg/(nbx-1), 70, haut, loose)

	#fopen file "rideau.cth" append

	#local i=0;
	#while(i<nbx)
		#write(file, 0+30*i, ", 0.5, 0.0, 0.5,\n")
		#write(file, 1+30*i, ", 0.7, 0.1, 0.7,\n")
		#write(file, 2+30*i, ", 0.9, 0.2, 0.9,\n")
		#write(file, 3+30*i, ", 1.0, 0.4, 1.0,\n")
		#write(file, 4+30*i, ", 1.0, 0.8, 1.0,\n")
		#local i=i+1;
	#end

	#fclose file
#end


#declare Haut=350;
#declare Nbx=300;
#declare Larg=600;

WriteInitialRideau(Nbx, Larg, 350, 1.2)



simcloth {
	gravity     -0.1*y

	internal_collision off
	damping     0.80
	intervals   0.05
	iterations  1000

	input       "rideau.cth"
	output      "rideau.cth"
	mesh_output "rideau_s.msh"
	smooth_mesh on
	uv_mesh     on
}




#declare Rideau = mesh {
	#include "rideau_s.msh"
	uv_mapping
	texture {
		pigment {
			checker
			color rgb <1,.5, .2>, color rgb <.9, .85, .4>
		}
		scale <.1, .1, 1>
	}
	translate -350*y
	scale <1,Haut/(30*Larg/(Nbx-1)),1>
	translate 350*y
}

camera {location <300, 400, -800> angle 55 look_at 300*x+200*y }

light_source { <-10, 100, -100>*10, color rgb .5 shadowless }

light_source { <50, 150, -100>*30, color rgb 1.2
	spotlight
	radius 20
	falloff 30
	tightness 2
	point_at 30*y
}


object { Rideau }

