/* Storm skies ... dark thunder clouds */

fog {
color rgbt <.325,.325,.355,.2> distance 6000 //6000
}
         
#local AtmEndSphere = 
sphere {      
    <0,0,0>, 1.0
    hollow   
    no_shadow  
               
}

#local CloudStartSphere = 
sphere {
    <0,0,0>, 0.9982 //MAKING this closer to 1.0 (but not equal, thins the slice, making the clouds seem
                   //less intense also   
    hollow
    no_shadow
}               

#local SkySphere =
difference {
    object { AtmEndSphere }
    object { CloudStartSphere }
    hollow
    no_shadow
   
}


#declare BlackCloudDensity = 
density {
    granite
    turbulence 0.1
    color_map { 
        [ 0.05 rgb <0.00,0.00,0.00> ] //the higher the scalar here, the fewer clouds!
        [ 1.0 rgb  <0.4,0.4,0.4> ] /* the higher the rgb, the darker the effect. 
                                              (yes, higher, remember the negative emission
                                               value!) Too high loses definition of the 
                                               individual cloud shapes, although might be 
                                               useful in a black smoke-like effect. */
    }
    scale <2700,800/250,2200> //2500 750 2000
 }


object { 
    SkySphere 
    scale <10000,8500,10000>
    material {
        texture { 
            pigment {
                rgbt <1,1,1,1>
            }
        }
        interior { 
            media {
                emission -.15
                density {   
                    planar 
                    //eschew the temptation to use turbulence, even though this means the horizon line
                    //will be awfully straight. Turblence affects the density patterns as well as the
                    //density map. Too bad reset_children didn't make it past MegaPOV. :(
                    density_map {
                        [ 0 BlackCloudDensity ]
                        [ .55 BlackCloudDensity ] //.35
                        [ .75 color rgb .15 ] //adjust the horizon by altering the border between the two
                                            //density patterns. .6
                        [ 1 color rgb .15 ] 
                    }
                    scale <1.2,350,1.2>
                }   
                
           }
       }
    }
    rotate <-90,.5,10> scale 1.2
}


object { 
    SkySphere 
    scale <10000,8500,10000>*1.002 //this is a second layer of clouds to "patch in" behind the clear parts
    material {
        texture { 
            pigment {
                rgbt <1,1,1,1>
            }
        }
        interior { 
            media {
                emission -.15
                density {
                        granite
                        turbulence 0.15 lambda 1.5 omega .5 octaves 3
                        color_map {
                           [ 0.05 rgb <0.15,0.15,0.15> ] //the higher the scalar here, the fewer clouds!
                           [ 1.0 rgb <.41,.41,.41> ]
                        }
                        scale <2700,2900,950>//2500 2700 750
                        rotate <0,.5,40>
                }                            
            }    
           
        }
    }
}
