/*****************************************/
// POV-Ray Scene Description File
// Version     :  POV-Ray 3.5
// Title       :  Circles
// Author      :  Jonas Weigt
// Date        :  2002-08-11
// Finish Date :  2002-08-27
// Description :  A Mechwarrior discovering his own Mech's footsteps in the desert,
//                realizing in this moment that he is alone, having run in circles for hours,
//                hopelessly trapped in the vast and cruel sands and never again able to find
//                his home... Unless he repairs the battle-worn navigation system.
//
// Image HowTo :  I have been using POV-Ray since August the 9th 2002, being my first (serious)
//                attempt in Raytracing. Even though my skills are not yet adequate, I decided to
//                submit this as an entry for the IRTC. 
//                I had the base idea for the Mech a few days after beginning to learn POV-Ray,
//                though I had no knowledge of the IRTCs existence. Later, when I came to know
//                the Competition and the current topic, I decided to use the model for an entry.
//                After modelling the Mech object entirely from CSG, basically using simple
//                shapes like spheres, boxes, splines etc., I began working on the textures,
//                whereas I quickly came up with ideas on the background. I wanted the scene to
//                carry the topic, "loneliness", via different aspects of the picture. The aspect
//                ratio of 16:9 increases the feeling of a vast space, in which the Mechs pilot
//                would be hopelessly lost, namely the desert which I created via a height_field.
//                I wanted to increase the feeling of eerieness and strangeness by making the
//                desert, the fog and the lights rather unrealisticy bright and from a unusual
//                angle. I used media and normal ground fog for the glow, and a bright area_light
//                sun in front of the camera. Radiosity was also used.
// Thanks To   :  Many people in the povray.binaries.images newsgroup helped me during the
//                creation process on problems I encountered, and I want to express my thanks to
//                all of them.
//
// Filename    :  Circles.pov
// Files needed:  HF_Desert_FS.tga, HF_Desert.tga (Create these using HF_Desert_FS.pov and HF_Desert.pov)
// Command Line:  +FT +A0.0 +R3 +W1024 +H576
//
/*****************************************/


/*****************************************/
/* Standard includes */
#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "metals.inc"
/*****************************************/


/*****************************************/
/* Scene Object On/Off Switches */
#declare Mech   = 1;
#declare Desert = 1;
#declare Storm  = 1;
#declare Fog    = 1;
#declare Dust   = 1;
#declare Rad    = 1;
//#declare Sig    = 0;    (My signature bump_map is not included)
/*****************************************/


/*****************************************/
/* Global Settings */
global_settings { 
  #if ( Rad )
    radiosity {
      brightness .75
      recursion_limit 1
      max_sample .75
    }  
  #end
}
/*****************************************/


/*****************************************/
/* Background */
background { color White }
/*****************************************/
 

/*****************************************/
/* Cameras */
camera {                      /* Scene cam */
  location <40, -3, -20> 
  up <0,1,0> 
  right <1.77,0,0> 
  look_at <10, 6, 15> 
//  #if (Sig)                 /* Signature Bump Map */
//    normal {
//      bump_map {
//        tga "signature.tga" 
//        bump_size .25
//        once
//      }
//      scale .175
//      translate <.3,-.5,0>
//      }
//  #end
}     
/*****************************************/


/*****************************************/
/* Light Sources */
light_source {            /* Sun from up in front of the camera */
  <0, 50, 75> 
  color rgb <1, 1, 1> 
  area_light <5, 0, 0>, <0, 0, 5>, 5, 5
  adaptive 1
  jitter
}  
/*****************************************/


/*****************************************/
/* Terrain */
#declare Desert_HF = height_field {   /* Desert */
  tga "HF_Desert_FS.tga"
  smooth
  pigment { 
    color Wheat
  }
  translate <-.75, -.86, -.125>
  scale <200,50,200>
}
#if (Desert)
  height_field { Desert_HF translate y*.05}
#end
/*****************************************/


/*****************************************/
/* Low Altitude Sand Storm (Media) */
#declare Surface_Dust_HF = height_field {   
  tga "HF_Desert.tga"
  hollow
  pigment { 
    rgbt <1,1,1,1>
  }
  interior {    
    media {
      scattering {
        3,
        color rgb <0.0847059, 0.0847059, 0.074902>
        extinction .1
      }
      density {
        agate
        turbulence .9
        omega .5 
        octaves 5 
        lambda 3
        density_map {
          [ 0.00 color rgb < 0.00, 0.00, 0.00> ]
          [ 0.20 color rgb < 0.15, 0.15, 0.15> ]
          [ 0.40 color rgb < 0.00, 0.00, 0.00> ]
          [ 0.60 color rgb < 0.25, 0.25, 0.25> ]
          [ 0.80 color rgb < 0.50, 0.50, 0.50> ]   
          [ 1.00 color rgb < 0.75, 0.75, 0.75> ]
        }
      }                                  
      intervals 1
      samples 10,30
      scale .25
    }
  }
  translate <-.75, -.86, -.125>
  scale <200,50,200>
}
#if (Dust)
  height_field { Surface_Dust_HF translate y*3.5 }
#end
/*****************************************/


/*****************************************/
/* Thunderstorm Clouds */
#declare Storm_Clouds =  sphere {
  <0,0,0>,
  400 
  hollow
  pigment {
    color rgbt <0,0,0,1>
  }
  finish {
    ambient 0
    diffuse 0
  }
  interior {
    media {
    }
  }
}
#if (Storm)
  object { Storm_Clouds }
#end
/*****************************************/


/*****************************************/
/* Fog */
#declare Sand_Fog = fog {
  distance 45
  color rgbf<0.847059, 0.847059, 0.74902, 0.1>
  fog_type 2
  fog_offset 0
  fog_alt 1
  turbulence .9
  turb_depth .25
}
#if (Fog)
  fog { Sand_Fog }
#end
/*****************************************/  


/*****************************************/
/* Textures */
#declare Camou_Paint_001_Base = texture {   /* Camouflage Paint 1 Base  */
  pigment {
    cells
    turbulence 2
    color_map {
      [0.00 color Gray25]
      [0.25 color Khaki]
      [0.50 color Sienna]
      [0.75 color Wheat]
      [1.00 color Goldenrod]
    }
  }
  normal { 
    gradient x
    turbulence .5
    normal_map {
      [0.00 bumps .25 scale .25 ]
      [0.50 dents .25 scale .25 ]
      [1.00 bumps .25 scale .25 ]
    }
  }
  finish {
    ambient 0
    diffuse .4
    phong .125
  }
}
#declare Hull_Paint_001_Base = texture {   /* Hull Paint 1 Base  */
  pigment {
    color White
  }
  normal { 
    gradient x
    turbulence .5
    normal_map {
      [0.00 bumps .25 scale .125 ]
      [0.50 dents .50 scale .125 ]
      [1.00 bumps .25 scale .125 ]
    }
  }
  finish {
    ambient 0
    diffuse .6
    phong .25
  }
}
#declare Rocket_Paint = texture {      /* Rocket Paint */
  pigment {
    checker 
    color Red 
    color White
  }
  finish { 
    ambient 0 
    diffuse .4
    phong .25 
  }
}
#declare Weapon_Steel_001 = texture {   /* Weapon Steel 001 Gray Steel */
  pigment {
    color Gray25
  }
  finish { 
    ambient 0
    diffuse .8
    brilliance 6.0
    reflection 0.6
    phong 1
    phong_size 120
  }
  normal {
    bumps .1
    scale .25
  }
}
#declare Weapon_Steel_002 = texture {   /* Weapon Steel 002 Dark Gold*/
  pigment {
    color OldGold
  }
  finish {
    ambient 0
    diffuse .8
    brilliance 6.0
    reflection 0.6
    phong 1
    phong_size 120
  }
  normal {
    bumps .1
    scale .25
  }
}
#declare Rusty_Steel_001 = texture { /* Rust */
  pigment {
    granite
    color_map {
      [0.0 color Black]
      [0.8 color SemiSweetChoc]
      [1.0 color HuntersGreen]
    }
    frequency 10
  }
  finish {
    ambient 0
    diffuse .4
  }
  normal {
    dents .1
    scale .25
  }
}
#declare Rusty_Steel_002 = texture { /* Burn Stains */
  pigment {
    bozo
    turbulence 1
    color_map {
      [0.0 color rgbt <0.25,0.0,0.0,0.5> ]
      [1.0 color rgbt <0.0,0.0,0.0,0.5> ]
    }
    frequency 5
    scale .25
  }
  finish {
    ambient 0
    diffuse .4
  }
}
#declare Camou_Paint_001 = texture {  /* Camouflage Paint Final */
  bozo
  turbulence .25
  texture_map {
    [ 0.00  Rusty_Steel_001 ]
    [ 0.25  Rusty_Steel_002 ]
    [ 0.50  Camou_Paint_001_Base ]
    [ 1.00  Camou_Paint_001_Base ]
  }
} 
#declare Hull_Paint_001 = texture {  /* Hull Paint Final */
  bozo
  turbulence .25
  texture_map {
    [ 0.00  Rusty_Steel_001 ]
    [ 0.25  Rusty_Steel_002 ]
    [ 0.50  Hull_Paint_001_Base ]
    [ 1.00  Hull_Paint_001_Base ]
  }
} 
/****************************************/


/****************************************/
/* Torso */
#declare Point_0 = <0.00, 0.00>;  /* Spline 1 Control Points */
#declare Point_1 = <4.00, 0.00>;
#declare Point_2 = <4.00, 4.00>;
#declare Point_3 = <3.00, 6.00>;
#declare Point_4 = <2.00, 7.00>;
#declare Point_5 = <1.00, 7.50>;
#declare Point_6 = <0.00, 7.75>;
#declare Point_7 = <0.00, 0.00>;

#declare Point_0a = <0.00, 0.00>;  /* Spline 2 Contol Points */
#declare Point_1a = <3.00, 0.00>;
#declare Point_2a = <3.00, 4.00>;
#declare Point_3a = <2.50, 4.50>;
#declare Point_4a = <0.50, 6.00>;
#declare Point_5a = <0.00, 7.00>;

#declare Torso_Part_001 = union {   /* Torso Top Part 1 */
  difference {
    lathe {
      linear_spline /* Spline 1 */
      8,
      Point_0,
      Point_1,
      Point_2,
      Point_3,
      Point_4,
      Point_5,
      Point_6,
      Point_7
    }
    box {
      <0, -0.5, -4>
      <4, 10,  4>
    }
    rotate z*-90
  }
  difference {
    lathe {
      linear_spline /* Spline 2 */
      6,
      Point_0a,
      Point_1a,
      Point_2a,
      Point_3a,
      Point_4a,
      Point_5a
    }
    box {
      <0, -0.5, -4>
      <4, 10,  4>
      rotate y*180
    }
    rotate z*-90
    scale <1,0.75,1>
  }
  texture { Camou_Paint_001 }
}
#declare Torso_Part_001_cutout = difference {   /* Torso Front Part_001 - cutout for Cockpit/Side Rocket Pods */
  object {
    Torso_Part_001
  }
  merge {  
    box {
      <-3, 5, -5>,
      <-2, 7,  5>
      pigment {
        color Black
      }
    }
    merge {
      cylinder {
        <-1.5, 0, -2.75>,
        <-1.5,10, -2.75>,
        .15
      } 
      cylinder {
        <-1, 0, -3.00>,
        <-1,10, -3.00>,
        .15
      } 
      cylinder {
        <-0.5, 0, -3.125>,
        <-0.5,10, -3.125>,
        .15
      } 
      cylinder {
        <-1.5, 0, 2.75>,
        <-1.5,10, 2.75>,
        .15
      } 
      cylinder {
        <-1, 0, 3.00>,
        <-1,10, 3.00>,
        .15
      } 
      cylinder {
        <-0.5, 0, 3.125>,
        <-0.5,10, 3.125>,
        .15
      } 
      texture { Weapon_Steel_001 }
    }
    rotate z*-90
  }
}
#declare Torso_Part_002 = union {  /* Torso Bottom Part */
  merge {
    cylinder {
      <0,0,0>,
      <0,8,0>,
      1
    }
    sphere {
      <0,-0.25,0>,
      0.9
    }
    sphere {
      <0,8.25,0>,
      0.9
    }
  }
  merge {
    cylinder {
      <-2,2,0>,
      <-2,6,0>,
      1.5
    }
    sphere {
      <-2,1.5,0>,
      1.25
    }  
    sphere {
      <-2,6.5,0>,
      1.25
    }
    translate z*-1
    translate x*1
  }
  difference {         /* Torso Front Weapon Slot*/
    sphere {           
      <0.0, 4.0, 5.5>,
      1
    }  
    box {
      < -1, 3.8, 5.5>,
      <  0, 4.2, 6.5>
    }
  }
  rotate z*90
  rotate y*90
  translate x*1
  translate z*-4
  texture { Camou_Paint_001 }
}
#declare F_Torso_WH = intersection {  /* Torso Front Weapon Holder*/
  sphere {        
    <0.0, 4.0, 5.5>,
    1.1
  }  
  box {
    < -2, 3.8, 5.5>,
    <  0, 4.2, 7.5>
  }  
  texture { Weapon_Steel_001 }
  rotate z*90
  rotate y*90
  translate x*1
  translate z*-4
}
#declare F_Torso_Weapon = union {  /* Front Torso Weapon */

  merge {
    cylinder {
      <-0.5, 4, 6.0>,
      <-1.0, 4, 6.5>,
      .25  
    }
    cylinder {
      <-1.8, 4, 7.3>,
      <-1.9, 4, 7.4>,
      .25  
    }
    texture { 
      Camou_Paint_001
    }
  }
  merge {
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
    }
    cylinder {
      <-1.95, 4, 7.45>,
      <-2.05, 4, 7.55>,
      0.075
    }  
    
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*.1
      translate z*.1
    }
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*-.1
      translate z*-.1
    }
    difference {
      cylinder {        /* Main Barrel */
        <-1.95, 4, 7.45>,
        < -2.1, 4,  7.6>,
        0.075
        translate x*-.1
        translate z*-.1
      }
      cylinder {
        <-1.0, 4, 6.5>,
        <-2.5, 4, 8.0>,
        0.04
        translate x*-.1
        translate z*-.1
      }
    }
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*.05
      translate y*.1
      translate z*.05
    }
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*-.05
      translate y*-.1
      translate z*-.05
    }
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*-.05
      translate y*.1
      translate z*-.05
    }
    cylinder {
      <-1.0, 4, 6.5>,
      <-2.0, 4, 7.5>,
      0.05
      translate x*.05
      translate y*-.1
      translate z*.05
    }
    texture { Weapon_Steel_002 }
  }
  rotate z*90
  rotate y*90
  translate x*1
  translate z*-4
}
/****************************************/


/****************************************/
/* Torso Back Part */
#declare Point_0b = <0.00, 0.00>;    /* Spline 3 Control Points */
#declare Point_1b = <4.00, 0.00>;
#declare Point_2b = <4.00, 1.00>;
#declare Point_3b = <3.00, 1.50>;
#declare Point_4b = <0.00, 2.00>;

#declare Back_Part_001 = difference {   /* Torso Back Part Spline */
  lathe {
    linear_spline /* Spline 3 */
    5,
    Point_0b,
    Point_1b,
    Point_2b,
    Point_3b,
    Point_4b
  }
  box {
    <0, -0.05, -4>
    <4, 10,  4>
  }
  texture { Camou_Paint_001 }
  rotate z*-90
  rotate y*180
}
/****************************************/


/****************************************/
/* Rocket Arrays */
#declare Rockets = union {
  merge {
    box {
      <-1, 0, -1.5>
      < 2, 3,  1.5>
    }
    sphere {
      <0.5,0,0>,1.4
    }
    sphere {
      <0.5,1.5,1.5>,1.4
    }
    box {
      <-1.25,   0, -1.25>
      < 1.25, 2.5,  1.25>
    }
    box {
      <-1.5, 0, -1>
      < 0.5, 2,  1>
    }
    translate x*0
    translate y*2.5
    translate z*-3
  }
  merge {
    box {
      <-1, 0, -1.5>
      < 2, 3,  1.5>
    }
    sphere {
      <0.5,0,0>,1.4
    }
    sphere {
      <0.5,1.5,-1.5>,1.4
    }
    box {
      <-1.25,   0, -1.25>
      < 1.25, 2.5,  1.25>
    }
    box {
      <-1.5, 0, -1>
      < 0.5, 2,  1>
    }
    translate x*0
    translate y*2.5
    translate z*3
  }
  texture { Camou_Paint_001 }
}
#declare War_Head = lathe {    /* Rocket Array War Heads */
  quadratic_spline
  4,
  <1.00, 1.00>,
  <1.00, 1.00>,
  <1.00, 2.00>,
  <0.00, 4.00>
  texture { Rocket_Paint }
}
#declare R_Heads = union {        /* Left Rocket Array Warheads*/
  object { War_Head }
  object { War_Head translate z*3 }
  object { War_Head translate z*6 }
  object { War_Head translate x*3 }
  object { War_Head translate x*3 translate z*3 }
  object { War_Head translate x*3 translate z*6 }
  object { War_Head translate x*6 translate z*0 }
  object { War_Head translate x*6 translate z*3 }
  rotate z*-90
  scale .3
}
#declare L_Heads = union {        /* Right Rocket Array Warheads */
  object { War_Head }
  object { War_Head translate z*3 }
  object { War_Head translate z*6 }
  object { War_Head translate x*3 }
  object { War_Head translate x*3 translate z*3 }
  object { War_Head translate x*3 translate z*6 }
  object { War_Head translate x*6 translate z*6 }
  object { War_Head translate x*6 translate z*3 }
  rotate z*-90
  scale .3
}
/****************************************/


/****************************************/
/* Cockpit */
#declare Cockpit = intersection {
  lathe {
    quadratic_spline
    3,
    <3.95, 3.00>,
    <3.95, 4.00>,
    <1.95, 7.00>
  }
  box {
    <-3, 5, -5>,
    <-2, 7,  5>
  }
  texture {
    pigment { 
      color White
      filter .5
    }  
    finish {
      brilliance 6
      reflection .6
      ambient .5
      phong 1
    }
  }  
  rotate z*-90
}
/****************************************/
 
 
/****************************************/
/* Legs */
#declare Leg_Part_001 = union { /* Legs Upper Part */
  merge {
    box {
      <0,0,0>,
      <1,1,1>
    }
    cylinder {
      <0.5,0,0.5>,
      <0.5,1,0.5>,
      0.6
    }
    sphere {
      <0.5,0,0.5>,0.5
    }
    cylinder {
      <0.25,1,0.25>,
      <0.25,2,0.25>,
      0.25
    }
    cylinder {
      <0.75,1,0.75>,
      <0.75,3,0.75>,
      0.25
    }
  }
  merge {
    box {
      <0,0,0>,
      <1,1,1>
    }
    cylinder {
      <0.5,0,0.5>,
      <0.5,2,0.5>,
      0.6
    }
    sphere {
      <0.5,0,0.5>,0.5
    }
    cylinder {
      <0.25,1,0.25>,
      <0.25,5,0.25>,
      0.125
    }
    cylinder {
      <0.75,1,0.75>,
      <0.75,5,0.75>,
      0.125
    }
    cylinder {
      <0.25,1,0.75>,
      <0.25,5,0.75>,
      0.125
    }
    cylinder {
      <0.75,1,0.25>,
      <0.75,5,0.25>,
      0.125
    }
    rotate z*180
    translate y*5
    translate x*1
  }
  texture { Camou_Paint_001 }
  rotate z*-90
}
#declare Leg_Part_002 = union { /* Leg Lower Part */
  merge {
    box {
      <0,0,0>,
      <1,1,1>
    }
    cylinder {
      <0.5,0,0.5>,
      <0.5,1,0.5>,
      0.6
    }
    sphere {
      <0.5,0,0.5>,0.5
    }
    cylinder {
      <0.25,1,0.25>,
      <0.25,2,0.25>,
      0.25
    }
    cylinder {
      <0.75,1,0.75>,
      <0.75,3,0.75>,
      0.25
    }
    texture { Camou_Paint_001 }
  }
  merge {
    box {
      <0,0,0>,
      <1,1,1>
    }
    cylinder {
      <0.5,0,0.5>,
      <0.5,2,0.5>,
      0.6
    }
    sphere {
      <0.5,0.5,0>,0.5
    }
    sphere {
      <0.5,0.5,1>,0.5
    }
    cylinder {
      <0.25,1,0.25>,
      <0.25,5,0.25>,
      0.125
    }
    cylinder {
      <0.75,1,0.75>,
      <0.75,5,0.75>,
      0.125
    }
    cylinder {
      <0.25,1,0.75>,
      <0.25,5,0.75>,
      0.125
    }
    cylinder {
      <0.75,1,0.25>,
      <0.75,5,0.25>,
      0.125
    }
    texture { Camou_Paint_001 }
    rotate z*180
    translate y*5
    translate x*1
  }
  difference {
    lathe {
      linear_spline
      5,
      <0.00,3.00>,
      <0.75,3.00>,
      <1.00,4.50>,
      <1.00,5.50>,
      <0.00,5.50>
    }  
    box {
      <0,2.5,-3>,
      <3,6.0, 3>
      rotate y*-90
    } 
    texture { Hull_Paint_001 }
    rotate z*180
    translate y*5
    translate x*.5
    translate z*.5
  }  
  difference {
    lathe {
      linear_spline
      5,
      <0.00,0.00>,
      <0.50,0.00>,
      <0.50,1.50>,
      <0.25,3.00>,
      <0.00,2.00>
    }  
    box {
      <0,-0.1,-3>,
      <3,4.0, 3>
      rotate y*90
    } 
    texture { Camou_Paint_001 }
    rotate z*0
    translate y*4.75
    translate x*.5
    translate z*.5
  }  
  rotate z*90
  rotate x*90
}
#declare Leg_Part_003 = merge { /* Feet */
  box {
    <0,0,0>,
    <1,0.5,1>
  }
  sphere {
    <0.5,0.5,0.5>,0.5
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate x*.4
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate z*-.4
  }
  box {
    <0.1,   0, 0.1>,
    <0.9, 0.4, 0.9>
    translate z*.4
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate x*.7
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate z*-.7
  }
  box {
    <0.2,   0, 0.2>,
    <0.8, 0.3, 0.8>
    translate z*.7
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate x*.9
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate z*-.9
  }
  box {
    <0.3,   0, 0.3>,
    <0.7, 0.2, 0.7>
    translate z*.9
  }
  texture { Camou_Paint_001 }
}
/****************************************/


/****************************************/
/* Antennas */
#declare Antennas = union { /* Antenna 1 */
  merge {                   
    cylinder {
      <0,   -2,0>,
      <0,0.25,0>,
      0.15
      texture { Camou_Paint_001 }
    }
    cylinder {
      <0,0.25,0>,
      <0,5,0>,
      0.05
      pigment {
        color SteelBlue
      }
      finish { 
        F_MetalD 
      }
    }
    cylinder {
      <0,5,0>,
      <0,6,0>,
      0.1
      texture { Camou_Paint_001 }
    }
  }
  merge {                   /* Antenna 2 */
    cylinder {
      <0,   -2,0>,
      <0,0.25,0>,
      0.15
      texture { Camou_Paint_001 }
    }
    cylinder {
      <0,0.25,0>,
      <0,2,0>,
      0.05
      texture { Weapon_Steel_001 }
    }
    cylinder {
      <0,2,0>,
      <0,2.5,0>,
      0.1
      texture { Camou_Paint_001 }
    }
    translate x*.5
    translate z*-.25
  }  
  merge {                   /*  Antenna 3 */
    cylinder {
      <0, -2,0>,
      <0,0.25,0>,
      0.15
      texture { Camou_Paint_001 }
    }
    cylinder {
      <0,0.25,0>,
      <0,3.5,0>,
      0.05
      texture { Weapon_Steel_001 }
    }
    cylinder {
      <0,3.5,0>,
      <0,4,0>,
      0.1
      texture { Camou_Paint_001 }
    }
    translate x*.5
    translate z*.25
  }
}
/****************************************/


/****************************************/
/* Weapons  */
#declare Main_Weapon_R = union {
  merge {
    box {
      <-0.5,-0.5,-0.5>,
      < 0.5, 0.5, 0.5>
    }
    sphere {
      <-0.5,0,0>,
      0.5
    }
    sphere {
      <0,0.5,0>,
      0.5
    }
    sphere {
      <0,0,-0.5>,
      0.5
    }
    sphere {
      <1.5,0.5,0>,
      0.74
    }
    cylinder {
      <-0.5,0,0>,
      <1.5,0,0>,
      0.6
    }
    cylinder {
      <1.5,0,0>,
      <3.75,0,0>,
      0.5
    }
    cylinder {
      <3.75,0,0>,
      <4.5,0,0>,
      0.6
    }
    cylinder {
      <3.5,.5,0>,
      <3.75,.5,0>,
      0.74
    }
    difference {
      lathe {
        linear_spline
        5,
        <0.00,0.00>,
        <0.50,0.00>,
        <0.75,0.50>,
        <0.75,2.25>,
        <0.00,0.50>
      }
      box {
        <0,-.5,-1>,
        <1,3,1>
      }  
      scale 1
      translate x*-.5
      rotate z*-90
      rotate x*-90
    }
    difference {
      lathe {
        linear_spline
        5,
        <0.00,0.00>,
        <0.50,0.00>,
        <0.75,0.50>,
        <0.25,2.25>,
        <0.00,0.50>
      }
      box {
        <0,-.5,-1>,
        <1,3,1>
      }  
      scale 1
      translate x*-.5
      rotate z*90
      rotate x*90
    }
    texture { Camou_Paint_001 }
  }
  merge {
    merge {
      difference {
        cylinder {
          <1.5,0,0>,
          <3.5,0,0>,
          0.74
        }
        box {
          <2.25,0,-1>,
          <3.25,1,1>
        }
        texture { Weapon_Steel_001 }
        translate y*.5
      }
      cylinder {
        <3.5,0,0>,
        <4.35,0,0>,
        0.675
        texture { Weapon_Steel_001 }
        translate y*.5
      }
      difference {
        cylinder {
          <3.75,0,0>,
          <4.75,0,0>,
          0.3
        texture { Weapon_Steel_001 }
          translate y*.25
        }
        cylinder {
          <3.75,0,0>,
          <4.85,0,0>,
          0.2
        texture { Weapon_Steel_002 }
          translate y*.25
        }
      }
    }  
    merge {
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.25
        translate y*.5
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*1
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*.75
        translate z*-.5
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*.75
        translate z*.5
      }
      texture { Weapon_Steel_002 }
    }
    intersection {
      box {
        <3.75,-.65,-.65>,
        <4.25,0.65,0.65>
      }         
      box {
        <3.75,-.65,-.65>,
        <4.26,0.65,0.65>
        rotate x*-45
      }         
      texture { Weapon_Steel_001 }
      translate y*.5
    }
  }
}
#declare Main_Weapon_L = union {
  merge {
    box {
      <-0.5,-0.5,-0.5>,
      < 0.5, 0.5, 0.5>
    }
    sphere {
      <-0.5,0,0>,
      0.5
    }
    sphere {
      <0,0.5,0>,
      0.5
    }
    sphere {
      <0,0,0.5>,
      0.5
    }
    sphere {
      <1.5,0.5,0>,
      0.74
    }
    cylinder {
      <-0.5,0,0>,
      <1.5,0,0>,
      0.6
    }
    cylinder {
      <1.5,0,0>,
      <3.75,0,0>,
      0.5
    }
    cylinder {
      <3.75,0,0>,
      <4.5,0,0>,
      0.6
    }
    cylinder {
      <3.5,.5,0>,
      <3.75,.5,0>,
      0.74
    }
    difference {
      lathe {
        linear_spline
        5,
        <0.00,0.00>,
        <0.50,0.00>,
        <0.75,0.50>,
        <0.75,2.25>,
        <0.00,0.50>
      }
      box {
        <0,-.5,-1>,
        <1,3,1>
      }  
      scale 1
      translate x*-.5
      rotate z*-90
      rotate x*-270
    }
    difference {
      lathe {
        linear_spline
        5,
        <0.00,0.00>,
        <0.50,0.00>,
        <0.75,0.50>,
        <0.25,2.25>,
        <0.00,0.50>
      }
      box {
        <0,-.5,-1>,
        <1,3,1>
      }  
      scale 1
      translate x*-.5
      rotate z*90
      rotate x*270
    }
    texture { Camou_Paint_001 }
  }
  merge {
    merge {
      difference {
        cylinder {
          <1.5,0,0>,
          <3.5,0,0>,
          0.74
        }
        box {
          <2.25,0,-1>,
          <3.25,1,1>
        }
        texture { Weapon_Steel_001 }
        translate y*.5
      }
      cylinder {
        <3.5,0,0>,
        <4.35,0,0>,
        0.675
        texture { Weapon_Steel_001 }
        translate y*.5
      }
      difference {
        cylinder {
          <3.75,0,0>,
          <4.75,0,0>,
          0.3
        texture { Weapon_Steel_001 }
          translate y*.25
        }
        cylinder {
          <3.75,0,0>,
          <4.85,0,0>,
          0.2
        texture { Weapon_Steel_001 }
          translate y*.25
        }
      }
    }  
    merge {
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.25
        translate y*.5
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*1
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*.75
        translate z*-.5
      }
      cylinder {
        <1.6,0,0>,
        <3.3,0,0>,
        0.15
        translate y*.75
        translate z*.5
      }
      texture { Weapon_Steel_002 }
    }
    intersection {
      box {
        <3.75,-.65,-.65>,
        <4.25,0.65,0.65>
      }         
      box {
        <3.75,-.65,-.65>,
        <4.26,0.65,0.65>
        rotate x*-45
      }         
      texture { Weapon_Steel_001 }
      translate y*.5
    }
  }
}
/****************************************/


/****************************************/
/* Position Lighting */
#declare Position_Light = union {    /* Center Position Light /White */
  cylinder {
    <0,0,0>,
    <0,-0.15,0>,
    0.5
    texture { Camou_Paint_001 }
  }
  cylinder {
    <0,-0.15,0>,
    <0,-0.45,0>,
    0.5
    pigment { color White filter .1 }
    finish { ambient 1 phong 1 }
  }
}
#declare P_Light_Center = light_source {
  <0,-0.3,0>
  color White
  looks_like {
    Position_Light
  }
  fade_power 1   
  fade_distance 1
}  
#declare Position_Light_R = union {   /* Right Position Light /Green */
  cylinder {
    <0,0,0>,
    <0,-0.15,0>,
    0.5
    texture { Camou_Paint_001 }
  }
  cylinder {
    <0,-0.15,0>,
    <0,-0.45,0>,
    0.5
    pigment { color Green filter .1 }
    finish { ambient 1 phong 1 }
  }
}
#declare P_Light_Right = light_source {
  <0,-0.3,0>
  color Green
  looks_like {
    Position_Light_R
  }
  fade_power 1   
  fade_distance 1
}  
#declare Position_Light_L = union {   /*Left Position Light /Red */
  cylinder {
    <0,0,0>,
    <0,-0.15,0>,
    0.5
    texture { Camou_Paint_001 }
  }
  cylinder {
    <0,-0.15,0>,
    <0,-0.45,0>,
    0.5
    pigment { color Red filter .1 }
    finish { ambient 1 phong 1 }
  }
}
#declare P_Light_Left = light_source {
  <0,-0.3,0>
  color Red
  looks_like {
    Position_Light_L
  }
  fade_power 1   
  fade_distance 1
}  
/****************************************/


/****************************************/
/* Search Lights */

#declare SL_001_Target = <-5,25,-5>;  /*Search Light Target Points */
#declare SL_002_Target = <-5,25,-5>;

#declare Search_Light = union {   /* Search Light Base */
  sphere {
    <0,0,0>,
    0.25
    texture {
      Camou_Paint_001
    }
  }
  lathe {
    linear_spline
    4,
    <0.00,0.00>,
    <0.25,0.00>,
    <0.25,0.50>,
    <0.24,0.50>
    texture {
      Camou_Paint_001
    }
  }
  lathe {
    linear_spline
    2,
    <0.00,0.25>,
    <0.24,0.50>
    texture { 
      Weapon_Steel_001  
    }
  }  
  cylinder {
    <0,0.5,0>,
    <0,0.55,0>,
    0.25
    hollow
    pigment { color White filter 0 }
    finish { ambient 1 phong 1 }
  }    
}
#declare S_Light_001 = light_source {   /* Search Light 1 Right */
   <0,0.525,0>
   color rgb <1,1,1>
   spotlight 
   radius 15
   falloff 20
   tightness 10
   point_at SL_001_Target 
   looks_like {
     Search_Light
   }
   rotate x*-25
}
#declare S_Light_002 = light_source {  /* Search Light 2 Left */
   <0,0.525,0>
   color rgb <1,1,1>
   spotlight
   radius 15
   falloff 20
   tightness 10
   point_at SL_002_Target 
   looks_like {
     Search_Light
   }
   rotate x*25
}
/****************************************/

   
/****************************************/
/* Show Objects On/Off */


#if (Mech)
  object { Torso_Part_001_cutout } 
  object { Torso_Part_002 }
  object { F_Torso_Weapon rotate z*40 translate y*-4.5 translate x*1.5}
  object { F_Torso_WH}
  object { Back_Part_001 }
  object { Rockets }
  object { R_Heads translate x*1.50 translate y*5 translate z*-4  }
  object { L_Heads translate x*1.50 translate y*5 translate z*2.2 }
  object { Cockpit }  

  /* Upper Leg Parts R/L */
  object { Leg_Part_001 translate x*-6.00 translate y*-0.750 translate z*-5.00 rotate z*15 scale 0.65 }
  object { Leg_Part_001 translate x*-7.50 translate y*-0.50 translate z*04.00 rotate z*45 scale 0.65 }

  /* Lower Leg Parts R/L */
  object { Leg_Part_002 translate x*04.25 translate y*-2.75 translate z*-2.50 rotate y*0 rotate z*-60 scale 1.50 }
  object { Leg_Part_002 translate x*03.75 translate y*-3.50 translate z*01.50 rotate y*0 rotate z*-25 scale 1.50 }

  /* Feet R/L */
  object { Leg_Part_003 translate x*-1.00 translate y*-6.25 translate z*-2.50 scale 1.50 }
  object { Leg_Part_003 translate x*01.50 translate y*-6.00 translate z*01.50 scale 1.50 }

  /* Upper Arm Parts ( = ULP s.a. ) R/L */
  object { Leg_Part_001 translate x*-5.00 translate y*-1.00 translate z*-9.50 rotate z*45 scale 0.50 }
  object { Leg_Part_001 translate x*-5.00 translate y*-1.00 translate z*08.50 rotate z*45 scale 0.50 }

  /* Weapon Arm Parts R/L */
  object { Main_Weapon_R translate x*-1.5 translate y*-3.25 translate z*-4.5 }
  object { Main_Weapon_L translate x*-1.5 translate y*-3.25 translate z*5 }

  /* Position Lighting */
  object { P_Light_Center translate x*30.5 translate y*0.25 scale .25 }
  object { P_Light_Right translate x*20 translate y*0.25 translate z*-13.25 scale .25 }
  object { P_Light_Left translate x*20 translate y*0.25 translate z*13.25 scale .25 }

  /* Search Lights R/L */
  object { S_Light_001 rotate z*-135 translate y*.25 translate x*14.5 translate z*-2 scale .5 }
  object { S_Light_002 rotate z*-135 translate y*.25 translate x*14.5 translate z* 2 scale .5 }

  /* Antennas */
  object { Antennas translate x*-1.5 translate y*6 translate z*0 scale .75} 
#end