// Height Field Image Map for "Circles.pov" Scene
//
// Command Line : +FT +A0.0 +R3 +W1280 +H1024

/**************************/
/* Standard Includes */
#include "colors.inc"
/**************************/

/**************************/
/* Global Settings */
global_settings {
  assumed_gamma 2.2
  hf_gray_16
}
/**************************/

/**************************/
/* Camera */
camera { location <0, 0, -10> look_at <0, 0, 0> }
/**************************/

/**************************/
/* Light Sources */
light_source { <0, 20, -100> color White }
light_source {<10, 20, -100>  color Red }
/**************************/

/**************************/
/* Switch Plane */
#declare Plane = 1;
/**************************/

/**************************/
/* Plane */
#declare Desert_Plane = plane { 
  z,
  10
  pigment {
    bozo
    color_map {
      [0 0.5*White]
      [1 White]
    }
    scale 4
  }
}
#if (Plane)
 object { Desert_Plane }
#end
/**************************/

