#include "PALM.inc"
#include "TOMTREE.inc"


#declare Vase =
difference {
   sor {
       10,
       < 3.0,  -1.0>,
       < 3.0,   0.0>,
       < 3.0,   1.0>,
       < 4.0,   4.0>,
       < 5.0,   6.0>,
       < 6.0,   8.0>,
       < 4.0,  10.0>,
       < 3.0,  11.0>,
       < 3.0,  12.0>
       < 3.0,  13.0>
       open 
       }
    cylinder { <0,-2,0>, <0,15,0>,2.9
             }
       texture { T_Stone41 scale 4}      //T_Grnt25 T_Stone25
       normal{granite 1.5}
       finish {phong 0.5  phong_size 1}
}
       

/************* CENSOR ********
******************************/


#declare Censor=

union {
   cylinder {  //bottom
      <-4*Feet,0.0*Feet,-1.5*Feet>,       // Center of one end
      <-4*Feet,0.5*Feet,-1.5*Feet>,       // Center of other end
      .6*Feet            // Radius
      texture{Bronze_Metal} 
   }
   difference{   //holds fire
      union{sphere{ 
                    <0*Feet,0*Feet,0*Feet>,1.999
                  }
            sphere{<0*Feet, 0*Feet, 0*Feet>,2
            texture {T_Brass_1A}
            }
            }
      cylinder{
      <0*Feet,0*Feet,0*Feet>,       // Center of one end
      <0*Feet,2*Feet,0*Feet>,       // Center of other end
      2*Feet            // Radius
      }
      texture{pigment {rgbt <1,1,1,1>}} 
      translate <-4*Feet, 1.7*Feet, -1.5*Feet>
      hollow on
      interior {media {CensorMedia1}}
      interior {media {CensorMedia2}}
   }
   cylinder {       //front left
      <(-4*Feet)-(.53*Feet), 0.0*Feet, (-1.5*Feet)-(.53*Feet)>,       
      <(-4*Feet)-(.53*Feet), 2.0*Feet, (-1.5*Feet)-(.53*Feet)>,       
      .1*Feet            // Radius
      texture{Bronze_Metal} 
   }
   cylinder {    //rear left
      <(-4*Feet)-(.54*Feet), 0.0*Feet, (-1.5*Feet)+(.54*Feet)>,       
      <(-4*Feet)-(.54*Feet), 2.0*Feet, (-1.5*Feet)+(.54*Feet)>,       
      .1*Feet            // Radius
      texture{Bronze_Metal} 
   }
   cylinder {       //front right
      <(-4*Feet)+(.53*Feet), 0.0*Feet, (-1.5*Feet)-(.53*Feet)>,       
      <(-4*Feet)+(.53*Feet), 2.0*Feet, (-1.5*Feet)-(.53*Feet)>,       
      .1*Feet            // Radius
      texture{Bronze_Metal} 
   }
   cylinder {       //rear right
      <(-4*Feet)+(.54*Feet), 0.0*Feet, (-1.5*Feet)+(.54*Feet)>,       
      <(-4*Feet)+(.54*Feet), 2.0*Feet, (-1.5*Feet)+(.54*Feet)>,       
      .1*Feet            // Radius
      texture{Bronze_Metal} 
   } 
   sphere{  <0, 0, 0>, 5
        pigment {
                crackle 
 		color_map {
			[0.0 color rgbt <.0, .0, .0, .0>]
			[0.3 color rgbt <.3, .3, .3, .0>]
			[0.3 color rgbt <.4, .0, .0, .0>]
			[1.0 color rgbt <.4, .0, .0, .0>]
		}
    }
    scale <.1*Foot, .01*Foot, .1*Foot>
    translate <-4*Feet, 1.6*Feet, -1.5*Feet>
}
   hollow on
   no_reflection 
}
           

/*************  SMOKE ********
******************************/

#declare R2 = seed(12345);
#declare Smoke = 
  blob { 
     threshold .6
     #declare N=1;
     #while (N<20)
        sphere{ < (rand(R2) * 15*Feet) + rand(R2), 
                  (rand(R2) * 15*Feet) + rand(R2), 
                  (rand(R2) * 25*Feet) + rand(R2) >,           
                  15*Feet + rand(R2),1
           scale <.5 * Feet, 1*Feet, 0.5*Feet>
           rotate <rand(R2)*180, rand(R2)*180, rand(R2)*180>
        }
        #declare N = N + 1;
     #end 
     texture{pigment{rgbt <1,1,1,1>}}
     finish { ambient 1 diffuse 1 }
     hollow on
     interior { media { SmokeMedia } } 
     sturm  
}


/*************   MAN ********
******************************/
#declare Hair = off; 
       
#include "bmpeople.inc"
#include "bmarray.txt" 

#declare BM_Skin_Tex= texture {pigment{rgb<.46,.35,.30>      //pigment{rgb <.9,.7,.6>}  -5
                                       }
#declare BM_Hair_Col  = <0,0,0>;                               }                                
#declare BM_HairStyle=0;
#declare BM_PoseNo=0;

Blob_Man(Male,6*Feet) 


//Picture
#declare Picture =
box { <0,0,0> , <1,1,0>
  texture{
    pigment{
      image_map{ gif "tower.gif"
      map_type 0
      once
      interpolate 2
      }
    }
  }
}


#declare FringTex =
    texture {  pigment{ 
                       wood
                       turbulence 0.8*Feet  //.04
                       octaves 3*Feet
                       scale <0.05*Feet, .05*Feet, 1*Feet>
                       color_map { 
                               [0.0, 0.1 color rgbt <1,1,1,1>
                                         color rgbt <1,1,1,1>]
                               [0.1, 0.9 color Scarlet //rgb <0.88, 0.60, 0.40>
                                         color rgbt <1,1,1,1>]
                               [0.9, 1.0 color IndianRed //rgbt <1,1,1,1>
                                         color rgbt <1,1,1,1>]
                                  }
                      }
             }

#declare Rug =
union {
    box{<0*Feet, .8*Feet, 0*Feet> , <8*Feet, 1.001*Feet, -4*Feet>
    texture{FringTex scale 5*Feet rotate y*90 }
   } 
   box{<0*Feet, 0*Feet, 0*Feet> , <7.7*Feet, 1.002*Feet, -4*Feet>
       texture{pigment{
                        wrinkles scale .5*Feet
                        turbulence 0}}
       texture {pigment {color Scarlet transmit .5 } }
       normal {wrinkles 5*Feet }
       finish {ambient .5} 
   }
}  


/*************   ROBE ********
******************************/

#declare Robe  =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.869, 0.355, 2.018> <2.655, 0.504, 2.059> <2.391, 0.732, 2.143> <2.156, 0.852, 2.156> 
		<2.518, 0.224, 1.744> <2.304, 0.374, 1.785> <2.199, 0.548, 1.863> <1.964, 0.668, 1.877> 
		<1.876, 0.088, 1.681> <2.191, 0.027, 1.895> <2.191, 0.027, 1.895> <1.765, -0.087, 1.751> 
		<1.450, -0.026, 1.537> <1.450, -0.026, 1.537> <1.450, -0.026, 1.537> <1.450, -0.026, 1.537> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.187, 1.024, 2.110> <-2.503, 1.144, 2.208> <-3.143, 0.834, 2.133> <-3.238, 0.501, 2.066> 
		<-2.407, 0.854, 2.100> <-2.724, 0.974, 2.197> <-3.215, 0.583, 2.082> <-3.309, 0.250, 2.015> 
		<-2.361, 0.409, 1.987> <-2.600, 0.500, 2.060> <-2.600, 0.500, 2.060> <-2.675, 0.236, 2.007> 
		<-2.435, 0.145, 1.934> <-2.435, 0.145, 1.934> <-2.435, 0.145, 1.934> <-2.435, 0.145, 1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.435, 0.145, 1.934> <-2.151, 0.037, 1.847> <-1.592, -0.456, 1.474> <-1.508, -0.157, 1.534> 
		<-2.361, 0.409, 1.987> <-2.077, 0.301, 1.899> <-1.474, -0.037, 1.558> <-1.389, 0.262, 1.618> 
		<-2.407, 0.854, 2.100> <-2.009, 0.702, 1.978> <-2.009, 0.702, 1.978> <-1.788, 0.872, 1.988> 
		<-2.187, 1.024, 2.110> <-2.187, 1.024, 2.110> <-2.187, 1.024, 2.110> <-2.187, 1.024, 2.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.031, 1.185, 2.935> <-0.043, 1.255, 2.670> <-0.074, 1.371, 2.322> <-0.072, 1.419, 2.052> 
		<0.321, 1.172, 2.932> <0.309, 1.242, 2.667> <0.304, 1.309, 2.340> <0.306, 1.358, 2.070> 
		<0.790, 1.143, 2.904> <0.598, 1.203, 2.782> <0.842, 1.281, 2.328> <0.810, 1.276, 2.095> 
		<1.142, 1.126, 2.891> <0.950, 1.186, 2.768> <1.220, 1.220, 2.346> <1.189, 1.214, 2.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.072, 1.419, 2.052> <-0.070, 1.473, 1.751> <-0.036, 1.493, 1.344> <-0.020, 1.524, 1.040> 
		<0.306, 1.358, 2.070> <0.308, 1.411, 1.770> <0.277, 1.422, 1.397> <0.293, 1.453, 1.093> 
		<0.810, 1.276, 2.095> <0.777, 1.270, 1.845> <0.791, 1.357, 1.487> <0.714, 1.319, 1.250> 
		<1.189, 1.214, 2.113> <1.155, 1.208, 1.864> <1.009, 1.127, 1.560> <0.932, 1.089, 1.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.232, 0.681, 2.791> <-2.922, 0.784, 2.829> <-2.518, 0.948, 2.902> <-2.199, 1.025, 2.919> 
		<-3.233, 0.627, 2.573> <-2.924, 0.730, 2.612> <-2.515, 0.948, 2.659> <-2.195, 1.025, 2.677> 
		<-3.236, 0.555, 2.283> <-3.141, 0.888, 2.350> <-2.507, 1.145, 2.450> <-2.190, 1.024, 2.353> 
		<-3.238, 0.501, 2.066> <-3.143, 0.834, 2.133> <-2.503, 1.144, 2.208> <-2.187, 1.024, 2.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.199, 1.025, 2.919> <-1.863, 1.106, 2.938> <-1.339, 1.136, 3.103> <-1.058, 1.206, 2.912> 
		<-2.195, 1.025, 2.677> <-1.859, 1.106, 2.695> <-1.110, 1.193, 2.947> <-0.829, 1.263, 2.756> 
		<-2.190, 1.024, 2.353> <-1.864, 1.276, 2.368> <-1.292, 1.242, 2.295> <-0.887, 1.318, 2.283> 
		<-2.187, 1.024, 2.110> <-1.860, 1.275, 2.125> <-1.262, 1.285, 2.017> <-0.857, 1.360, 2.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.058, 1.206, 2.912> <-0.829, 1.263, 2.756> <-0.887, 1.318, 2.283> <-0.857, 1.360, 2.006> 
		<-0.750, 1.199, 2.919> <-0.521, 1.256, 2.763> <-0.654, 1.361, 2.277> <-0.625, 1.404, 2.000> 
		<-0.339, 1.196, 2.938> <-0.351, 1.266, 2.673> <-0.309, 1.353, 2.308> <-0.308, 1.401, 2.038> 
		<-0.031, 1.185, 2.935> <-0.043, 1.255, 2.670> <-0.074, 1.371, 2.322> <-0.072, 1.419, 2.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, 1.360, 2.006> <-0.826, 1.405, 1.713> <-0.856, 1.454, 1.317> <-0.856, 1.494, 1.021> 
		<-0.625, 1.404, 2.000> <-0.593, 1.448, 1.707> <-0.694, 1.638, 1.263> <-0.693, 1.678, 0.967> 
		<-0.308, 1.401, 2.038> <-0.306, 1.455, 1.737> <-0.277, 1.547, 1.303> <-0.261, 1.579, 1.000> 
		<-0.072, 1.419, 2.052> <-0.070, 1.473, 1.751> <-0.036, 1.493, 1.344> <-0.020, 1.524, 1.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.142, 1.126, 2.891> <0.950, 1.186, 2.768> <1.220, 1.220, 2.346> <1.189, 1.214, 2.113> 
		<1.448, 1.031, 3.087> <1.256, 1.090, 2.964> <1.510, 1.111, 2.359> <1.479, 1.106, 2.126> 
		<2.001, 0.949, 2.877> <1.939, 0.950, 2.665> <1.990, 1.099, 2.332> <1.880, 0.993, 2.171> 
		<2.363, 0.849, 2.865> <2.301, 0.850, 2.652> <2.266, 0.958, 2.316> <2.156, 0.852, 2.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.189, 1.214, 2.113> <1.155, 1.208, 1.864> <1.009, 1.127, 1.560> <0.932, 1.089, 1.324> 
		<1.479, 1.106, 2.126> <1.445, 1.100, 1.876> <1.260, 0.862, 1.645> <1.183, 0.825, 1.408> 
		<1.880, 0.993, 2.171> <1.688, 0.809, 1.892> <1.459, -0.028, 1.543> <1.144, 0.033, 1.329> 
		<2.156, 0.852, 2.156> <1.964, 0.668, 1.877> <1.765, -0.087, 1.751> <1.450, -0.026, 1.537> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.869, 0.355, 2.018> <2.655, 0.504, 2.059> <2.391, 0.732, 2.143> <2.156, 0.852, 2.156> 
		<3.065, 0.428, 2.172> <2.852, 0.577, 2.213> <2.501, 0.838, 2.303> <2.266, 0.958, 2.316> 
		<3.027, 0.516, 2.580> <2.807, 0.595, 2.593> <2.526, 0.787, 2.644> <2.301, 0.850, 2.652> 
		<3.094, 0.585, 2.821> <2.875, 0.664, 2.834> <2.588, 0.786, 2.857> <2.363, 0.849, 2.865> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.450, -0.026, 1.537> <1.144, 0.033, 1.329> <1.183, 0.825, 1.408> <0.932, 1.089, 1.324> 
		<1.412, -0.055, 1.237> <1.106, 0.004, 1.029> <1.176, 0.782, 1.136> <0.925, 1.046, 1.051> 
		<1.277, -0.113, 0.837> <1.152, 0.207, 0.800> <1.142, 0.700, 0.729> <0.926, 0.968, 0.689> 
		<1.324, -0.123, 0.537> <1.199, 0.197, 0.500> <1.125, 0.678, 0.455> <0.910, 0.946, 0.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.065, 0.634, -0.451> <-1.102, 0.634, -0.847> <-1.173, 0.737, -1.387> <-1.189, 0.634, -1.772> 
		<-1.311, 0.411, -0.398> <-1.348, 0.411, -0.794> <-1.445, 0.521, -1.324> <-1.462, 0.419, -1.709> 
		<-1.725, 0.032, -0.677> <-1.785, 0.046, -0.987> <-1.729, 0.103, -1.252> <-1.775, 0.093, -1.565> 
		<-1.826, -0.187, -0.443> <-1.886, -0.173, -0.753> <-1.980, -0.129, -1.164> <-2.027, -0.139, -1.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.189, 0.634, -1.772> <-1.208, 0.520, -2.202> <-1.181, 0.144, -2.689> <-1.178, -0.067, -3.082> 
		<-0.889, 0.872, -1.841> <-0.907, 0.757, -2.271> <-0.828, 0.388, -2.812> <-0.824, 0.177, -3.205> 
		<-0.514, 1.356, -1.886> <-0.533, 1.304, -2.227> <-0.627, 1.119, -2.719> <-0.651, 1.029, -3.052> 
		<-0.125, 1.364, -1.915> <-0.145, 1.312, -2.256> <-0.182, 1.152, -2.692> <-0.206, 1.062, -3.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.027, -0.139, -1.476> <-2.066, -0.148, -1.742> <-2.086, -0.218, -2.096> <-2.112, -0.252, -2.362> 
		<-1.775, 0.093, -1.565> <-1.815, 0.084, -1.831> <-1.806, -0.162, -2.312> <-1.832, -0.196, -2.578> 
		<-1.462, 0.419, -1.709> <-1.480, 0.304, -2.139> <-1.465, -0.052, -2.590> <-1.462, -0.262, -2.983> 
		<-1.189, 0.634, -1.772> <-1.208, 0.520, -2.202> <-1.181, 0.144, -2.689> <-1.178, -0.067, -3.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.020, 1.524, 1.040> <-0.014, 1.523, 0.815> <0.007, 1.537, 0.514> <0.000, 1.522, 0.290> 
		<-0.261, 1.579, 1.000> <-0.256, 1.578, 0.774> <-0.285, 1.566, 0.522> <-0.292, 1.551, 0.297> 
		<-0.693, 1.678, 0.967> <-0.700, 1.567, 0.799> <-0.661, 1.447, 0.627> <-0.685, 1.346, 0.454> 
		<-0.856, 1.494, 1.021> <-0.862, 1.383, 0.853> <-0.853, 1.225, 0.634> <-0.877, 1.124, 0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.522, 0.290> <-0.011, 1.499, -0.046> <-0.056, 1.434, -0.490> <-0.080, 1.397, -0.823> 
		<-0.292, 1.551, 0.297> <-0.303, 1.528, -0.039> <-0.436, 1.375, -0.426> <-0.460, 1.338, -0.759> 
		<-0.685, 1.346, 0.454> <-0.724, 1.188, 0.184> <-0.723, 1.040, -0.239> <-0.780, 0.893, -0.513> 
		<-0.877, 1.124, 0.461> <-0.916, 0.966, 0.191> <-1.009, 0.781, -0.177> <-1.065, 0.634, -0.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 1.397, -0.823> <-0.094, 1.387, -1.151> <-0.107, 1.414, -1.591> <-0.125, 1.364, -1.915> 
		<-0.460, 1.338, -0.759> <-0.474, 1.328, -1.087> <-0.495, 1.405, -1.562> <-0.514, 1.356, -1.886> 
		<-0.780, 0.893, -0.513> <-0.817, 0.893, -0.909> <-0.872, 0.974, -1.457> <-0.889, 0.872, -1.841> 
		<-1.065, 0.634, -0.451> <-1.102, 0.634, -0.847> <-1.173, 0.737, -1.387> <-1.189, 0.634, -1.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 1.364, -1.915> <-0.145, 1.312, -2.256> <-0.182, 1.152, -2.692> <-0.206, 1.062, -3.024> 
		<0.221, 1.372, -1.942> <0.202, 1.320, -2.283> <0.257, 1.185, -2.664> <0.232, 1.094, -2.997> 
		<0.518, 0.868, -1.905> <0.530, 0.740, -2.238> <0.476, 0.468, -2.672> <0.501, 0.290, -2.981> 
		<0.808, 0.678, -1.924> <0.821, 0.550, -2.257> <0.866, 0.264, -2.644> <0.890, 0.086, -2.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.932, 1.089, 1.324> <0.925, 1.046, 1.051> <0.926, 0.968, 0.689> <0.910, 0.946, 0.414> 
		<0.714, 1.319, 1.250> <0.707, 1.276, 0.977> <0.724, 1.219, 0.651> <0.707, 1.198, 0.376> 
		<0.293, 1.453, 1.093> <0.299, 1.453, 0.868> <0.331, 1.505, 0.506> <0.323, 1.489, 0.281> 
		<-0.020, 1.524, 1.040> <-0.014, 1.523, 0.815> <0.007, 1.537, 0.514> <0.000, 1.522, 0.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.910, 0.946, 0.414> <0.889, 0.918, 0.060> <0.839, 0.931, -0.412> <0.808, 0.925, -0.766> 
		<0.707, 1.198, 0.376> <0.687, 1.170, 0.023> <0.601, 1.117, -0.387> <0.571, 1.110, -0.741> 
		<0.323, 1.489, 0.281> <0.313, 1.467, -0.055> <0.239, 1.480, -0.539> <0.215, 1.443, -0.873> 
		<0.000, 1.522, 0.290> <-0.011, 1.499, -0.046> <-0.056, 1.434, -0.490> <-0.080, 1.397, -0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, 0.925, -0.766> <0.808, 0.851, -1.114> <0.796, 0.805, -1.593> <0.808, 0.678, -1.924> 
		<0.571, 1.110, -0.741> <0.571, 1.036, -1.088> <0.505, 0.995, -1.574> <0.518, 0.868, -1.905> 
		<0.215, 1.443, -0.873> <0.201, 1.433, -1.201> <0.240, 1.421, -1.618> <0.221, 1.372, -1.942> 
		<-0.080, 1.397, -0.823> <-0.094, 1.387, -1.151> <-0.107, 1.414, -1.591> <-0.125, 1.364, -1.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, 0.678, -1.924> <0.821, 0.550, -2.257> <0.866, 0.264, -2.644> <0.890, 0.086, -2.953> 
		<1.199, 0.424, -1.949> <1.211, 0.296, -2.282> <1.197, 0.091, -2.620> <1.222, -0.087, -2.929> 
		<1.742, 0.125, -2.021> <1.775, 0.120, -2.257> <1.755, -0.068, -2.647> <1.746, -0.080, -2.885> 
		<2.141, -0.112, -2.063> <2.175, -0.117, -2.299> <2.121, -0.139, -2.618> <2.112, -0.151, -2.856> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.852, -0.112, -1.029> <1.939, -0.112, -1.339> <2.096, -0.106, -1.744> <2.141, -0.112, -2.063> 
		<1.720, 0.156, -1.363> <1.807, 0.156, -1.673> <1.696, 0.131, -1.703> <1.742, 0.125, -2.021> 
		<1.160, 0.650, -0.804> <1.160, 0.576, -1.151> <1.186, 0.551, -1.618> <1.199, 0.424, -1.949> 
		<0.808, 0.925, -0.766> <0.808, 0.851, -1.114> <0.796, 0.805, -1.593> <0.808, 0.678, -1.924> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.406, -0.107, 0.339> <-1.248, 0.262, 0.376> <-1.141, 0.818, 0.470> <-0.877, 1.124, 0.461> 
		<-1.349, -0.102, 0.694> <-1.190, 0.268, 0.731> <-1.116, 0.919, 0.643> <-0.853, 1.225, 0.634> 
		<-1.477, -0.142, 1.175> <-1.282, 0.353, 1.022> <-1.221, 0.978, 0.972> <-0.862, 1.383, 0.853> 
		<-1.508, -0.157, 1.534> <-1.312, 0.339, 1.380> <-1.215, 1.089, 1.140> <-0.856, 1.494, 1.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.910, 0.946, 0.414> <1.125, 0.678, 0.455> <1.199, 0.197, 0.500> <1.324, -0.123, 0.537> 
		<0.889, 0.918, 0.060> <1.104, 0.650, 0.101> <1.276, 0.181, 0.011> <1.400, -0.140, 0.047> 
		<0.839, 0.931, -0.412> <1.191, 0.656, -0.450> <1.866, -0.141, -0.994> <1.998, -0.409, -0.660> 
		<0.808, 0.925, -0.766> <1.160, 0.650, -0.804> <1.720, 0.156, -1.363> <1.852, -0.112, -1.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.826, -0.187, -0.443> <-1.725, 0.032, -0.677> <-1.311, 0.411, -0.398> <-1.065, 0.634, -0.451> 
		<-1.906, -0.362, -0.257> <-1.805, -0.143, -0.491> <-1.254, 0.558, -0.124> <-1.009, 0.781, -0.177> 
		<-1.449, -0.111, 0.075> <-1.290, 0.258, 0.112> <-1.179, 0.660, 0.200> <-0.916, 0.966, 0.191> 
		<-1.406, -0.107, 0.339> <-1.248, 0.262, 0.376> <-1.141, 0.818, 0.470> <-0.877, 1.124, 0.461> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.508, -0.157, 1.534> <-1.389, 0.262, 1.618> <-1.788, 0.872, 1.988> <-2.187, 1.024, 2.110> 
		<-1.312, 0.339, 1.380> <-1.193, 0.758, 1.464> <-1.461, 1.124, 2.003> <-1.860, 1.275, 2.125> 
		<-1.215, 1.089, 1.140> <-1.215, 1.049, 1.436> <-1.231, 1.329, 1.724> <-1.262, 1.285, 2.017> 
		<-0.856, 1.494, 1.021> <-0.856, 1.454, 1.317> <-0.826, 1.405, 1.713> <-0.857, 1.360, 2.006> 
	}


}





