# include "colors.inc"
# include "stones.inc"
# include "textures.inc"
# include "woods.inc"
# include "metals.inc"


# declare cm = .1;
# include "units.inc"

#include "DavMedia.inc"
#include "DavRoom.inc"

# declare CensorPos = <-2*Feet, 0*Feet, -1*Feet>; 

#include "DavLight.inc" 
#include "DavObjects.inc"

//+a0.0 +r5
//+a0.1 +r5 +j1.0 (def)   - copy 4 - 7.5 hrs
//+a0.1 +am2 +r3 - copy 5 - 2.5 hrs  
//+a0.2 +am2 + r3  - 1 hr

#declare Rad_Quality = 5;
 
global_settings { assumed_gamma 1 
                  max_trace_level 200
                  ambient_light color rgb <.3,.3,.15> //.1,.1,.05
#switch (Rad_Quality)
 #case (1)
  radiosity {             // --- Settings 1 (fast) ---
    pretrace_start 0.08
    pretrace_end   0.02
    count 50
    error_bound 0.5
    recursion_limit 1
  }
 #break
 #case (2)
  radiosity {             // --- Settings 2 (medium quality) ---
    pretrace_start 0.08
    pretrace_end   0.01
    count 120
    error_bound 0.25
    recursion_limit 1
  }
 #break
 #case (3)
  radiosity {             // --- Settings 3 (high quality) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 400
    error_bound 0.1
    recursion_limit 1
  }
 #break
 #case (4)
  radiosity {             // --- Settings 4 (medium quality, recursion_limit 2) ---
    pretrace_start 0.08
    pretrace_end   0.005
    count 350
    error_bound 0.15
    recursion_limit 2
  }
 #break
 #end

}

camera{  
//  location <-.2*Feet, 7*Feet, -8*Feet>  // figure
  location <-11*Feet, 5*Feet, -15*Feet>  // scene 2 -11,14,-8    y=14 or 5
//  location <-4*Feet, 5*Feet, -6*Feet>  // censor
//  location <5*Feet, 5*Feet, -2*Feet>  // vase
//  location <0*Feet, 3.5*Feet, -8*Feet>  // door
  up       y
  right    x
  angle    50
//  look_at  <-0*Feet,1*Feet,-7*Feet> // figure 
  look_at  <-2*Feet,20*Inches,-5*Feet> // scene  45
//  look_at  <-4*Feet,2*Feet,-2*Feet> // censor
//  look_at  <14*Feet, 0.1*Feet, -3.2*Feet> // vase
//  look_at  <0*Feet, 3.5*Feet, 0*Feet> // door
}

object { Floor}

object { Wall1}

object { Wall2}


object { Censor 
       translate CensorPos        //<-2*Feet, 0*Feet, -1.5*Feet> 
}

object {Smoke 
    scale <.006*Foot, .01*Foot, .005*Foot>  //.005,.01.,.005
    translate CensorPos +  <-4*Feet, 2.2*Feet, -1.0*Feet>         //<-5.8*Feet, 3.5*Feet, -2*Feet>
       } 

object {BlobMan 
        rotate y*180 rotate x*90
        scale .06*Feet
        translate <-.5*Feet, .5*Feet, -5*Feet>  }
        
#object{Robe
        material{RobeMaterial}
	scale 1.8
        translate <-.4*Feet, .1*Feet, -7*Feet> 
}       

object{
	TREE
	scale 20
	translate <10*Feet, 1.0*Feet, -3*Feet>
    }

#object { Picture
         scale <24*Inches, 44*Inches, 1*Inch>   //24x44
         translate <35*Inches, 44*Inches, -1*Inch>
}


#object {Vase 
         translate <10*Feet, 0*Foot, -3*Feet>        
         } 

         
#object {Rug
           translate <-12*Feet, -.9*Feet, -5*Feet>
           finish {ambient .4}
         }  

