global_settings {max_trace_level 40}

camera {
    location <0, 4, -25>
    right x*image_width/image_height
    up y 
	look_at  <0, 8, 0> 
	normal{wrinkles 0.014}
}

light_source {<-50, 20, -40> color rgb<1, 0.9, 0.8>*3} 
light_source {<50, 6, 15> color rgb<1, 0.6, 0.45>*1.4 shadowless}

background {color rgb<0.85, 0.35, 0.1>}

fog {
	distance 110
    color rgb<1, 0.8, 0.7>
    fog_type 2
    fog_offset 0
    fog_alt 25
    turbulence 0.5
    turb_depth 0.2
    
    rotate x*6
}

#include "ground.inc" 
object{Ground} 
object{LeavesOnGround}

union {
	#include "man.inc"
	object{Man}
	
	#include "dognlead.inc"
	object{DogAndLead}
	
	scale 0.03 rotate -y*20 translate <-10, 0.1, -2>
}

#include "wall.inc"
object{Wall}

#include "fence.inc"
object{Fence}               
object{FencePart texture{FenceTxt} rotate -z*5.5 rotate y*6 translate<6.5, 0.5, -15>}
         
#include "olive.inc"
#include "tomtree.inc"
object {TREE scale 170 rotate y*180 translate<-5, -20, 150>} 

#include "grass1.inc"
object{Grass1 scale 0.4 translate z*9}
object{Grass1 scale 0.3 rotate -x*10 rotate -z*15 translate<20, 0, 9>}

#include "grass2.inc"
object{Grass2 scale 0.25 translate <6, 0, 9>}
object{Grass2 scale 0.3 rotate z*15 translate <-26, 0, 9>}  

#include "grass3.inc"
object{Grass3 scale 0.5 translate <12, 0, 9>}
object{Grass3 scale 0.45 translate <13, 0, 9>}
object{Grass3 scale 0.52 rotate -z*30 translate <-12, 0, 9>}
object{Grass3 scale 0.44 rotate -z*25 translate <-13, 0, 9>}
object{Grass3 scale 0.50 rotate z*20 translate <-15, 0, 9>}

#include "grass4.inc"
object{Grass4 scale 1.10 translate <8, 0, 9>}
object{Grass4 scale 0.75 rotate -z*25 translate <-4.0, 0, 9>}
object{Grass4 scale 0.85 rotate -z*15 translate <-4.5, 0, 9>}
object{Grass4 scale 0.85 rotate z*15 translate <-5, 0, 9>}
object{Grass4 scale 0.75 rotate z*25 translate <-5.5, 0, 9>}
object{Grass4 scale 0.65 rotate z*30 translate <-6, 0, 9>}
