#include "functions.inc"  

#declare StoneTxt = texture{
    pigment{
    	bozo color_map{
    		[0.0 color rgb<0.36, 0.25, 0.15>*1.5]
    		[1.0 color rgb <0.3, 0.2, 0.15>*1.5]
    	}
    	scale <0.4, 0.65, 0.65>
   	}        
}  
texture{
    pigment{
    	gradient -y
    	color_map{
    		[0.0 color rgbft<0.12*1.5, 0.121*1.5, 0.1*1.5, 1, 0>]
    		[0.55 color rgbft<0.12*1.5, 0.121*1.5, 0.1*1.5, 1, 0.85>]
    		[1.0 color rgbt<0, 0, 0, 1>]
    	}
    	turbulence 0.2
    	scale<0.3, 4, 1>
    	translate -y*0.25
   	}
}
texture{
    pigment{
    	gradient y
    	color_map{
    		[0.0 color rgbft<0, 0.07*1.5, 0.06*1.5, 1, 0>]
    		[0.3 color rgbft<0, 0.07*1.5, 0.06*1.5, 1, 0.85>]
    		[1.0 color rgbt<0, 0, 0, 1>]
    	}
    	turbulence 0.05
    	scale<0.35, 4, 1>                  
  		translate<1.5, -2.3, 0>
   	}
   	finish{ambient 0.04 diffuse 0.7 phong 0.05}
}

#declare Brick = isosurface {
  function { f_rounded_box(x,y,z,0.08,0.7,0.3,0.1) + f_noise3d(x*45, y*45, z*45)*0.022}
        max_gradient 2
        contained_by{sphere {0, 1}}
        
        translate y*0.14
		scale 3
}

#declare Brick1 = isosurface {
  function { f_rounded_box(x,y,z,0.08,0.7,0.3,0.1) + f_noise3d(x*45, y*45, z*45)*0.028}
        max_gradient 2
        contained_by{sphere {0, 1}}
        
        translate y*0.14
		scale 3
}   

#declare Brick2 = isosurface {
  function { f_rounded_box(x,y,z,0.08,0.7,0.2,0.4) + f_noise3d(x*45, y*45, z*45)*0.024}
        max_gradient 2
        contained_by{sphere {0, 1}}
        
        translate y*0.14
		scale 2
		rotate -y*90
		translate<0, 1.3, 0.8>
}

#declare Wall = union {
	union { 
		object{Brick rotate z*1 translate<-4.15, 0.02, 10>}
		object{Brick rotate -z*2 translate<-4.15*2, 0, 10>}
		object{Brick1 rotate z*3 translate<-4.15*3, 0.01, 10>}
		object{Brick rotate -z*1 translate<-4.15*4, 0.04, 10>}
		object{Brick rotate -z*3 translate<-4.15*5, 0.01, 10>} 
		object{Brick rotate z*2 translate<-4.15*6, 0.05, 10>}
		object{Brick rotate z*1 translate<-4.15*7, 0.02, 10>} 
		object{Brick1 rotate z*0 translate<-4.15*8, 0.04, 10>}
		object{Brick rotate z*3 translate z*10}
		object{Brick rotate -z*1 translate<4.1, 0.03, 10>}
		object{Brick rotate z*3 translate<4.15*2, 0.06, 10>}
		object{Brick1 rotate -z*1 translate<4.15*3, 0.01, 10>}
		object{Brick1 rotate z*2 translate<4.15*4, 0.04, 10>}
		object{Brick rotate -z*1 translate<4.15*5, 0.02, 10>} 
		object{Brick rotate z*4 translate<4.15*6, 0.05, 10>}  
		object{Brick rotate -z*1 translate<4.15*7, 0.02, 10>} 
		object{Brick rotate z*4 translate<4.15*8, 0.05, 10>} 
	
		texture{StoneTxt translate y*2}   
	} 
                                              
	#declare k = 1.59;
                                              
	union {                                     
		object{Brick2 rotate -z*2 translate<-k*0, 0, 10>}  
		object{Brick2 rotate -z*5 translate<-k*1 - 0.05, 0, 10>}
		object{Brick2 rotate  z*3 translate<-k*2 + 0.14, 0, 10>}
		object{Brick2 rotate -z*2 translate<-k*3, 0, 10>}
		object{Brick2 rotate  z*4 translate<-k*4 + 0.1, 0, 10>}
		object{Brick2 rotate  z*5 translate<-k*5 + 0.2, 0, 10>}
		object{Brick2 rotate -z*3 translate<-k*6, 0, 10>}
		object{Brick2 rotate -z*5 translate<-k*7, 0, 10>}
		object{Brick2 rotate -z*4 translate<-k*8, 0, 10>}
		object{Brick2 rotate  z*3 translate<-k*9 + 0.15, 0, 10>}
		object{Brick2 rotate -z*3 translate<-k*10, 0, 10>}
		object{Brick2 rotate -z*2 translate<-k*11, 0, 10>}  
		object{Brick2 rotate -z*4 translate<-k*12, 0, 10>}
		object{Brick2 rotate  z*2 translate<-k*13 + 0.15, 0, 10>}
		object{Brick2 rotate -z*4 translate<-k*14, 0, 10>}
		object{Brick2 rotate -z*2 translate<-k*15, 0, 10>}
		object{Brick2 rotate  z*3 translate<-k*16, 0, 10>}
		object{Brick2 rotate -z*3 translate<-k*17, 0, 10>}
		object{Brick2 rotate -z*4 translate<-k*18, 0, 10>}
		object{Brick2 rotate  z*3 translate<-k*19, 0, 10>}
		object{Brick2 rotate -z*2 translate<-k*20, 0, 10>}
		object{Brick2 rotate z*1 translate<k, 0, 10>} 
		object{Brick2 rotate -z*2 translate<k*2, 0, 10>}
		object{Brick2 rotate  z*1 translate<k*3, 0, 10>}
		object{Brick2 rotate  z*4 translate<k*4, 0, 10>}
		object{Brick2 rotate -z*1 translate<k*5 - 0.1, 0, 10>}
		object{Brick2 rotate  z*4 translate<k*6, 0, 10>}
		object{Brick2 rotate -z*2 translate<k*7 - 0.05, 0, 10>}
		object{Brick2 rotate -z*4 translate<k*8 - 0.15, 0, 10>}
		object{Brick2 rotate  z*3 translate<k*9, 0, 10>}
		object{Brick2 rotate  z*2 translate<k*10, 0, 10>}
		object{Brick2 rotate -z*1 translate<k*11, 0, 10>}
		object{Brick2 rotate  z*4 translate<k*12, 0, 10>}
		//object{Brick2 rotate -z*2 translate<k*13, 0, 10>}
		object{Brick2 rotate  z*3 translate<k*14, 0, 10>}
		object{Brick2 rotate  z*1 translate<k*15, 0, 10>}
		object{Brick2 rotate -z*3 translate<k*16, 0, 10>}
		object{Brick2 rotate -z*4 translate<k*17, 0, 10>}
		object{Brick2 rotate  z*2 translate<k*18, 0, 10>}
		object{Brick2 rotate  z*1 translate<k*19, 0, 10>}
		object{Brick2 rotate -z*3 translate<k*20, 0, 10>}
	
		texture{StoneTxt translate<2, -1, 0>}
		translate y*0.03
	}
}   
