#declare useRadiosity = 1;

#if(useRadiosity)
	global_settings {
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 500

      nearest_count 10
      error_bound 0.02
      recursion_limit 1

      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
    }}
    sky_sphere{
    	pigment{color rgb<0.1, 0.4, 1>*1.45}
    }
#else
	light_source {<0, 15, -20> color rgb 0.7} 
	light_source {<10, 15, -20> color rgb 0.7}
#end

camera { 
    location <0.35, 0.6, -0.6>
	look_at <0.35, 0.5, 0> 
}

background{color rgb 0.3}

#include "house4.inc"
object{House4 scale 1 rotate -y*80 translate<-0.1, 0, 0>} 
object{House4 scale 1.4 translate<0.17, 0, 1>}
object{House4 scale 1.5 translate<1.2, 0.9, 1.7>}
object{House4 scale 1.5 translate<-1.5, 0.95, 2.1>}
  
#include "house3.inc" 
object{House3 scale 1 rotate -y*80 translate<0.76, 0, -0.1>}
object{House3 scale 1.2 rotate -y*80 translate<1.45, 0, -0.05>}
object{House3 scale 1.4 translate<-1.2, 0.5, 1.55>} 

#include "house1.inc"
object{House1 scale 1.4 translate <-0.7, 0, 0.8>} 
object{House1 scale 1.7 translate<-0.9, 1, 2.7>} 
object{House1 scale 1.8 rotate -y*120 translate<1.5, 0.9, 2.6>}
  
#include "house2.inc"
object{House2 scale 0.6 rotate y*10 translate <-0.04, 0, -0.1>}
object{House2 scale 0.6 translate <-0.04, 0, 0.4> rotate y*10}

#include "house5.inc"
object{House5 scale 1.2 translate <0.02, 0, 1.2>}
                                               
#include "house6.inc"
object{House6 scale 1.6 translate <0.8, 0.2, 1.2>}

plane{y, 0 pigment{color rgb 0.7}}

