// Textures

#declare useColor = 0;
#declare Monochrome = pigment{color rgb 1}

#declare BaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.4}
	#else
		pigment{Monochrome}
	#end
}

#declare WallTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}

#declare CornerTexture = texture {
	#if(useColor)
		pigment{color rgb 0.65}
	#else
		pigment{Monochrome}
	#end
}

#declare AroundWindowTexture = texture {
	#if(useColor)
		pigment{color rgb 0.65}
	#else
		pigment{Monochrome}
	#end
}

#declare NicheTexture = texture {
	#if(useColor)
		pigment{color rgb 0.6}
	#else
		pigment{Monochrome}
	#end
}

#declare RoofTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0.5, 0.6>}
	#else
		pigment{Monochrome}
	#end
}            

#declare ChimneyTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}               

#declare AtticTexture = texture {
	#if(useColor)
		pigment{color rgb <0.6, 0.55, 0.5>}
	#else
		pigment{Monochrome}
	#end
}             

#declare AtticDoorTexture = texture {
	#if(useColor)
		pigment{color rgb <0.5, 0.1, 0.1>}
	#else
		pigment{Monochrome}
	#end
}                 

#declare WindowFrameTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare WindowGlassTexture = texture {
	#if(useColor)
		pigment{color rgb <0, 0.6, 0.65>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyBaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.7}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyTopTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                  

#declare BalconyStickTexture = texture {
	#if(useColor)
		pigment{color rgb 0.7}
	#else
		pigment{Monochrome}
	#end
}

#declare DoorMainTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                

#declare DoorSecondaryTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}

#declare LadderTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0.2, 0>}
	#else
		pigment{Monochrome}
	#end
}

// Objects

#declare Base = union {        
	difference {
		union {
			box{0, <0.58, 0.25, 0.26> texture{WallTexture}}
			// low level
			box{<-0.004, 0, -0.004>, <0.584, 0.02, 0.26> texture{BaseTexture}}
		}
		union {                        
			#local rows = 2; 
			#local cnt = 0;
			#while (cnt < rows)
				// holes for front windows   
				box{<0, 0, -1>, <0.05, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.045}
				box{<0, 0, -1>, <0.07, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.145}
				box{<0, 0, -1>, <0.07, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.365}
				box{<0, 0, -1>, <0.05, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.485}
				// holes for side windows
				box{<0, 0, -1>, <0.05, 0.065, 0.02> rotate y*90 translate y*(0.04 + cnt*0.12) translate z*(0.105 + 0.05)}
				box{<0, 0, -1>, <0.03, 0.065, 0.02> rotate y*90 translate y*(0.04 + cnt*0.12) translate z*(0.185 + 0.03)} 
				box{<0, 0, -1>, <0.05, 0.065, 0.02> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.105>}
				box{<0, 0, -1>, <0.03, 0.065, 0.02> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.185>}
        		#local cnt = cnt + 1;
   			#end
   			// center
			box{<0, 0, -1>, <0.05, 0.065, 0.02> translate y*0.16 translate x*0.265}
			// door
			box{<0, -1, -1>, <0.08, 0.1, 0.01> translate x*0.25}
			texture{NicheTexture}
   		}
	}
	// columns
	union {
		box{<-0.007, 0, -0.007>, <0.02, 0.25, 0.027>}
		box{<0.56, 0, -0.007>, <0.587, 0.25, 0.027>}
		
		texture{CornerTexture}
	}
	// top
	box{<-0.008, 0.25, -0.008>, <0.588, 0.26, 0.26> texture{WallTexture}}
	// around windows
	union {                        
		#local rows = 2; 
		#local cnt = 0;
		#while (cnt < rows)
			difference {   
				union { 
					// front windows
					box{<0, 0, -0.004>, <0.05, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.045}
					box{<0, 0, -0.004>, <0.07, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.145}
					box{<0, 0, -0.004>, <0.07, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.365}
					box{<0, 0, -0.004>, <0.05, 0.065, 0.02> translate y*(0.04 + cnt*0.12) translate x*0.485}
					// side windows
					box{<0, 0, -0.004>, <0.05, 0.065, 0.02> rotate y*90 translate y*(0.04 + cnt*0.12) translate z*0.155}
					box{<0, 0, -0.004>, <0.03, 0.065, 0.02> rotate y*90 translate y*(0.04 + cnt*0.12) translate z*0.215} 
					box{<0, 0, -0.004>, <0.05, 0.065, 0.02> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.105>}
					box{<0, 0, -0.004>, <0.03, 0.065, 0.02> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.185>}
				}
				// holes for windows
				union {
					// front windows
					box{<0.005, 0.01, -1>, <0.045, 0.06, 1> translate y*(0.04 + cnt*0.12) translate x*0.045}
					box{<0.005, 0.01, -1>, <0.065, 0.06, 1> translate y*(0.04 + cnt*0.12) translate x*0.145}
					box{<0.005, 0.01, -1>, <0.065, 0.06, 1> translate y*(0.04 + cnt*0.12) translate x*0.365}
					box{<0.005, 0.01, -1>, <0.045, 0.06, 1> translate y*(0.04 + cnt*0.12) translate x*0.485}
					// side windows
					box{<0.005, 0.01, -1>, <0.045, 0.06, 1> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.105>}
					box{<0.005, 0.01, -1>, <0.025, 0.06, 1> rotate -y*90 translate y*(0.04 + cnt*0.12) translate <0.58, 0, 0.185>}
				}
			}
        	#local cnt = cnt + 1;
   		#end
   		// center
   		difference {
			box{<0, 0, -0.004>, <0.05, 0.065, 0.02> translate y*0.16 translate x*0.265} 
			box{<0.005, 0.01, -1>, <0.045, 0.06, 1> translate y*0.16 translate x*0.265}
		}
		// door
		difference {
			box{<0, 0, -0.004>, <0.08, 0.1, 0.01> translate x*0.25}
			box{<0.01, -1, -1>, <0.07, 0.09, 1> translate x*0.25}
		}
		
		texture{AroundWindowTexture}
   	}
}

#declare Roof = union {
	difference {
		union {
			plane{-z, 0}
			// ribs
			#local st = 15; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0006 translate x*cnt*0.04} 
        		#local cnt = cnt + 1;
   			#end			                                                 
   			rotate x*60 translate -z*0.02
		}
		plane{y, 0}
		plane{-z, 0 translate z*0.26}
		plane{x, 0 rotate -z*30 translate -x*0.02}
		plane{-x, 0 rotate z*30 translate x*0.6}
	} 
	  
	difference {  
		union {
			// ribs
			#local st = 7; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0006 translate z*cnt*0.04 rotate z*30 translate x*0.6}
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0006 translate z*cnt*0.04 rotate -z*30 translate -x*0.02} 
        		#local cnt = cnt + 1;
   			#end			                                                 
		}                                                           
		plane{y, 0}
		plane{z, 0 rotate x*60 translate -z*0.02}
	}
	// ladder
	union {                 
		box{<0.21, 0.01, -0.004>, <0.213, 0.32, 0>}
		box{<0.21, 0.01, -0.004>, <0.213, 0.32, 0> translate x*0.02}
		// steps
		#local st = 30; 
		#local cnt = 0;
		#while (cnt < st)
			box{<0.213, 0.02, -0.002>, <0.23, 0.023, 0> translate y*cnt*0.01}
       		#local cnt = cnt + 1;
  		#end
		
		rotate x*60 translate -z*0.02
		
		texture{LadderTexture}
	}
	         
	translate y*0.26
	
	texture{RoofTexture}
} 

#declare Chimney = difference {
	merge {
		box{<-0.003, 0, -0.003>, <0.043, 0.08, 0.033>}
		box{<0, 0.08, 0>, <0.04, 0.11, 0.03>}
		box{<-0.0025, 0.11, -0.0025>, <0.0425, 0.12, 0.0325>}
		box{<-0.005, 0.12, -0.005>, <0.045, 0.125, 0.035>}
	}
	box{<0.002, -1, 0.002>, <0.038, 1, 0.028>}                     
	
	texture{ChimneyTexture}
} 

#declare Attic = union {
	difference {
		intersection {
			plane{-x, 0}
			plane{x, 0.05}
			plane{-y, 0}
			plane{z, 0.015}
			plane{-z, 0 translate -z*0.015}
			plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
		}
		box{<-1, -1, -0.01>, <1, 0.02, 0.01>}           
		texture{AtticTexture}
	}
	// roof
	difference {
		intersection {
			plane{y, 0 rotate -x*40 translate <0, 0.021, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.021, 0.015>}
			plane{-x, 0 translate -x*0.003}
			plane{x, 0.1}
		}                 
		intersection {
			plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
		}                  
		plane{y, 0 rotate x*40}
		plane{y, 0 rotate -x*40}
		texture{RoofTexture}
	}       
	// ribs
	difference {
		union { 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <-0.003, 0.021, -0.015>}
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.017, 0.021, -0.015>} 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.037, 0.021, -0.015>} 
		}
		plane{-z, 0}
		plane{y, 0 rotate x*40}
		texture{RoofTexture}
	}  
	difference {
		union { 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <-0.003, 0.021, 0.015>}
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.017, 0.021, 0.015>} 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.037, 0.021, 0.015>} 
		}
		plane{z, 0}
		plane{y, 0 rotate -x*40}
		texture{RoofTexture}
	}
	// door              
	union {
		box{<-0.001, 0, -0.01>, <0.01, 0.02, 0.01>}
		difference {
			union {
				#local rows = 11; 
				#local cnt = 2;
				#while (cnt < rows)
					box{<-0.003, 0, -0.01 + 0.001>, <0.0025, 0.0005, 0.01 - 0.001> 
						rotate z*50 translate<0, cnt*(0.0212/rows), 0>
					}
        			#local cnt = cnt + 1;
   				#end 
   			}
   			box{<-1, -1, -0.0005>, <1, 1, 0.0005>}
   		} 
   		texture{AtticDoorTexture}  
   	}
}

#declare Window1 = union {
	difference {
		box{0, <0.04, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.02 - 0.001)}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.049, 0.01> texture{WindowGlassTexture}}
	translate z*0.005
}

#declare Window2 = union {
	difference {
		box{0, <0.06, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.04 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.04 - 0.001)}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.059, 0.049, 0.01> texture{WindowGlassTexture}}
	translate z*0.005
}

#declare Window3 = union {
	difference {
		box{0, <0.02, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.002, 0.035 - 0.001, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.002, 0.05 - 0.002, 1>}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.019, 0.049, 0.01> texture{WindowGlassTexture}}
	translate z*0.005
}  

#declare Windows = union {
	#local rows = 2; 
	#local cnt = 0;
	#while (cnt < rows)
		object{Window1 translate y*(0.05 + cnt*0.12) translate x*0.05}
		object{Window2 translate y*(0.05 + cnt*0.12) translate x*0.145}
		object{Window2 translate y*(0.05 + cnt*0.12) translate x*0.365}
		object{Window1 translate y*(0.05 + cnt*0.12) translate x*0.49}
		// side windows
		object{Window1 rotate y*90 translate y*(0.05 + cnt*0.12) translate z*0.15}
		object{Window3 rotate y*90 translate y*(0.05 + cnt*0.12) translate z*0.21} 
		object{Window1 rotate -y*90 translate y*(0.05 + cnt*0.12) translate <0.58, 0, 0.11>}
		object{Window3 rotate -y*90 translate y*(0.05 + cnt*0.12) translate <0.58, 0, 0.19>}		
       	#local cnt = cnt + 1;
	#end
	// center
	object{Window1 translate y*0.17 translate x*0.27}
} 

#declare Door = union {
	// left
	difference {          
		box{0, <0.0298, 0.09, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.09 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
	}
	// right
	difference {          
		box{0, <0.0298, 0.09, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.09 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
		translate x*0.0302
	}
	translate<0.26, 0, 0.005>
}                                    

#declare HalfHouse2 = union {
	object{Base}                    
	object{Roof}
	object{Chimney translate<0.1, 0.3, 0.14>} 
	object{Chimney translate<0.44, 0.3, 0.14>}
	object{Attic scale 2 rotate -y*90 translate<0.29, 0.29, 0.03>}
	object{Windows}
	object{Door}
}           

#declare House2 = union {
	object{HalfHouse2}
	object{HalfHouse2 rotate -y*180 translate <0.58, 0, 0.52>}
}  
