// Textures

#declare useColor = 0;
#declare Monochrome = pigment{color rgb 1}

#declare BaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.4}
	#else
		pigment{Monochrome}
	#end
}

#declare WallTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}

#declare NicheTexture = texture {
	#if(useColor)
		pigment{color rgb 0.6}
	#else
		pigment{Monochrome}
	#end
}

#declare RoofTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0.5, 0.6>}
	#else
		pigment{Monochrome}
	#end
}            

#declare ChimneyTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}               

#declare AtticTexture = texture {
	#if(useColor)
		pigment{color rgb <0.6, 0.55, 0.5>}
	#else
		pigment{Monochrome}
	#end
}             

#declare AtticDoorTexture = texture {
	#if(useColor)
		pigment{color rgb <0.5, 0.1, 0.1>}
	#else
		pigment{Monochrome}
	#end
}                 

#declare WindowFrameTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare WindowGlassTexture = texture {
	#if(useColor)
		pigment{color rgb <0, 0.6, 0.65>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare DoorMainTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                

#declare DoorSecondaryTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
} 

#declare FireEscapeTexture = texture {
	#if(useColor)
		pigment{color rgb 0.2}
	#else
		pigment{Monochrome}
	#end
}

#declare TopTexture = texture {
	#if(useColor)
		pigment{color rgb 0.6}
	#else
		pigment{Monochrome}
	#end
}

#declare DrainTexture = texture {
	#if(useColor)
		pigment{color rgb 0.9}
	#else
		pigment{Monochrome}
	#end
}

#declare DrainMountTexture = texture {
	#if(useColor)
		pigment{color rgb 0.3}
	#else
		pigment{Monochrome}
	#end
}

// Objects

#declare Base = union {        
	difference {
		union {
			box{0, <0.77, 0.3, 0.2> texture{WallTexture}}
			// low level
			box{<-0.003, 0, -0.003>, <0.773, 0.02, 0.2> texture{BaseTexture}}
		}
		union {                        
			#local rows = 3; 
			#local cnt = 0;
			#while (cnt < rows)
				// holes for front windows   
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*0)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*1)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*2)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*3)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*4)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*5)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*6)}
				box{<0, 0, -1>, <0.04, 0.05, 0.01> translate y*(0.04 + cnt*0.09) translate x*(0.05 + 0.09*7)}
				// holes for side windows
				box{<0, 0, -1>, <0.02, 0.05, 0.01> rotate y*90 translate y*(0.04 + cnt*0.09) translate z*(0.06 + 0.02)}
				box{<0, 0, -1>, <0.02, 0.05, 0.01> rotate y*90 translate y*(0.04 + cnt*0.09) translate z*(0.13 + 0.02)} 
				box{<0, 0, -1>, <0.02, 0.05, 0.01> rotate -y*90 translate y*(0.04 + cnt*0.09) translate <0.77, 0, 0.06>}
				box{<0, 0, -1>, <0.02, 0.05, 0.01> rotate -y*90 translate y*(0.04 + cnt*0.09) translate <0.77, 0, 0.13>}
        		#local cnt = cnt + 1;
   			#end
			// doors
			box{<0, -1, -1>, <0.06, 0.09, 0.011> translate x*0.22}
			box{<0, -1, -1>, <0.06, 0.09, 0.011> translate x*0.49}
			
			texture{NicheTexture}
   		}
	}
	// top
	box{<-0.005, 0.3, -0.005>, <0.775, 0.31, 0.2> texture{WallTexture}}
	box{<-0.01, 0.31, -0.01>, <0.78, 0.32, 0.2> texture{WallTexture}}
}

#declare Roof = union {
	// top                                                              
	difference {
		box{<-1, 0.23, -0.002>, <1, 1, 0.002> rotate x*70 translate -z*0.02 texture{TopTexture}}
		plane{x, 0.0746}
		plane{-z, 0 translate z*0.2}
		plane{-x, 0 translate x*(0.77 - 0.0746)}
	}
	difference {
		union {
			plane{-z, 0}
			// ribs
			#local st = 26; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0.01, -2, 0>, <0.01, 2, 0>, 0.0005 translate x*cnt*0.03} 
        		#local cnt = cnt + 1;
   			#end			                                                 
   			rotate x*70 translate -z*0.02
		}
		plane{y, 0}
		plane{-z, 0 translate z*0.2}
		plane{x, 0 rotate -z*50 translate -x*0.02}
		plane{-x, 0 rotate z*50 translate x*0.79}
	} 
	  
	difference {  
		union {
			// ribs
			#local st = 6; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0005 translate z*(0.035 + cnt*0.03) rotate z*50 translate x*0.79}
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0005 translate z*(0.035 + cnt*0.03) rotate -z*50 translate -x*0.02} 
        		#local cnt = cnt + 1;
   			#end			                                                 
		}                                                           
		plane{y, 0}
		plane{z, 0 rotate x*70 translate -z*0.02}
	}
	         
	translate y*0.32
	
	texture{RoofTexture}
} 

#declare Chimney = difference {
	merge {
		box{<0, -0.1, 0>, <0.04, 0.11, 0.03>}
		box{<-0.003, 0.11, -0.003>, <0.043, 0.115, 0.033>}
		box{<-0.005, 0.115, -0.005>, <0.045, 0.12, 0.035>}
	}
	box{<0.005, -1, 0.005>, <0.035, 1, 0.025>}                     
	
	texture{ChimneyTexture}
} 

#declare Window = union {
	difference {
		box{0, <0.04, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.05 - 0.001, 1>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.02 - 0.001)}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.049, 0.01> texture{WindowGlassTexture}}
	translate z*0.003
}

#declare Window1 = union {
	difference {
		box{0, <0.04, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.02 - 0.001)}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.049, 0.01> texture{WindowGlassTexture}}
	translate z*0.003
}

#declare Window2 = union {
	difference {
		box{0, <0.02, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.002, 0.035 - 0.001, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.002, 0.05 - 0.002, 1>}
		
		texture{WindowFrameTexture}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.019, 0.049, 0.01> texture{WindowGlassTexture}}
}  

#declare Windows = union {
	#local rows = 3; 
	#local cnt = 0;
	#while (cnt < rows)
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.05}
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.14}
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.32}
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.41}
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.59}
		object{Window translate y*(0.04 + cnt*0.09) translate x*0.68}
		// side windows
		object{Window2 rotate y*90 translate y*(0.04 + cnt*0.09) translate z*0.08 translate x*0.003}
		object{Window2 rotate y*90 translate y*(0.04 + cnt*0.09) translate z*0.15 translate x*0.003} 
		object{Window2 rotate -y*90 translate y*(0.04 + cnt*0.09) translate z*0.06 translate x*0.767}
		object{Window2 rotate -y*90 translate y*(0.04 + cnt*0.09) translate z*0.13 translate x*0.767}		

       	#local cnt = cnt + 1;
       	
	#end
	// center
	object{Window1 translate y*0.13 translate x*0.23}
	object{Window1 translate y*0.22 translate x*0.23}
	object{Window1 translate y*0.13 translate x*0.50}
	object{Window1 translate y*0.22 translate x*0.50}
} 

#declare Door = union {
	// left
	difference {          
		box{0, <0.0298, 0.09, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.09 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
	}
	// right
	difference {          
		box{0, <0.0298, 0.09, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.09 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
		translate x*0.0302
	}
}

#declare FireEscape = union {
	cylinder{<0.78, 0.04, 0.19>, <0.78, 0.25, 0.19>, 0.0006}
	cylinder{<0.78, 0.04, 0.21>, <0.78, 0.25, 0.21>, 0.0006}
	
	// steps
	#local st = 21; 
	#local cnt = 0;
	#while (cnt < st)
		cylinder{<0.78, 0.05, 0.19>, <0.78, 0.05, 0.21>, 0.0004 translate y*cnt*0.01}
        #local cnt = cnt + 1;
   	#end
   	
   	difference {
   		torus{0.01, 0.0006 rotate x*90}
   		plane{y, 0}
   		plane{x, 0}
   		translate <0.77, 0.25, 0.19>
   	}
   	difference {
   		torus{0.01, 0.0006 rotate x*90}
   		plane{y, 0}
   		plane{x, 0}
   		translate <0.77, 0.25, 0.21>
   	}
	
	// mount
	#local st = 2; 
	#local cnt = 0;
	#while (cnt < st)
		cylinder{<0.77, 0.07, 0.19>, <0.78, 0.07, 0.19>, 0.0004 translate y*cnt*0.1} 
		cylinder{<0.77, 0.07, 0.21>, <0.78, 0.07, 0.21>, 0.0004 translate y*cnt*0.1}
        #local cnt = cnt + 1;
   	#end
	
	texture{FireEscapeTexture}
	
	translate -z*0.02
} 

#declare Attic = union {
	cylinder{0, <0.1, 0, 0>, 0.025 texture{AtticTexture}}
	difference {
		cylinder{<-0.005, 0, 0>, <0.1, 0, 0>, 0.026}
		cylinder{<-1, 0, 0>, <1, 0, 0>, 0.025}
		texture{RoofTexture}
	}
	// door                                     
	union {
		box{<-0.001, 0, -0.01>, <0.01, 0.02, 0.01>}
		difference {
			union {
				#local rows = 11; 
				#local cnt = 2;
				#while (cnt < rows)
					box{<-0.003, 0, -0.01 + 0.001>, <0.0025, 0.0005, 0.01 - 0.001> 
						rotate z*50 translate<0, cnt*(0.0212/rows), 0>
					}
        			#local cnt = cnt + 1;
   				#end 
   			}
   			box{<-1, -1, -0.0005>, <1, 1, 0.0005>}
   		}
   		texture{AtticDoorTexture}   
   	}
   	// ribs           
   	union {
		torus{0.026, 0.0007 rotate z*90 translate -x*0.005}
		torus{0.026, 0.0007 rotate z*90 translate x*0.015}
		torus{0.026, 0.0007 rotate z*90 translate x*0.035}
		torus{0.026, 0.0007 rotate z*90 translate x*0.055}
		texture{RoofTexture}
	}
}

#declare DrainFront = difference {
	cylinder{<-0.015, 0.32, -0.02>, <0.785, 0.32, -0.02>, 0.003}
	cylinder{<-1, 0.32, -0.02>, <0.785, 0.32, -0.02>, 0.0028}
	plane{-y, 0 translate y*0.32}
	
	texture{DrainTexture}
} 

#declare DrainSide = union { 
	// left
	difference {
		difference {
			cylinder{<0, 0, -0.02>, <0, 0, 0.3>, 0.0035}
			cylinder{<0, 0, -0.1>, <0, 0, 1>, 0.0033}
			plane{-y, 0}
			translate <-0.003, 0.002, 0.001>
			rotate -x*10 rotate -z*50 
			translate -x*0.02
		}                                  
		plane{-z, 0 translate z*0.2}
	} 
    
    // right
    difference {
		difference {
			cylinder{<0, 0, -0.02>, <0, 0, 0.3>, 0.0035}
			cylinder{<0, 0, -0.1>, <0, 0, 1>, 0.0033}
			plane{-y, 0}
			translate <0.003, 0.002, 0.001>
			rotate -x*10 rotate z*50 
			translate x*0.79
		}                                  
		plane{-z, 0 translate z*0.2}
	} 
                   
	translate y*0.32                   
                   
	texture{DrainTexture}
}

#declare HalfHouse3 = union {
	object{Base}                    
	object{Roof}
	object{Chimney translate<0.14, 0.32, 0.14>} 
	object{Chimney translate<0.32, 0.32, 0.14>}
	object{Chimney translate<0.41, 0.32, 0.14>} 
	object{Chimney translate<0.59, 0.32, 0.14>}
	object{Attic scale<1.4, 1.4, 1.1> rotate -y*90 translate<0.25, 0.35, 0.06>} 
	object{Attic scale<1.4, 1.4, 1.1> rotate -y*90 translate<0.52, 0.35, 0.06>}
	object{Windows}
	object{FireEscape}
	object{Door translate<0.22, 0, 0.005>}
	object{Door translate<0.49, 0, 0.005>}
	object{DrainFront} 	
	object{DrainSide}
}           

#declare House3 = union {
	object{HalfHouse3}
	object{HalfHouse3 rotate -y*180 translate <0.77, 0, 0.4>}
}  
