// Textures

#declare useColor = 0;
#declare Monochrome = pigment{color rgb 1.1}

#declare BaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.4}
	#else
		pigment{Monochrome}
	#end
}

#declare WallTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}

#declare NicheTexture = texture {
	#if(useColor)
		pigment{color rgb 0.6}
	#else
		pigment{Monochrome}
	#end
}

#declare RoofTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0.5, 0.6>}
	#else
		pigment{Monochrome}
	#end
}            

#declare ChimneyTexture = texture {
	pigment{color rgb 0.75}
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}               

#declare AtticTexture = texture {
	#if(useColor)
		pigment{color rgb <0.6, 0.55, 0.5>}
	#else
		pigment{Monochrome}
	#end	
}             

#declare AtticDoorTexture = texture {
	#if(useColor)
		pigment{color rgb <0.5, 0.1, 0.1>}
	#else
		pigment{Monochrome}
	#end
}                 

#declare WindowFrameTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end	
}                   

#declare WindowGlassTexture = texture {
	#if(useColor)
		pigment{color rgb <0, 0.6, 0.65>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyBaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.2}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyTopTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end	
}                  

#declare BalconyStickTexture = texture {
	#if(useColor)
		pigment{color rgb 0.7}
	#else
		pigment{Monochrome}
	#end	
}

#declare DoorMainTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                

#declare DoorSecondaryTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}

#declare BlockTexture = texture {
	#if(useColor)
		pigment{color rgb 0.3}
	#else
		pigment{Monochrome}
	#end	
} 

#declare LadderTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0.2, 0>}
	#else
		pigment{Monochrome}
	#end
}

#declare FenceTexture = texture {
	#if(useColor)
		pigment{color rgb 0.5}
	#else
		pigment{Monochrome}
	#end	
}

// Objects

#declare Base = difference {
	union {
		box{0, <0.66, 0.4, 0.15> texture {WallTexture}}
		// low level
		box{<-0.002, 0, -0.002>, <0.662, 0.025, 0.15> texture{BaseTexture}}
	}
	union {           
		plane{z, 0 rotate x*45 translate y*0.3}
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*0.00}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*0.09}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*0.18} 
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*0.00}
		box{<0.04, 0.03, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*0.09}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*0.18}
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*0.00}
		box{<0.04, 0.03, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*0.09}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*0.18} 
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*(0.37 + 0.00)}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*(0.37 + 0.09)}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate x*(0.37 + 0.18)} 
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*(0.37 + 0.00)}
		box{<0.04, 0.03, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*(0.37 + 0.09)}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*(0.37 + 0.18)}
			
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*(0.37 + 0.00)}
		box{<0.04, 0.03, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*(0.37 + 0.09)}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*(0.37 + 0.18)}
			
		// center
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.09 translate x*(0.29 - 0.015)}
		box{<0.04, 0.05, -1>, <0.07, 0.1, 0.02> translate y*0.18 translate x*(0.29 - 0.015)}
		// doors
		box{<0, -1, -1>, <0.06, 0.08, 0.015> translate x*0.3}
			
		// side windows
		box{<-1, 0.05, 0.09>, <0.02, 0.1, 0.11>}
		box{<-1, 0.05, 0.09>, <0.02, 0.1, 0.11> translate y*0.09}
		box{<-1, 0.05, 0.09>, <0.02, 0.1, 0.11> translate y*0.18}
			
		box{<0.64, 0.05, 0.09>, <1, 0.1, 0.11>}
		box{<0.64, 0.05, 0.09>, <1, 0.1, 0.11> translate y*0.09}
		box{<0.64, 0.05, 0.09>, <1, 0.1, 0.11> translate y*0.18}
			
		cylinder{<-1, 0.35, 0.15>, <1, 0.35, 0.15>, 0.015}
		
		texture{NicheTexture}
	}
}

#declare Roof = union {
	box{<-0.01, 0, -0.154>, <0.67, 0.001, 0> rotate -x*45 translate <0, 0.4, 0.1>}
	box{<-0.01, 0.4, 0.1>, <0.67, 0.401, 0.15>}

	// ribs
	#local st = 33; 
	#local cnt = 0;
	#while (cnt < st)
		cylinder{<0.01, 0.001, -0.154>, <0.01, 0.001, 0>, 0.0004 rotate -x*45 translate <cnt*0.02, 0.4, 0.1>} 
		cylinder{<0.01, 0.401, 0.1>, <0.01, 0.401, 0.15>, 0.0004 translate x*cnt*0.02} 
   		#local cnt = cnt + 1;
	#end			             
	
	// ladders
	union {                 
		box{<0, 0, -0.004>, <0.002, 0.15, 0>}
		box{<0, 0, -0.004>, <0.002, 0.15, 0> translate x*0.015}
		// steps
		#local st = 14; 
		#local cnt = 0;
		#while (cnt < st)
			box{<0.002, 0.01, -0.002>, <0.015, 0.012, 0> translate y*cnt*0.01}
       		#local cnt = cnt + 1;
  		#end
		
		translate -y*0.005 rotate x*45 translate <0.14, 0.3, 0>
		
		texture{LadderTexture}
	}
	union {                 
		box{<0, 0, -0.004>, <0.002, 0.15, 0>}
		box{<0, 0, -0.004>, <0.002, 0.15, 0> translate x*0.015}
		// steps
		#local st = 14; 
		#local cnt = 0;
		#while (cnt < st)
			box{<0.002, 0.01, -0.002>, <0.015, 0.012, 0> translate y*cnt*0.01}
       		#local cnt = cnt + 1;
  		#end
		
		translate -y*0.005 rotate x*45 translate <0.52 - 0.015, 0.3, 0>
		
		texture{LadderTexture}
	}                                    

	texture{RoofTexture}
} 

#declare Chimney = difference {
	merge {
		box{<0, 0.3, 0>, <0.02, 0.4, 0.05>}
		box{<-0.002, 0.4, -0.002>, <0.022, 0.41, 0.052>}
		box{<-0.003, 0.41, -0.003>, <0.023, 0.415, 0.053>}
	}
	box{<0.005, -1, 0.005>, <0.015, 1, 0.045>}                     
	
	texture{ChimneyTexture}
} 

#declare Window1 = union {
	// frame
	difference {
		box{0, <0.03, 0.07, 0.002>}
		box{<0.00125, 0.035 - 0.00125, -1>, <0.03 - 0.00125, 0.05 - 0.00125, 1>}
		box{<0.00125, 0.00125, -1>, <0.01 - 0.00125, 0.035 - 0.00125*2, 1>} 
		box{<0.01, 0.00125, -1>, <0.02, 0.035 - 0.00125*2, 1>}
		box{<0.02 + 0.00125, 0.00125, -1>, <0.03 - 0.00125, 0.035 - 0.00125*2, 1>}
	
		texture{WindowFrameTexture}
	}                                                                            
	// block
	box{<-0.002, -0.003, -0.011>, <0.032, 0.0001, 0.012> texture{BlockTexture}}
	// glass
	box{<0.001, 0.001, 0.001>, <0.029, 0.049, 0.003> texture{WindowGlassTexture}}
	
	translate z*0.01
} 

#declare Window2 = union {
	// frame
	difference {
		box{0, <0.03, 0.07, 0.002>}
		box{<0.00125, 0.00125, -1>, <0.03 - 0.00125, 0.07 - 0.00125, 1>}
		texture{WindowFrameTexture}
	}                           
	union {
		box{<0.015 - 0.001, 0.001, 0>, <0.015 + 0.001, 0.0699, 0.002>}
		box{<0.001, 0.02, 0>, <0.029, 0.02125, 0.002>}
		box{<0.001, 0.05, 0>, <0.029, 0.05125, 0.002>}
		texture{WindowFrameTexture}
	}
	// glass
	box{<0.001, 0.001, 0.001>, <0.029, 0.069, 0.003> texture{WindowGlassTexture}}
	// balcony
	box{<-0.01, -0.003, -0.03>, <0.04, 0, 0> texture{BalconyBaseTexture}}
	difference {
		box{<-0.01, 0.025, -0.03>, <0.04, 0.0257, 0>}
		box{<-0.008, -1, -0.028>, <0.038, 1, 1>}
		texture{BalconyTopTexture}
	}
	#local st = 11; 
	#local cnt = 0;
	#local incr = (0.009 + 0.039)/10;
	#while (cnt < st)
		cylinder{<-0.009, 0, -0.029>, <-0.009, 0.025, -0.029>, 0.0004 texture{BalconyStickTexture} translate x*cnt*incr} 
   		#local cnt = cnt + 1;
	#end
	#local st = 5; 
	#local cnt = 0;
	#local incr = 0.03/6;	
	#while (cnt < st)
		cylinder{<-0.009, 0, -0.025>, <-0.009, 0.025, -0.025>, 0.0004 translate z*cnt*incr texture{BalconyStickTexture}}
		cylinder{<0.039, 0, -0.025>, <0.039, 0.025, -0.025>, 0.0004 translate z*cnt*incr texture{BalconyStickTexture}} 
   		#local cnt = cnt + 1;
	#end
	
	translate z*0.01                                                 
}

#declare Window3 = union {
	difference {
		box{0, <0.02, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.002, 0.035 - 0.001, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.002, 0.05 - 0.002, 1>}
		
		texture{WindowFrameTexture}
	}
	// block
	box{<-0.002, -0.003, -0.011>, <0.022, 0.0001, 0.012> texture{BlockTexture}} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.019, 0.049, 0.01> texture{WindowGlassTexture}}
}  

#declare Window4 = union {
	difference {                                        
		cylinder{<0.005, 0.35, 0.15>, <0.02, 0.35, 0.15>, 0.015}
		cylinder{<-1, 0.35, 0.15>, <1, 0.35, 0.15>, 0.013}
	}
	box{<0.005, 0.35-0.015, 0.149>, <0.02, 0.35+0.015, 0.151>}
	box{<0.005, 0.35-0.001, 0.151-0.015>, <0.02, 0.35+0.001, 0.152+0.015>} 
	// glass 
	cylinder{<0.006, 0.35, 0.15>, <0.02, 0.35, 0.15>, 0.015 texture{WindowGlassTexture}}
	
	texture{WindowFrameTexture}
}

#declare Windows = union {
	
	// center
	object{Window1 translate y*0.05 translate x*0.04}
	object{Window1 translate y*0.05 translate x*0.13}
	object{Window1 translate y*0.05 translate x*0.22} 
			
	object{Window1 translate y*0.14 translate x*0.04}
	object{Window2 translate y*0.12 translate x*0.13}
	object{Window1 translate y*0.14 translate x*0.22}
			
	object{Window1 translate y*0.23 translate x*0.04}
	object{Window2 translate y*0.21 translate x*0.13}
	object{Window1 translate y*0.23 translate x*0.22} 
			
	object{Window1 translate y*0.05 translate x*(0.37 + 0.04)}
	object{Window1 translate y*0.05 translate x*(0.37 + 0.13)}
	object{Window1 translate y*0.05 translate x*(0.37 + 0.22)} 
			
	object{Window1 translate y*0.14 translate x*(0.37 + 0.04)} 
	object{Window2 translate y*0.12 translate x*0.50}
	object{Window1 translate y*0.14 translate x*(0.37 + 0.22)}
			
	object{Window1 translate y*0.23 translate x*(0.37 + 0.04)} 
	object{Window2 translate y*0.21 translate x*0.5}
	object{Window1 translate y*0.23 translate x*(0.37 + 0.22)}
			
 	// center
 	object{Window1 translate y*0.14 translate x*(0.33 - 0.015)}
 	object{Window1 translate y*0.23 translate x*(0.33 - 0.015)}
			
	// side windows
	object{Window3 translate -x*0.02 rotate y*90 translate<0.01, 0.05, 0.09>}  
	object{Window3 translate -x*0.02 rotate y*90 translate<0.01, 0.14, 0.09>}
	object{Window3 translate -x*0.02 rotate y*90 translate<0.01, 0.23, 0.09>} 
	
	object{Window3 rotate -y*90 translate<0.65, 0.05, 0.09>}  
	object{Window3 rotate -y*90 translate<0.65, 0.14, 0.09>}
	object{Window3 rotate -y*90 translate<0.65, 0.23, 0.09>}
	
	// Attic
	object{Window4}
} 

#declare Door = union {
	// left
	difference {          
		box{0, <0.0298, 0.08, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.08 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
	}
	// right
	difference {          
		box{0, <0.0298, 0.08, 0.01> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.03 - 0.005, 0.04, 0.0009> texture{DoorSecondaryTexture}}
		box{<0.005, 0.045, -1>, <0.03 - 0.005, 0.08 - 0.005, 0.0009> texture{DoorSecondaryTexture}}
		translate x*0.0302
	}
}

#declare Attic = union {
	difference {
		intersection {
			plane{-x, 0}
			plane{x, 0.05}
			plane{-y, 0}
			plane{z, 0.015}
			plane{-z, 0 translate -z*0.015}
			plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
		}
		box{<-1, -1, -0.01>, <1, 0.02, 0.01>}
		texture{AtticTexture}           
	}
	// roof
	difference {
		intersection {
			plane{y, 0 rotate -x*40 translate <0, 0.021, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.021, 0.015>}
			plane{-x, 0 translate -x*0.003}
			plane{x, 0.1}
		}                 
		intersection {
			plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
		}                  
		plane{y, 0 rotate x*40}
		plane{y, 0 rotate -x*40}
		texture{RoofTexture}
	}       
	// ribs
	difference {
		union { 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <-0.003, 0.021, -0.015>}
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.017, 0.021, -0.015>} 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.037, 0.021, -0.015>} 
		}
		plane{-z, 0}
		plane{y, 0 rotate x*40}
		texture{RoofTexture}
	}  
	difference {
		union { 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <-0.003, 0.021, 0.015>}
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.017, 0.021, 0.015>} 
			cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.037, 0.021, 0.015>} 
		}
		plane{z, 0}
		plane{y, 0 rotate -x*40}
		texture{RoofTexture}
	}
	// door
	union {
		box{<-0.001, 0, -0.01>, <0.01, 0.02, 0.01>}
		difference {
			union {
				#local rows = 11; 
				#local cnt = 2;
				#while (cnt < rows)
					box{<-0.003, 0, -0.01 + 0.001>, <0.0025, 0.0005, 0.01 - 0.001> 
						rotate z*50 translate<0, cnt*(0.0212/rows), 0>
					}
        			#local cnt = cnt + 1;
   				#end 
   			}
   			box{<-1, -1, -0.0005>, <1, 1, 0.0005>}
   		}   
   		texture{AtticDoorTexture}
   	}
}

#declare Fence = union {
	cylinder{<-0.002, 0.31, -0.008>, <0.662, 0.31, -0.008>, 0.00035}
	#local st = 68; 
	#local cnt = 0;
	#local incr = 0.664/67;
	#while (cnt < st)
		cylinder{<-0.002, 0.292, -0.008>, <-0.002, 0.31, -0.008>, 0.0003 translate x*cnt*incr}
   		#local cnt = cnt + 1;
 	#end 	
 	texture{FenceTexture}
}

#declare HalfHouse4 = union {
	object{Base}
	                    
	object{Roof} 
	object{Chimney translate<0.09, 0.01, 0.03>} 
	object{Chimney translate<0.27, 0.01, 0.03>}
	object{Chimney translate<0.37, 0.01, 0.03>} 
	object{Chimney translate<0.55, 0.01, 0.03>} 
	object{Windows}
	object{Attic scale <1.4, 1.1, 1.4> rotate -y*90 translate<0.19, 0.333, 0.03>}
	object{Attic scale <1.4, 1.1, 1.4> rotate -y*90 translate<0.66 - 0.19, 0.333, 0.03>}	
	object{Door translate<0.3, 0, 0.005>}
	object{Fence}
}           

#declare House4 = union {
	object{HalfHouse4}
	object{HalfHouse4 rotate -y*180 translate <0.66, 0, 0.3>}
}  
