// Textures

#declare Monochrome = pigment{color rgb 1}

#declare BaseTexture = texture {
		pigment{Monochrome}
} 

// Objects

#declare Window1 = union {
	difference {
		box{0, <0.04, 0.05, 0.01>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1>}
		box{<0.002, 0.002, -1>, <0.02 - 0.001, 0.035 - 0.001, 1> translate x*(0.02 - 0.001)}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1>}
		box{<0.002, 0.035 + 0.001, -1>, <0.02 - 0.001, 0.05 - 0.002, 1> translate x*(0.02 - 0.001)}
	} 
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.049, 0.01>}
	translate -z*0.002
}

#declare Window2 = union {
	// frame
	difference {
		box{0, <0.04, 0.08, 0.004>}
		box{<0.00125, 0.00125, -1>, <0.04 - 0.00125, 0.08 - 0.00125, 1>}
	}                           
	union {
		box{<0.02 - 0.001, 0.001, 0>, <0.02 + 0.001, 0.0799, 0.002>}
		box{<0.001, 0.02, 0>, <0.039, 0.02125, 0.002>}
		box{<0.001, 0.06, 0>, <0.039, 0.06125, 0.002>}
	}
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.079, 0.003>}
	// balcony
	box{<-0.01, -0.003, -0.03>, <0.05, 0, 0.01>}
	difference {
		box{<-0.01, 0.03, -0.03>, <0.05, 0.0307, 0.01>}
		box{<-0.008, -1, -0.028>, <0.048, 1, 1>}
	}
	#local st = 11; 
	#local cnt = 0;
	#local incr = (0.009 + 0.049)/10;
	#while (cnt < st)
		cylinder{<-0.009, 0, -0.029>, <-0.009, 0.03, -0.029>, 0.0004 translate x*cnt*incr} 
   		#local cnt = cnt + 1;
	#end
	#local st = 5; 
	#local cnt = 0;
	#local incr = 0.03/6;	
	#while (cnt < st)
		cylinder{<-0.009, 0, -0.025>, <-0.009, 0.03, -0.025>, 0.0004 translate z*cnt*incr}
		cylinder{<0.049, 0, -0.025>, <0.049, 0.03, -0.025>, 0.0004 translate z*cnt*incr} 
   		#local cnt = cnt + 1;
	#end
	
	translate -z*0.002                                                 
}

#declare Block = union {
	// base
	box{0, <0.3, 0.18, 0.1>}
	// columns                              
	union {
		box{<0, 0, -0.0007>, <0.01, 0.18, 0.01>} 
		
		box{<0.09, 0, -0.0005>, <0.11, 0.18, 0.01>}
		box{<0.095, 0, -0.0007>, <0.105, 0.18, 0.01>}
		
		box{<0.19, 0, -0.0005>, <0.21, 0.18, 0.01>}
		box{<0.195, 0, -0.0007>, <0.205, 0.18, 0.01>}
		
		box{<0.29, 0, -0.0007>, <0.3, 0.18, 0.01>}	
	}                                          
	// under windows                           
	union {
		box{<0.01, 0, -0.0003>, <0.09, 0.03, 0.09>}
		box{<0.01, 0.005, -0.0004>, <0.09, 0.025, 0.09>}
		
		box{<0.01, 0, -0.0003>, <0.09, 0.03, 0.09> translate x*0.2}
		box{<0.01, 0.005, -0.0004>, <0.09, 0.025, 0.09> translate x*0.2}
	}
	// windows
	object{Window1 translate<0.03, 0.03, 0>}
	object{Window1 translate<0.23, 0.03, 0>}
	object{Window1 translate<0.03, 0.12, 0>}
	object{Window1 translate<0.23, 0.12, 0>}
	
	object{Window2 translate<0.13, 0, 0>}
	object{Window2 translate<0.13, 0.09, 0>}
}

#declare HalfHouse5 = union { 
	// 1 floor
	object{Block}                                 
	object{Block translate x*0.3}
	// 2 floor
	object{Block translate y*0.18}
	object{Block translate <0.3, 0.18, 0>}
	// 3 floor
	object{Block translate y*0.18*2}
	object{Block translate <0.3, 0.18*2, 0>}
	// 4 floor
	object{Block translate y*0.18*3}
	object{Block translate <0.3, 0.18*3, 0>}
	// 5 floor
	object{Block translate y*0.18*4}
	object{Block translate <0.3, 0.18*4, 0>}
	// 6 floor
	object{Block translate y*0.18*5}
	object{Block translate <0.3, 0.18*5, 0>}
	
	texture{BaseTexture}
}           

#declare House5 = union {
	object{HalfHouse5}
	object{HalfHouse5 rotate -y*180 translate <0.6, 0, 0.2>} 
}  
