// Textures

#declare useColor = 0;
#declare Monochrome = pigment{color rgb 1.1}

#declare BaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.4}
	#else
		pigment{Monochrome}
	#end	
}

#declare WallTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}

#declare NicheTexture = texture {
	#if(useColor)
		pigment{color rgb 0.6}
	#else
		pigment{Monochrome}
	#end
}

#declare BoundTexture = texture {
	#if(useColor)
		pigment{color rgb 0.5}
	#else
		pigment{Monochrome}
	#end
}                      

#declare BlockTexture = texture {
	#if(useColor)
		pigment{color rgb 0.8}
	#else
		pigment{Monochrome}
	#end
}

#declare DrainTexture = texture {
	#if(useColor)
		pigment{color rgb <0, 0.6, 0.7>}
	#else
		pigment{Monochrome}
	#end
}

#declare DrainMountTexture = texture {
	#if(useColor)
		pigment{color rgb 0.3}
	#else
		pigment{Monochrome}
	#end
}

#declare RoofTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0.5, 0.6>}
	#else
		pigment{Monochrome}
	#end
}            

#declare ChimneyTexture = texture {
	#if(useColor)
		pigment{color rgb 0.75}
	#else
		pigment{Monochrome}
	#end
}               

#declare AtticTexture = texture {
	#if(useColor)
		pigment{color rgb <0.6, 0.55, 0.5>}
	#else
		pigment{Monochrome}
	#end
}             

#declare AtticDoorTexture = texture {
	#if(useColor)
		pigment{color rgb <0.5, 0.1, 0.1>}
	#else
		pigment{Monochrome}
	#end
}                 

#declare WindowFrameTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare WindowGlassTexture = texture {
	#if(useColor)
		pigment{color rgb <0, 0.6, 0.65>}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyBaseTexture = texture {
	#if(useColor)
		pigment{color rgb 0.7}
	#else
		pigment{Monochrome}
	#end
}                   

#declare BalconyTopTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                  

#declare BalconyStickTexture = texture {
	#if(useColor)
		pigment{color rgb 0.7}
	#else
		pigment{Monochrome}
	#end
}

#declare DoorMainTexture = texture {
	#if(useColor)
		pigment{color rgb <0.3, 0, 0>}
	#else
		pigment{Monochrome}
	#end
}                

#declare DoorSecondaryTexture = texture {
	#if(useColor)
		pigment{color rgb <0.4, 0, 0>}
	#else
		pigment{Monochrome}
	#end
} 

#declare FireEscapeTexture = texture {
	#if(useColor)
		pigment{color rgb 0.2}
	#else
		pigment{Monochrome}
	#end
}

// Objects

#declare Base = difference{        
	box{0, <0.6, 0.4, 0.1> texture{WallTexture}}
	
	// holes for stairway windows
	box{<0.13, -1, -1>, <0.17, 0.37, 0.0055> texture{NicheTexture}}
	box{<0.13, -1, -1>, <0.17, 0.37, 0.0055> texture{NicheTexture} translate x*0.3}
	
	union {
		#local rows = 4; 
		#local cnt = 0;
		#while (cnt < rows)
			// holes for front windows   
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.00}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.06}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.17}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.23}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.30}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.36}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.47}
			box{<0.02, 0.03, -1>, <0.05, 0.07, 0.01> translate y*cnt*0.1 translate x*0.53}
			// holes for side windows
			box{<-1, 0.03, 0.02>, <0.01, 0.07, 0.04> translate y*cnt*0.1 translate z*0.03}
			box{<0.59, 0.03, 0.02>, <1, 0.07, 0.04> translate y*cnt*0.1 translate z*0.03}
		
        	#local cnt = cnt + 1;
   		#end
   		texture{NicheTexture}
   	}
}

#declare Stripes = union{
	difference{ 
		box{<-0.002, 0, -0.002>, <0.602, 0.01, 0.1> texture{BoundTexture}}
		// holes for stairway windows
		box{<0.132, -1, -1>, <0.168, 0.37, 0.005-0.001> texture{NicheTexture}}
		box{<0.132, -1, -1>, <0.168, 0.37, 0.005-0.001> texture{NicheTexture} translate x*0.3}
	}  
	difference{ 
		box{<-0.003, 0.003, -0.003>, <0.603, 0.007, 0.1> texture{BoundTexture}}
		// holes for stairway windows
		box{<0.133, -1, -1>, <0.167, 0.37, 0.005-0.002> texture{NicheTexture}}
		box{<0.133, -1, -1>, <0.167, 0.37, 0.005-0.002> texture{NicheTexture} translate x*0.3}
	}
}

#declare Eaves = union {
	box{<-0.0005, 0, -0.0005>, <0.6005, 0.01, 0.1>}
	box{<-0.001, 0.002, -0.001>, <0.601, 0.01, 0.1>}
	box{<-0.0015, 0.005, -0.0015>, <0.6015, 0.01, 0.1>}
	translate y*(0.4 - 0.01)
	
	texture{BoundTexture}
} 

#declare DrainFront = difference {
	cylinder{<-0.004, 0.4, -0.004>, <0.604, 0.4, -0.004>, 0.0025}
	cylinder{<-0.006, 0.4, -0.004>, <0.606, 0.4, -0.004>, 0.0023}
	plane{-y, 0 translate y*0.4}
	box{<0, 0, -1>, <0.01, 1, 1> translate x*0.295}                                
	translate -z*0.0025
	
	texture{DrainTexture}
} 

#declare DrainSide = difference {
	cylinder{<0, 0.4, -0.004>, <0, 0.4, 0.1>, 0.0025}
	cylinder{<0, 0.4, -0.006>, <0, 0.4, 0.2>, 0.0023}
	plane{-y, 0 translate y*0.4}

	texture{DrainTexture}
}

#declare FireEscape = union {
	cylinder{<0.61, 0.02, 0.1>, <0.61, 0.405, 0.1>, 0.0003}
	cylinder{<0.61, 0.02, 0.112>, <0.61, 0.405, 0.112>, 0.0003}
	
	// steps
	#local st = 38; 
	#local cnt = 0;
	#while (cnt < st)
		cylinder{<0.61, 0.03, 0.1>, <0.61, 0.03, 0.112>, 0.0002 translate y*cnt*0.01}
        #local cnt = cnt + 1;
   	#end
   	
   	difference {
   		torus{0.005, 0.0003 rotate x*90}
   		plane{y, 0}
   		translate <0.61 - 0.005, 0.405, 0.1>
   	}
   	difference {
   		torus{0.005, 0.0003 rotate x*90}
   		plane{y, 0}
   		translate <0.61 - 0.005, 0.405, 0.112>
   	}
	
	cylinder{<0.6, 0.4, 0.1>, <0.6, 0.405, 0.1>, 0.0003}
	cylinder{<0.6, 0.4, 0.112>, <0.6, 0.405, 0.112>, 0.0003}
	
	// mount
	#local st = 4; 
	#local cnt = 0;
	#while (cnt < st)
		cylinder{<0.6, 0.055, 0.1>, <0.61, 0.055, 0.1>, 0.0002 translate y*cnt*0.1} 
		cylinder{<0.6, 0.055, 0.112>, <0.61, 0.055, 0.112>, 0.0002 translate y*cnt*0.1}
        #local cnt = cnt + 1;
   	#end
	
	translate -z*0.006
	
	texture{FireEscapeTexture}
}

#declare DrainPipe = union {
	cylinder{<0, 0.02, 0>, <0, 0.38, 0>, 0.002}
	
	difference {
		cylinder{<0, 0.02, 0>, <0, 0.01, 0>, 0.002}
		cylinder{<0, -0.02, 0>, <0, 0.1, 0>, 0.0018}
		            
		translate -y*0.02
		translate -x*0.002 rotate -z*35 translate <0.002, 0.02, 0>
	}
	
	union {
		cylinder{0, <0, 0.01, 0>, 0.002}
		difference {
			cylinder{0, <0, 0.01, 0>, 0.002}
			cylinder{<0, -1, 0>, <0, 0.1, 0>, 0.0018}
			
			translate x*0.002 rotate -z*25 translate <-0.002, 0.01, 0>
		}
		difference {
			cone{<0, 0.01, 0>, 0.002, <0, 0.012, 0>, 0.005}           
			cone{<0, 0.01 - 0.0001, 0>, 0.0018, <0, 0.012 + 0.0001, 0>, 0.0048}
			
			translate x*0.002 rotate -z*25 translate <-0.002, 0.01, 0>
		}
		
		translate -x*0.002 rotate z*25 translate <0.002, 0.38, 0>
	}
	
	texture{DrainTexture}
}

#declare DrainPipeMount = union {
	torus{0.0022, 0.0005 translate <0, 0.05, 0>}
	torus{0.0022, 0.0005 translate <0, 0.05+0.1, 0>}
	torus{0.0022, 0.0005 translate <0, 0.05+0.2, 0>}
	torus{0.0022, 0.0005 translate <0, 0.05+0.3, 0>}
	cylinder{<0, 0, 0.0022>, <0, 0, 0.01>, 0.0005 translate <0, 0.05, 0>}
	cylinder{<0, 0, 0.0022>, <0, 0, 0.01>, 0.0005 translate <0, 0.05+0.1, 0>}
	cylinder{<0, 0, 0.0022>, <0, 0, 0.01>, 0.0005 translate <0, 0.05+0.2, 0>}
	cylinder{<0, 0, 0.0022>, <0, 0, 0.01>, 0.0005 translate <0, 0.05+0.3, 0>}
	
	texture{DrainMountTexture}
}

#declare Roof = union {
	difference {
		union {
			plane{-z, 0}
			// ribs
			#local st = 30; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0004 translate x*cnt*0.02} 
        		#local cnt = cnt + 1;
   			#end			                                                 
   			rotate x*55 translate -z*0.004
		}
		plane{y, 0}
		plane{-z, 0 translate 0.1}
		plane{x, 0 rotate -z*55 translate -x*0.004}
		plane{-x, 0 rotate z*55 translate x*0.604}
	} 
	  
	difference {  
		union {
			// ribs
			#local st = 6; 
			#local cnt = 0;
			#while (cnt < st)
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0004 translate z*cnt*0.02 rotate z*55 translate x*0.604}
				cylinder{<0, -2, 0>, <0, 2, 0>, 0.0004 translate z*cnt*0.02 rotate -z*55 translate -x*0.004} 
        		#local cnt = cnt + 1;
   			#end			                                                 
		}                                                           
		plane{y, 0}
		plane{z, 0 rotate x*55 translate -z*0.004}
	}
	         
	translate y*0.4
	
	texture{RoofTexture}
} 

#declare Chimney = difference {
	merge {
		box{0, <0.03, 0.05, 0.02>}
		box{<0.003, 0, 0.003>, <0.03 - 0.003, 0.068, 0.02 - 0.003>}
		box{<0.002, 0.065, 0.002>, <0.03 - 0.002, 0.069, 0.02 - 0.002>}
		box{<0.001, 0.068, 0.001>, <0.03 - 0.001, 0.07, 0.02 - 0.001>}
	}
	box{<0.005, -1, 0.0055>, <0.03 - 0.005, 1, 0.02 - 0.0055>}                     
	
	texture{ChimneyTexture}
} 

#declare Fence = union {
	cylinder{<-0.004, 0.41, -0.004>, <0.604, 0.41, -0.004>, 0.00035}
	#local st = 61; 
	#local cnt = 0;
	#local incr = (0.6 + (0.004 * 2))/60;
	#while (cnt < st)
		cylinder{<-0.004, 0.4, -0.004>, <-0.004, 0.41, -0.004>, 0.0003 translate x*cnt*incr}
   		#local cnt = cnt + 1;
 	#end
 	
 	cylinder{<-0.004, 0.41, -0.004>, <-0.004, 0.41, 0.09>, 0.00035}
 	#local st = 10; 
	#local cnt = 0;
	#local incr = 0.094/10;
	#while (cnt < st)
		cylinder{<-0.004, 0.4, -0.004>, <-0.004, 0.41, -0.004>, 0.0003 translate z*(incr + cnt*incr)}
   		#local cnt = cnt + 1;
 	#end
 	
 	cylinder{<-0.004, 0.41, 0.11>, <-0.004, 0.41, 0.204>, 0.00035}
 	#local st = 10; 
	#local cnt = 0;
	#local incr = 0.094/10;
	#while (cnt < st)
		cylinder{<-0.004, 0.4, 0.11>, <-0.004, 0.41, 0.11>, 0.0003 translate z*cnt*incr}
   		#local cnt = cnt + 1;
 	#end
 	
 	texture{FireEscapeTexture}
}

#declare Attic = union {
	difference {
		intersection {
			plane{-x, 0}
			plane{x, 0.05}
			plane{-y, 0}
			plane{z, 0.015}
			plane{-z, 0 translate -z*0.015}
			plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
			plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
		}
		box{<-1, -1, -0.01>, <1, 0.02, 0.01>}           
		texture{AtticTexture}
	}
	// roof
	union {
		difference {
			intersection {
				plane{y, 0 rotate -x*40 translate <0, 0.021, -0.015>}
				plane{y, 0 rotate x*40 translate <0, 0.021, 0.015>}
				plane{-x, 0 translate -x*0.003}
				plane{x, 0.1}
			}                 
			intersection {
				plane{y, 0 rotate -x*40 translate <0, 0.02, -0.015>}
				plane{y, 0 rotate x*40 translate <0, 0.02, 0.015>}
			}                  
			plane{y, 0 rotate x*40}
			plane{y, 0 rotate -x*40}
		}       
		// ribs
		difference {
			union { 
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <-0.003, 0.021, -0.015>}
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.017, 0.021, -0.015>} 
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate -x*40 translate <0.037, 0.021, -0.015>} 
			}
			plane{-z, 0}
			plane{y, 0 rotate x*40}
		}  
		difference {
			union { 
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <-0.003, 0.021, 0.015>}
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.017, 0.021, 0.015>} 
				cylinder{<0, 0, -1>, <0, 0, 1>, 0.0003 rotate x*40 translate <0.037, 0.021, 0.015>} 
			}
			plane{z, 0}
			plane{y, 0 rotate -x*40}
		}
		texture{RoofTexture}      
	}
	// door      
	union {
		box{<-0.001, 0, -0.01>, <0.01, 0.02, 0.01>}
		difference {
			union {
				#local rows = 11; 
				#local cnt = 2;
				#while (cnt < rows)
					box{<-0.003, 0, -0.01 + 0.001>, <0.0025, 0.0005, 0.01 - 0.001> 
						rotate z*50 translate<0, cnt*(0.0212/rows), 0>
					}
        			#local cnt = cnt + 1;
   				#end 
   			}
   			box{<-1, -1, -0.0005>, <1, 1, 0.0005>}
   		}
   		texture{AtticDoorTexture}   
   	}
}  

#declare FrontWindow = union {
	// frame
	difference {
		box{0, <0.03, 0.04, 0.002>}
		box{<0.00125, 0.03 - 0.00125, -1>, <0.03 - 0.00125, 0.04 - 0.00125, 1>}
		box{<0.00125, 0.00125, -1>, <0.01 - 0.00125, 0.03 - 0.00125*2, 1>} 
		box{<0.01, 0.00125, -1>, <0.02, 0.03 - 0.00125*2, 1>}
		box{<0.02 + 0.00125, 0.00125, -1>, <0.03 - 0.00125, 0.03 - 0.00125*2, 1>}
	
		texture{WindowFrameTexture}
	}
	// glass
	box{<0.001, 0.001, 0.001>, <0.029, 0.039, 0.003> texture{WindowGlassTexture}}
	// block above
	box{<-0.001, 0.0395, -0.0045>, <0.031, 0.042, 0.03> texture{BlockTexture}} 
	// block under
	box{<-0.001, 0.0005, -0.0045>, <0.031, -0.004, 0.03> texture{BlockTexture}}
}

#declare FrontWindowWithLight = union {
	// frame
	difference {
		box{0, <0.03, 0.04, 0.002>}
		box{<0.00125, 0.03 - 0.00125, -1>, <0.03 - 0.00125, 0.04 - 0.00125, 1>}
		box{<0.00125, 0.00125, -1>, <0.01 - 0.00125, 0.03 - 0.00125*2, 1>} 
		box{<0.01, 0.00125, -1>, <0.02, 0.03 - 0.00125*2, 1>}
		box{<0.02 + 0.00125, 0.00125, -1>, <0.03 - 0.00125, 0.03 - 0.00125*2, 1>}
	
		texture{WindowFrameTexture}
	}
	// glass
	box{<0.001, 0.001, 0.001>, <0.029, 0.039, 0.003> texture{pigment{color rgb<1, 1, 0.8>} finish{ambient 0.8}}}
	// block above
	box{<-0.001, 0.0395, -0.0045>, <0.031, 0.042, 0.03> texture{BlockTexture}} 
	// block under
	box{<-0.001, 0.0005, -0.0045>, <0.031, -0.004, 0.03> texture{BlockTexture}}
} 

#declare FrontWindows = union {
	#local rows = 4; 
	#local cnt = 0;
	#while (cnt < rows)
		object{FrontWindow translate<0.02, 0.03 + cnt*0.1, 0.004>}
		#if(cnt = 3)
			object{FrontWindowWithLight translate<0.08, 0.03 + cnt*0.1, 0.004>}
		#else
			object{FrontWindow translate<0.08, 0.03 + cnt*0.1, 0.004>}
		#end
		object{FrontWindow translate<0.19, 0.03 + cnt*0.1, 0.004>}
		object{FrontWindow translate<0.25, 0.03 + cnt*0.1, 0.004>}
		object{FrontWindow translate<0.32, 0.03 + cnt*0.1, 0.004>}
		object{FrontWindow translate<0.38, 0.03 + cnt*0.1, 0.004>}
		object{FrontWindow translate<0.49, 0.03 + cnt*0.1, 0.004>}
		object{FrontWindow translate<0.55, 0.03 + cnt*0.1, 0.004>}
        #local cnt = cnt + 1;
   	#end
} 

#declare SideWindow = union {
	difference {
		box{0, <0.02, 0.04, 0.002>}
		box{<0.00125, 0.03 - 0.00125, -1>, <0.02 - 0.00125, 0.04 - 0.00125, 1>}
		box{<0.00125, 0.00125, -1>, <0.01 - 0.00125/2, 0.03 - 0.00125*2, 1>} 
		box{<0.01 + 0.00125/2, 0.00125, -1>, <0.02 - 0.00125, 0.03 - 0.00125*2, 1>}
	
		texture{WindowFrameTexture}
	}
	// glass
	box{<0.001, 0.001, 0.001>, <0.019, 0.039, 0.003> texture{WindowGlassTexture}}
	// block above
	box{<-0.001, 0.0395, -0.0045>, <0.021, 0.042, 0.03> texture{BlockTexture}} 
	// block under
	box{<-0.001, 0.0005, -0.0045>, <0.021, -0.004, 0.03> texture{BlockTexture}}
	rotate -y*90
}

#declare SideWindows = union {
	#local rows = 4; 
	#local cnt = 0;
	#while (cnt < rows)
		object{SideWindow translate<0.6 - 0.004, 0.03 + cnt*0.1, 0.05>}
		object{SideWindow translate<0.6 - 0.004, 0.03 + cnt*0.1, 0.13>}
        #local cnt = cnt + 1;
   	#end
}

#declare StairwayWindow = union {
	box{0, <0.00125, 0.06, 0.002>}
	box{0, <0.00125, 0.06, 0.002> translate x*(0.04 - 0.00125)}
	box{0, <0.00125, 0.06, 0.002> translate x*(0.01 - 0.00125/2)}
	box{0, <0.00125, 0.06, 0.002> translate x*(0.02 - 0.00125/2)}
	box{0, <0.00125, 0.06, 0.002> translate x*(0.03 - 0.00125/2)}
	
	box{0, <0.04, 0.00125, 0.002>}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.06 - 0.00125)}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.01 - 0.00125/2)}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.02 - 0.00125/2)}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.03 - 0.00125/2)}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.04 - 0.00125/2)}
	box{0, <0.04, 0.00125, 0.002> translate y*(0.05 - 0.00125/2)}
	// glass
	box{<0.001, 0.001, 0.001>, <0.039, 0.059, 0.003> texture{WindowGlassTexture}}

	texture{WindowFrameTexture}
}

#declare StairwayWindows = union {
	object{StairwayWindow translate<0.13, 0.31, 0.004>}
	object{StairwayWindow translate<0.13, 0.21, 0.004>}
	object{StairwayWindow translate<0.13, 0.11, 0.004>}
	
	object{StairwayWindow translate<0.43, 0.31, 0.004>}
	object{StairwayWindow translate<0.43, 0.21, 0.004>}
	object{StairwayWindow translate<0.43, 0.11, 0.004>}
}

#declare Door = union {
	// left
	difference {          
		box{0, <0.0195, 0.06, 0.004> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.02 - 0.005, 0.03, 0.001> texture{DoorSecondaryTexture}}
		box{<0.005, 0.035, -1>, <0.02 - 0.005, 0.06 - 0.005, 0.001> texture{DoorSecondaryTexture}}
		
		translate <0.01, 0.01, 0.02>
	}
	// right
	difference {          
		box{0, <0.02, 0.06, 0.004> texture{DoorMainTexture}}
		box{<0.005, 0.005, -1>, <0.02 - 0.005, 0.03, 0.001> texture{DoorSecondaryTexture}}
		box{<0.005, 0.035, -1>, <0.02 - 0.005, 0.06 - 0.005, 0.001> texture{DoorSecondaryTexture}}
	
		translate <0.01 + 0.0205, 0.01, 0.02>
	}
	// steps
	union {
		box{0, <0.06, 0.005, 0.04>}
		box{<0.01, 0.005, 0.01>, <0.05, 0.01, 0.04>} 
		// roof
		box{<0.005, 0.07, 0>, <0.055, 0.072, 0.04>}
		texture{BlockTexture}
	}
}                                    

#declare Doors = union {
	object{Door translate<0.12, 0, -0.02>}
	object{Door translate<0.42, 0, -0.02>}
}

#declare HalfHouse6 = union {
	object{Base}                    
	object{Stripes translate y*0.1}
	object{Stripes translate y*0.2}
	object{Stripes translate y*0.3}
	object{Eaves}
	object{DrainFront}
	object{DrainSide translate -x*0.0065}
	object{DrainSide translate x*0.6065}
	object{FireEscape}                         
	object{DrainPipe rotate -y*0 translate <0.001, -0.004, -0.005>}
	object{DrainPipeMount translate <0.001, -0.004, -0.005>}
	object{DrainPipe rotate -y*90 translate <0.3, -0.004, -0.005>}
	object{DrainPipeMount translate <0.3, -0.004, -0.005>}
	object{DrainPipe rotate -y*180 translate <0.6 - 0.001, -0.004, -0.005>} 
	object{DrainPipeMount translate <0.6 - 0.001, -0.004, -0.005>}
	object{Roof}                                             
	object{Chimney translate<0.08, 0.4, 0.04>} 
	object{Chimney translate<0.19, 0.4, 0.04>}
	object{Chimney translate<0.38, 0.4, 0.04>}
	object{Chimney translate<0.49, 0.4, 0.04>}
	object{Fence}          
	object{Attic translate<0.01, 0.41, 0.1>}
	object{Attic rotate -y*90 translate<0.3, 0.41, 0.01>}
	object{FrontWindows}  
	object{SideWindows}
	object{StairwayWindows}
	object{Doors}
}           

#declare House6 = union {
	object{HalfHouse6}
	object{HalfHouse6 rotate -y*180 translate <0.6, 0, 0.2>}
}  
