/************** The Lonely Howl *************************
howl.pov - main scene file
// +Ihowl.pov +V +W320 +H240
// +Ihowl.pov +V +W640 +H480
// +Ihowl.pov +w800 +h600 +a0.3 +GAdebug.txt
//  +sc0.446809 +sr0.278798 +ec0.541927 +er0.445743
********************************************************/
//Test render 320x240 (Atmo Int 10, ISO off) 1h 51m 26s

//To Do
// - Confidence and Variance are commented out, un-comment when final render!!

// - Front fog (ok)
// - Consider smoke turbulence / freq
// - Wood ambience too much
// - Middle short tree: look at proportion
// - Wolf fur!!
// - Fallen tree root section and cut-surface

// - Tree Texture (More C12)
// - Focal Blur?????
// - Wolf skin - POVMAN (?)
// - More falling trees (ok)
// - Right side falling tree... atmo interaction (ok)
// - tree_2 rand # (ok)
// - Interior fade distance (hmm....)
// - Light fading (awaiting test)
// - Smoke thickness (awaiting test)
// - Perfect Ground (darken image for ash - done)
// - Detail ISO surface (ok for now)
// - Ambient tree bark (ok for now)
// - Perfect bg trees (ok for now)
// - Branches angles? (ok for now)
// - Secondary light source (done)
// - Max-gradient check (ok for now)
//---------------------------------------------------------------------------------------------------//
//                                       Misc. Functions                                             //
//---------------------------------------------------------------------------------------------------//
/*global_settings {
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
    }
}*/
//radiosity 160x120 => 4:34 vs no radiosity 4:07



//RGB colour converter
#macro RGBColour (r, g, b)
     <r/255, g/255, b/255>    
#end

//Custom World Axis
#declare show_axis = 0;
#declare axis_length = .449328;

#if (show_axis = 0)
  #declare axis_radius = 0;
#else
  #declare axis_radius = 0.03;
#end

union {
  cylinder{<axis_length,0,0>,<-axis_length,0,0>,axis_radius pigment {colour rgb <1,0,0>}} //x
  cylinder{<0,axis_length,0>,<0,-axis_length,0>,axis_radius pigment {colour rgb <0,1,0>}} //y
  cylinder{<0,0,axis_length>,<0,0,-axis_length>,axis_radius pigment {colour rgb <0,0,1>}} //z
}


//---------------------------------------------------------------------------------------------------//
//                                       Custom Settings                                             //
//---------------------------------------------------------------------------------------------------//

//Atmosphere.inc settings
#declare Show_Light_Vector = 0;    // - to turn off, comment out variable
#declare Atmosphere = 1;           //Turn on atmospheric effect
#declare True_Smoke = 1;
#declare Use_Real_Light = 1;       //Show only the lights that will be used in final render
#declare Atmo_Qual_Level = 5;      //5 or 8 for half-qual testing -> Media Intervals Settings
#declare HQ_Atmo_Settings = 60;     //High quality Atmospheric Settings Enable (set sample size >= 1)
#declare Atmo_Test_Mode = 0;       //Test mode (use with aerial cam view)
#declare Show_Sky = 0;             //Show Sky sphere
#declare Show_Ground_Fog = 0;      //Ordinary ground fog

//Tree.inc detail settings
#declare branch_high_detail = 1;   //foreground tree branch detail on/off
#declare bg1_high_detail = 1;      //background tree detail on/off
#declare fg_high_detail = 1;       //foreground tall tree detail on/off
#declare st_high_detail = 1;       //Short tree detail on/off
#declare detail_texture = 1;       //Detail texture

//Camera and test mode settings
#declare Cam_Angle = 2;            //Set camera angle (see Camera Section for detail)
#declare OrthoView = 0;            //Set Orthographic camera on/off
#declare Blue_bg = 0;              //Turn on/off blue background (test mode: set up background colour)

//Object Display Settings
#declare Show_All = 1;             //Show ALL objects used in scene
#declare Show_BG_Tree = 0;         //Partial showing (background tree)
#declare Show_FG_Tree = 0;         //Foreground ISO-surf tree
#declare Show_Ground = 0;
#declare Show_Wolf = 1;

//Misc. variables -> Not for customization
#declare wolf_rotation = -5*y;     //Wolf + Trunk rotation: Should not touch
#declare Wolf_Image_Map = 1;       //Wolf Image map: Normally [ON]
#declare bg_tree_finish = finish { ambient 0.15 diffuse 0.4 };

//Comments
//Full detail parse time approx. 1.00min
//640x480 fg iso detail aa0.0 render 12m
//640x480 detail -fg +atmo5 aa0.0 render 3h
//Comparison between HQ_Atmo_Setting and Atmo_Qual_Level
//Render time: 160x120
//HQ_Atmo_Setting w/ 50 samples: 6min 18s
//Atmo_Qual_Level at 10 intervals: 12min 09s
//Ideal Quality: 50 Samples + 3-5 Intervals

//ISO Surface Rendering: top half average @ 50 pps A160x120 AA0.3; lower half @ 20 pps; slowest @ 12pps

//Full Detail Rendering @ 512x384 AA0.3 (Int1 Smpl50) average 187 ppm => 17h 38min
//no fg detail, 100smpl AA0.3, 320x240 avg 6 pps 3h 5m 38s
//---------------------------------------------------------------------------------------------------//
//                                       Text Stream                                                 //
//---------------------------------------------------------------------------------------------------//
//Message, variable, default condition, status type
//stat_type: 1 for ON/OFF, 0 for HIGH/LOW
#macro Status1 (message, var, cond, stat_type)
     #if (stat_type) #local true_str = "ON"; #local false_str = "OFF";
     #else #local true_str = "HIGH"; #local false_str = "LOW"; #end

     #debug concat(message," ")
     #if (var = 1) 
          #debug true_str
     #else 
          #debug false_str
          #if (cond = 0) #debug " (default)" 
          #else #debug " <="
          #end
     #end
     #debug "\n"
#end

#debug "\n============================================\n"
#debug "Howl.pov \"The Lonesome Call\" Render Settings\n"
#debug "         -= (c) Johnny Yip 2002 =-\n"
#debug "============================================\n"

#debug "Camera Angle set to: " #switch (Cam_Angle)
#case(1) #debug "Object View\n" #break
#case(2) #debug "Final Render View\n" #break
#case(3) #debug "Free-Moving Cam\n" #break
#case(4) #debug "Aerial View\n" #break
#else #debug "Undefined (warning)\n" #end
#if (Cam_Angle = 2) #debug "Camera Angle is OK (For final render)\n" #else #debug "Camera view not set to final render config <=\n" #end
#if (OrthoView) #debug "Orthographic Camera is ON <=\n" #end
#if (!Use_Real_Light) #debug "Non-Real lights INCLUDED, please turn off for final render <=\n" #else #debug "Light Sources are OK\n" #end
#if (Blue_bg) #debug "Blue Background is turned ON <=\n" #end
#debug "Atmosphere " #if (Atmo_Test_Mode) #debug "(Test Mode) " #end #debug "is turned "
#if (Atmosphere) #debug concat("on at interval count ",str(Atmo_Qual_Level,2,0),"\n") #else #debug "OFF <=\n" #end
#debug "High Quality Atmospheric Settings "
#if (HQ_Atmo_Settings > 0) #debug concat("Enabled at sample size ",str(HQ_Atmo_Settings,3,0),"\n") #else #debug "[Disabled] <=\n" #end
Status1("True Smoke Settings:", (True_Smoke), 1, 1)
Status1("Ground Fog is", (Show_Ground_Fog), 0, 1)
Status1("Foreground Tree Detail Level:", (st_high_detail & fg_high_detail), 1, 0)
Status1("TOMTree Detail Level:", (branch_high_detail & bg1_high_detail), 1, 0)
Status1("Texture Detail is turned", detail_texture, 1, 1)
Status1("Sky Sphere is turned", Show_Sky, 0, 1)
#if (!Show_All) #debug "Not all objects are set to display! <=\n" #end

//---------------------------------------------------------------------------------------------------//
//                                       Include Files                                               //
//---------------------------------------------------------------------------------------------------//

#debug "\nLoading Include Files...\n"
#include "colors.inc"
#include "functions.inc"
#if (Atmosphere) #include "atmosphere.inc" #end
#if (Show_BG_Tree | Show_FG_Tree | Show_All) #include "tree.inc" #end
#if (Show_Ground | Show_All) #include "ground.inc" #end
#if (Show_Wolf | Show_All) #include "wolf_obj.inc" #end

//---------------------------------------------------------------------------------------------------//
//                                       Camera... Action!                                           //
//---------------------------------------------------------------------------------------------------//
#debug "\nInitializing Camera Settings...\n"
#switch (Cam_Angle)
     #case (1)
          //Testing cam angle
          #declare camera_location = <1,1,-1>; #declare camera_look_at = <0,0,0>;
     #break
     #case (2)
          //Prospective cam angle
          #declare camera_location = <5,2,-36>; #declare camera_look_at = <0,17,0>;
     #break
     #case (3)
          //Free CAM
          #declare camera_location = <0,20,-20>; #declare camera_look_at = <-10,10,20>;
     #break
     #case (4)
          //Aerial View Cam
          #declare camera_location = <0,100,0>; #declare camera_look_at = <0,0,0>;
     #break
     #else
          //Original test cam
          #declare camera_location = <15,10,0>; #declare camera_look_at = <0,0,0>;
#end

camera {
     #if (OrthoView) orthographic #end
     location camera_location
     look_at camera_look_at
}

//---------------------------------------------------------------------------------------------------//
//                                    Atmosphere & Sky Sphere                                        //
//---------------------------------------------------------------------------------------------------//

#if (Atmosphere)
     object { air }
#end
#if (!Use_Real_Light)
     light_source {<0,10,100> colour rgb 0.5 shadowless}
     light_source {<-100,50,-80> colour rgb 1 shadowless}
     light_source {<-50,100,-50> colour rgb 0.2 shadowless}
     light_source {<30,30,-50> colour rgb 1 shadowless}
#end


#if (Blue_bg) background { Blue } #end


#if (Show_Ground_Fog)
     fog {
          distance 100
          colour rgbft<0.75, 0.75, 0.75, 0.5, 0.4>
          fog_type 2
          fog_offset 20
          fog_alt 3
          turbulence 0.2
          turb_depth 0.3
     }
#end
//---------------------------------------------------------------------------------------------------//
//                                       Scene Definition                                            //
//---------------------------------------------------------------------------------------------------//

#if (Show_FG_Tree | Show_All)
     object { fg_tree_group }
#end
#if (Show_BG_Tree | Show_All)     
     object { bg_tree_group }
#end
#if (Show_Ground | Show_All)
     object { Ground_HF }
     object { Hill_HF }
#end
#if (Show_Wolf | Show_All)
     object { wolf scale 13 rotate <0,31.5,4> translate <0.8,2.4,-9.5> rotate wolf_rotation}  //<4,1.8,-7>
#end

//object { Moon scale 500 rotate <0,90,20> translate <-2300,9500,10000>}

//object { Moon scale 20 translate <110,160,250>}

#declare ball_r = 10;
#declare fur = (0.13/6)*10;

/*sphere { <0,20,0>, ball_r
     texture {
          //normal { bumps 0.5 bump_size 0.5 scale 0.5 }
          pigment { 
               image_map {
                    tga "texturez/wolf_skin2.tga"
                    map_type 1
               }
          }
     }
}

sphere { <0,20,0>, ball_r+fur
     texture {
          pigment { 
               agate
               colour_map {
                    [0.0 colour rgb 1 transmit 0.8]
                    [0.3 colour rgb 1 transmit 0.8]
                    [0.3 colour rgb 1 transmit 1.0]
                    [1.0 colour rgb 1 transmit 1.0]
               }
               scale 0.8
          }
          normal { 
               bumps 1 
               bump_size 5 
               scale 0.05
          }
          finish { 
               ambient 0.76
               diffuse 0.1
               specular 0.5
               roughness 0.001
          }
     }
}*/