//---------------------------------------------------------------------------------------------------//
//                                        Wolf_obj.inc                                               //
// Objects included:                                                                                 //
// - the Wolf                                                                                        //
// Render Wolf only in camera view #2
// +Ihowl.pov +SC250 +SR280 +EC400 +ER440 +W640 +H480
//---------------------------------------------------------------------------------------------------//

#declare OBJuvPOVmaxX =  .115008;
#declare OBJuvPOVminX = -.113048;
#declare OBJuvPOVmaxY =  .449328;
#declare OBJuvPOVminY =  0;
#declare OBJuvPOVmaxZ =  .268734;
#declare OBJuvPOVminZ = -.207977;

#declare move2center = <-(OBJuvPOVmaxX-((OBJuvPOVmaxX-OBJuvPOVminX)/2)),
                        -(OBJuvPOVmaxY-((OBJuvPOVmaxY-OBJuvPOVminY)/2)),
                        -(OBJuvPOVmaxZ-((OBJuvPOVmaxZ-OBJuvPOVminZ)/2))>;
#declare move2center = <-0.00098,-0.224664,-0.0303785>;
#declare fur_scale = 1.03;

#declare Wolf_Image = pigment {
   #if (Wolf_Image_Map)
        image_map
        {
            tga "texturez/wolfmap.tga"
            interpolate 2
        }
   #else
        colour rgb 1
   #end
}


#declare Fur_Finish = finish {
     ambient 0.15    //0.1
     diffuse 0.5
     //phong 0.2
     //phong_size 10
     //reflection { 0.03, 0.08 falloff 2 exponent 0.5}
     //specular 0.5
     //roughness 0.005
}
     
#declare Eye_Finish = finish {
     ambient 0.3
     diffuse 0.3
     specular 1
     roughness 0.05
}

#declare bump_scale = 0.7;//<0.05,0.05,0.5>;
#declare Fur_Texture = texture {
     uv_mapping 
     pigment { Wolf_Image }
     normal {
          //wrinkles 0.5
          bump_map
          {
            tga "texturez/wolf_skin2.tga"
            interpolate 2
            bump_size 0.8
          }
          scale bump_scale
     }
     finish { Fur_Finish }
}

#declare Eye_Texture = texture {
     uv_mapping 
     pigment { Wolf_Image }
     finish { Eye_Finish }
}     

#declare OBJuvPOV_Texture = texture {
     uv_mapping 
     pigment { Wolf_Image }
     finish { Fur_Finish }
}

#declare OBJuvPOV_Texture_OBJuvPOVfur = texture {Fur_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVclaws = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnose = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyewhite = texture {Eye_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {Eye_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {Eye_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerEar = texture {OBJuvPOV_Texture}

#include "wolf.inc"

//#declare light_intensity = 1;

#declare wolf_core = object { ConvObject translate move2center }

#declare t_fur_transp = texture {
     pigment { 
          granite
          //agate_turb 0.5
          frequency 10
          colour_map {
               [0.0 colour rgb 1 transmit 0.8]
               [0.3 colour rgb 1 transmit 0.9]
               [0.4 colour rgb 1 transmit 1.0]
               [1.0 colour rgb 1 transmit 1.0]
               //[1.0 colour rgb 1 transmit 0.9]
          }
          scale <0.03,0.03,0.1>
     }
     normal { 
          bumps 1 
          bump_size 5 
          scale 0.05
     }
     finish { 
          ambient 0.81
          diffuse 0.0
          //specular 0.1
          //roughness 0.001
     }
}

#declare t_fur_highlight = texture {
     gradient y
     texture_map {
          [0.0 pigment {colour rgbt 1}]
          [0.1 pigment {colour rgbt 1}]
          [0.2 t_fur_transp]
          [1.0 t_fur_transp]
     }
}

#declare t_no_fur = texture {
     pigment { colour rgbt 1 }
}

#declare OBJuvPOV_Texture_OBJuvPOVfur = texture {t_fur_highlight}
#declare OBJuvPOV_Texture_OBJuvPOVclaws = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVnose = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVeyewhite = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {t_no_fur}
#declare OBJuvPOV_Texture_OBJuvPOVinnerEar = texture {t_fur_transp}

#include "wolf.inc"

#declare wolf_fur = object { ConvObject translate move2center scale fur_scale }

#declare wolf = union {
     object { wolf_core }
     object { wolf_fur }
     translate -move2center
}

/*light_group {
     light_source { <-10,0,3>, rgb RGBColour(237,234,233)*light_intensity }//fade_distance 40 fade_power 0.8}
     //light_source { <-8,10,10>, rgb RGBColour(196,175,154)*light_intensity }//fade_distance 40 fade_power 0.8}
     object { ConvObject }
     global_lights on
}*/