#macro grass_blade(gheight,gwidth,taper,bending,segments)

////////////////////////////////////////////////////////////////////////
////                                                                ////
//// Macro to create a simple "bent sheet" blade of grass           ////
//// Fully parametric for random placement, variation.              ////
////                                                                ////
//// By: Phil Brewer                                                ////
////                                                                ////
////                                                                ////
//// segments = number of segments in blade. 3-5 works well         ////
//// bending = amount of bending. 0-1, 1 being flat accross on top  ////
//// gheight = height of blade (really length)                       ////
//// gwidth = width of blade at base                                ////
//// taper = taper of blade. 0 is no taper, 1 tapers to a point     ////
////                                                                ////
////////////////////////////////////////////////////////////////////////

#declare Grass_Points = array[4][segments+2] // Initialize array to hold triangle points

#declare Grass_Points[0][0] = <0,-gheight/segments,0>; // Initialize null point
#declare Grass_Points[2][0] = <0,-gheight/segments,0>; // Initialize null point

///////////////////////////////////////////////////
//// Loop through segments to calculate points ////
///////////////////////////////////////////////////

#declare seg = 0; // Set current segment to 0
#while ( seg < segments+1 ) 
  #declare Grass_Points[0][seg+1] = vaxis_rotate(<gwidth/2,gheight/segments,0>,<1,0,0>,bending*90/segments*seg) + <-.5*taper*seg*gwidth/segments,Grass_Points[0][seg].y,Grass_Points[0][seg].z>; // Calculate +x point, rotate, and taper
  #declare Grass_Points[2][seg+1] = vaxis_rotate(<-gwidth/2,gheight/segments,0>,<1,0,0>,bending*90/segments*seg) + <.5*taper*seg*gwidth/segments,Grass_Points[2][seg].y,Grass_Points[2][seg].z>; // Calculate -x point, rotate, and taper
  #declare seg = seg + 1; //Increment segment
#end

////////////////////////////////////////////////////
//// Loop through segments to calculate normals ////
////////////////////////////////////////////////////

#declare seg = 0;
#while ( seg < segments+2 )
  #declare Grass_Points[1][seg] = vaxis_rotate(<0,0,-1>,<1,0,0>,bending*90/segments*seg); // Rotate normal based on segment number
  #declare Grass_Points[3][seg] = vaxis_rotate(<0,0,-1>,<1,0,0>,bending*90/segments*seg); // Rotate normal based on segment number
  #declare seg = seg + 1;
#end

/////////////////////////////////////
//// Create smooth triangle mesh ////
/////////////////////////////////////

mesh{
  #declare seg = 1;
  #while ( seg < segments+1 )
    smooth_triangle{
      Grass_Points[0][seg], Grass_Points[0][seg]+Grass_Points[1][seg],
      Grass_Points[2][seg], Grass_Points[3][seg]+Grass_Points[2][seg],
      Grass_Points[0][seg+1], Grass_Points[1][seg+1]+Grass_Points[0][seg+1]
      }
    smooth_triangle{
      Grass_Points[2][seg], Grass_Points[1][seg]+Grass_Points[2][seg],
      Grass_Points[0][seg+1], Grass_Points[3][seg+1]+Grass_Points[0][seg+1],
      Grass_Points[2][seg+1], Grass_Points[1][seg+1]+Grass_Points[2][seg+1]
      }
    #declare seg = seg + 1;
  #end
  texture{ grass_tex }
}

#end