#version unofficial MegaPov 0.7;
#include "colors.inc"
#include "stones1.inc"


#declare stone_main_rough =
texture{
  T_Stone15
  finish{ diffuse .05 ambient .1 crand .05 phong 0.99 phong_size 60 }
  scale 10
}

#declare stone_main_shiny =
texture{
  T_Stone15
  finish{ 
    diffuse .01 ambient .7 metallic 
    reflection .15 reflection_blur .01 reflection_samples 7
    }
  scale 10
}

#declare grass_tex = 
texture{
  pigment{ color rgb <.1,.3,.1> }
  finish{ ambient .2 diffuse .6 phong .1 phong_size 10 reflection .1 }
  normal{ bumps .1 scale .6 }
}

#declare grass_tex_far = 
texture{
  pigment{ color rgb <.1,.3,.1> }
  finish{ ambient .2 diffuse .6 phong .1 phong_size 10 crand .3 }
}

#declare ground_tex = 
texture{
  pigment{ color rgb <0.34118, 0.2902, 0.19216> }
  finish{ ambient .1 diffuse .2 }
}

#declare leave_tex =
texture{
  pigment{ color rgb <.2,.8,.2> }
  finish{ ambient .02 diffuse .4 }
}

#declare bark_tex =
texture{
  pigment{
    bozo
    turbulence .7
    octaves 6
    lambda 2
    omega .8
    color_map{
      [0.0 rgb <0.46667, 0.40392, 0.25882> ]
      [0.5 rgb <0.57647, 0.50196, 0.34118> ]
      [1.0 rgb <0.47843, 0.4549, 0.32157> ]
      }
  } 
  finish{ ambient .02 diffuse .7 }
  normal{ bumps .7 }
  scale <.02,3,.02>
}

#declare lens_tex =
texture{
  pigment{
    image_map{
      png "lens_map.png"
      interpolate 0
      //map_type 2
  }}
  finish{ ambient .4 diffuse .9 reflection .4 } 
  translate <-.5,-.5,-.5>
  scale <20,8,1>
  rotate 34*y
  translate <2,-5,0>
}

#declare pont_logo =
texture{
  pigment{
    image_map{
      png "pont_logo.png"
      interpolate 0
    }
  }
  finish{ ambient .4 diffuse .8 reflection .2 } 
  translate <-.5,-.5,0>
  rotate 28*z
  scale 2.3
}

#declare gloss_black =
texture{
  pigment{ color rgb .02 }
  finish{ ambient .1 diffuse .8 phong .4 phong_size 100 reflection .1 } 
}

#declare flat_black =
texture{
  pigment{ color rgb .2 }
  finish{ ambient .2 diffuse .2 } 
}

#declare grey_fleece =
texture{
  pigment{ color rgb .6 }
  finish{ ambient .05 diffuse .4 }
  normal{ wrinkles .3 scale .1 } 
}

#declare grey_fleece_seams =
texture{
  pigment{ color rgb .75 }
  finish{ ambient .05 diffuse .4 }
  normal{ wrinkles .3 scale .1 } 
}

#declare charcoal =
texture{
  pigment{ color rgb .15 }
  finish{ ambient .01 diffuse .7 }

}

#declare wet_velvet =
texture{
  pigment{ color rgb <.1,.1,.15> }
  finish{ ambient .2 diffuse .8 specular .6 roughness 40 }
}

#declare aluminum =
texture{
  pigment{ color rgb .45 }
  finish{ ambient .01 diffuse .5 metallic
          specular .9 roughness .6 reflection .4 }
}

#declare aluminum_brushed =
texture{
  pigment{ color rgb .7 }
  finish{ ambient .2 diffuse .6 metallic
          specular .7 roughness 20 reflection .3 
          //reflection_blur .03 reflection_samples 5 
  }
}

#declare grad_y =
texture{
  pigment{
    gradient y
    color_map{
      [0.0 color rgb .6 ]
      [0.03 color rgb .6 ]
      [0.04 color rgbf 1 ]
      [0.94 color rgbf 1 ]
      [0.96 color rgb .6 ]
      [1.0 color rgb .6 ]
      }
  }
  scale 1
}

#declare fence_tex =
texture{ grad_y rotate 40*z }
texture{ grad_y rotate -40*z }

#declare rubber =
texture{ 
  pigment{ color rgb .4 }
  finish{ ambient .01 diffuse .3 phong .05 phong_size 15 }
  }

#declare paint =
texture{
  pigment{ color rgb <0.40392, 0.06275, 0.06275> }
  finish{ reflect_metallic metallic reflection .6 specular .8  
          roughness .4 ambient .2 diffuse .7 reflection_blur .005 reflection_samples 8 }
  }

#declare clearcoat =
texture{
  pigment{ color rgbf 1 }
  finish{ phong .1 phong_size 20 diffuse .8}
  }
  
#declare pot_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb .6]
      [0.8 color rgb .6]
      [0.85 color rgb .3]
      [1.0 color rgb .3]
      } scale .1 }
  finish{ ambient .2 diffuse .6 crand .2 reflection .2 }
}

#declare stone_tex1 =
texture{
  pigment{ color rgb .8 }
  finish{ ambient .1 diffuse .5 crand .3 }
}

#declare stone_tex2 =
texture{
  pigment{ color rgb <0.53333, 0.34118, 0.3451> }
  finish{ crand .3 }
}

#declare road_bed =
texture{
  pigment{ color rgb <0.86275, 0.83922, 0.78824> }
  finish{ crand .2 ambient .1 diffuse .3 reflection .10 }
}

#declare road_gravel =
texture{
  pigment{ color rgb <0.86275, 0.83922, 0.78824> }
  finish{ crand .2 ambient .1 diffuse .3 reflection .10 phong .4 phong_size 100 }
}

#declare puddle =
texture{
  pigment{ color rgb .3 }
  finish{ reflection .4 }
  normal{ waves 1 frequency 8 scale .2 translate <-.5,-.5,-.5> }
}

#declare clear =
texture{
  pigment{ color rgbf 1 }
  finish{ reflection .05 }
  normal{ bumps .2 scale .5 }
}     