#macro tree(recursions,L,point0,R0,decay,bark,leaves)

  /////////////////////////////////////////
  ///////////// basic variables ///////////
  /////////////////////////////////////////

  #local gravity = -.3;  // -y component to be added to branches to make the "droop"

  #local pull = .1; // pull factor to help in drooping branches

  #local sprout_placement_along = .3*( rand(S1)+.1*rand(S1) ) + .3; // picks a semi-random placement along the parent branch for the sprout to originate

  #local sprout_probability = int( rand(S1)+.9 ); // makes sprouts not 100% probable

  #local sprout_scale = .3*( rand(S1)+.1*rand(S1) ) + .5; // scales down the initial diameter of a new sprout w/ respect to the parent branch

  #local R1 = .75*R0; // scales down the secondary diameter of branch
  
  #local recurse = recursions - 1; // subtracts one recursion so trees are finite in complexity

  /////////////////////////////////////////
  ////////// advanced variables ///////////
  /////////////////////////////////////////
 
  #local point1 = point0 + vrotate(L,<15*rand(S1)-7.5,15*rand(S1)-7.5,15*rand(S1)-7.5>); // randomly rotate branch
  
  #local point1 = point1 + <pull*(point1.x-point0.x),gravity,pull*(point1.z-point0.z)>; // droop branch and "pull" away from center

    #if ( R0 > .02 ) cone{ point0,R0  point1,R1  texture{ bark } } #end   // create branch cone segment
    #if ( recurse > 2 ) sphere{ point1,R1 texture{ bark } } #end          // create sphere to fill-in between cone segments
    //#if ( recurse < 3 ) leaves_place(point0,point1) #end

  #local L = decay*L;

  #if ( sprout_probability ) // test for presence of sprout 
  
    #local sprout0 = sprout_placement_along*(point1-point0) + point0 ;

    #local sprout1 = sprout0 + decay*vrotate(L,<50*rand(S1)-25,50*rand(S1)-25,50*rand(S1)-25>);
  
    #local sprout1 = sprout1 + <pull*(sprout1.x-sprout0.x),gravity,pull*(sprout1.z-sprout0.z)>;

      #if ( R0 > .04 ) cone{ sprout0,sprout_scale*R0  sprout1,sprout_scale*R1  texture{ bark } } #end
      #if ( recurse > 2 ) sphere{ sprout1,sprout_scale*R1 texture{ bark } } #end

  #end  


  #if ( recurse > 0 )
     
    tree(recurse,L,point1,R1,decay,bark,leaves)
    #if ( sprout_probability ) tree(recurse,(sprout1-sprout0),sprout1,R1*sprout_scale,decay,bark,leaves) #end
       
  #end
  
    
  


  //#local M0 = (P1 + P0)/2;
  
  //#local K = decay*vrotate(L,<40*rand(S1)-25,360*rand(S1),40*rand(S1)-25>);
  
  //#local M1 = P0 + vrotate(L,<10*rand(S1)-5,20*rand(S1),10*rand(S1)-5>);

  
  
  
  
  
  
  
  //#local L = decay*L;

  //#local R1 = .7*R0;
  
  //#local D0 = R1;
  
  //#local D1 = .7*D0;

  //cone{ P0,R0  P1,R1  texture{ bark } }
  //cone{ M0,D0  M1,D1  texture{ bark } }
 
  //#local recurse = recursions - 1;
 
    //#if ( recurse < 2 ) 
      //sphere{ P1, L.y/2 hollow texture{ leaves }}  
      //sphere{ M1, K.y/1 hollow texture{ leaves }} 
    //#end  
      
  //#if ( recurse > 0 )
     
    //tree(recurse,L,P1,R1,decay,bark,leaves)
    //tree(recurse,K,M1,D1,decay,bark,leaves)
       
  //#end


     
#end

