/*

Tyre creation Macro.
Tested with Megapov 0.4

fd 18/5/2000

*/

#version unofficial MegaPov 0.7;
#macro Tyre(
  R,     // Rayon
  Rint,  // Rayon intrieur
  Ep,    // Epaisseur
  Fm,    // Fichier marques (png)
  Em,    // Epaisseur marques
  Hbase, // Hauteur max fond des dessins
  Htop,  // # de hauteur entre marques du centre et des bords
  k_lathe
  )

  #local poids_cyl = R/(R+Em);
  #local poids_map = 1-poids_cyl;
  #local fcyl = function{(sqrt(sqr(x)+sqr(z))-1)}
  #local fpneus=function{
    pigment{
      image_map{
	png Fm
	map_type 2
	interpolate 2
	once
      }
    }
  }
  #local fwear = function{
    pigment{
      granite color_map {
	[0 rgb 0]
	[1 rgb 0.1]
      }
      scale .1
    }
  }
  #local rbase = Hbase/Em;
  #local rbase2 = 1-rbase;
  #local fbase=function{sqr(1-4*(y*(1-y)))*rbase+rbase2}
  #local rtop = Htop/Em;
  #local ftop=function{(1-4*y*(1-y))*rtop}
  #local ftop2=function{(1-(4*y*(1-y)))*rtop}
  #local fpneus1=function{
      fpneus(x, y, z)*((fbase(x, y, z))-ftop2(x, y, z))+
      ftop2(x, y, z)
  }
  #local Rflanc1=poids_cyl;
  #local Rflanc2=Rflanc1*Rint/R;
  
  union{
    difference{
      isosurface{
	function {fcyl(x, y, z)*1+poids_map*(fpneus1(x, y, z))}
	sign 1
	threshold 0
	method 2 max_gradient 10
	contained_by {box{<-1.1, 0, -1.1>, <1.1, 1, 1.1>}}
	translate -.5*y
      }
      cylinder {-y, y, Rflanc2}
    }
    #local Tyre_torus=lathe{
      bezier_spline 4, // Thanks to P.Popov for this hint ;-)
      <Rflanc1, 0.5>,
      <Rflanc1-poids_map*rbase*8*k_lathe, 0.5+k_lathe>,
      <Rflanc2, .5+k_lathe>, //Square angle
      <Rflanc2, 0.5>
      sturm
    }
    object {Tyre_torus translate .5*0*y}
    object {Tyre_torus rotate 180*x translate -.5*y*0}
    scale <R+Em, Ep, R+Em>
  }
#end
