//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 5 materials and 76 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 08/24/2002    (24.08.2002)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <1.000,1.000,1.000> }

camera {  //  Camera StdCam
  location  <      0.000,      -0.001,      30.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.00000,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      40.000
  look_at   <      0.000,       0.000,       0.000>
  // Focal blur settings
  focal_point  <0.000, 0.000, 0.000> // Always Lookat
  aperture     1.5
  blur_samples 28
  confidence   0.9375
  variance     0.0075
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  -20.0*z
}


//
// ********  MATERIALS  *******
//

#include "irtclnly.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare ThingSphere = object {
  sphere { // ThingSphere
    <0,0,0>,1
    material {
      CootieTxtr
    }
    scale 0.1
    translate  <0.0, 2.646805, -8.056282>
  }
}


#declare NyaHF = object {   // NyaHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf10.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <1.5, 1.5, 0.1>
  translate  <-4.072417, -9.810823, -2.808612>
}


#declare PickerHF = object {   // PickerHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf9.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <2.0, 2.0, 0.1>
  rotate <0.0, 0.0, -2.84086>
  translate  <-7.634641, -0.410854, -0.813019>
}


#declare DrunkHF = object {   // DrunkHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf2.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <3.0, 3.0, 0.1>
  rotate -25.455303*z
  translate  <4.87348, 6.774523, -1.0>
}
#declare FlipperHF = object {   // FlipperHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf1.tga"
    water_level 0.1
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  hollow
  scale <3.0, 2.420601, 0.1>
  translate  <-0.356606, 0.500063, -4.225564>
}
#declare DancerHF = object {   // DancerHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf6.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <2.5, 2.5, 0.1>
  rotate 15.278161*z
  translate  <-6.8893, -6.476664, -6.430243>
}


#declare HgtFld003 = object { 
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf3.tga"
    water_level 0.3
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <2.0, 2.0, 0.1>
  translate  -1.0*z
}
#declare HgtFld004 = object { 
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf4.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    BlackTexture
  }
  scale <2.0, 2.0, 0.1>
  translate  -0.805699*z
}
#declare NerdCootieGrp = union { // NerdCootieGrp
  object { HgtFld003 }
  object { HgtFld004 }
  scale <1.5, 1.5, 1.0>
  rotate -30.808056*z
  translate  <7.380867, -8.824812, -8.130192>
}








//
// ********  OBJECTS  *******
//

union { // ThingSQGrp
  superellipsoid { // ThingSQ
    <2.75, 2.84>
    scale 0.2
    rotate <-78.066025, -84.973312, 100.68045>
    translate  <5.265586, -7.071302, -3.57702>
  }
  superellipsoid { // ThingSQ1
    <2.75, 2.84>
    scale 0.2
    rotate <-52.800674, -21.220556, -58.338932>
    translate  <-6.517127, 1.58926, -7.391084>
  }
  superellipsoid { // ThingSQ2
    <2.75, 2.84>
    scale 0.2
    rotate <73.702499, -47.580643, -122.919403>
    translate  <-10.041371, -8.229652, -7.834549>
  }
  superellipsoid { // ThingSQ3
    <2.75, 2.84>
    scale 0.2
    rotate <84.282204, 86.94577, -70.945251>
    translate  <-2.31385, -3.139701, -5.36553>
  }
  superellipsoid { // ThingSQ4
    <2.75, 2.84>
    scale 0.2
    rotate <-38.26009, -43.509804, 59.291286>
    translate  <8.650526, -6.489033, -2.66079>
  }
  superellipsoid { // ThingSQ5
    <2.75, 2.84>
    scale 0.2
    rotate -40.942867*y
    translate  <0.054928, -7.737706, -2.143414>
  }
  superellipsoid { // ThingSQ6
    <2.75, 2.84>
    scale 0.2
    translate  <8.267028, 10.367768, -7.485245>
  }
  superellipsoid { // ThingSQ7
    <2.75, 2.84>
    scale 0.2
    rotate <66.192734, 0.0, 16.742916>
    translate  <-11.459742, -2.969156, -3.444538>
  }
  superellipsoid { // ThingSQ8
    <2.75, 2.84>
    scale 0.2
    rotate <125.479691, 16.214783, -21.393875>
    translate  <0.260125, 4.928995, -8.056282>
  }
  superellipsoid { // ThingSQ9
    <2.75, 2.84>
    scale 0.2
    rotate -28.341377*x
    translate  <7.774614, 1.203214, -2.586879>
  }
  material {
    CootieTxtr
  }
  translate  <0.066241, 0.0, 1.059858>
}


union { // ThingCylGrp
  cylinder { // ThingCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <88.176689, 34.281143, 134.982681>
    translate  <0.313024, 4.960025, -2.586879>
  }
  cylinder { // ThingCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <72.957268, 50.479568, 15.065338>
    translate  <-4.308753, 8.298133, -2.586879>
  }
  cylinder { // ThingCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <16.939041, 17.67775, 142.582809>
    translate  <-4.482981, 1.8102, -6.799797>
  }
  cylinder { // ThingCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <129.225586, -7.853775, 57.403778>
    translate  <9.107476, -5.4115, -4.309148>
  }
  cylinder { // ThingCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <49.447647, 48.863007, -159.168808>
    translate  <0.965836, -2.936547, -8.204103>
  }
  cylinder { // ThingCyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <84.903755, 57.945908, 47.659729>
    translate  <-9.190356, 4.905408, -1.990709>
  }
  cylinder { // ThingCyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <157.56749, 11.324814, 163.695206>
    translate  <-8.692434, -3.588837, -7.091275>
  }
  cylinder { // ThingCyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <-13.481689, -12.151184, -153.88002>
    translate  <4.665207, 2.042578, -4.176666>
  }
  cylinder { // ThingCyl8
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <89.208565, 35.589005, -157.169556>
    translate  <4.879122, 9.188317, -2.586879>
  }
  cylinder { // ThingCyl9
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <-19.93132, -4.922287, 131.503708>
    translate  <8.054379, 6.026595, -4.706595>
  }
  cylinder { // ThingCyl10
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <-133.948395, 10.439362, 58.194458>
    translate  <-3.816489, -4.89241, -7.760638>
  }
  cylinder { // ThingCyl11
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <79.776352, -0.376785, -34.403473>
    translate  <-7.374747, -9.808604, -6.282421>
  }
  cylinder { // ThingCyl12
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <119.125854, 15.815216, -176.92717>
    translate  <-1.698479, 2.615339, -9.238855>
  }
  cylinder { // ThingCyl13
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <173.812897, 4.445847, -55.70649>
    translate  <1.816457, -8.225329, -2.586879>
  }
  cylinder { // ThingCyl14
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <109.950806, 35.64679, -134.483185>
    translate  <11.411402, -1.660207, -5.099848>
  }
  cylinder { // ThingCyl15
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <88.176689, 34.281143, 134.982681>
    translate  <-3.640505, -4.497846, -2.586879>
  }
  cylinder { // ThingCyl16
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <-105.217499, 14.251907, -150.548416>
    translate  <-11.752054, -1.865475, -6.208511>
  }
  cylinder { // ThingCyl17
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <88.176689, 34.281143, 134.982681>
    translate  <-5.812236, 9.633377, -2.586879>
  }
  cylinder { // ThingCyl18
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <91.286095, 47.198608, 172.497086>
    translate  <-2.248474, -11.113638, -5.691135>
  }
  cylinder { // ThingCyl19
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <34.060257, 24.761627, 107.911072>
    translate  <4.477996, -12.10737, -7.538906>
  }
  cylinder { // ThingCyl20
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate <128.195709, 40.760132, -143.810394>
    translate  <10.190843, 1.221122, -6.356332>
  }
  material {
    CootieTxtr
  }
  translate  <-0.066241, 0.0, 1.059858>
}


union { // ThingSphGrp
  object { ThingSphere }
  object { // ThingSphere1 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-6.293735, 6.01607, 0.0>
  }
  object { // ThingSphere2 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <5.156762, 0.18511, 3.047091>
  }
  object { // ThingSphere3 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-3.979862, -5.904871, 1.256484>
  }
  object { // ThingSphere4 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <4.45625, -13.51302, -1.523546>
  }
  object { // ThingSphere5 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-0.951863, -5.460741, 1.78851>
  }
  object { // ThingSphere6 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-11.106592, -3.331977, 4.305672>
  }
  object { // ThingSphere7 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <9.030456, 3.794752, 4.438154>
  }
  object { // ThingSphere8 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <9.930217, 2.160217, 4.239431>
  }
  object { // ThingSphere9 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <3.953548, -0.832994, 0.927376>
  }
  object { // ThingSphere10 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <4.152271, -7.774614, 2.782127>
  }
  object { // ThingSphere11 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-4.164972, -9.255493, 0.0>
  }
  object { // ThingSphere12 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <3.331977, -14.068349, 0.0>
  }
  object { // ThingSphere13 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <11.013124, -3.146868, 1.457304>
  }
  object { // ThingSphere14 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <1.995632, 8.056976, 1.78851>
  }
  object { // ThingSphere15 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-5.478356, -1.594241, -1.126099>
  }
  object { // ThingSphere16 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-4.724104, 6.668527, 4.636878>
  }
  object { // ThingSphere17 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-8.311258, 2.593582, 5.498012>
  }
  object { // ThingSphere18 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-5.828231, -5.299321, 4.968083>
  }
  object { // ThingSphere19 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-1.537881, -12.753229, 0.0>
  }
  object { // ThingSphere20 -> ThingSphere
    ThingSphere
    rotate -0.0*x
    translate  <-4.355595, 1.434102, 1.034752>
  }
  translate  <0.066241, 0.0, 1.523546>
}


object { // NyaHF3 -> NyaHF
  NyaHF
  scale <1.5, 1.5, 1.0>
  rotate 33.413712*z
  translate  <-12.865135, 10.181042, 0.0>
}


object { // NyaHF2 -> NyaHF
  NyaHF
  rotate <0.0, 0.0, 109.243256>
  translate  <-8.277316, 13.69813, -3.643261>
}


object { // NyaHF1 -> NyaHF
  NyaHF
  rotate <0.0, -0.0, -59.992352>
  translate  <14.479104, 0.411231, -7.243262>
}


object { NyaHF }


object { // PickerHF1 -> PickerHF
  PickerHF
  // PickerHF1 does not inherit transformations, so do 
  // inverse transformations of PickerHF
    translate  <7.634641, 0.410854, 0.813019>
    rotate 2.84086*z rotate -0.0*y rotate -0.0*x
    scale <1.0/2.0, 1.0/2.0, 1.0/0.1>
  // Now write the regular transformations of PickerHF1
  scale <2.0, 2.0, 0.1>
  rotate <-0.0, -180.0, -0.0>
  translate  <1.66082, 8.9824, -9.830142>
}


object { PickerHF }


object { // DrunkHF1 -> DrunkHF
  DrunkHF
  // DrunkHF1 does not inherit transformations, so do 
  // inverse transformations of DrunkHF
    translate  <-4.87348, -6.774523, 1.0>
    rotate 25.455303*z
    scale <1.0/3.0, 1.0/3.0, 1.0/0.1>
  // Now write the regular transformations of DrunkHF1
  scale <1.0, 1.0, 0.1>
  rotate <-0.0, -0.0, 73.953156>
  translate  <-3.548113, -1.207868, -0.88693>
}


object { // FlipperHf3 -> FlipperHF
  FlipperHF
  // FlipperHf3 does not inherit transformations, so do 
  // inverse transformations of FlipperHF
    translate  <0.356606, -0.500063, 4.225564>
    scale <1.0/3.0, 1.0/2.420601, 1.0/0.1>
  // Now write the regular transformations of FlipperHf3
  scale <1.0, 1.0, 0.1>
  rotate <-0.0, -0.0, -114.37159>
  translate  <-7.398193, 7.245628, -0.88693>
}


object { // FlipperHf2 -> FlipperHF
  FlipperHF
  // FlipperHf2 does not inherit transformations, so do 
  // inverse transformations of FlipperHF
    translate  <0.356606, -0.500063, 4.225564>
    scale <1.0/3.0, 1.0/2.420601, 1.0/0.1>
  // Now write the regular transformations of FlipperHf2
  scale <1.5, 1.5, 0.1>
  rotate 133.717438*z
  translate  <0.226475, -10.040405, -0.960841>
}


object { // DancerHF3 -> DancerHF
  DancerHF
  // DancerHF3 does not inherit transformations, so do 
  // inverse transformations of DancerHF
    translate  <6.8893, 6.476664, 6.430243>
    rotate -15.278161*z
    scale <1.0/2.5, 1.0/2.5, 1.0/0.1>
  // Now write the regular transformations of DancerHF3
  scale <2.0, 2.0, 0.1>
  rotate <0.855345, -179.759415, 16.996737>
  translate  <10.493355, 2.491228, -0.88693>
}


object { // DancerHF2 -> DancerHF
  DancerHF
  // DancerHF2 does not inherit transformations, so do 
  // inverse transformations of DancerHF
    translate  <6.8893, 6.476664, 6.430243>
    rotate -15.278161*z
    scale <1.0/2.5, 1.0/2.5, 1.0/0.1>
  // Now write the regular transformations of DancerHF2
  scale <1.0, 1.0, 0.1>
  rotate <-0.0, 0.0, 90.988167>
  translate  <2.009473, 3.784823, -0.88693>
}


object {   // PuncherHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf8.tga"
    water_level 0.2
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <3.0, 3.0, 0.1>
  translate  <-0.393302, -5.718865, -0.88693>
}


object {   // KickerHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf7.tga"
    water_level 0.1
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <3.5, 3.5, 0.1>
  rotate <-0.0, -0.0, -27.847509>
  translate  <7.210544, -2.302625, -0.960841>
}


object { DancerHF }


object { // NerdCootieGrp3 -> NerdCootieGrp
  NerdCootieGrp
  // NerdCootieGrp3 does not inherit transformations, so do 
  // inverse transformations of NerdCootieGrp
    translate  <-7.380867, 8.824812, 8.130192>
    rotate 30.808056*z
    scale <1.0/1.5, 1.0/1.5, 1.0/1.0>
  // Now write the regular transformations of NerdCootieGrp3
  scale <0.75, 0.75, 1.0>
  rotate 47.296341*z
  translate  <6.452031, 3.084681, 0.0>
}


object { // NerdCootieGrp2 -> NerdCootieGrp
  NerdCootieGrp
  // NerdCootieGrp2 does not inherit transformations, so do 
  // inverse transformations of NerdCootieGrp
    translate  <-7.380867, 8.824812, 8.130192>
    rotate 30.808056*z
    scale <1.0/1.5, 1.0/1.5, 1.0/1.0>
  // Now write the regular transformations of NerdCootieGrp2
  rotate 144.683105*z
  translate  <-11.164034, 2.680556, -4.286829>
}


object { // NerdCootieGrp1 -> NerdCootieGrp
  NerdCootieGrp
  // NerdCootieGrp1 does not inherit transformations, so do 
  // inverse transformations of NerdCootieGrp
    translate  <-7.380867, 8.824812, 8.130192>
    rotate 30.808056*z
    scale <1.0/1.5, 1.0/1.5, 1.0/1.0>
  // Now write the regular transformations of NerdCootieGrp1
  material {
    CootieTxtr
  }
  scale <0.8, 0.8, 1.0>
  rotate -106.333481*z
  translate  <-1.965986, 9.8311, 0.0>
}


object {   // PokerHF
  height_field {
    tga "C:\Program Files\POV-Ray for Windows v3.1\IMAGES\coothf5.tga"
    water_level 0.15
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    CootieTxtr
  }
  scale <4.0, 4.0, 0.1>
  rotate 18.679771*z
  translate  <-3.670823, 3.670823, -0.88693>
}


object { NerdCootieGrp }


object { DrunkHF }


object { FlipperHF }


plane { // Plane001
  z,0
  material {
    ApertureTexture
  }
  hollow
}




