#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "textures.inc"
#include "body.inc"
#include "body2.inc"

#declare limits=35;
#declare metalcol=pigment {rgb <0, 0, 0>}
#declare slocx=0;
#declare slocz=-2;
#declare gold=<1.00, 0.875, 0.575>;

camera {
	location <-0.85, 0.65, -5>
	look_at <0.35, 0.35, 0>
}

light_source {<0, 10, 0> color rgb 0.5
	parallel point_at <0, 2, 0>
	media_interaction on media_attenuation on
	fade_distance 20 fade_power 4
}

#declare bolts=
union {	
	sphere {<-0.4, 0, -0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.2, 0, -0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0, 0, -0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.2, 0, -0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.4, 0, -0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.4, 0, -0.2>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.4, 0, -0.2>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.4, 0, 0>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.4, 0, 0>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.4, 0, 0.2>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.4, 0, 0.2>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.4, 0, 0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<-0.2, 0, 0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0, 0, 0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.2, 0, 0.4>, 0.02 scale <1, 0.5, 1>}
	sphere {<0.4, 0, 0.4>, 0.02 scale <1, 0.5, 1>}
	texture {T_Silver_5E}
}

#declare pegboard=
union {
	torus {0.27, 0.02 scale <1, 0.5, 1> texture {T_Silver_5E}}
	object {bolts}
	difference {
		superellipsoid {<0.15, 0.15> scale <0.55, 0.55, 0.55> translate y*-0.55
			pigment {metalcol}
			normal {crackle 0.2 turbulence 0.5 scale 0.1}
			finish {F_MetalB}
		}
		cylinder {<0, -0.75, 0>, <0, 0.001, 0>, 0.25
			texture {T_Silver_5E
			 	normal {
			 		spiral1 1
			 		frequency 2
			 		scallop_wave scale <1, 0.025, 1>
			 		bump_size 0.15
				}
			}
		}
	}
}

#declare xmin=-limits-1;
#declare xmax=limits+1;
#declare zmin=-limits-1;
#declare zmax=limits+1; 
#declare cx=xmin;
#while (cx<=xmax)
	#declare cz=zmin;
	#while (cz<=zmax)
		object {pegboard translate <cx, 0, cz>}
		#declare cz=cz+1;
	#end
	#declare cx=cx+1;
#end

#declare peg=
union {
	cylinder {<0, -0.5, 0>, <0. 0.5, 0>, 0.2 hollow
		pigment {Col_Glass_General}
		finish {F_Glass3}
		interior {I_Glass3}
	}
	object {
		body
		rotate y*180 translate y*-0.25 scale 1.8
		pigment {rgbt <1, 1, 1, 0.5>}
	}
}

#declare sd=seed(123);
#declare xmin=-limits-1;
#declare xmax=limits+1;
#declare zmin=-limits-1;
#declare zmax=limits+1;
#declare chance=0.25;
#declare cx=xmin;
#while (cx<=xmax)
	#declare cz=zmin;
	#while (cz<=zmax)
		#declare r=rand(sd);
		#if (r<chance & (cx!=slocx | cz!=slocz))
			object {peg translate <cx, 0, cz>}
		#end
		#declare cz=cz+1;
	#end
	#declare cx=cx+1;
#end

union {
	box {<-0.25, 0, -0.25>, <0.25, 1, 0.25> hollow
		pigment {Col_Glass_General}
		normal {facets coords 0.15 turbulence 0.75 omega 0.25 lambda 4 scale 0.75}
		finish {F_Glass3}
		interior {I_Glass3 caustics 0.2 media {emission gold*0.25}}
		rotate y*-15
	}
	light_source {<0, 0.46, 0> color rgb gold
		looks_like {object {body2 texture {T_Gold_5E} rotate y*165 translate y*-0.25 scale 1.7}}
		media_attenuation on media_interaction on
		fade_distance 0.5 fade_power 8
	}
	translate <slocx, 0, slocz>
}

#declare air=
density {rgb 0.025}

#declare clouds=
density {
	wrinkles turbulence 0.2 lambda 4 omega 0.05 octaves 8
	density_map {
		[0 rgb 0.5]
		[0.3 rgb 1.5]
		[0.6 rgb 0.5]
		[0.7 rgb 0.1]
		[1 air]
	}
	scale <1.75, 0.025, 1.75>
}

sphere {<0, 0, 0>, 1 hollow scale <limits*10, 10, limits*10>
	pigment {Clear}
	interior {
		caustics 0.9
		media {
			scattering {3, 0.2}
			intervals 3
			samples 3, 3
			method 3
			density {
				gradient y
				density_map {
					[0 air]
					[0.075 air]
					[0.15 clouds]
					[1 clouds]
				}
				scale <1, 10, 1>
			}
		}
	}
}