/* $Id: altar-piece.pov,v 1.3 2002/08/26 20:17:56 ziotom Exp $ */

/* Extents: from <-0.25, 0, -1> to <0.25, ?, 1>, where ? means 3 or
 * 4 units. */

#declare IMPORT_SPATCH = 1;

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"

#include "statue.pov"

// Uncomment this to compile this .pov file alone
// #declare STANDALONE = 1;

#local AltarTexture =
texture {
	pigment {
		granite
		turbulence 0.4
		omega 0.3
		lambda 0.7
		color_map {
			[0.00 color rgb 1.2]
			[0.75 color rgb 0.9]
			[1.00 color rgb 0.1]
		}

		scale 0.5
	}

	normal {
		granite 0.4
		turbulence 0.4
		omega 0.3
		lambda 0.7

		scale 0.5
	}
}

#local FrameTexture =
texture {
	T_Wood9
	rotate 31*x
	rotate 17*y
	rotate 41*z
}

#local ColumnBaseTexture =
texture {
	T_Stone10
}

#local ColumnTexture =
texture {
//	T_Stone21

	pigment {
		agate
		turbulence 0.6
		omega 0.6
		lambda 0.2
		color_map {
			[0.00 color <0.70, 0.30, 0.35>]
			[0.90 color <0.65, 0.40, 0.40>]
			[1.00 color <0.55, 0.55, 0.55>]
		}

		scale 0.1
	}

	normal {
		agate 0.2
		turbulence 0.6
		omega 0.6
		lambda 0.2

		scale 0.1
	}

	finish { phong 0.4 }
}

#local BackgroundWallTexture =
texture {
	AltarTexture
}

#local StatueTexture =
texture {
	T_Grnt1a
}

#local ReliefTexture =
texture {
	pigment {
		agate
		turbulence 0.8
		omega 0.7
		color_map {
			[0.00 color <1.0, 0.8, 0.8>]
			[0.33 color <1.0, 1.0, 0.8>]
			[0.66 color <1.0, 0.9, 0.9>]
			[1.00 color White]
		}
	}
	normal {
		agate 0.3
		turbulence 0.8
		omega 0.7
	}
}

#ifdef (STANDALONE)
	camera { 
		location <5, 2.2, 0>
		look_at <0, 2.2, 0>
		up y
		right x
	}

	light_source {
		<5, 4, -5>
		color rgb 1
	}
#end

/***********************************************************************/
/* Altar piece */
/***********************************************************************/

#local MainAltarPiece =
union {
	box {
		<0.25, 0, -1>, <-0.25, 0.05, 1>
		texture { AltarTexture }
	}

	box {
		<0.25 - 0.05, 0.05, -1 + 0.05>,
			<-0.25 - 0.05, 0.95, 1 - 0.05>
		texture { AltarTexture }
	}

	box {
		<0.5, 0.95, -1>, <-0.5, 1, 1>
		texture { AltarTexture }
	}

	box {
		<0.5, 1 + 1.85 + .35, -1>,
			<-0.5, 1 + 1.85 + .35 + 0.1, 1>
		texture { AltarTexture }
	}
}

#local AltarPiece =
difference {
	object { MainAltarPiece }

	box {
		<0.3, 0.2, -0.8>, <0.1, 0.8, 0.8>
		texture { T_Grnt25 rotate <0.6, 0.1, 0.7> * 35 scale 0.3 }
	}
}

/***********************************************************************/
/* The background wall */
/***********************************************************************/

#local BackgroundWall =
box {
	<-0.25, 1, -1>, <-0.5, 1 + 1.85 + .35, 1>
	texture { BackgroundWallTexture }
}

/***********************************************************************/
/* Relief on the altar */
/***********************************************************************/

#local Relief =
height_field {
	png "relief.png"
	water_level 0.1
	texture { ReliefTexture }
	translate <-0.5, 0, -0.5>
	scale <1.6, 0.05, 0.6>
	rotate -90*z
	rotate 90*x
	translate <0.1, 0.5, 0>
}

/***********************************************************************/
/* The painting */
/***********************************************************************/

#local Painting =
box {
	<0, 1.1, -0.5>, <-0.5, 1.1 + 1.85, 0.5>

	pigment {
		image_map {
			jpeg "latour.jpg"
		}

		translate <0.5, 0.5, 0>
		scale <1.0, 1.85, 1.0>
		rotate -90*y
	}
}

/***********************************************************************/
/* The two columns standing by the painting */
/***********************************************************************/

#local ColumnRadius = 0.12;

#local Column =
union {
	torus {
		(ColumnRadius * 5/4) .03
		translate <0, 1, 0>
		texture { ColumnBaseTexture }
	}

	torus {
		ColumnRadius .015
		translate <0, 1 + .03, 0>
		texture { ColumnBaseTexture }
	}

	cylinder {
		<0, 1, 0>, <0, 1 + 1.85 + .35, 0>, ColumnRadius
		texture { ColumnTexture }
	}

	torus {
		(ColumnRadius * 5/4) .03
		translate <0, 1 + 1.85 + .35, 0>
		texture { ColumnBaseTexture }
	}

	torus {
		ColumnRadius .015
		translate <0, 1 + 1.85 + .35 - .03, 0>
		texture { ColumnBaseTexture }
	}
}

/***********************************************************************/
/* Painting frame */
/***********************************************************************/

#local PaintingFrame =
height_field {
	png "frame.png"
	smooth
	water_level 0.1
	texture { FrameTexture }
	translate <-0.5, 0, -0.5>
	scale <1, 0.1, 1.85> * 1.15
	rotate -90*z
	rotate 90*x
	translate <0, 1 + 1.85 / 2 + .1, 0>
}

/***********************************************************************/
/* Altar top */
/***********************************************************************/

#local AltarTop =
height_field {
	png "altar-top.png"
	smooth
	water_level 0.01
	texture { AltarTexture }
	translate <-0.5, -0.5, 0>
	rotate -90*y
	rotate -90*z
	scale <1, 0.3, 2>
	translate <0, 1 + 1.85 + .35 + .1, 0>
}

/***********************************************************************/
/* Statue on the top */
/**********************************************************************/

#local Statue =
object {
	union {
		object { StatueBody }
		object { StatueArms }
		object { StatueCross }
	}

	scale 0.3
	rotate -90*y
	translate <0.2, 4.3, 0>
	pigment { color rgb 1 }
}

#declare Altar =
union {
	object { AltarPiece }
	object { AltarTop }
	object { BackgroundWall }

	object { Relief }

	object { Painting }
	object { PaintingFrame }

	object { Statue }

	object { Column translate <0.2, 0, -0.75> }
	object { Column translate <0.2, 0, 0.75> }
}

#ifdef (STANDALONE)
object { Altar }
#end
