/* $Id: altar.pov,v 1.2 2002/08/25 18:18:37 ziotom Exp $ */

#include "colors.inc"

#declare Gray_Marble_Color_Map = 
color_map {
    [0.0 rgb 1 * 2 ]
    [0.8 rgb 1 * 0.7 * 2]
    [1.0 rgb 1 * 0.4]
}
// White marble with gray veins
#declare GrayMarble = 
pigment {
    marble
    color_map { Gray_Marble_Color_Map }
    turbulence 0.6
}

#declare AltarTexture = texture { GrayMarble }

camera {
	location <7.92, 1, 5.00>
	look_at <1.27, 1, 5.00>
}

light_source {
	<4.92, 3, 0> color rgb 1 * 0.2
}

#declare AltarBody =
difference {
	box {
		<-0.5, 0.2, -0.5>, <0.5, 1, 0.5>
		texture { AltarTexture }
	}

	box {
		<0.47, 0.35, -0.38>, <0.51, 0.85, 0.38>
		texture { AltarTexture }
	}
}

#declare Altar =
union {
	cylinder {
		<-0.6, 0.1, -0.6>, <0.6, 0.1, -0.6>, 0.1
		texture { AltarTexture }
	}

	cylinder {
		<-0.6, 0.1, 0.6>, <0.6, 0.1, 0.6>, 0.1
		texture { AltarTexture }
	}

	box {
		<-0.6, 0, -0.6>, <0.6, 0.2, 0.6>
		texture { AltarTexture }
	}

	box {
		<-0.6, 1, -0.6>, <0.6, 1.1, 0.6>
		texture { AltarTexture }
	}

	object { AltarBody }
}

object {
	Altar
	scale <1.0, 1.0, 2.0>
	translate <0.0, 0.0, 3.29 + 3.57/2>

	finish {
		ambient 0.3
		diffuse 0.45
	}
}
