/* $Id: arches.pov,v 1.3 2002/08/26 20:59:38 ziotom Exp $ */

/***********************************************************************/
/* Arches */
/***********************************************************************/

#declare ArchTexture = texture {
	pigment {
		rgb <0.66, 0.68, 0.58>
		quick_color White
	}
}


#declare TwoArches =
union {
	object {
		Arch
		translate <-0.5, 0, 0>
	}

	object {
		Arch
		translate <0.5, 0, 0>
	}

	texture { ArchTexture }
	finish { diffuse 0.65 ambient 0 }
}

#declare ThreeArches =
union {
	object {
		Arch
		scale <1.2, 1.0, 1.0>
	}

	object {
		Arch
		scale <1.2, 1.0, 1.0>
		translate <-1, 0, 0>
	}

	object {
		Arch
		scale <1.2, 1.0, 1.0>
		translate <1, 0, 0>
	}

	texture { ArchTexture }
	finish { diffuse 0.65 ambient 0 }
}

object {
	TwoArches
	rotate 90*y
	scale <1, 1, 6.5 / 2 - 0.4>
	translate <-11.1, 2, 9.15>
}

object {
	TwoArches
	rotate 90*y
	scale <1, 1, 6.5 / 2 - 0.4>
	rotate -45*y
	translate <-8.8, 2, 3.6 + 0.2>
}

object {
	TwoArches
	rotate 90*y
	scale <1, 1, 6.5 / 2 - 0.4>
	rotate 45*y
	translate <-8.8, 2, 14.7 - 0.2>
}

object {
	ThreeArches
	scale <6.5 / 3 - 0.4, 1, 1>
	translate <-3.25, 2, 1.3 - 0.3>
}

object {
	ThreeArches
	scale <6.5 / 3 - 0.4, 1, 1>
	translate <-3.25, 2, 17 + 0.3>
}

