/* $Id: benches.pov,v 1.4 2002/08/25 18:18:37 ziotom Exp $ */

/***********************************************************************/
/* Benches */
/***********************************************************************/

#declare BenchTexture = texture {
	T_Wood2
	pigment {
		quick_color Brown
	}
	/* Give some randomness to the texture... */
	rotate 31*y
	rotate 16*x
}

#declare Bench =
union {
	object { Bench1 }
	object { Bench2 }
	object { Bench3 }

	scale <0.3, 0.3, 0.6>
	rotate y*-90
	translate <16, 0.35, 9.15>

	texture { BenchTexture }
	finish { diffuse 0.65 ambient 0 }
}

#local ZSpace = 8.0;

#declare Count = -2;
#while (Count <= 0)
	object { Bench translate <0, 0, -ZSpace/2 + 1.2 * Count> }
	object { Bench translate <10, 0, -ZSpace/2 + 1.2 * Count> }
	#declare Count = Count + 1;
#end

object { Bench translate <22, 0, 3> }

#declare Count = 0;
#while (Count < 3)
	object { Bench translate <0, 0, ZSpace/2 + 1.2 * Count> }
	object { Bench translate <10, 0, ZSpace/2 + 1.2 * Count> }
	#declare Count = Count + 1;
#end


/***********************************************************************/
/* Kneeling stool */
/***********************************************************************/

object {
	KneelingStool
	scale <0.4, 0.45, 0.4>
	rotate y*180
	translate <3, 0.35, 0.9 + 9.15>

	texture { BenchTexture }
	finish { diffuse 0.65 ambient 0 }
}

