/* $Id: candlestick.pov,v 1.2 2002/08/25 19:02:53 ziotom Exp $ */

/***********************************************************************
 * The "Candlestick" object. It is fully enclosed in a <-0.5, 0, -0.5>,
 * <0.5, 1, 0.5> box.
 ***********************************************************************/

#local LegRadius = 0.02;

#declare Candlestick =
union {
	box {
		<-0.5, 0.9, -0.5>, <0.5, 1, 0.5>
	}

	difference {
		box {
			<-0.15, 0.65, -0.5>, <0.15, 0.89, -0.3>
		}
	
		box {
			<-0.05, 0.82, -0.6>, <0.05, 0.85, -0.4>
		}
	}

	cylinder {
		<0, 0.9, 0>, <0, 0.2, 0>, LegRadius
	}
	
	cylinder {
		<0, 0.2, 0>, <-0.3, 0, -0.3>, LegRadius
	}
	
	cylinder {
		<0, 0.2, 0>, <0.3, 0, -0.3>, LegRadius
	}
	
	cylinder {
		<0, 0.2, 0>, <-0.3, 0, 0.3>, LegRadius
	}
	
	cylinder {
		<0, 0.2, 0>, <0.3, 0, 0.3>, LegRadius
	}
	
	cylinder {
		<-0.15, 0.1, -0.15>, <0.15, 0.1, -0.15>, LegRadius
	}
	
	cylinder {
		<-0.15, 0.1, -0.15>, <-0.15, 0.1, 0.15>, LegRadius
	}
	
	cylinder {
		<0.15, 0.1, 0.15>, <0.15, 0.1, -0.15>, LegRadius
	}
	
	cylinder {
		<0.15, 0.1, 0.15>, <-0.15, 0.1, 0.15>, LegRadius
	}

	texture {
		pigment {
			color rgb 0.5
		}
		
		normal {
			granite 0.1
		}

		finish {
			ambient 0
			diffuse 0.65
			specular 0.1
			roughness 0.01
		}
	}
}

object { Candlestick }
