#include "functions.inc"
#include "rad_def.inc"

global_settings {
  radiosity {
//		Rad_Settings(Radiosity_Fast, off, off)
		Rad_Settings(Radiosity_OutdoorHQ, off, off)
  }
}


// Camera
camera {
	location 16*y
	look_at 15
}

//Fog
fog {
  fog_type 1
  distance 80
  color rgb 0.5
  turbulence 0.3
  turb_depth 5
}

// Light Source

light_source {
	<5000, 4000, -7000>
	colour rgb 0.5
	shadowless
}


// Standing Stone
isosurface {
	function {
		(pow(x,2)*4.3) + (pow(y,2)/12) + (pow(z,2)*3.5) + (f_hetero_mf(x/2, y/4.6, z/4, 1, 5, 10, 0, 0.9, 0)*5)
	}
	max_gradient 18
	contained_by {
		box {
			<-2, -1, -2>,
			< 2,  9,  2>
		}
	}
	pigment {
		colour rgb 0.5
	}
	scale 10
	translate <40, 0, 50>
}

// Grass
isosurface {
	function {
		y + (f_noise3d(x*2, y/17, z*2)*9)
	}
	max_gradient 21.912
	contained_by {
		box {
			<   0, -10,    0>,
			<1000, 30, 1000>
		}
	}
	pigment {
		colour green 0.6
	}
}
