#declare WATER     = 1;
#declare FOG       = 1;
#declare BOAT      = 1;
#declare RADIOSITY = 1;
#declare LOON      = 1;

global_settings { 
	#if(RADIOSITY)	
		radiosity { 
			recursion_limit 2
			count 25 nearest_count 6
			error_bound .8 low_error_factor .1
		} 
		ambient_light 0
	#end
}

camera { location <-10,3,10> look_at 0 }

light_source { 300 rgb .4 shadowless }
light_source { 300 rgb .6}

sky_sphere { pigment { bozo color_map { [0 rgb .3][1 rgb 1] } turbulence .6  } }


#if(BOAT)
#declare boat =
	#include "vene.pov"

object { boat rotate y*100 translate <3,-1.75,0>}
#end

#declare waveset =
function { pigment { granite scale <1,1,4>*5 rotate y*20 } }

#declare water =
	texture {
		pigment { rgb 1 }
		finish { reflection { 0 1 fresnel on } diffuse .01 conserve_energy }
	}

#if(WATER)

#declare siz = 75;

box { <-siz,-2,-siz> <siz,-3,siz> texture { pigment { rgb 0 } } }

#if(BOAT)

difference {

#end

	isosurface {
		function {y+.75*waveset(.6*x,.6*y,.6*z).hf }
		contained_by { box { <-siz,-2.1,-siz> <siz,.06,siz> } }
		accuracy 0.001
		max_gradient 2

		material {
			texture { water }

			interior { 
				ior 1.33 
			}
		}

		hollow

	}
#if(BOAT)
	difference {
		object { water_difference rotate y*100 translate <3,-1.75,0> translate <.1,-.1,-.2> }
		plane { y, -1.25 texture { water } }
	}
	hollow
} // difference
#end
plane {
	y, -2
	material {
	texture { water }
	interior { ior 1.33 }
	}
}

#else
#if(BOAT)
difference {
#end

plane {
	y 0
	material {
	texture { water }
	interior { ior 1.33 }
	}
}
#if(BOAT)
difference {
object { water_difference scale <1.1,1,1> translate <.15,0,0> rotate y*100 translate <3,-1.75,0> }
plane { y, -1.35 texture { water } }
}
}
#end
#end

#if(FOG)
fog {
	rgbf <.48,.48,.48,.3>
	fog_type 2
	distance 13
	fog_offset 1
	fog_alt 1
}
#end
#if(LOON)
#declare aloon =
	#include "loon.pov"

object { aloon rotate y*220 scale .4 translate <25,0,0> }
#end
