global_settings {
  assumed_gamma 2.2
  radiosity { count 200 error_bound 1.4 brightness 0.5 }
}

default {
  finish { ambient 0 diffuse 1 }
}

#include "fakewood.inc"
#include "crayon.inc"
#include "box.inc"

camera {
   location < 0, 0, -15 >
   look_at 0
   rotate < 45, -30, 0 >
   translate < 0, 2.5, 1 >
   angle 35
}

light_source {
  < 10, 20, -10 > color rgb 1
  area_light 2*x, 2*y, 8, 8 circular orient
}
light_source { < -20, 10, -10 > color rgb 0.5 shadowless }

box {
  < 72, 0, -144 >, < 73, 72, 144 >
  texture {
    pigment { color rgb 1 }
    finish { ambient 1 diffuse 0 }
  }
}
union {
  box { < 0, 120, -48 >, < 12, 121, -36 > }
  box { < 0, 120, -24 >, < 12, 121, -12 > }
  box { < 0, 120, 0 >, < 12, 121, 12 > }
  box { < 0, 120, 24 >, < 12, 121, 36 > }
  box { < -24, 120, -48 >, < -12, 121, -36 > }
  box { < -24, 120, -24 >, < -12, 121, -12 > }
  box { < -24, 120, 0 >, < -12, 121, 12 > }
  box { < -24, 120, 24 >, < -12, 121, 36 > }
  texture {
    pigment { color rgb < 1, 1, 0.7 > }
    finish { ambient 1 diffuse 0 }
  }
}

/*sky_sphere {
    pigment {
        gradient y
        color_map {
            [0, 1 color rgb 0.5 color rgb 0.8]
        }
    }
}*/

union { WholeCrayon rotate < 20, -45, 0 > translate < -0.48, 0.25, -0.9 > }
plane { y, 0 texture { FakeWood } }
union { CompleteBox }
