//sentinel
//by tek


//scene controls

#declare gboMedia = on;
#declare gboBlur = on;

#declare colSky = rgb<4,2,1>/4;
#declare colGround1 = rgb <.6,.12,.1>*.6;
#declare colGround2 = rgb <.6,.165,.05>*.8;


//includes

#include "rad_def.inc"
#include "functions.inc"


//global set up

global_settings {
  assumed_gamma 1
	max_trace_level 8//20
	radiosity {
    Rad_Settings(Radiosity_Fast, off, off)
	}
}

#default { pigment { rgb 1 } finish { diffuse 1 ambient 0 } }



//the scene

#declare f_Granite =
	function {
		pigment {
			granite
			colour_map {
				[0	rgb 0]
				[1	rgb 1]
			}
		}
	}

#macro m_oPlanet( vPos, fRad, tSurface )

	#if ( vPos.z = 0 )
		#local fHeightScale = 40; //planet we're on.
	#else
		#local fHeightScale = 200;//background planets.
	#end
	
	union {
		sphere {
			0, fRad
			texture { tSurface }
		}
		sphere {
			0, fRad + fHeightScale*8
			hollow on
			
			material {
				texture {
					pigment { rgbt 1 }
				}
				interior {
#if (gboMedia)
					media {
						scattering {
							5, colSky
							extinction 1
							eccentricity .9
						}
						absorption 0
						
						aa_threshold .001 //fixes some wierdness.
						
						density {
							#local fDensity = .0003;
							function {
								fDensity*exp(
									-(
										sqrt(x*x+y*y+z*z) - fRad
										+ (-.5 + f_Granite(x/2000,y/2000,z/2000).red)*400
									)/fHeightScale
								)
							}
							
							density_map {
								[0	rgb 0]
								[1	rgb 1]
							}

						}//density							
					}//media
#end
				}//interior
			}//material
		}//sphere (atmosphere)
		
		translate vPos
	}//union
#end //macro

#declare tGroundNear =
	texture {
		pigment {
			granite
			turbulence .2
			scale 8
			colour_map {
				[0 colGround1]
				[1 colGround2]
			}
		}
		normal {
			granite -.2
			//poly_wave .1
			scale 1
		}
	}

#declare tGroundFar =
	texture {
		pigment {
			granite
			turbulence .2
			scale 3000
			colour_map {
				[0 colGround1]
				[1 colGround2]
			}
		}
		normal {
			granite .8
			poly_wave .1
			scale 7000
		}
	}

m_oPlanet( -y*10000, 10000, tGroundNear )

m_oPlanet( <1,1,6>*10000, 10000, tGroundFar )

m_oPlanet( <-.5,1,12>*10000, 10000, tGroundFar )


//some rock like objects
#declare rsRockForm = seed(2179);

#macro m_oRock()
	intersection {
		box { -1, 1 }
		box { -1, 1 rotate <rand(rsRockForm),rand(rsRockForm),rand(rsRockForm)>*360 }
		box { -1, 1 rotate <rand(rsRockForm),rand(rsRockForm),rand(rsRockForm)>*360 }
		
		texture {
			pigment {
				agate
				agate_turb .9
				scale .4
				rotate <rand(rsRockForm),rand(rsRockForm),rand(rsRockForm)>*360
				colour_map {
					[0 rgb <.4,.3,.25>]
					[1 rgb <.8,.6,.5>]
				}
			}
		}
	}
#end

#declare nRockVariations = 4;
#declare aoRock = array[nRockVariations];
#declare nRock = 0;
#while ( nRock < nRockVariations )
	#declare aoRock[nRock] = m_oRock();
	#declare nRock = nRock + 1;
#end


#declare nRocksNum = 12000;
#declare vRocksAreaMax = <300,0,500>;
#declare vRocksAreaMin = <-299.7,0,-1.5>;
#declare rsRockPos = seed(29711);
#declare rsRockRot = seed(22284);
#declare rsRockRad = seed(421);
#declare fRockRadMin = .1;
#declare fRockRadMax = .2;

#declare oAllRocks =
	union {
		#declare nRock = 0;
		#while (nRock < nRocksNum )
		
			#declare vPos = <rand(rsRockPos),rand(rsRockPos),rand(rsRockPos)>*(vRocksAreaMax - vRocksAreaMin) + vRocksAreaMin;
			
			//compute y val to put it on spherical ground
			#declare vPos = vPos*<1,0,1> + y*( (sqrt(1 - vdot(vPos/10000,vPos/10000)) - 1)*10000 );

			#declare fRockRad = pow(rand(rsRockRad),2)*(fRockRadMax-fRockRadMin) + fRockRadMin;
			
			object {
				aoRock[mod(nRock,nRockVariations)]
				rotate <rand(rsRockRot),rand(rsRockRot),rand(rsRockRot)>*360
				scale fRockRad
				translate vPos + y*fRockRad*.7
			}
		
			#declare nRock = nRock + 1;
		#end
	}

object { oAllRocks }


//moon
//tek: removed this from the final image because it was mostly just a sillouhette against the stars and looked a bit lame!
/*julia_fractal {
	m_JuliaPalette(100)
	max_iteration	8
	precision			20
	rotate <0,135,0>
	rotate <-30,0,0>*/
/*isosurface {
	function {
		f_sphere(x,y,z,.7)
		-.2+f_Granite(x/5,y/5,z/5).red*.5
	}
	max_gradient 2
	contained_by { sphere { 0, 2 } }
	
	scale 3000
	translate <-2,1.8,8>*10000
	
	finish { ambient 0 }
}*/




//the figure
#declare oFigure =
	union {
		#macro m_FigJulia(nCode, nIter, vRotate, vScale, vPos)
			julia_fractal {
				//bizarre technique to set julia parameters. I rendered an animation of all 256 values values of nCode,
				//then picked which ones I wanted to use in this scene.
				<mod(nCode,4),mod(int(nCode/4),4),mod(int(nCode/16),4),mod(int(nCode/64),4)>*.6/3
				
				max_iteration	nIter
				precision			20
			
				rotate <0,0,90>
				rotate vRotate
				
				scale vScale
				translate <-1.3,.9,7>+vPos
				
			}
		#end //macro
	
		intersection {
			m_FigJulia( 9, 9, <0,0,0>, <.5,.4,.4>, 0 )
			plane { -y, 0 rotate z*5 translate <-1.3,.9,7> }
			translate y*.05
			translate y*.2
		}
		intersection {
			m_FigJulia( 60, 8, <0,0,0>, <.4,.4,.4>, .1*x )
			plane { y, 0 rotate <5,0,8> rotate <0,10,0> translate <-1.3,1.05,7> }
			translate -y*.05
			translate y*.2
		}
		m_FigJulia( 240, 8, <0,0,0>, <.2,.3,.2>, <0,.8,0> )
		m_FigJulia( 172, 9, <0,-10,0>, <.35,1,.25>, <0,-.8,0> )
	
		material {
			texture {
				finish { diffuse .5 reflection { 0, 1 fresnel } conserve_energy specular 1 roughness .001 }
			}
			interior {
				ior 1.3
			}
		}
	}

object { oFigure }


//camera/lights, etc.

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z*2

	location <.4,.4,-.5>
	look_at <.2,1,7>

	#if ( gboBlur )
		aperture			.03
		blur_samples	20
		focal_point		<.4,.4,-.5> + (<.2,1,7>-<.4,.4,-.5>)*1.5
//		confidence		.7
//		variance			1/32
	#end
}

light_source {
	<-1,2,3>*1000000
	rgb 1
	area_light x*10000,y*10000,4,4 adaptive 1 circular orient
}


//stars
sky_sphere {
	pigment {
		spotted
		scale .003*320/image_width //keep it the right size relative to the image pixels.
		poly_wave 20
		colour_map {
			[0 rgb 0]
			[1 rgb 5]
		}
	}
}

