// Persistence of Vision Ray Tracer Include File
// File: SKS_Sunset.inc
// Vers: 3.5
// Desc: Sky from "The Burial" ("Loneliness" IRTC entry)
// Date: 07/09/2002
// Auth: Copyright  2002 by Sherry K. Shaw


//**********************************************************
// The sky pigments...
//**********************************************************

#declare SKY_PIG =                    // Out of the clear blue of the western sky...
pigment {
  gradient y
  color_map {
    [ 0.5 color rgb < 0.3, 0.4, 1.0 > ]
    [ 1.0 color rgb < 0.0, 0.0, 0.4 > ]
  }
  scale 2
  translate -1
}

#declare CLOUD_PIG =
pigment {
  spotted
  turbulence 3.5
  color_map {
    [ 0.0 1.0 color rgbf < 1.0, 1.0, 1.0, 1.0 > color rgbf < 1.0, 1.0, 1.0, 0.3 > ]
  }
  scale < 0.7, 0.2, 0.7 >
  rotate y*180                        // Just rotated to a spot I liked...
}

#declare SUNSET_PIG =
pigment {
  gradient y
  turbulence 0.01
  color_map {
    [ 0.0 0.3 color rgbf < 1.0, 0.4, 0.0, 0.4 > color rgbf < 1.0, 0.8, 0.0, 0.7 > ]
    [ 0.3 0.6 color rgbf < 1.0, 0.8, 0.0, 0.7 > color rgbf < 0.0, 0.0, 0.0, 1.0 > ]
    [ 0.6 1.0 color rgbf < 0.0, 0.0, 0.0, 1.0 > color rgbf < 0.0, 0.0, 0.0, 1.0 > ]
  }
  scale 0.5
}

//**********************************************************
// The sky...
//**********************************************************
//sky_sphere {
//  pigment {
//    SKY_PIG
//  }
//  pigment {
//    CLOUD_PIG
//  }
//  pigment {
//    SUNSET_PIG
//  }
//}
