/* SUBWAY.POV - Programmed by Maarten Hofman */
/* 240602: Started programming */
/* 250602: Changed to a shredder */
/* 020702: Changed to collaboration */
/* 190702: Changed to lonely */
/* 220702: Added the door sides */
/* 230702: Made the chairs more realistic and added frames */
/* 240702: Added graffiti */

#include "colors.inc"
#include "metals.inc"
#include "glass.inc"
#include "woods.inc"
#include "stones.inc"

camera {  
  location <1.5,1.5,1>
  look_at <2,1.3,10>
//  location <1,1.5,5>
//  look_at <3.5,0.1,8>  
//  location <1.9,1,3>
//  look_at <0.75,0,2.75>
}

background {
  colour White
}

/* Tunnel */
difference {
  box {
    <-100,-100,-100>,
    <100,100,100>
  }
  box {
    <0,0,0>,
    <4,3,20>
  }
  pigment {
    Black
  }
}

/* Windows cut out */
#declare wco = union {
  box {
    <1.7,1,11>,
    <2.3,1.8,9>
  }
  box {
    <1.7,0.3,11>,
    <2.3,0.6,9>
  }
  box {
    <0.4,0.3,8.7>,
    <0.6,1.8,8.55>
  }
  box {
    <0.4,0.3,8.45>,
    <0.6,1.8,8.3>
  }
  box {
    <0.4,1,6>,
    <0.6,1.3,8>
  }
  box {
    <0.4,1.4,6>,
    <0.6,1.7,8>
  }
  box {
    <0.4,1,5>,
    <0.6,1.4,3>
  }
  box {
    <0.4,1.5,5>,
    <0.6,1.7,3>
  }   
  box {
    <3.4,0.3,8.7>,
    <3.6,1.8,8.55>
  }
  box {
    <3.4,0.3,8.45>,
    <3.6,1.8,8.3>
  }
  box {
    <3.4,1,6>,
    <3.6,1.3,8>
  }
  box {
    <3.4,1.4,6>,
    <3.6,1.7,8>
  }
  box {
    <3.4,1,5>,
    <3.6,1.4,3>
  }
  box {
    <3.4,1.5,5>,
    <3.6,1.7,3>
  }
}

/* Frames */
difference {
  union {   
    box {
      <1.68,0.98,10>,
      <2.32,1.82,9.97>
    }
    box {
      <0.9,0.5,10>,
      <1.4,1,9.97>
    }
    box {
      <1.68,0.28,10>,
      <2.32,0.62,9.97>
    }
    box {
      <0.5,0.28,8.72>,
      <0.53,1.82,8.53>
    }
    box {
      <0.5,0.28,8.47>,
      <0.53,1.82,8.28>
    }
    box {
      <0.5,0.98,5.98>,
      <0.53,1.32,8.02>
    }
    box {
      <0.5,1.38,5.98>,
      <0.53,1.72,8.02>
    }
    box {
      <0.5,0.98,5.02>,
      <0.53,1.42,2.98>
    }
    box {
      <0.5,1.48,5.02>,
      <0.53,1.72,2.98>
    }   
    box {
      <3.5,0.28,8.72>,
      <3.47,1.82,8.53>
    }
    box {
      <3.5,0.28,8.47>,
      <3.47,1.82,8.28>
    }
    box {
      <3.5,0.98,5.98>,
      <3.47,1.32,8.02>
    }
    box {
      <3.5,1.38,5.98>,
      <3.47,1.72,8.02>
    }
    box {
      <3.5,0.98,5.02>,
      <3.47,1.42,2.98>
    }
    box {
      <3.5,1.48,5.02>,
      <3.47,1.72,2.98>
    }
  }
  object {
    wco
  }
  box {
    <0.92,0.52,11>,
    <1.38,0.98,9>
  }
  texture {
    T_Chrome_1A
  }
}

/* Details */
union {
  box {
    <3.5,1.6,5.02>,
    <3.47,1.62,2.98>
  }
  box {
    <3.5,1.9,3.95>,
    <3.43,1.92,4.05>
  }
  box {
    <0.5,1.1,5.9>,
    <0.57,1.12,5.92>
  }
  box {
    <0.5,1.5,5.9>,
    <0.57,1.52,5.92>
  }       
  box {
    <1.5,1.1,10>,
    <1.53,1.2,9.97>
  }
  box {
    <1.51,1.15,10>,
    <1.52,1.16,9.92>
  }
  box {
    <1.51,1.15,9.92>,
    <1.61,1.16,9.91>
  }
  texture {
    T_Chrome_1A
  }
}

/* Windows */
union {
  box {
    <1.7,1,10>,
    <2.3,1.8,10.01>
  }
  box {
    <1.7,0.3,10>,
    <2.3,0.6,10.01>
  }       
  box {
    <0.5,0.3,8.7>,
    <0.49,1.8,8.55>
  }
  box {
    <0.5,0.3,8.45>,
    <0.49,1.8,8.3>
  }
  box {
    <0.5,1,6>,
    <0.49,1.3,8>
  }
  box {
    <0.5,1.4,6>,
    <0.49,1.7,8>
  }
  box {
    <0.5,1.5,5>,
    <0.49,1.7,3>
  }   
  box {
    <3.5,0.3,8.7>,
    <3.51,1.8,8.55>
  }
  box {
    <3.5,0.3,8.45>,
    <3.51,1.8,8.3>
  }
  box {
    <3.5,1,6>,
    <3.51,1.3,8>
  }
  box {
    <3.5,1.4,6>,
    <3.51,1.7,8>
  }
  box {
    <3.5,1,5>,
    <3.51,1.4,3>
  }
  box {
    <3.5,1.5,5>,
    <3.51,1.7,3>
  }
  texture {
    T_Glass1
  }
  interior {
    I_Glass
  }
}    

#declare glasscut = torus {
  0.1,0.009
  rotate <0,0,90>
  texture {
    T_Glass2
  }
}

/* Graffiti in glass */
difference {
  box {
    <0.5,1,5>,
    <0.49,1.4,3>
    texture {
      T_Glass1
    }
  }
  /* A */
  object {
    glasscut
    translate <0.5,1.25,3.21>
  }
  object {
    glasscut
    scale <1,0.5,0.5>
    translate <0.5,1.15,3.14>
  }
  object {
    glasscut
    scale <1,0.5,0.5>
    translate <0.5,1.13,3.24>
  }
  /* L */
  object {
    glasscut
    scale <1,1,0.5>
    translate <0.5,1.27,3.4>
  }
  object {
    glasscut
    scale <1,0.5,1>
    translate <0.5,1.15,3.47>
  }
  /* O */
  object {
    glasscut
    translate <0.5,1.26,3.59>
  }
  /* N */
  object {
    glasscut
    scale <1,1,0.5>
    translate <0.5,1.27,3.78>
  }
  object {
    glasscut
    scale <1,1,0.5>
    translate <0.5,1.25,3.93>
  }
  object {
    glasscut
    scale <1,0.5,1>
    translate <0.5,1.39,3.86>
  }
  /* E */
  object {
    glasscut
    scale <1,1,0.5>
    translate <0.5,1.23,4.02>
  }
  object {
    glasscut
    scale <1,0.5,1>
    translate <0.5,1.24,4.04>
  }
  object {
    glasscut
    scale <1,0.5,1>
    translate <0.5,1.14,4.05>
  }
  object {
    glasscut
    scale <1,0.5,1>
    translate <0.5,1.36,4.04>
  }    
  interior {
    I_Glass
  }
}      
/* Poster */
difference {
  box {
    <0.5,2,4.5>,
    <2,2.5,5.5>
  }
  cylinder {
    <2,1.25,4.4>,
    <2,1.25,5.6>,1.48
  }
  texture {
    T_Grnt27
  }
}

/* Carriage */
difference {
  box {
    <0.5,0,0>,
    <3.5,2.5,10>
  }
  box {
    <0.51,0.01,0.01>,
    <3.49,2,9.99>
  }
  cylinder {
    <2,1.25,0.01>,
    <2,1.25,9.99>,1.49
  }
  object {
    wco
  }
  pigment {
    White
  }
  finish {
    ambient 0.4
    diffuse 0.2
  }
}                     

/* Ceiling */
box {
  <0.5,2.5,0>,
  <3.5,2.6,10>
  texture {
    T_Chrome_2A
  }
}

/* Sides */
difference {
  union {
    box {
      <0.51,0,0>,
      <0.52,2.5,10>
      texture {
        T_Chrome_2A
      }
    }
    box {
      <0,0,0>,
      <1,1,0.01>    
      texture {
        T_Chrome_2A
      }
      pigment {
        image_map {
          png "graffiti.png"
        }
      }
      scale <1,0.5,1>
      rotate <0,90,0>
      translate <3.47,1,6>
    }
    box {
      <3.48,0,0>,
      <3.49,2.5,10>
      texture {
        T_Chrome_2A
      }
    }
    box {
      <0.5,0,0>,
      <3.5,2.5,0.01>
      texture {
        T_Chrome_2A
      }
    }
  }
  object {
    wco
  }
}

union {
  box {
    <1.6,2.5,0>,
    <1.62,2.48,8>
  }
  box {
    <1.63,2.5,0>,
    <1.65,2.46,8>
  }
  box {
    <1.66,2.5,0>,
    <1.68,2.48,0>
  }
  box {
    <2.4,2.5,0>,
    <2.38,2.48,8>
  }
  box {
    <2.37,2.5,0>,
    <2.35,2.46,8>
  }
  box {
    <2.34,2.5,0>,
    <2.32,2.48,0>
  }
  texture {
    T_Chrome_2A
  }
}
  
/* Floor */
box {
  <0.5,0,0>,
  <3.5,0.1,10>
  texture {
    T_Stone1
  }
}

#declare lightbulb = union {
  light_source {
    <0,0,0>
    colour White
    fade_distance 1.5
    fade_power 1
  }
  sphere {
    <0,0,0>,0.06
    texture {
      pigment {
        White filter 0.3
      } 
    }
    finish {
      diffuse 0.8
      ambient 1
    }
  }
}

object { lightbulb translate <0.9,2.25,2> }
object { lightbulb translate <3.1,2.25,2> }
object { lightbulb translate <0.9,2.25,4> }
object { lightbulb translate <3.1,2.25,4> }
object { lightbulb translate <0.9,2.25,6> }
object { lightbulb translate <3.1,2.25,6> }
object { lightbulb translate <0.9,2.25,8> }
object { lightbulb translate <3.1,2.25,8> }
object { lightbulb translate <0.9,2.25,3> }
object { lightbulb translate <3.1,2.25,3> }
object { lightbulb translate <0.9,2.25,7> }
object { lightbulb translate <3.1,2.25,7> }

#declare dualchair = union {
  box {
    <0,0,0>,
    <1,0.5,-0.1>
    texture {
      T_Grnt2
    }
  }
  box {
    <0,0.5,0>,
    <1,1,-0.06>
    texture {
      T_Grnt2
    }
  }
  box {
    <0,0.4,0>,
    <1,0.5,-0.5>
    texture {
      T_Grnt2
    }
  }
  superellipsoid {
    <0.25,0.25>
    scale <0.24,0.02,0.24>
    translate <0.25,0.515,-0.25>
    pigment {
      Orange
    }
    finish {       
      phong 1      
      phong_size 50
    }
  }
  superellipsoid {    
    <0.25,0.25>
    scale <0.24,0.02,0.24>
    translate <0.75,0.515,-0.25>
    pigment {
      Orange
    }
    finish {
      phong 1      
      phong_size 50
    }
  }
  superellipsoid {         
    <0.25,0.25>
    scale <0.25,0.25,0.03>
    translate <0,0.25,0>
    rotate <6,0,0>
    translate <0.25,0.5,-0.085>
    pigment {
      Orange
    }
    finish {
      phong 1       
      phong_size 50
    }
  }
  superellipsoid {         
    <0.25,0.25>
    scale <0.25,0.25,0.03>
    translate <0,0.25,0>
    rotate <6,0,0>
    translate <0.75,0.5,-0.085>
    pigment {
      Orange
    }
    finish {
      phong 1       
      phong_size 50
    }
  }
}

#declare chair = difference {
  object {
    dualchair
  }
  sphere {
    <0.25,0.75,-0.34>,0.25
    pigment {
      Orange
    }
    finish {
      phong 1
      phong_size 50
    }
  }
  sphere {
    <0.75,0.75,-0.34>,0.25
    pigment {
      Orange
    } 
    finish {
      phong 1 
      phong_size 50
    }
  }
}

object {
  chair
  translate <0.54,0.1,4>
}

object {
  chair
  translate <2.46,0.1,4>
}

object {
  chair
  rotate <0,180,0>
  translate <1.54,0.1,4>
}

object {
  chair
  rotate <0,180,0>
  translate <3.46,0.1,4>
}

object {
  chair
  rotate <0,-90,0>
  translate <0.54,0.1,2>
}

object {
  chair
  rotate <0,-90,0>
  translate <0.54,0.1,6>
}

object {
  chair
  rotate <0,-90,0>
  translate <0.54,0.1,7.1>
}

object {
  chair
  rotate <0,-90,0>
  translate <0.54,0.1,8.9>
}

object {
  chair
  rotate <0,90,0>
  translate <3.46,0.1,3>
}

object {
  chair
  rotate <0,90,0>
  translate <3.46,0.1,7>
}

object {
  chair
  rotate <0,90,0>
  translate <3.46,0.1,8.1>
}

object {
  chair
  rotate <0,90,0>
  translate <3.46,0.1,9.9>
}

#declare pole = union {
  cylinder {
    <0,0,0>,
    <0,2.5,0>,0.02
  }
  cylinder {
    <0,2.3,0>,
    <0,2.5,0>,0.04
  }
  cylinder {
    <0,0,0>,
    <0,0.12,0>,0.03
  }
  texture {
    T_Silver_3A
  }
}

object {
  pole
  translate <2,0,1>
}

object {
  pole
  translate <2,0,3>
}

object {
  pole
  translate <2,0,5>
}

object {
  pole
  translate <2,0,7>
}

/* Shorter pole */
object {
  pole
  translate <2,0,9>
}
cylinder {
  <2,2.1,9>,
  <2,2.3,9>,0.04
  texture {
    T_Silver_3A
  }
}

object {
  pole
  translate <1.4,0,4>
}

object {
  pole
  translate <2.6,0,4>
}
                
/* Lower ceiling */
box {
  <0.5,2.3,7.5>,
  <3.5,2.5,10>
  texture {
    T_Chrome_2A
  }
}

/* The back */
difference {
  box {
    <0.5,0,10>,
    <3.5,2.5,9.98>
  }
  object {
    wco
  }
  texture {
    T_Chrome_2A
  }
}

#declare quarter = difference {
  torus {
    0.1,0.02
    rotate <90,0,0>
  }
  box {
    <0,-1,-1>,
    <-1,1,1>
  }
  box {
    <0,-1,-1>,
    <1,1,1>
    rotate <0,0,45>
  } 
}

#declare half = difference {
  torus {
    0.1,0.02
    rotate <90,0,0>
    rotate <0,90,0>
  }
  box {
    <-1,-1,0>,
    <1,1,-1>
  }
  box {
    <-1,0,-1>,
    <1,1,1>
  }
}

#declare addbar = union {
  object {
    half
  }
  cylinder {
    <0,-0.1,0>,
    <0,-0.1,-1>,0.02
  }
  cylinder {
    <0,0,0.1>,
    <0,0.5,0.1>,0.02
  }
  cylinder {
    <0,-0.1,-1>,
    <0,-0.1,-0.8>,0.04
  }
  cylinder {
    <0,0.3,0.1>,
    <0,0.5,0.1>,0.04
  }
  cylinder {
    <0,-0.2,-1>,
    <0,0,-1>,0.04
  }               
  texture {
    T_Silver_3A
  }
}

#declare doorpost = union {
  cylinder {
    <0,0.6,0>,
    <0,2.3,0>,0.02
  }
  cylinder {
    <0,2.1,0>,
    <0,2.3,0>,0.04
  }
  object {
    quarter
    rotate <0,0,-90>
    translate <0.1,0.6,0>
  }
  cylinder {
    <0.0293,0.5293,0>,
    <0.3293,0.2293,0>,0.02
  }
  object {
    quarter
    rotate <0,0,-45>
    translate <0.4,0.3,0>
  }
  cylinder {
    <0.4,0.2,0>,
    <0.6,0.2,0>,0.2
  }
  cylinder {
    <0,0.8,0>,
    <0.1,0.8,0>,0.02
  }
  object {
    quarter
    translate <0.1,0.9,0>
  }
  cylinder {
    <0.1707,0.8293,0>,
    <0.4707,1.1293,0>,0.02
  }
  object {
    quarter
    rotate <0,0,180>
    translate <0.5,1.0293,0>
  }
  cylinder {
    <0.5,1.1293,0>,
    <0.6,1.1293,0>,0.02
  }
  texture {
    T_Silver_3A
  }
}

object {
  doorpost
  translate <2.9,0,8.2>
}      

object {
  addbar
  rotate <0,180,0>
  translate <2.9,2,7.2>
}       

object {
  addbar
  rotate <0,180,0>
  translate <1.1,2,7.2>
}

object {
  doorpost
  translate <2.9,0,8.8>
}

object {
  doorpost
  rotate <0,180,0>
  translate <1.1,0,8.2>
}

object {
  doorpost
  rotate <0,180,0>
  translate <1.1,0,8.8>
}
               
object {
  pole
  translate <1.4,0,2>
}
object {
  addbar
  translate <1.4,2,3> 
}     

object {
  pole
  translate <2.6,0,2>
}
object {
  addbar
  translate <2.6,2,3> 
}

#declare can = union {
  difference {
    cylinder {
      <0,0,0>,
      <0,0.1,0>,0.03
    }
    cylinder {
      <0,0.09,0>,
      <0,0.11,0>,0.028
    }
    sphere {
      <0,0,0>,0.028
    }
    box {
      <0.01,0.11,-0.005>,
      <0.02,0.05,0.005>
    }
    texture {
      T_Chrome_2A
    }
  }         
  difference {
    cylinder {
      <0,0.01,0>,
      <0,0.09,0>,0.031
    }
    cylinder {
      <0,0,0>,
      <0,0.1,0>,0.03
    }
    pigment {
      checker pigment { Red }, pigment { White }
      scale <0.02,0.02,0.02>
    }
  }    
}

object {
  can
  translate <2.4,0.1,4>
}

box {
  <0,0,0>
  <1,1,0.01>
  pigment {
    image_map {
      png "poem.png"
    }
  }
  scale <0.2,0.3,1>
  rotate <90,0,0>
  rotate <0,30,0>
  translate <1.95,0.102,3.9>
}

#declare aco = union {
  sphere {
    <0.05,0,0>,0.04 
  }
  sphere {
    <-0.05,0,0>,0.04
  }
  sphere {
    <0,0,0.05>,0.04
  }
  sphere {
    <0,0,-0.05>,0.04
  }
}

union {
  difference {
    sphere {
      <0,0,0>,0.04
    }
    object {
      aco
    }
    pigment {
      Wheat
    }
  }
  difference {
    sphere {
      <0,0,0>,0.041
    }
    object {
      aco
    }
    sphere {
      <0,0,0>,0.04
    }
    pigment {
      Red
    }             
    /* Shinier apple */
    finish {
      phong 1       
      phong_size 50
  }
  }
  cylinder {
    <0,0.04,0>,
    <0.02,0.05,0.02>,0.002
    pigment {
      DarkGreen
    }
  }           
  rotate <0,90,0>
  rotate <0,0,90>          
  rotate <0,-20,0>
  scale <1.1,1.1,1.1>
  translate <0.9,0.66,2.91>
}

/* Icecream */
superellipsoid {
  <1,0.25>
  rotate <90,0,0>
  scale <0.25,0.5,0.25>
  translate <1.5,-0.39,5>
  pigment {
    colour <1,1,0.9,0.3>
  }    
  normal {
    ripples
    scale <0.01,0.01,0.01>
  }        
  finish {
    phong 1       
    phong_size 100
  }
}
cone {
  <1.65,0.15,5>,0.035
  <1.76,0.1,5.09>,0
  pigment {
    checker pigment { Brown } pigment { Red }
    scale <0.002,0.002,0.002>
  }
  hollow
}
