#include "colors.inc"
#include "stones3.inc"
#include "lights.inc"

global_settings {
    assumed_gamma 2.2
    hf_gray_16
  }

// orthographic projection using parallel camera rays
// Could be used to render a planar image map, for example
camera {
  orthographic
  location <0,1.5e2,0>    // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view
  up 1*y               // vertical size of view
}

#declare fnTer0 = function { sin(pow(x*x+z*z,.25)) }
#declare fnTer1 = function { (x*x+z*z)*1e-4 - (x*x*x*x+z*z*z*z)*1e-8 }
#declare fnTer2 = function { pattern {
	crackle
	form <-2, 1, 1>
	turbulence 0.23
	omega 0.75
	scale 2
} }

Sun(3.5, 2e2, 89, 0)

plane { y, 0 pigment {
	function { fnTer0(x,0,z)*2+fnTer1(x,0,z)-fnTer2(x,0,z)*.5 }
	sine_wave
	color_map { [ 0 rgb 0 ] [ 1 rgb 1 ] }
	scale .4
} }

	