//EMAIL: castlewrks@aol.com
//NAME: Robert J Becraft
//TOPIC: Loneliness
//COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//TITLE: White Queen
//COUNTRY:  USA
//WEBPAGE: 
//RENDERER USED: POVRAY 3.5
//TOOLS USED: PSP for copyright, Irfvan32 (convert to jpg), POSER 3 for the woman, UVMAPER & OBJ2POV (figure conversion)
//RENDER TIME: 3 hours 57 minutes
//HARDWARE USED: Pentium 433
//IMAGE DESCRIPTION:
//
// The queen stands alone in the royal audience chamber.  Empty of people, loneliness at the
// top.  The image is intended to evoke this type of loneliness and also has a number of 
// metaphores to tingle the veiwer's senses... notice that the floor is 8x8 grids (chess-boards),
// the king's chair is overturned... symbolic of how one resign's a chessgame.  The pillars for the 
// daiz approach are like pawns.  The hall was created large to emphasize its being empty.  Some scale
// is given through the railings on the balcony over the far wall.
//
//DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
// Created the space and vaulting of the ceilings.
// Added detail to each component in the scene
// Created the figure, crown, necklace and ring are all done in POV, applied to the figure by hand
// Lighting was the toughest... radiosity was also attempted, however, it pushed the render time to 4+ days.
// 
// Challenges... using a single light to light the hall gives a smooth finish to all the objects in the
// scene.  Using actual light sources at the point of origin (i.e. in the light fixtures), created the
// interesting patterns on the ceiling, walls and floors.  Would this space actually light in that fashion,
// I'm not entirely sure.  
//
// Respectfully submitted,
// Robert J Becraft
//
                      
#include "kolors.inc"   // ken's kolor file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
#declare RL=0;
#include "../med/brick.inc" 
#include "castletext.inc"
//---------------------------------------------------
//#declare GlobalOn=yes; // uncomment to include global settings.
#ifdef(GlobalOn)
 global_settings {
                  radiosity{
                            brightness 1         // 3.3 default   (3.6) Last values
                            count 100            // 100 default  (300) 
                            distance_maximum 50  //0 default      (30)
                            error_bound .4       // .4 default    (.3)
                            gray_threshold .5    // .5 default   (.75)
                            low_error_factor .8 // .8 default    (.8)
                            minimum_reuse .015  // .015 default  (.015)
                            nearest_count 6     // 6 default     (6)
                            recursion_limit 1   // 1 default     (3) 
                           }
//                    max_trace_level 25          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }
#end                 
                 
camera { 
    up y right 1024/768*x    
    //up y right 1/2*x  // 600x1200       
   // location <0,5,-50> look_at <0,15,0>   // test
   // location <-6,10,-80> look_at <0,15,0>  
    location <-2.5,4.7,-52.5> look_at <10,10,20>  // throne view  
   // location <1,5,-50.5> look_at <0,10,20>  // throne view original
   // location <1,6,-50> look_at <0,10,20>  // throne view 600x1200                
   // location <0,1,-15> look_at<0,0,0>
}

#declare LH=10;  // light height for fixtures 
//#declare NoLady=yes; // turns off poser figure
#declare DetailLite=yes;  // final render lighting

#declare Lshape=sphere{<0,0,0> .25 texture{pigment{color White} finish {ambient .8 diffuse .6}}} 

#ifndef(DetailLite)

light_source{<3,10,-65> color Orange}  // BIG light                       

#else
light_source{<500,1500,1500> color White*2}  // BIG light outside and behind
//light_source{<0,8,90> color Wheat fade_distance 35 fade_power 2}  // hall light

light_source{<0,9,-60> color White fade_distance 10 fade_power 3}  // lamp light (scene light)



//light_source{<2+20,LH,0> color NewTan fade_distance 10 fade_power 2 looks_like{Lshape}}  // lamp light    (added lights down hall)
//light_source{<2-20,LH,40> color NewTan fade_distance 10 fade_power 2.5 looks_like{Lshape}}  // lamp light  
//light_source{<-2,LH,-30> color NewTan fade_distance 10 fade_power 3 looks_like{Lshape}}  // lamp light 
//light_source{<2-20,LH,-10> color NewTan fade_distance 10 fade_power 3 looks_like{Lshape}}  // lamp light
//light_source{<-2,LH,-20> color NewTan fade_distance 10 fade_power 3 looks_like{Lshape}}  // lamp light
//light_source{<-2,LH,-40> color NewTan fade_distance 10 fade_power 3 looks_like{Lshape}}  // lamp light
//light_source{<2,LH,-10> color NewTan fade_distance 10 fade_power 2 looks_like{Lshape}}  // lamp light
//light_source{<-2,LH,20> color White fade_distance 10 fade_power 2 looks_like{Lshape}}  // lamp light    
//light_source{<2,LH,40> color White fade_distance 10 fade_power 2 looks_like{Lshape}}  // lamp light  
//light_source{<2,LH,50> color White fade_distance 10 fade_power 2 looks_like{Lshape}}  // lamp light

//light_source{<2,LH,-60> color Orange fade_distance 30 fade_power 2}  // lamp light
//light_source{<2+20,LH,0> color Orange fade_distance 7.5 fade_power 1.5}  // lamp light    
//light_source{<2-20,LH,40> color Wheat fade_distance 10 fade_power 2}  // lamp light  
//light_source{<-2,LH,-20> color GreenCopper fade_distance 7.5 fade_power 1.5}  // lamp light
//light_source{<2,LH,-60> color Wheat fade_distance 10 fade_power 1}  // lamp light
//light_source{<-2+20,LH,0> color Wheat fade_distance 7.5 fade_power 2}  // lamp light    
//light_source{<2-20,LH,40> color Orange fade_distance 10 fade_power 1}  // lamp light  
//light_source{<2,LH,0> color White fade_distance 7.5 fade_power 1}  // lamp light
#end // ifndef(DetailLite)     
     
#ifndef(SkyOff)
                           
#include "..\med\cloud.inc"       
fog {                                                 // White ground fog
  distance 250
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 45
  fog_alt 25
  turbulence 1.0
  turb_depth 3.0
}
#end // ifndef(SkyOff)

#declare Post=union{
  box{<-.28,0,-.28><.28,.1,.28>}
  cylinder{<0,0,0><0,1,0> .25}  
  box{<-.28,.9,-.28><.28,1,.28>}
  sphere{<0,1.2,0> .25}
 texture{T_Stone8}
} 
  
#declare Floor=union{
  box{<-30,-.1,-60><30,0,100> texture{checker texture{T_Stone8},texture{T_Stone18} scale 2 }}  
  box{<-8,-.1,-60><8,3,-42> texture{checker texture{T_Stone8 scale .25},texture{T_Stone18 scale .25} scale 2 }}  
  
  #declare R1=3;
  #while (R1>0)
    object{Post translate<-7.5,R1,-41.5+(12-R1*4)>}
    object{Post translate<7.5,R1,-41.5+(12-R1*4)>}   
    #declare R1=R1-.25;
  #end
  //object{Post translate<-7.5,2.75,-40.5>}
  //object{Post translate<7.5,2.75,-40.5>}  
 
  union{
    box{<-12,-.1,-60><-8,.001,100>}
    box{<8,-.1,-60><12,.001,100>}       
    box{<-32,-.1,-60><-28,.001,100>}
    box{<28,-.1,-60><32,.001,100>}
    
    box{<-30,-.1,-38><30,.001,-42>}    
    box{<-30,-.1,-18><30,.001,-22>}    
    box{<-30,-.1,-2><30,.001,2>}
    box{<-30,-.1,18><30,.001,22>}
    box{<-30,-.1,38><30,.001,42>}
    box{<-30,-.1,58><30,.001,62>}    
    box{<-30,-.1,78><30,.001,82>}
    box{<-9,-.1,-60><9,2.999,-41> } //edge of platform 
    #declare R1=2.75;               // stairs
    #while (R1>0)
       box{<-8,R1,-59><8,R1-.25,-41+(12-4*R1)> }    
       box{<-7.9,R1+.0001,-59><7.9,R1-.25,-41.1+(12-4*R1)> texture{T_Stone8}}       
       #declare R1=R1-.25;
    #end    
   texture{T_Stone12 scale .25}
  }             
  union{
    box{<-11,-.1,-60><-9,.0015,100>}
    box{<9,-.1,-60><11,.0015,100>}       
    box{<-31,-.1,-60><-29,.0015,100>}
    box{<29,-.1,-60><31,.0015,100>}
                                   
    box{<-30,-.1,-39><30,.001,-41>}                                   
    box{<-30,-.1,-19><30,.0015,-21>}    
    box{<-30,-.1,-1><30,.0015,1>}
    box{<-30,-.1,19><30,.0015,21>}
    box{<-30,-.1,39><30,.0015,41>}
    box{<-30,-.1,59><30,.0015,61>}    
    box{<-30,-.1,79><30,.0015,81>}
  //  box{<-9,-.1,-53><9,2.999,-35> } //edge of platform 
   texture{T_Stone8 scale .25}
  }                             
  union{
    box{<-10.5,-.1,-60><-9.5,.002,100>}
    box{<9.5,-.1,-60><10.5,.002,100>}       
    box{<-30.5,-.1,-60><-29.5,.002,100>}
    box{<29.5,-.1,-60><30.5,.002,100>}

    box{<-30,-.1,-39.5><30,.001,-40.5>}    
    box{<-30,-.1,-19.5><30,.002,-20.5>}    
    box{<-30,-.1,-.5><30,.002,.5>}
    box{<-30,-.1,19.5><30,.002,20.5>}
    box{<-30,-.1,39.5><30,.002,40.5>}
    box{<-30,-.1,59.5><30,.002,60.5>}    
    box{<-30,-.1,79.5><30,.002,80.5>}
  //  box{<-9,-.1,-53><9,2.999,-35> } //edge of platform 
   texture{checker texture{T_Stone18},texture{T_Stone8} scale .5 }
  }      
}                                                     

#declare Ceiling=difference{
  box{<-10,0,-10><10,15,10>}
  cylinder{<-11.5,0,-10.1><-11.5,0,10.1> 11}
  cylinder{<11.5,0,-10.1><11.5,0,10.1> 11}      
  
  cylinder{<-10.1,.5,-11.5><10.1,.5,-11.5> 11}
  cylinder{<-10.1,.5,11.5><10.1,.5,11.5> 11}  
}

#declare Colx=difference{
  cylinder{<0,0,0><0,1.95,0> 1.5}
  #declare R1=0;
  #while (R1<360)
    cylinder{<0,-.1,1.5><0,2,1.5> .15 rotate<0,R1,0>}
    #declare R1=R1+20;
  #end
}

#declare Arch1=intersection{
   torus{10,.25 rotate<0,0,90>}
   box{<-.26,0,-10.35><.26,10.35,-1>}
   translate<0,0,10> // center
}
#declare Arch1a=intersection{
   difference{
     cylinder{<-.5,0,0><.5,0,0> 11}
     cylinder{<-.51,0,0><.51,0,0> 10.5}
   }
   box{<-.52,0,-11.35><.52,11.35,-1>}
   translate<0,0,10> // center
}
#declare Arch1b=intersection{
   torus{10.75,.15 rotate<0,0,90>}
   box{<-.26,0,-11.35><.26,11.35,-1>}
   translate<0,0,10> // center
}
#declare Arch1c=intersection{
   difference{
     cylinder{<-.25,0,0><.25,0,0> 11}
     cylinder{<-.51,0,0><.51,0,0> 10}
   }
   box{<-.252,0,-11.1><.252,11.1,-1>}
   translate<0,0,10> // center
}        
#declare Arch2=union{
  object{Arch1}
  object{Arch1 translate<-.25,.2,0>}
  object{Arch1 translate<.25,.2,0>}     
  object{Arch1c}
  
  object{Arch1a}
  object{Arch1b translate<.75,0,0>}
  object{Arch1b translate<-.75,0,0>}  
  
//  object{Arch1b rotate<0,50,0> translate<.75,0,-.75>}
//  object{Arch1b rotate<0,-50,0> translate<-.75,0,-.75>}    
} 

#declare Col1=union{
  // top
  cylinder{<0,20,0><0,20.2,0> 1.55}   
  cone{<0,20,0>1.5<0,21.8,0> 1.75}
  torus{1.5,.35 translate<0,21.8,0>}
  cylinder{<0,21.75,0><0,21.85,0> 1.9}      
  cylinder{<0,21.45,0><0,21.55,0> 1.75}  
  #declare R1=0;
  #while (R1<360)            
     torus{.25,.05 rotate<90,0,0> translate<1.7,21.5,0> rotate<0,R1,0>}  
     torus{.15,.035 rotate<0,0,115> scale <1,1.5,1> translate<1.7,21.25,0> rotate<0,R1,0>}
     torus{.15,.035 rotate<0,0,115> scale <1,1.5,1> translate<1.67,21,0> rotate<0,R1,0>} 
     torus{.15,.035 rotate<0,0,115> scale <1,1.5,1> translate<1.62,20.75,0> rotate<0,R1,0>}     
     torus{.15,.035 rotate<0,0,115> scale <1,1.5,1> translate<1.57,20.5,0> rotate<0,R1,0>} 
     torus{.15,.035 rotate<0,0,115> scale <1,1.5,1> translate<1.52,20.25,0> rotate<0,R1,0>}      
     sphere{<0,0,0>,.085 scale <1,1.5,1> translate<1.7,21.25,0> rotate<0,R1,0>}
     sphere{<0,0,0>,.065 translate<1.78,21.25,0> rotate<0,R1,0>}    
     torus{.1,.04 rotate<0,0,90> translate<1.9,21.8,0> rotate<0,R1,0>}     
     sphere{<0,0,0>,.075 translate<1.9,21.8,0> rotate<0,R1,0>}
     #declare R1=R1+12.5;
  #end  
  // middle
  #declare R1=2;
  #while (R1<20)
    object{Colx translate<0,R1,0>}
 //   cylinder{<0,R1,0><0,R1+1.95,0> 1.5} 
    #declare R1=R1+2;
  #end 
  // bottom
  cylinder{<0,0,0><0,.35,0> 2.05}
  cylinder{<0,0,0><0,1.5,0> 1.65}
  cylinder{<0,1.45,0><0,1.5,0> 1.70}
  torus{1.4,.3 translate<0,1.55,0> }
  cylinder{<0,1.55,0><0,1.95,0>1.5}
}
             
#declare Col2=union{             
  object{Col1 }

  object{Arch2 translate<0,21.5,1.5>}
  object{Arch2 rotate<0,180,0> translate<0,21.5,-1.5>} 
  object{Arch2 rotate<0,90,0> translate<1.5,21.5,0>}
  object{Arch2 rotate<0,-90,0> translate<-1.5,21.5,0>}             
  
  object{Ceiling translate<0,21.5,0> texture{pigment{color White}}}

 texture{T_Stone12 scale .25} 
}

#declare HallRow=union{
object{Col2 translate<10,0,0>}
object{Col2 translate<-10,0,0>}  
object{Col2 translate<30,0,0>}
object{Col2 translate<-30,0,0>}
}

#declare HallWin1=intersection{
   torus{1,.1 rotate<0,0,90> }
   box{<-.11,0,-1.2><.11,1.2,-.3>}
   translate<0,0,.3>
} 
#declare HallWin1b=intersection{
   difference{
     cylinder{<-.15,0,0><.15,0,0>1.25}
     cylinder{<-.16,0,0><.16,0,0>1.05}
   }
   box{<-.31,0,-1.3><.31,1.3,-.3>}
   translate<0,0,.3>
}
#declare HallWin1c=union{
  box{<-.05,-3,-.05><.05,1,.05>}  
  box{<-.05,-3,-.4><.05,1,-.3>}
  box{<-.05,-3,.4><.05,1,.3>}    
  
  box{<-.05,-1.05,-1><.05,-.95,1>}  
  box{<-.05,-2.05,-1><.05,-1.95,1>}  
  box{<-.05,-.05,-1><.05,.05,1>}  
}
#declare HallWin2=union{
  difference{
     box{<-.1,-4,-1><.1,2,1>}
     cylinder{<-.11,0,0><.11,0,0> 1}
     box{<-.11,-3,-.7><.11,0,.7>}
    texture{T_Stone5 scale .2}
  }
  object{HallWin1}  
  object{HallWin1b}
  object{HallWin1 rotate<0,180,0>}
  object{HallWin1b rotate<0,180,0>}
  box{<-.15,-3,-1.25+.3><.15,0,-1.05+.3>}
  box{<-.15,-3,1.25-.3><.15,0,1.05-.3>}
  cylinder{<0,0,0><0,-3,0> .1 translate<0,0,1-.3>}
  cylinder{<0,0,0><0,-3,0> .1 translate<0,0,-1+.3>}
  box{<-.15,-3.25,-1.25+.3><.15,-3,1.25-.3>}  
  
  object{HallWin1c}
}

#declare HallWin2b=union{   
    object{HallWin2 translate<0,1,-5>}  
    object{HallWin2 translate<0,1,-3>} 
    object{HallWin2 translate<0,1,-1>}   
    object{HallWin2 translate<0,1,1>}      
    object{HallWin2 translate<0,1,3>}  
    object{HallWin2 translate<0,1,5>}
  rotate<0,0,0> texture{T_Stone12 scale .25}
}

#declare HallWin2c=union{
  box{<-.25,0,-8><.25,1,8>}
 // box{<-.15,1,-8><.15,3,8>}
  object{HallWin2b translate<0,4,0>}
  object{HallWin2b translate<0,10,0>}
  object{HallWin2b translate<0,16,0>}  
  object{HallWin2b translate<0,22,0>} 
  
  box{<-.15,24,-8><.15,35,8>} 
  box{<-.15,0,-6><.15,35,-8>}
  box{<-.15,0,6><.15,35,8>}
    
  texture{T_Stone12 scale .25}
}
#declare HallD=union{
  box{<-1,0,-.1><1,5,.1> texture{T_Wood1 scale .1}}
  //verticals
  box{<-1,0,-.15><-.8,5,.15>}
  box{<.8,0,-.15><1,5,.15>}
  box{<.1,0,-.15><.1,5,.15>}
  //horizontals
  box{<-1,0,-.16><1,.5,.16>}
  box{<-1,4.5,-.16><1,5,.16>}
  box{<-1,2.4,-.14><1,2.6,.14>}
  
 texture{T_Wood1 scale .1}  
}
#declare SunOrnament=union{
      torus{.1,.035 rotate<90,0,0>}
      sphere{<0,0,0> .075} 
      sphere{<0,0,0> .025  scale <1,1,.5> translate<0,0,-.075> texture{T08}}
      #declare R1=-132.5;
      #while (R1<132.5)
         union{
             cone{<0,0,.02> .05 <0,.16,-.05> .005}
             sphere{<0,.16,-.05> .015}
           translate<.01,.14,0> 
           rotate<0,0,R1>
         }
         #declare R1=R1+20;
      #end    
      texture{T01}
      scale 5
}
#declare RS=seed(279);
#declare WindowDetail1=union{
  #declare R1=1;
  #while (R1<=20)
    //#declare RD=rand(RS)*1.5+.5;
    //#declare RDI=rand(RS)*.175+.05;
    //#declare RDX=rand(RS)*3.5+.5;
    //#declare ROZ=rand(RS)*360;
    //torus{RD,RDI rotate<90,0,0> translate<RDX,0,0> rotate<0,0,ROZ>}
    torus{2,.1 rotate<90,0,0> translate<3,0,0> rotate<0,0,R1*18>}
    #declare R1=R1+1;
  #end
}
#declare HallDoor=union{
  difference{
    box{<-10,0,-.2><10,10,.2>}
    box{<-2,0,-.21><2,5,.21>}
  }
  
  object{HallD translate<1,0,0> rotate<0,-45,0> translate<-2,0,0>}
  object{HallD translate<-1,0,0> rotate<0,55,0> translate<2,0,0>}
  object{SunOrnament rotate<0,0,0> translate<0,9,-.5>}
    
  //doorframe                                           
  union{
    box{<-2,0,-.3><-2.2,5.2,.3>}
    box{<2,0,-.3><2.2,5.2,.3>}
    box{<-2.2,5,-.3><2.2,5.2,.3>}
    
    cylinder{<-3,0,-.2><-3,6,-.2> .3}
    cylinder{<3,0,-.2><3,6,-.2> .3}    
    
    box{<-4,6,-.5><4,6.5,0>}
    box{<0,0,-.5><5,.5,0> rotate<0,0,30> translate<-4,6,0>}
    box{<0,0,-.5><-5,.5,0> rotate<0,0,-30> translate<4,6,0>}
    
   texture{T_Stone18 scale .15}
  }

  
  box{<-10,10,-.3><10,10.5,20>}
  box{<-10,10.3,-.4><10,10.5,0>} 
  box{<-10,0,20><10,20,20.1>} // rear wall
  
  cylinder{<-5,10.5,0><-5,20,0> .3} //columns
  cylinder{<0,10.5,0><0,20,0> .3}
  cylinder{<5,10.5,0><5,20,0> .3}
  
  cylinder{<-10,10.75,0><10,10.75,0> .2} // railing
  cylinder{<-10,11.5,0><10,11.5,0> .2}
  #declare R1=-10;
  #while (R1<=10)
     cylinder{<R1,10.75,0><R1,11.5,0> .15}
     #declare R1=R1+.5;
  #end
  
  
  box{<-10,20,-.3><10,20.5,20>}

  difference{  
    box{<-10,20.5,-.2><10,35,.2>}
    cylinder{<0,25,-.21><0,25,.21> 4}
  }
  torus{4,.25 rotate<90,0,0> translate<0,25,0>}
  
  object{WindowDetail1 translate<0,25,0>}

  
 texture{T_Stone12 scale .25}
}
//-------------------------------------Throne Objects    
#declare ThroneDetail1=union{
  cylinder{<-.03,.9,0><.03,.9,0> .01}
  cylinder{<-.03,.1,0><.03,.1,0> .01}
  #declare R1=-.03;
  #while (R1<=.04)
    cylinder{<R1,.1,0><R1,.9,0> .0075}
    #declare R1=R1+.02;
  #end
  texture{T01}
}
#declare RS=seed(7978);
#declare ThroneDetail2=union{
  #declare R1=1;
  #while (R1<80)
    #declare RD=rand(RS)*.045+.025;
    #declare RDI=rand(RS)*.01+.005;
    #declare RDX=rand(RS)*.25+.15;
    #declare ROZ=rand(RS)*180;
    torus{RD,RDI rotate<90,0,0> translate<RDX,0,0> rotate<0,0,ROZ>}
    #declare R1=R1+1;
  #end
}
#declare RS=seed(798);
#declare ThroneDetail3=union{
  #declare R1=1;
  #while (R1<80)
    #declare RD=rand(RS)*.045+.025;
    #declare RDI=rand(RS)*.01+.005;
    #declare RDX=rand(RS)*.25-.125;
    #declare RDY=rand(RS)*1;
    torus{RD,RDI rotate<90,0,0> translate<RDX,RDY,0>}
    #declare R1=R1+1;
  #end
}
#declare ThroneCushion=union{
  cylinder{<0,0,-.4><0,0,.4> .1}
  torus{.075,.025 rotate<90,0,0> translate<0,0,-.4>}
  #declare R1=0;
  #while (R1<360)
     cone{<0,0,-.4>.001 <.075,0,-.4> .025 rotate<0,0,R1>}
     #declare R1=R1+(rand(RS)*25+5);
  #end
  sphere{<0,0,0> .03 scale <1,1,.5> translate<0,0,-.4> texture{T01}} // center button
 texture{pigment{color Red}}
}

#declare Throne=union{
  union{  // legs
    box{<-.5,0,-.5><-.4,1,-.4>}
    cylinder{<-.5,.05,-.5><-.4,.05,-.5> .05} 
    cylinder{<-.5,.975,-.5><-.4,.975,-.5> .05}
        
    box{<-.5,0,.5><-.4,1,.4>}
    box{<.5,0,-.5><.4,1,-.4>}

    box{<.5,0,.5><.4,1,.4>}
    cylinder{<.5,.05,-.5><.4,.05,-.5> .05} 
    cylinder{<.5,.975,-.5><.4,.975,-.5> .05}    
     
    object{ThroneDetail1 translate<-.45,0,-.5>}
    object{ThroneDetail1 translate<.45,0,-.5>}
    
   texture{T_Wood35 rotate<0,90,90> scale .2}
  }
  union{ // arms
    box{<-.525,1.06,-.55><-.375,1.07,.5> texture{T01}}
    cylinder{<-.45,1.06,-.55><-.45,1.07,-.55> .075 texture{T01}}    
    box{<-.52,1.05,-.55><-.38,1.08,.5>}
    cylinder{<-.45,1.05,-.55><-.45,1.08,-.55> .07}  
    box{<-.5,1,-.55><-.4,1.05,.5>}
    cylinder{<-.45,1,-.55><-.45,1.05,-.55> .05}    
    cylinder{<-.52,1,.4><-.38,1,.4> .1}

    box{<.525,1.06,-.55><.375,1.07,.5> texture{T01}}
    cylinder{<.45,1.06,-.55><.45,1.07,-.55> .075 texture{T01}}       
    box{<.52,1.05,-.55><.38,1.08,.5>}
    cylinder{<.45,1.05,-.55><.45,1.08,-.55> .07}   
    box{<.5,1,-.55><.4,1.05,.5>}
    cylinder{<.45,1,-.55><.45,1.05,-.55> .05}    
    cylinder{<.52,1,.4><.38,1,.4> .1}
    
   texture{T_Wood35 rotate<0,0,0> scale .1}
  }
  union{
    #declare R1=-.4;
    #while (R1<=.4)
       cylinder{<-.455,.6,R1><-.475,1,R1> .02} 
       cylinder{<.455,.6,R1><.475,1,R1> .02}
       #declare R1=R1+.1;
    #end
   texture{T_Wood35 rotate<0,90,90> scale .2}
  }
  union{ // seat
    box{<-.475,.5,-.475><.475,.6,.475>}
    union{
      cylinder{<-.35,.55,-.475><.35,.55,-.475> .05}
      sphere{<-.35,.55,-.475> .05}
      sphere{<.35,.55,-.475> .05}
     texture{T_Wood35 rotate<0,90,0> scale .1}
    }  
    
    // front/back details
    box{<-.4,.35,-.45><.4,.55,-.425> texture{T_Wood35 rotate<0,90,0> scale .1}} // front
    
    box{<-.475,.75,.415><.475,.95,.485>} // back 
    box{<-.475,.95,.4><.475,1,.485>} // back
                                          
    union{
      box{<-.135,1,.405><-.045,1.95,.42>}  
      box{<.135,1,.405><.045,1.95,.42>}      
      box{<-.45,1,.405><-.35,1.95,.42>}
      box{<.45,1,.405><.35,1.95,.42>}         
      box{<-.45,1,.40><-.5,1.95,.425>}
      box{<.45,1,.40><.5,1.95,.425>}      
     texture{T_Wood35 rotate<0,90,90> scale .052}
    }  
    
    #declare R1=1.05;
    #while (R1<=1.95)
      cylinder{<-.045,R1,.4125><.045,R1,.4125> .01}
      torus{.025,.0075 rotate<90,0,0> translate<-.4,R1,.405>}
      torus{.025,.0075 rotate<90,0,0> translate<.4,R1,.405>}
      #declare R1=R1+.06;
    #end
                                          
    box{<-.5,1.95,.4><.5,2,.485>} // back
        
    cylinder{<0,2,.42><0,2,.48> .15}
    difference{
       cylinder{<0,2,.41><0,2,.49> .14}
       cylinder{<0,2,.4><0,2,.5> .13}
      texture{T01}
    }
    difference{
       cylinder{<0,2,.41><0,2,.49> .11}
       cylinder{<0,2,.4><0,2,.5> .10}
      texture{T01}
    }
    cylinder{<0,2,.41><0,2,.49> .05 texture{T01}}
    
    difference{
       cylinder{<0,2,.41><0,2,.49> .5}
       cylinder{<0,2,.4><0,2,.5> .4}
       box{<-.51,2-.51,.4><.51,2,.51>} // bottom half
    }
    difference{
       cylinder{<0,2,.405><0,2,.495> .48}
       cylinder{<0,2,.4><0,2,.5> .45}
       box{<-.51,2-.51,.4><.51,2,.51>} // bottom half
      texture{T01}       
    }    
    //top doily
    union{
      torus{.1,.035 rotate<90,0,0>}
      sphere{<0,0,0> .075} 
      sphere{<0,0,0> .025  scale <1,1,.5> translate<0,0,-.075> texture{T08}}
      #declare R1=-132.5;
      #while (R1<132.5)
         union{
             cone{<0,0,.02> .05 <0,.16,-.05> .005}
             sphere{<0,.16,-.05> .015}
           translate<.01,.14,0> 
           rotate<0,0,R1>
         }
         #declare R1=R1+20;
      #end
      translate<0,2.5,.42>    
      texture{T01}
    }
    // repeated decorations   
    #declare R1=-.4;
    #while (R1<=.4)
      box{<R1,.4,-.475><R1+.02,.55,-.45>} // on front
      sphere{<R1+.01,.465,-.475> .02 texture{T01}}
      box{<R1,.8,.4><R1+.02,.95,.415>} // on back 
      sphere{<R1+.01,.875,.4> .02 texture{T01}}
      #declare R1=R1+.04;
    #end
    
    object{ThroneDetail2 translate<0,2,.45>}      
    object{ThroneDetail3 translate<-.3,1,.45>}
    object{ThroneDetail3 rotate<0,180,0> translate<.3,1,.45>}
    
      union{
        box{<-.35,.6,-.45><.35,.64,.45>} 
        cylinder{<-.35,.62,-.45><.35,.62,-.45> .014}
        cylinder{<-.35,.62,-.45><-.35,.62,.45> .014}
        cylinder{<-.35,.62,.45><.35,.62,.45> .014}
        cylinder{<.35,.62,-.45><.35,.62,.45> .014}
       texture{pigment{color Red}}
      }
      union{ // cusion piping
        cylinder{<-.414,.62,-.464><.414,.62,-.464> .005}
        cylinder{<-.414,.62,-.464><-.414,.62,.464> .005}
        cylinder{<-.414,.62,.464><.414,.62,.464> .005}
        cylinder{<.414,.62,-.464><.414,.62,.464> .005}
       texture{pigment{color Goldenrod1}}
      }        
  }
  // front rail
  cylinder{<-.475,.3,-.475><.475,.3,-.475> .02}
  cone{<-.475,.3,-.475> .02 <-.1,.3,-.475> .035}
  cone{<.475,.3,-.475> .02  <.1,.3,-.475> .035}
  sphere{<-.1,.3,-.475> .035}
  sphere{<.1,.3,-.475> .035}
  sphere{<-.025,.3,-.475> .035}
  sphere{<.025,.3,-.475> .035}
  
  cylinder{<-.475,.3,.475><.475,.3,.475> .02}
  
 texture{T_Wood35 rotate<0,90,0> scale .2}
}
#declare ThroneC=union{
  object{ThroneCushion rotate<0,-5,0> translate<.3,.72,0>}
  object{ThroneCushion rotate<0,10,0> translate<-.25,.72,0>}
}   

//-------------------------------------END Throne Objects
//-------------------------------------Lantern Objects
#declare Lantern1=difference{
    cylinder{<0,0,0><0,.2,0> .5}
    cylinder{<0,-.1,0><0,.3,0> .495}
    #declare R1=0;
    #while (R1<180)
       cylinder{<-.51,.135,0><.51,.135,0>.03 rotate<0,R1,0>}
       cylinder{<-.51,.065,0><.51,.065,0>.03 rotate<0,R1,0>}
       cylinder{<-.51,.1,-.035><.51,.1,-.035>.03 rotate<0,R1,0>}
       cylinder{<-.51,.1,.035><.51,.1,.035> .03 rotate<0,R1,0>}
       #declare R1=R1+20;
     #end
}
#declare Lantern1b=union{
  object{Lantern1}
  torus{.5,.015}
  torus{.5,.015 translate<0,.2,0>}
}     
#declare Lantern1a=union{
   #declare R1=0;
   #while (R1<360)
     torus{.18,.0075 rotate<90,0,0> translate<0,0,.5> rotate<0,R1,0>}
     torus{.08,.0075 rotate<90,0,0> translate<0,0,.5> rotate<0,R1-10,0>}
     torus{.08,.0075 rotate<90,0,0> translate<0,0,.5> rotate<0,R1+10,0>}
     cylinder{<0,0,.5><0,0,.50001> .07 rotate<0,R1-10,0> texture{T_Ruby_Glass}}
     cylinder{<0,0,.5><0,0,.50001> .07 rotate<0,R1+10,0> texture{T_Orange_Glass}}     
     #declare R1=R1+20;
   #end
}
#declare CLink1=intersection{
   torus{.02,.0075 rotate<90,0,0>}
   box{<-.031,-.031,-.01><.031,0,.01>} // bottom
}
#declare CLink=union{
  object{CLink1 translate<0,-.02,0>}
  object{CLink1 rotate<0,0,180> translate<0,.02,0>}
  cylinder{<-.02,-.02,0><-.02,.02,0> .0075}
  cylinder{<.02,-.02,0><.02,.02,0> .0075}
}
    
#declare Lantern2=union{
 //  light_source{<0,.5,0> color NewTan fade_distance 10 fade_power 2 looks_like{Lshape}}
   object{Lantern1b}
   object{Lantern1b translate<0,.6,0>}
   object{Lantern1a translate<0,.4,0>}
   object{Lantern1a translate<0,1,0>}
   object{Lantern1b translate<0,1.2,0>}
   
   #ifdef(DetailedOn)                                                
   cylinder{<0,10,0><0,30-LH,0> .01}                                                
   // Chain
     object{CLink rotate<0,90,0> translate<0,2.57,0> }   
     #declare R1=2.65;
     #while (R1<10)
    //    torus{.02,.005 rotate<90,0,0> scale <1,2,.5> rotate<0,rand(RS)*10-5,0> translate<0,R1,0> texture{pigment{color White}}}
        #declare ROY=int(rand(RS)*10-5)*10;
        object{CLink rotate<0,ROY,0> translate<0,R1,0> } 
        #declare R1=R1+.07;
     #end
   #else
     cylinder{<0,2.55,0><0,30-LH,0> .01}
   #end  
   torus{.05,.01 rotate<90,0,0> translate<0,2.5,0>}
   cone{<0,2.45,0> .01 <0,1.4,.5> .01}
   cone{<0,2.45,0> .01 <0,1.4,.5> .01 rotate<0,-130,0>}
   cone{<0,2.45,0> .01 <0,1.4,.5> .01 rotate<0,130,0>}
  // sphere{<0,.5,0> .15 texture{pigment{color Wheat}}}
   
 texture{Bright_Bronze}
}
#macro MakeLamp(Mx,My,Mz)
  union{
    object{Lantern2 rotate<0,rand(RS)*360,0>}
    #ifdef(DetailLite)
      #declare RL=rand(RS);
      #if (RL>.25)
         #declare FD=rand(RS)*10+5;
         #declare FP=rand(RS)*2+2.5;
         light_source{<0,.7,0> color White fade_distance FD fade_power FP looks_like{Lshape}}
      #end
    #end
    translate<Mx,My,Mz>
  }
#end // #macro MakeLamp  
   
#declare RDS=seed(1234);
#declare LanternRow=union{
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,70>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,70>}  
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,60>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,60>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,50>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,50>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,40>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,40>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,30>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,30>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,20>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,20>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,10>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,10>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,0>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,0>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,-10>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,-10>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,-20>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,-20>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<2,LH,-30>}
object{Lantern2 rotate<0,rand(RS)*360,0> translate<-2,LH,-30>}
}           
#declare LanternRow=union{
  MakeLamp(0,LH,70)
  MakeLamp(0,LH,60)
  MakeLamp(0,LH,50)
  MakeLamp(0,LH,40)
  MakeLamp(0,LH,30)
  MakeLamp(0,LH,20)
  MakeLamp(0,LH,10)
  MakeLamp(0,LH,0)          
  MakeLamp(0,LH,-10)  
  MakeLamp(0,LH,-20)  
  MakeLamp(0,LH,-30)  
  MakeLamp(0,LH,-40)  
  MakeLamp(0,LH,-50)   
  
  MakeLamp(-20,LH,70)
  MakeLamp(-20,LH,60)
  MakeLamp(-20,LH,50)
  MakeLamp(-20,LH,40)
  MakeLamp(-20,LH,30)
  MakeLamp(-20,LH,20)
  MakeLamp(-20,LH,10)
  MakeLamp(-20,LH,0)          
  MakeLamp(-20,LH,-10)  
  MakeLamp(-20,LH,-20)  
  MakeLamp(-20,LH,-30)  
//  MakeLamp(-20,LH,-40)  
//  MakeLamp(-20,LH,-50)  
  
  MakeLamp(20,LH,70)
  MakeLamp(20,LH,60)
  MakeLamp(20,LH,50)
  MakeLamp(20,LH,40)
  MakeLamp(20,LH,30)
  MakeLamp(20,LH,20)
  MakeLamp(20,LH,10)
  MakeLamp(20,LH,0)          
  MakeLamp(20,LH,-10)  
  MakeLamp(20,LH,-20)  
  MakeLamp(20,LH,-30)  
//  MakeLamp(20,LH,-40)  
//  MakeLamp(20,LH,-50)      
}

//-------------------------------------END Lantern Objects
// -----------------------------------OBJECTS.

//#ifdef(HOLD)
object{HallRow translate<0,0,-40>}
object{HallRow translate<0,0,-20>}
object{HallRow}
object{HallRow translate<0,0,20>}
object{HallRow translate<0,0,40>}
object{HallRow translate<0,0,60>}
object{HallRow translate<0,0,80>}

object{LanternRow}
//object{LanternRow translate<-20,0,0>}
//object{LanternRow translate<20,0,0>}
 
object{Floor}

union{  // Queen's throne
  object{Throne}
  object{ThroneC}
 rotate<0,-25,0> translate<-1,3,-43>
}
// King's throne
object{Throne rotate<0,0,0> rotate<0,0,-88> rotate<0,20,0> translate<.5,3.5,-43>}
object{ThroneCushion rotate<0,50,0> translate<.8,3.1,-44.2>}
object{ThroneCushion rotate<0,-5,0> translate<2,3.1,-44.25>}  

object{HallDoor translate<0,0,80>}
object{HallDoor translate<-20,0,80>}
object{HallDoor translate<20,0,80>}

object{HallWin2c translate<-30,0,-10>}
object{HallWin2c translate<30,0,-10>}
object{HallWin2c translate<-30,0,10>}
object{HallWin2c translate<30,0,10>}
object{HallWin2c translate<-30,0,30>}
object{HallWin2c translate<30,0,30>}  
object{HallWin2c translate<-30,0,50>}
object{HallWin2c translate<30,0,50>}
object{HallWin2c translate<-30,0,70>}
object{HallWin2c translate<30,0,70>}
//#end

//object{HallRow}
//object{HallDoor}
//object{HallDoor translate<-20,0,0>}
//object{HallDoor translate<20,0,0>}
 
 
#ifndef(NoLady)
#declare CrownJewels=union{
  difference{
    cylinder{<0,0,0><0,0,-.005> .004}
    cylinder{<0,0,-.006><0,0,-.001> .00375}
  }
  cylinder{<0,0,-.001><0,0,-.0011> .00375 texture{pigment{color White}}}
  sphere{<0,0,0> .00375 scale<1,1,.5> translate<0,0,-.004> texture{T_Ruby_Glass}}
}   
#declare CrownJewels2=union{
  difference{
    cylinder{<0,0,0><0,0,-.005> .004}
    cylinder{<0,0,-.006><0,0,-.001> .00375}
  }
  cylinder{<0,0,-.001><0,0,-.0011> .00375 texture{pigment{color White}}}
  sphere{<0,0,0> .00375 scale<1,1,.5> translate<0,0,-.004> texture{T_Orange_Glass}}
}         
#declare CrownJewels3=union{
  difference{
    cylinder{<0,0,0><0,0,-.0025> .002}
    cylinder{<0,0,-.0026><0,0,-.001> .001875}
  }
  cylinder{<0,0,-.001><0,0,-.0011> .001875 texture{pigment{color White}}}
  sphere{<0,0,0> .001875 scale<1,1,.25> translate<0,0,-.004> texture{T_Green_Glass}}
}
#declare CrownJewels3a=union{
  object{CrownJewels3 translate<0,.004+.002,0> rotate<0,0,45>} 
  object{CrownJewels3 translate<0,.004+.002,0> rotate<0,0,-45>}
  object{CrownJewels3 translate<0,.004+.002,0> rotate<0,0,135>}
  object{CrownJewels3 translate<0,.004+.002,0> rotate<0,0,-135>}
  object{CrownJewels3 translate<0,.004+.002,0> rotate<0,0,0>}        
}  
#declare Crown1=union{
  torus{.095,.002 }
  #declare R1=-30;
  #while (R1<=30)
    torus{.015,.0010 rotate<90,0,0> scale<.95,1.75,1> translate<0,.02,-.1> rotate<0,R1,0>}
    object{CrownJewels3a scale 1 translate<0,.02,-.0995> rotate<0,R1,0>}
    object{CrownJewels scale 1 translate<0,.05,-.0995> rotate<0,R1,0>}
    object{CrownJewels scale 1 translate<0,.02,-.098> rotate<0,R1,0>}
    #declare R1=R1+10;
  #end
  
  #declare R1=-35;
  #while (R1<=35)
    object{CrownJewels2 translate<0,0,-.0985> rotate<0,R1,0>}
    object{CrownJewels3a translate<0,0,-.0985> rotate<0,R1,0>}
    #declare R1=R1+5;
  #end
  //cylinder{<0,0,-.1><0,0,-.11> .015}
 texture{T09}
}

#declare Necklace=union{
  difference{ 
    torus{.075,.002}
    box{<-.0115,-.0026,-.075+.0026><.0115,.0026,-.075-.0026>}
  }
  torus{.00405,.0005 scale<1,1.5,1> rotate<0,0,90> translate<0,0,-.078>}
  sphere{<0,0,0> .004 scale<1,1.5,1> translate<0,0,-.078> texture{T_Ruby_Glass}}
  torus{.0031,.0005 scale<1,1.5,1> rotate<0,0,90> translate<.007,0,-.078>}
  sphere{<0,0,0> .0030 scale<1,1.5,1> translate<.007,0,-.078> texture{T_Orange_Glass}}
  torus{.0031,.0005 scale<1,1.5,1> rotate<0,0,90> translate<-.007,0,-.078>}
  sphere{<0,0,0> .0030 scale<1,1.5,1> translate<-.007,0,-.078> texture{T_Orange_Glass}}
  
  #declare R1=15;
  #while (R1<=345)
     torus{.0025,.00075 rotate<90,0,0> translate<.075,0,0> rotate<0,R1,0> texture{T_Green_Glass}}
     torus{.0025,.00075 rotate<90,0,0> translate<.075,0,0> rotate<0,R1+2,0> texture{T_Green_Glass}}
     torus{.0025,.00075 rotate<90,0,0> translate<.075,0,0> rotate<0,R1-2,0> texture{T_Green_Glass}}
     #declare R1=R1+15;
  #end
  
  texture{T09}
}

#declare Ring=difference{
  torus{.00825,.001}
  cylinder{<0,-.011,0><0,.011,0> .008}
  scale<1,1.25,1>
}

//#ifdef(X)
#declare Dress_Texture = texture
{
    pigment
    {
        image_map
        {
            png "../../poser/udredg~1.png"
        }
    }
}
#declare OBJuvPOV_Texture_OBJuvPOVPreview = texture {Dress_Texture}
#declare Dress =
union
{
    #include "../../poser/Lonely1D.inc"
}

// ive code *********
#declare P_Body = pigment { image_map { png "../../poser/OBJuvPOV.png" interpolate 2}}
#declare F_Body = finish { ambient 0 diffuse 0.6 specular 0.04 roughness 0.06 metallic}

#declare OBJuvPOV_Texture_OBJuvPOVskin1 = texture {
  pigment {P_Body}
  finish {F_Body}
  normal {granite 0.06 scale 0.0025 }
}
// ******************

#declare OBJuvPOV_Texture = texture
{
    pigment
    {
        image_map
        {
            png "../../poser/OBJuvPOV.png"
        }
    }
}       
#declare OBJuvPOV_Texture_Hair = texture
{
    pigment
    {
        image_map
        {
            png "../../poser/Lonelyh1.png"
        }
    }
}
//#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipples1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrows1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlashes1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupils1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVfingerNails1 = texture {pigment{color Scarlet}}
#declare OBJuvPOV_Texture_OBJuvPOVtoeNails1 = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVHair = texture {OBJuvPOV_Texture_Hair}
#declare OBJuvPOV_Texture_OBJuvPOVDress = texture {Dress_Texture}

#declare Woman1 = union{
  #include "../../poser/Lonely1v2.inc"
}

union{ // w/ jewels
  union{
   // object {Dress scale <1.02,1,1.02>}
    object {Woman1}
     scale 2.5   
     rotate<0,-59,0> 
     translate<0,0,0>
   }
  object{Crown1 rotate<0,-17.5,0> translate<.04,1.59,-.105>}
  object{Necklace rotate<0,-12,0> rotate<-12,0,-11> translate<.04,1.405,-.025>}
  object{Ring rotate<-14,0,90> translate<.1221,1.32675,-.2236> texture{T04}}
 //rotate<0,20,0> 
  translate<-2.25,3.1,-48>
}  
  
#end // ifndef(NoLady)