
// POV-Ray Object File - Boats
// created 25-Sep-02
// last update 19-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Boats.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CatamaranS // simple version
// TwoMastedSchooner
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is along the waterline, at the base of the main mast
// Mast extends into +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "CatHull.inc"
#include "BoatHull.inc"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WhiteFiberglas =
	texture {
		pigment { color rgb<.99,.99,.99>*1.00 }
		finish { specular 0.93 roughness 0.04 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare CatamaranS = // simple version, origin at mast
	union {
		object { CatHull translate <0,-4*Feet,0> }
		object { CatHull translate <0, 4*Feet,0> }
		cylinder { // mast support
			<0,-4*Feet,0>,<0,4*Feet,0>,6
			scale <1,1,.3>
		}
		cylinder { // rear support
			<0,-4*Feet,0>,<0,4*Feet,0>,6
			scale <1,1,.3>
			translate <-6*Feet,0,0>
		}
		box { // web
			<0,-3.3*Feet,-1>,<4.3*Feet,3.3*Feet,0>
			translate <-5*Feet,0,10>
		}
		cylinder { // mast
			<0,0,0>,<0,0,18*Feet>,2.3
			scale <1,0.6,1>
		}
		sphere { // mast top
			<0,0,0>,2.3
			scale <1,0.6,1>
			translate <0,0,18*Feet>
		}
		cylinder { // boom
			<-7*Feet,0,0>,<-4,0,0>,2.2
			translate <0,0,28>
		}
		texture { WhiteFiberglas }
	} // end union

#declare TwoMastedSchooner = // origin at front mast
	union {
		object { BoatHull_shape scale 40 translate <-5*Feet, 0*Feet,14> }
//		box { <0,-4*Feet,0>,<40*Feet,4*Feet,4*Feet> translate <-30*Feet,0,0> } // hull stand-in
		cylinder { // main mast
//			<0,0,0>,<0,0,34*Feet>,3.3 // normal
			<0,0,0>,<0,0,34*Feet>,6.0 // enlarged
			scale <1,0.6,1>
		}
		sphere { // mast top
//			<0,0,0>,3.3 // normal
			<0,0,0>,6.0 // enlarged
			scale <1,0.6,1>
			translate <0,0,34*Feet>
		}
		cylinder { // front boom
			<-15*Feet,0,0>,<-4,0,0>,2.6
			translate <0,0,80>
		}
		julia_fractal { // furled sail
			<0.183,0.0,-0.83,-0.025>
			max_iteration 8
			scale <5*Feet,20,20>
			rotate y*10
			translate <-7*Feet,0,88>
		}
		cylinder { // mizzen mast
//			<0,0,0>,<0,0,34*Feet>,2.6 // normal
			<0,0,0>,<0,0,34*Feet>,4.6 // enlarged
			scale <1,0.6,1>
			translate <-18*Feet,0,0>
		}
		sphere { // mast top
//			<0,0,0>,2.6 // normal
			<0,0,0>,4.6 // enlarged
			scale <1,0.6,1>
			translate <-18*Feet,0,34*Feet>
		}
		cylinder { // rear boom
			<-9*Feet,0,0>,<-4,0,0>,2.2
			translate <-18*Feet,0,64>
		}
		julia_fractal { // furled sail
			<0.183,0.0,-0.83,-0.025>
			max_iteration 8
			scale <4.0*Feet,13,13>
			rotate <180,-18,0>
			translate <-22*Feet,0,78>
		}
		box { // cabin
			<-12*Feet,-3.3*Feet,-20>,<6*Feet,3.3*Feet,24>
			translate <-3*Feet,0,40>
		}
		box { // cabin roof
			<-12*Feet-1,-3.3*Feet-2,24>,<6*Feet+2,3.3*Feet+2,26>
			translate <-3*Feet,0,40>
		}
		texture { WhiteFiberglas }
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1, -90*Feet, 12*Feet> // overall
		look_at <0*Feet,0,16*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { CatamaranS scale 1 rotate x*0 translate <-4*Feet,-6*Feet ,0> }
object { TwoMastedSchooner scale 1 rotate z*0 translate <0,0,0> }

//object { TwoMastedSchooner scale 1 rotate z*55 translate <0,0,1> }
object { TwoMastedSchooner scale 1 rotate z*-60 translate <20*Feet,0,1> }


#end
