
// POV-Ray Object File - Bridges & Elevators
// created 14-Oct-02
// last update 27-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Bridges.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "MiscObjects.inc"
//
// Objects:
// StoneBridge
// Elevator1 -- an external elevator about 100ft tall
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Bridge extends into +X
// Sky is +Z
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "MiscObjects.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BronzeTex =
	texture {
		pigment { color rgb<.74,.51,.28>*.84 }
		finish { specular 0.96 roughness .08 metallic }
	}
#declare SteelTex =
	texture {
		pigment { color rgb<.44,.41,.48>*.84 }
		finish { specular 0.6 roughness .08 metallic }
	}
#declare ElevatorTex =
	texture {
		pigment { color rgb<.675,.600,.545>*.99 }
		finish { specular 0.6 roughness .05 }
	}
#declare ElevatorCarTex =
	texture {
		pigment { color rgb<.475,.600,.845>*.99 }
		finish { specular 0.98 roughness .015 }
	}
#declare WhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { specular 0.6 roughness .08 }
	}
#declare StoneBridgeTex =
		pigment {
			granite
			color_map {
				[ 0.24 color rgb <0.786,0.757,0.639> ]
				[ 0.51 color rgb <0.684,0.651,0.497> ]
				[ 0.77 color rgb <0.675,0.427,0.255>*.4 ] // red rust
				[ 0.92 color rgb <0.753,0.694,0.655>*.1 ] // black holes
			}
			scale <1,1,.6>*.06
		}
#declare BridgeDeckTex =
		pigment {
			granite
			color_map {
				[ 0.24 color rgb <0.786,0.757,0.639>*1.2 ]
				[ 0.51 color rgb <0.684,0.651,0.497>*1.2 ]
				[ 0.77 color rgb <0.675,0.427,0.255>*.5 ] // red rust
				[ 0.92 color rgb <0.753,0.694,0.655>*.03 ] // black holes
			}
			scale <1,1,.6>*.06
		}


//===============================================
//             Macros
//===============================================

#macro GuardRail(XLength,TotalPosts)
	union {
		#local PC = 0;
		#while ( PC < TotalPosts )
			cylinder { <0,0,0>,<0,0,36>1.4 translate <(XLength/TotalPosts)*PC,0,0> }
			#local PC = PC + 1;
		#end
		cylinder { <0,0,0>,<XLength,0,0>,2.4 scale <1,1,0.2> translate <0,0,36> texture { BronzeTex } }
		box { <0,-2,0>,<XLength,2,0.5> translate <0,0,12> }
		box { <0,-2,0>,<XLength,2,0.5> translate <0,0,24> }
		texture { ElevatorTex }
	} // end union
#end


//===============================================
//             Objects
//===============================================

//------------ Simple Bridges -------------------

#declare Hole1m_BridgeS =
	object { RoundedBox2(110*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}

#declare Hole12a_BridgeS =
	object { RoundedBox2(110*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}

#declare Hole12b_BridgeS =
	object { RoundedBox2(40*Feet,12*Feet,6*Feet,10) 
// RoundedBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		translate <0,-6*Feet,0> // center it
		texture { SteelTex }
	}

//------------ Complex Bridges ------------------

#declare StoneBridgeHF =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Bridge1HF.png"
		water_level .01
		scale <1,-1,1> // 
		scale <100*Feet,0.5*Feet,15*Feet>
	}
#declare StoneBridge =
	union {
		object { StoneBridgeHF translate <0,-3*Feet,0> }
		object { StoneBridgeHF scale <1,-1,1> translate <0,-3*Feet,0> }
		object { StoneBridgeHF translate <0, 3*Feet,0> }
		object { StoneBridgeHF scale <1,-1,1> translate <0, 3*Feet,0> }
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Bridge1deckHF.png"
			water_level .01
//			scale <100*Feet,8.3*Feet,23*Feet>
			scale <100*Feet,6.2*Feet,15*Feet>
//			translate <0,-4*Feet,-0.5*Feet>
			translate <0,-3*Feet,-0.5*Feet>
			texture { BridgeDeckTex }
		}
	texture { StoneBridgeTex }
//	translate <0,0,-15*Feet>
	translate <0,0,-10*Feet>
	} // end union

#declare Hole1m_Bridge =
	object { StoneBridge scale <0.9,1,1> }

#declare Hole12a_Bridge =
	object { StoneBridge scale <0.9,1,1> }

#declare Hole12b_Bridge =
	object { StoneBridge scale <0.6,1,1> }

#declare Hole3_Bridge =
	object { StoneBridge scale <0.96,1,1> }

//--------------- Elevator ----------------------

#declare ElevHt = -81*Feet; // total downwards height
#declare ElevatorPos = -40*Feet; // current height from upper platform
#declare EvCable = cylinder { <0,0,9*Feet>,<0,0,ElevatorPos+7*Feet>,0.54 }
#declare EvPulley = cylinder { <-0.75,0,0>,<0.75,0,0>,6 }
#declare ShaftCyl = cylinder { <0,0,8*Feet>,<0,0,ElevHt>,3.1 texture { ElevatorTex } }
#declare BackBone =
	union {
		box { <-2.3*Feet,0,8*Feet>,<2.3*Feet,24,ElevHt>  }
		cylinder { <-2.3*Feet,12,8*Feet>,<2.3*Feet,12,8*Feet>,12 }
		object { ShaftCyl translate <-1.8*Feet,-3.1,0> }
		object { ShaftCyl translate < 1.8*Feet,-3.1,0> }
		texture { SteelTex }
	} // end union
#declare ElevatorCar =
	difference {
		object { RoundedBox2(6*Feet,6*Feet,7.2*Feet,4.0)
			translate <-3*Feet,-3*Feet,0>
		}
		box { <-2.5*Feet,-2.5*Feet,6>,<2.5*Feet,2.5*Feet,6.7*Feet> texture { WhiteTex } } // interior
		box { <-3.5*Feet,-2.5*Feet,46>,<3.5*Feet,2.5*Feet,6.7*Feet> texture { WhiteTex } } // windows
		box { <-2.5*Feet,-3.5*Feet,46>,<2.5*Feet,3.5*Feet,6.7*Feet> texture { WhiteTex } } // interior
		texture { ElevatorCarTex }
	} // end union
#declare ElevatorBase =
	union {
//		cylinder { <-6*Feet,8*Feet,-40*Feet>,<-6*Feet,8*Feet,-10>,6*Feet } // support
		box { <-13*Feet,-4*Feet,-40*Feet>,<4*Feet,10*Feet,-10> } // support
		difference {
			box { <-16*Feet,-6*Feet,-20>,<6*Feet,25*Feet,30> } // bottom platform
			box { <-15.5*Feet,-5.5*Feet,0>,<5.5*Feet,24.5*Feet,31> } // walls cutout
			box { <-17*Feet,-0*Feet,0.1>,<-14*Feet,4*Feet,32> } // boardwalk cut
			box { <-12*Feet,-7*Feet,0.2>,<-6*Feet,-4*Feet,33> } // bridge cut
		} // end difference
		object { CokeMachineS rotate z*-90 translate <-6*Feet,5*Feet,0> }
	} // end union
#declare Elevator1 =
	union {
		difference {
			box { <-8*Feet,-6*Feet,-20>,<5*Feet,16*Feet,0> } // upper platform
			box { <-3*Feet,-3*Feet,-22>,<3*Feet,3*Feet,2> } // hole
		} // end difference
//#macro GuardRail(XLength,TotalPosts)
		object { GuardRail(12.0*Feet,4) translate <-7.5*Feet,-5.5*Feet,0> }
		object { GuardRail(20.0*Feet,7) rotate z*90 translate <-7.5*Feet,-5.5*Feet,0> }
		object { GuardRail(20.0*Feet,7) rotate z*90 translate < 4.5*Feet,-5.5*Feet,0> }
//		box { <-3.6*Feet,-3.6*Feet,0>,<3.6*Feet,16*Feet,10> translate <0,0,8*Feet> } // roof
//		box { <-3.0*Feet,0,-20>,<3.0*Feet,8*Feet,8*Feet> translate <0,8*Feet,0> } // motor room
		object { BackBone translate <0,3*Feet,0> }
		object { ElevatorBase translate <0,0,ElevHt> }		
		object { EvCable translate <0,1.6*Feet,0> }
		object { EvCable translate <6,1.6*Feet,0> }
		object { EvCable translate <-6,1.6*Feet,0> }
		object { EvPulley translate <0,1.6*Feet+6,9*Feet> }
		object { EvPulley translate <6,1.6*Feet+6,9*Feet> }
		object { EvPulley translate <-6,1.6*Feet+6,9*Feet> }
		object { ElevatorCar translate <0,0,ElevatorPos> }
		texture { ElevatorTex }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 30
		location  <-30*Feet, -30*Feet, 30*Feet> // overall
		look_at <0*Feet,10*Feet,16*Feet>
	}


light_source
{ <140*Feet,-135*Feet,150*Feet>, 1.0
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { TestSphere scale 20 translate <0,0,20> }

object { Elevator1 scale 1 rotate z*20 translate <4*Feet,-0*Feet ,100*Feet> }
//object { CokeMachineS scale 1 rotate z*20 translate <-4*Feet,-0*Feet ,8*Feet> }
//object { StoneBridge scale 1 rotate z*20 translate <-4*Feet,-40*Feet ,8*Feet> }
//object { StoneBridge scale 1 rotate z*90 translate <4*Feet,-16*Feet ,8*Feet> }


#end
